/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.AHelix;
import atlantis.data.ATrackData;
import atlantis.data.AVertex;
import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.list.AList;
import atlantis.list.AListManager;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjection3D;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AFit;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.tree.DefaultMutableTreeNode;

public class ARVxData
extends AData {
    private static ALogger logger = ALogger.getLogger(ARVxData.class);
    private static final int SIZE = 3;
    private ArrayList vertices = new ArrayList();
    private ArrayList tracksIndex = new ArrayList();
    private ArrayList tracksId = new ArrayList();
    private ArrayList tracksCollection = new ArrayList();
    private ArrayList drawFlag = new ArrayList();
    private ArrayList athenaOrigin = new ArrayList();
    private int[] primVxCand = null;
    private int[] numTracks = null;

    public String getParameterGroup() {
        return "RVx";
    }

    public String getName() {
        return "RVx";
    }

    public String getNameScreenName() {
        return "RecVertex";
    }

    ARVxData(AHashMap p, AEvent e) throws AAtlantisException {
        super(p, e);
        int[] tracks = p.getIntArray("tracks");
        this.numTracks = p.getIntArray("numTracks");
        Vector<String> SgKey = new Vector<String>();
        if (this.numTracks == null) {
            this.numTracks = new int[]{0};
        }
        float[] z = p.getFloatArray("z");
        float[] y = p.getFloatArray("y");
        float[] x = p.getFloatArray("x");
        float[] covMatrix = p.getFloatArray("covMatrix");
        float[] chi2 = p.getFloatArray("chi2");
        String[] sgkey = null;
        if (p.getStringArray("sgkey") != null) {
            sgkey = p.getStringArray("sgkey");
        } else {
            sgkey = new String[this.numData];
            for (int i = 0; i < this.numData; ++i) {
                sgkey[i] = "n/a";
            }
        }
        if (!sgkey[0].equals("n/a")) {
            SgKey.add(sgkey[0]);
        }
        for (int i = 0; i < sgkey.length; ++i) {
            if (sgkey[i].equals("n/a")) continue;
            Boolean inVector = false;
            for (int j = 0; j < SgKey.size(); ++j) {
                if (!sgkey[i].equals(SgKey.get(j))) continue;
                inVector = true;
                break;
            }
            if (inVector.booleanValue()) continue;
            SgKey.add(sgkey[i]);
        }
        Vector<Integer> TrkNum = new Vector<Integer>();
        Vector<Integer> Track = new Vector<Integer>();
        for (int i = 0; i < SgKey.size(); ++i) {
            int trackCount = 0;
            for (int j = 0; j < sgkey.length; ++j) {
                if (((String)SgKey.get(i)).equals(sgkey[j])) {
                    TrkNum.add(this.numTracks[j]);
                    for (int k = trackCount; k < trackCount + this.numTracks[j]; ++k) {
                        Track.add(tracks[k]);
                    }
                }
                trackCount += this.numTracks[j];
            }
            int[] assocTracks = new int[Track.size()];
            for (int j = 0; j < Track.size(); ++j) {
                assocTracks[j] = (Integer)Track.get(j);
            }
            int[] numTrks = new int[TrkNum.size()];
            for (int j = 0; j < TrkNum.size(); ++j) {
                numTrks[j] = (Integer)TrkNum.get(j);
            }
            this.event.getAssociationManager().add(new AAssociation("RVx", "InDetTrack" + (String)SgKey.get(i), numTrks, assocTracks, this.event));
            TrkNum.removeAllElements();
            Track.removeAllElements();
        }
        if (p.getIntArray("primVxCand") != null) {
            this.primVxCand = p.getIntArray("primVxCand");
        }
        AVertex vertex = null;
        double[] pos = new double[3];
        double[][] cov = new double[3][3];
        int[] tracksIdArray = null;
        int[] tracksIndexArray = null;
        int n = 0;
        int m = 0;
        for (int i = 0; i < this.numData; ++i) {
            int j;
            pos[0] = x[i];
            pos[1] = y[i];
            pos[2] = z[i];
            for (j = 0; j < 3; ++j) {
                for (int k = 0; k < j + 1; ++k) {
                    cov[j][k] = covMatrix[n] / 10000.0f;
                    cov[k][j] = cov[j][k];
                    ++n;
                }
            }
            vertex = new AVertex(chi2[i], pos, cov);
            this.vertices.add(vertex);
            tracksIdArray = new int[this.numTracks[i]];
            tracksIndexArray = new int[this.numTracks[i]];
            for (j = 0; j < this.numTracks[i]; ++j) {
                tracksIdArray[j] = tracks[m];
                tracksIndexArray[j] = tracks[m] - 1;
                ++m;
            }
            this.tracksIndex.add(tracksIndexArray.clone());
            this.tracksId.add(tracksIdArray.clone());
            this.tracksCollection.add(sgkey[i]);
            this.drawFlag.add(new Boolean(true));
            this.athenaOrigin.add(new Boolean(true));
        }
    }

    protected static AHashMap createRVx() {
        AHashMap newP = new AHashMap(1);
        newP.put("numData", new Integer(0));
        return newP;
    }

    public int getIdFromIndex(int index) {
        return this.listdl[index];
    }

    private void createVertexFromTracks(int[] listOfTracksToVertex, String key) {
        int[][] assoc = this.event.getAssociationManager().get("RVx", "InDetTrack" + key);
        if (assoc == null) {
            int[] numTracks2 = new int[]{listOfTracksToVertex.length};
            this.event.getAssociationManager().add(new AAssociation("RVx", "InDetTrack" + key, numTracks2, listOfTracksToVertex, this.event));
        } else {
            this.event.getAssociationManager().remove("InDetTrack" + key + "RVx");
            int[][] newAssoc = new int[assoc.length + 1][];
            for (int i = 0; i < newAssoc.length; ++i) {
                newAssoc[i] = i == assoc.length ? listOfTracksToVertex : assoc[i];
            }
            this.event.getAssociationManager().add(new AAssociation("RVx", "InDetTrack" + key, newAssoc, this.event));
        }
        ATrackData aRTr = null;
        aRTr = this.event.getTrackData("InDetTrack", key);
        if (aRTr == null) {
            return;
        }
        int[] trackIdLocal = new int[listOfTracksToVertex.length];
        AHelix[] thisHelGoToFitter = new AHelix[listOfTracksToVertex.length];
        for (int j = 0; j < listOfTracksToVertex.length; ++j) {
            AHelix helix = aRTr.getModifiableHelix(listOfTracksToVertex[j]);
            if (helix == null) {
                AOutput.alwaysAppend("\nOne or more of the selected tracks do not have perigee parameters, the vertex cannot be created\n", "BAD_COMMAND");
                return;
            }
            thisHelGoToFitter[j] = helix;
            trackIdLocal[j] = aRTr.getIdFromIndex(listOfTracksToVertex[j]);
        }
        double xVtx = APar.get("Event", "XVtx").getD();
        double yVtx = APar.get("Event", "YVtx").getD();
        double zVtx = APar.get("Event", "ZVtx").getD();
        AVertex startingPoint = new AVertex(new double[]{xVtx, yVtx, zVtx});
        try {
            AVertex vertex = AFit.fitVertex(startingPoint, thisHelGoToFitter);
            this.vertices.add(vertex);
            this.tracksIndex.add(listOfTracksToVertex.clone());
            this.tracksId.add(trackIdLocal.clone());
            this.tracksCollection.add(key);
            this.drawFlag.add(new Boolean(true));
            this.athenaOrigin.add(new Boolean(false));
            double[] par = vertex.getPosition();
            double Vx = par[0];
            double Vy = par[1];
            double Vz = par[2];
            for (int j = 0; j < thisHelGoToFitter.length; ++j) {
                double a = Vx - xVtx;
                double b = Vy - yVtx;
                double c = Vz - zVtx;
                double size = Math.sqrt(a * a + b * b + c * c);
                APar.get("3D", "xAxis").setD(a / size);
                APar.get("3D", "yAxis").setD(b / size);
                APar.get("3D", "zAxis").setD(c / size);
                thisHelGoToFitter[j].setPhiStartByXYPoint(Vx, Vy);
            }
            AOutput.alwaysAppend("\n" + this.getHitInfo(this.numData) + "\n", "NORMAL");
            ++this.numData;
            this.makeDrawList();
        }
        catch (RuntimeException e) {
            String temp = "\nRVx: tracks (";
            for (int i = 0; i < listOfTracksToVertex.length; ++i) {
                if (i > 0) {
                    temp = temp + ", ";
                }
                temp = temp + aRTr.getIdFromIndex(listOfTracksToVertex[i]);
            }
            AOutput.alwaysAppend(temp + ")\n   not originating from a common vertex\n", "NORMAL");
            throw e;
        }
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (this.numData > this.color.length) {
            this.color = new byte[this.numData];
        }
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorByIndex();
        }
        return 0;
    }

    public void makeDrawList() {
        this.numDraw = 0;
        this.listdl = new int[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            if (!((Boolean)this.drawFlag.get(i)).booleanValue()) continue;
            this.listdl[this.numDraw] = i;
            ++this.numDraw;
        }
        this.applyCuts();
    }

    public String getHitInfo(int index) {
        String origin;
        boolean athenaOriginBoolean = (Boolean)this.athenaOrigin.get(index);
        String string = origin = athenaOriginBoolean ? "Athena" : "Atlantis";
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n calculated in " + origin;
        }
        String temp = null;
        boolean tracksIDsKnown = false;
        temp = "\n" + this.getNameScreenName() + " (index: " + index + ") (calculated in " + origin + ")\n" + " type of Track: " + (String)this.tracksCollection.get(index) + "\n";
        temp = temp + " tracks IDs = ";
        int[] tracksIdInVertex = (int[])this.tracksId.get(index);
        for (int i = 0; i < tracksIdInVertex.length; ++i) {
            int id2 = tracksIdInVertex[i];
            if (id2 <= -1) continue;
            tracksIDsKnown = true;
            if (i > 0) {
                temp = temp + ",";
            }
            temp = temp + tracksIdInVertex[i];
        }
        if (!tracksIDsKnown) {
            temp = temp + "n/a";
        }
        temp = temp + "\nPrimary=" + this.primVxCand[index];
        temp = temp + "\nnumTracks=" + this.numTracks[index];
        temp = temp + "\n" + this.vertices.get(index);
        return temp;
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionYX) {
            ACoord centers = window.calculateDisplay(this.getUser(projection));
            int[] drawlist = centers.index;
            double[][][] hv = new double[2][drawlist.length][];
            double[][][] hvCentre = new double[2][drawlist.length][4];
            for (int i = 0; i < drawlist.length; ++i) {
                hv[0][i] = centers.hv[0][i];
                hv[1][i] = centers.hv[1][i];
                int len = centers.hv[0][i].length;
                double diffx = centers.hv[0][i][0] - centers.hv[0][i][len / 2];
                double diffy = centers.hv[1][i][0] - centers.hv[1][i][len / 2];
                for (int j = 0; j < 4; ++j) {
                    hvCentre[0][i][j] = centers.hv[0][i][0] - diffx / 2.0;
                    hvCentre[1][i][j] = centers.hv[1][i][0] - diffy / 2.0;
                }
            }
            ag.draw(new ACoord(hv, drawlist, (ADrawable)this, 3));
            ag.draw(new ACoord(hvCentre, drawlist, (ADrawable)this, 3));
        } else {
            super.draw(window, ag, projection);
        }
    }

    public ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            double[][] p = vertex.getYXEllipse();
            hv[0][i] = p[0];
            hv[1][i] = p[1];
            index[i] = this.listdl[i];
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    public ACoord getXZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            double[][] p = vertex.getXZEllipse();
            hv[0][i] = p[0];
            hv[1][i] = p[1];
            index[i] = this.listdl[i];
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    public ACoord getYZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            double[][] p = vertex.getYZEllipse();
            hv[0][i] = p[0];
            hv[1][i] = p[1];
            index[i] = this.listdl[i];
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    public ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            double[][] p = vertex.getRZEllipse();
            hv[0][i] = p[0];
            hv[1][i] = p[1];
            index[i] = this.listdl[i];
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    public ACoord getRZUser_fixedsize() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        if (phiMid > Math.PI * 2) {
            phiMid -= Math.PI * 2;
        }
        for (int i = 0; i < this.numDraw; ++i) {
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            double[] xyz = vertex.getPosition();
            double rho = vertex.getRho();
            double phi = vertex.getPhi();
            double z = xyz[2];
            double phiDiff = Math.abs(phi - phiMid);
            h[i] = z;
            v[i] = phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469 ? rho : -rho;
            index[i] = this.listdl[i];
        }
        return new ACoord(h, v, index, this);
    }

    protected ACoord get3DUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            double[] hvo = AProjection3D.getRotated(((AVertex)this.vertices.get(this.listdl[i])).getPosition());
            h[i] = hvo[0];
            v[i] = hvo[1];
            index[i] = this.listdl[i];
        }
        return new ACoord(h, v, index, this);
    }

    public ACoord getFZUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            double z;
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            double[] xyz = vertex.getPosition();
            double phi = vertex.getPhi();
            h[i] = z = xyz[2];
            v[i] = Math.toDegrees(phi);
            index[i] = this.listdl[i];
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FZ");
    }

    public ACoord getFRUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            double rho = vertex.getRho();
            double phi = vertex.getPhi();
            h[i] = rho;
            v[i] = Math.toDegrees(phi);
            index[i] = this.listdl[i];
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FR");
    }

    public ACoord getVPUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw * 2];
        double[] v = new double[this.numDraw * 2];
        int[] index = new int[this.numDraw * 2];
        double[] sign = new double[]{-1.0, 1.0};
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            double[] xyz = vertex.getPosition();
            double rho = vertex.getRho();
            double phi = vertex.getPhi();
            double z = xyz[2];
            double eta = AMath.eta(z, rho);
            double delEta = AProjectionVP.getDeltaEta(rho, z);
            for (int j = 0; j < 2; ++j) {
                h[num] = eta + sign[j] * delEta;
                v[num] = Math.toDegrees(phi);
                index[num] = this.listdl[i];
                ++num;
            }
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }

    protected void applyCuts() {
        AData.printCut("RVx", this.numDraw);
        this.cutIndex();
        float[] phi = new float[this.numDraw];
        float[] eta = new float[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            AVertex vertex = (AVertex)this.vertices.get(this.listdl[i]);
            phi[i] = (float)vertex.getPhi();
            double z = vertex.getPosition()[2];
            eta[i] = (float)AMath.eta(z, vertex.getRho());
        }
        this.cutPhi(phi);
        this.cutEta(eta);
        this.cut("CutsInDet", "NumRVxTracks", " Ntrack", this.numTracks);
        this.cut("CutsInDet", "PrimaryRVx", " Primary", this.primVxCand);
    }

    public Action[] getActions(Collection nodes) {
        if (nodes.size() != 1) {
            return new Action[0];
        }
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.iterator().next();
        if (!node.getAllowsChildren()) {
            return new Action[0];
        }
        AList[] list = AListManager.getInstance().getChildren(node);
        if (list == null) {
            return new Action[0];
        }
        HashSet<Integer> tracks = new HashSet<Integer>();
        HashSet<Integer> tracksID = new HashSet<Integer>();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].getSource() instanceof ATrackData) {
                if (i > 0) {
                    String key1 = list[i - 1].getSource().getStoreGateKey();
                    String key2 = list[i].getSource().getStoreGateKey();
                    if (!(key1 == null && key2 == null || key1.equals(key2))) {
                        String msg = "info: Vertexing is available if only one Track collection is chosen in the list.  (select: InDet->Track->Track Collections)\n";
                        AOutput.alwaysAppend(msg, "NORMAL");
                        return new Action[0];
                    }
                }
                for (int j = 0; j < list[i].getItems().length; ++j) {
                    int index = list[i].getItems()[j];
                    int id2 = list[i].getSource().getIdFromIndex(index);
                    tracks.add(new Integer(index));
                    tracksID.add(new Integer(id2));
                }
                continue;
            }
            return new Action[0];
        }
        int numTracks2 = tracks.size();
        if (numTracks2 < 2) {
            return new Action[0];
        }
        String trackName = list[0].getSource().getNameScreenName();
        final String trackStoreGateKey = list[0].getSource().getStoreGateKey();
        final int[] trackNumbers = new int[numTracks2];
        int[] trackIDs = new int[numTracks2];
        Iterator i = tracks.iterator();
        int n = 0;
        while (i.hasNext()) {
            trackNumbers[n++] = (Integer)i.next();
        }
        i = tracksID.iterator();
        n = 0;
        while (i.hasNext()) {
            trackIDs[n++] = (Integer)i.next();
        }
        Action[] action = new Action[]{new AbstractAction("Vertex " + trackName + " " + trackStoreGateKey + " in Atlantis"){

            public void actionPerformed(ActionEvent e) {
                try {
                    ARVxData.this.createVertexFromTracks(trackNumbers, trackStoreGateKey);
                    ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
                    node.setUserObject(new AList((AData)ARVxData.this, ARVxData.this.numData - 1));
                }
                catch (Exception ee) {
                    logger.debug("ARVxData.getActions() exception:  " + ee.getMessage(), ee);
                }
            }
        }};
        return action;
    }

    public void remove(int[] index) {
        String key = null;
        ATrackData aRTr = null;
        for (int i = 0; i < index.length; ++i) {
            this.drawFlag.set(index[i], new Boolean(false));
            key = (String)this.tracksCollection.get(index[i]);
            aRTr = this.event.getTrackData("InDetTrack", key);
            if (aRTr == null) continue;
            int[] tracksInVertex = (int[])this.tracksIndex.get(index[i]);
            for (int j = 0; j < tracksInVertex.length; ++j) {
                aRTr.getModifiableHelix(tracksInVertex[j]).setPhiStartByXYPoint(0.0, 0.0);
            }
        }
    }

    public void cutTracksToRVx(AEvent event) {
        for (int i = 0; i < this.numData; ++i) {
            int[] tracksIdInVertex;
            String trackKey;
            ATrackData tracks;
            boolean origin = (Boolean)this.athenaOrigin.get(i);
            if (!origin || (tracks = event.getTrackData("InDetTrack", trackKey = (String)this.tracksCollection.get(i))) == null || (tracksIdInVertex = (int[])this.tracksId.get(i)).length < 2) continue;
            AHelix[] thisHelGoToFitter = new AHelix[tracksIdInVertex.length];
            AVertex vertex = (AVertex)this.vertices.get(i);
            double[] par = vertex.getPosition();
            double Vx = par[0];
            double Vy = par[1];
            for (int j = 0; j < tracksIdInVertex.length; ++j) {
                int id2 = tracksIdInVertex[j];
                if (id2 <= -1) continue;
                thisHelGoToFitter[j] = tracks.getModifiableHelix(id2);
                thisHelGoToFitter[j].setPhiStartByXYPoint(Vx, Vy);
            }
        }
    }

    public double[] getPrimaryVertex() {
        double[] vtx = null;
        if (this.numData <= 0) {
            return vtx;
        }
        if (this.primVxCand != null) {
            for (int i = 0; i < this.numData; ++i) {
                if (this.primVxCand[i] != 1) continue;
                vtx = ((AVertex)this.vertices.get(i)).getPosition();
                break;
            }
            if (vtx == null) {
                vtx = ((AVertex)this.vertices.get(0)).getPosition();
            }
        } else {
            vtx = ((AVertex)this.vertices.get(0)).getPosition();
        }
        return vtx;
    }

    public double[] getVertex(int index) {
        double[] vtx = null;
        vtx = ((AVertex)this.vertices.get(index)).getPosition();
        return vtx;
    }
}

