/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.A3DPointData;
import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public class AS3DData
extends A3DPointData {
    private int[][] clusters = null;
    protected int[] layer = null;
    private int[] etaModule = null;
    private int[] phiModule = null;
    protected int[] group = null;
    private double[] eta = null;
    private boolean[] pixel = null;
    public static final int PIXEL = -1;
    public static final int CUT_INDET_SCT_ALL = -1;
    public static final int CUT_INDET_SCT_EC_NEG = 0;
    public static final int CUT_INDET_SCT_BARREL = 1;
    public static final int CUT_INDET_SCT_EC_POS = 2;

    public String getParameterGroup() {
        return "S3D";
    }

    public String getName() {
        return "S3D";
    }

    public String getNameScreenName() {
        return "SpacePoint";
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n" + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        String clId = this.clusters[index][0] + ", " + this.clusters[index][1];
        String type = this.pixel[index] ? " (Pixel hit)" : " (SCT hit)";
        String temp = this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")" + type + "\n cluster identifiers: " + clId + "\n x = " + AMath.d2s(this.x[index], 3) + " cm" + "\n y = " + AMath.d2s(this.y[index], 3) + " cm" + "\n z = " + AMath.d2s(this.z[index], 3) + " cm" + "\n " + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + " cm" + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 3) + " rad)" + "\n z = " + AMath.d2s(this.z[index], 3) + " cm" + "\n group = " + this.group[index];
        temp = temp + "\n \u03b7 module = ";
        temp = temp + (this.etaModule != null ? Integer.toString(this.etaModule[index]) : "n/a");
        temp = temp + "\n \u03a6 module = ";
        temp = temp + (this.phiModule != null ? Integer.toString(this.phiModule[index]) : "n/a");
        temp = temp + super.getHitInfo(index);
        return temp;
    }

    AS3DData(AHashMap p, AEvent e) {
        super(p, e);
        this.etaModule = p.get("etaModule") != null ? p.getIntArray("etaModule") : null;
        this.phiModule = p.get("phiModule") != null ? p.getIntArray("phiModule") : null;
        this.layer = p.getUnknownIntArray("layer");
        if (p.get("layer") == null || p.get("sub") == null) {
            this.calculateLayerSubdetector();
        }
        this.group = new int[this.numData];
        this.eta = new double[this.numData];
        if (p.get("clusters") != null) {
            this.pixel = new boolean[this.numData];
            this.clusters = new int[this.numData][];
            int[][] assocClusters = new int[this.numData][];
            int[] temp = p.getIntArray("clusters");
            for (int i = 0; i < this.numData; ++i) {
                this.clusters[i] = new int[]{temp[2 * i], temp[2 * i + 1]};
                if (temp[2 * i + 1] != -1) {
                    assocClusters[i] = new int[]{temp[2 * i], temp[2 * i + 1]};
                    continue;
                }
                this.pixel[i] = true;
                assocClusters[i] = new int[]{temp[2 * i]};
            }
            this.event.getAssociationManager().add(new AAssociation(this.getName(), "SiCluster", assocClusters, this.event));
            this.event.getAssociationManager().add(new AAssociation(this.getName(), "PixelCluster", assocClusters, this.event));
        }
    }

    protected void finalizeConstruction() {
        super.finalizeConstruction();
        super.calculateAssociationViaClusters();
    }

    protected int internalColor() {
        int numColorTypes = super.internalColor();
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == numColorTypes + 1) {
            this.colorByGroup();
        } else if (colorFunction == numColorTypes + 2) {
            this.colorBy(this.layer);
        }
        return numColorTypes + 2;
    }

    protected void colorByGroup() {
        byte ungroupedColor = APar.get(this.PARAMETER_GROUP, "Ungrouped").getStatus() ? (byte)APar.get(this.PARAMETER_GROUP, "Ungrouped").getI() : (byte)APar.get(this.PARAMETER_GROUP, "Unconnected").getI();
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = this.group[i] == 0 ? ungroupedColor : (byte)col[(this.group[i] - 1) % numColors];
        }
    }

    protected void setType() {
        int[][] assocSTr = this.event.getAssociationManager().get(this.getName(), "STr");
        int[][] assocRTr = this.event.getAssociationManager().get(this.getName(), this.getReconstructedTracks());
        for (int i = 0; i < this.numData; ++i) {
            this.type[i] = assocSTr != null && assocSTr[i] != null || assocRTr != null && assocRTr[i] != null || this.group[i] > 0 ? (byte)1 : 0;
        }
    }

    protected void applyCuts() {
        AData.printCut("S3D", this.numDraw);
        this.cutIndex();
        this.cutSubdetector();
        this.cut("CutsInDet", "Layer", " Layer", this.layer);
        this.cutPhi(this.phi);
        this.cutEta(this.rho, this.z);
        this.cutSimulatedTracks();
        this.cutReconstructedTracks();
        this.cut("CutsInDet", "Group", " Group", this.group);
        if (this.etaModule != null) {
            this.cut("CutsInDet", "EtaModule", " EtaModule", this.etaModule);
        }
        if (this.phiModule != null) {
            this.cut("CutsInDet", "PhiModule", " PhiModule", this.phiModule);
        }
    }

    private void cutSubdetector() {
        AParameter subPar = APar.get("CutsInDet", "SCT");
        if (subPar.getI() != -1) {
            this.cutArray(this.sub, subPar.getI(), "Barrel/Endcap");
        }
    }

    public int getLayer(int id) {
        int layer = id > -1 ? id >> 21 & 0xF : id >> 27 & 3;
        int sub = this.getSub(id);
        if (id > -1) {
            layer = sub == 1 ? (layer += 3) : (layer += 11);
        } else if (sub != 1) {
            layer += 7;
        }
        return layer;
    }

    public int getSub(int id) {
        if (id > -1) {
            return id >> 25 & 3;
        }
        return id >> 29 & 3;
    }

    private void calculateLayerSubdetector() {
        double rhoPixelMax = 24.0;
        double zBarrelPixelMax = 41.0;
        double zBarrelStripsMax = 78.0;
        double[] zEndcapPixel = new double[]{51.0, 64.0, 90.0};
        double[] zEndcapStrips = new double[]{88.0, 98.0, 116.0, 134.0, 156.0, 190.0, 233.0, 263.0};
        double[] rhoBarrel = new double[]{6.74, 11.5, 23.0, 34.0, 40.0, 48.0};
        block0: for (int i = 0; i < this.numData; ++i) {
            int l;
            double z = Math.abs(this.z[i]);
            double r = this.rho[i];
            if (r < 24.0) {
                if (z < 41.0) {
                    this.sub[i] = 1;
                    for (l = 0; l < rhoBarrel.length; ++l) {
                        if (!(r < rhoBarrel[l])) continue;
                        this.layer[i] = l;
                        continue block0;
                    }
                    continue;
                }
                this.layer[i] = 10;
                for (l = 0; l < zEndcapPixel.length; ++l) {
                    if (!(z < zEndcapPixel[l])) continue;
                    this.layer[i] = 7 + l;
                    break;
                }
                if (this.z[i] < 0.0f) {
                    this.sub[i] = 0;
                    continue;
                }
                this.sub[i] = 2;
                continue;
            }
            if (z < 78.0) {
                this.sub[i] = 1;
                this.layer[i] = 6;
                for (l = 0; l < rhoBarrel.length; ++l) {
                    if (!(r < rhoBarrel[l])) continue;
                    this.layer[i] = l;
                    continue block0;
                }
                continue;
            }
            this.layer[i] = 19;
            for (l = 0; l < zEndcapStrips.length; ++l) {
                if (!(z < zEndcapStrips[l])) continue;
                this.layer[i] = 11 + l;
                break;
            }
            this.sub[i] = this.z[i] < 0.0f ? 0 : 2;
        }
    }

    public int makeFilterDrawList(double etaRange) {
        this.calculateRhoPhi();
        this.numDraw = 0;
        for (int i = 0; i < this.numData; ++i) {
            double eta;
            this.eta[i] = eta = AMath.eta(this.z[i], this.rho[i]);
            if (!(eta > -etaRange) || !(eta < etaRange)) continue;
            this.listdl[this.numDraw++] = i;
        }
        return this.numDraw;
    }

    public int[] getIntegerEta(int numBins, double etaRange, int[] integerEta) {
        double binWidth = 2.0 * etaRange / (double)numBins;
        double etaRangeOptimised = etaRange + binWidth;
        for (int i = 0; i < this.numDraw; ++i) {
            integerEta[i] = (int)((this.eta[this.listdl[i]] + etaRangeOptimised) / binWidth);
        }
        return integerEta;
    }

    public int[] getIntegerPhi(int numBins, double skew, int[] integerPhi) {
        this.calculateRhoPhi();
        double binWidth = Math.PI * 2 / (double)numBins;
        for (int i = 0; i < this.numDraw; ++i) {
            double p = (double)this.phi[this.listdl[i]] - skew * (double)this.rho[this.listdl[i]];
            if (p < 0.0) {
                p += Math.PI * 2;
            } else if (p > Math.PI * 2) {
                p -= Math.PI * 2;
            }
            integerPhi[i] = (int)(p / binWidth) + 1;
        }
        return integerPhi;
    }

    public int[] getLayer(int[] layer) {
        for (int i = 0; i < this.numDraw; ++i) {
            layer[i] = this.layer[this.listdl[i]];
        }
        return layer;
    }

    public void setGroup(int[] group) {
        int i;
        for (i = 0; i < this.numData; ++i) {
            this.group[i] = 0;
        }
        for (i = 0; i < this.numDraw; ++i) {
            this.group[this.listdl[i]] = group[i];
        }
    }

    protected ACoord getFRUser() {
        if (!APar.get("SiCluster", "Stereo").getStatus()) {
            return super.getFRUser();
        }
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.rho[list];
            v[i] = Math.toDegrees(AMath.getPhiStereo(this.rho[list], this.phi[list], this.z[list]));
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FR");
    }

    protected ACoord getFZUser() {
        if (!APar.get("SiCluster", "Stereo").getStatus()) {
            return super.getFZUser();
        }
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.z[list];
            v[i] = Math.toDegrees(AMath.getPhiStereo(this.rho[list], this.phi[list], this.z[list]));
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FZ");
    }
}

