/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.canvas.AWindow;
import atlantis.data.ADHelix;
import atlantis.data.AHelix;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionXZ;
import atlantis.utils.A3Vector;
import atlantis.utils.A4Vector;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.APDGTable;

public class ASMTrData
extends AData {
    private static ALogger logger = ALogger.getLogger(ASMTrData.class);
    private static final double START_RADIUS = 2.0;
    protected int[] code;
    protected int[] particleType;
    protected int[] originVertex;
    protected float[] pT;
    protected float[][] rho = new float[2][];
    protected float[][] phi = new float[2][];
    protected float[][] z = new float[2][];
    protected float[][] x = new float[2][];
    protected float[][] y = new float[2][];
    AHelix[] innerTrack;
    protected int[] type;
    private int[] index;
    protected float[] phi0;
    protected float[] eta;
    protected float[] tL;

    public String getParameterGroup() {
        return "SMTr";
    }

    public String getName() {
        return "SMTr";
    }

    public String getNameScreenName() {
        return "SimMuonTrack";
    }

    ASMTrData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        int i2;
        this.x[0] = new float[this.numData];
        this.y[0] = new float[this.numData];
        this.rho[0] = p.getFloatArray("rhoVertex");
        this.phi[0] = p.getFloatArray("phiVertex");
        this.z[0] = p.getFloatArray("zVertex");
        for (i2 = 0; i2 < this.numData; ++i2) {
            this.x[0][i2] = (float)((double)this.rho[0][i2] * Math.cos(this.phi[0][i2]));
            this.y[0][i2] = (float)((double)this.rho[0][i2] * Math.sin(this.phi[0][i2]));
        }
        this.x[1] = (float[])this.x[0].clone();
        this.y[1] = (float[])this.y[0].clone();
        this.z[1] = (float[])this.z[0].clone();
        this.phi[1] = (float[])this.phi[0].clone();
        this.rho[1] = (float[])this.rho[0].clone();
        this.pT = p.getFloatArray("pt");
        this.code = p.getIntArray("code");
        this.type = new int[this.numData];
        this.particleType = new int[this.numData];
        this.originVertex = p.getIntArray("simulatedVertex");
        for (i2 = 0; i2 < this.numData; ++i2) {
            if (Math.abs(this.code[i2]) <= 10) continue;
            this.particleType[i2] = APDGTable.getParticleType(this.code[i2]);
        }
        this.calculateReasonableEndpoints(p.getFloatArray("phi"), p.getFloatArray("eta"));
        double[] phiD = new double[this.numData];
        float[] phiF = p.getFloatArray("phi");
        for (i = 0; i < this.numData; ++i) {
            phiD[i] = phiF[i];
        }
        this.index = this.indexBy(phiD);
        this.phi0 = p.getFloatArray("phi");
        this.eta = p.getFloatArray("eta");
        this.tL = new float[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.tL[i] = (float)(1.0 / Math.tan(2.0 * Math.atan(Math.exp(-this.eta[i]))));
        }
    }

    protected void calculateRhoPhi() {
        this.calculateRhoPhi(this.x[0], this.y[0], this.rho[0], this.phi[0]);
        this.calculateRhoPhi(this.x[1], this.y[1], this.rho[1], this.phi[1]);
    }

    private void calculateReasonableEndpoints(float[] phiDir, float[] eta) {
        double rhoTo = 1500.0;
        double zTo = 2500.0;
        int maxPoints = 5;
        double[] d = new double[maxPoints];
        block0: for (int i = 0; i < this.numData; ++i) {
            int j;
            double c;
            double a;
            double b;
            double squared;
            int numPoints = 0;
            if ((double)this.rho[0][i] < rhoTo && (double)Math.abs(this.z[0][i]) < zTo) {
                d[numPoints++] = 0.0;
            }
            double lambda = AMath.lambda(eta[i]);
            double x0 = this.x[0][i];
            double y0 = this.y[0][i];
            double z0 = this.z[0][i];
            this.x[1][i] = (float)x0;
            this.y[1][i] = (float)y0;
            this.z[1][i] = (float)z0;
            double u = Math.cos(lambda) * Math.cos(phiDir[i]);
            double v = Math.cos(lambda) * Math.sin(phiDir[i]);
            double w = Math.sin(lambda);
            if (w != 0.0) {
                d[numPoints++] = (zTo - z0) / w;
                d[numPoints++] = (-zTo - z0) / w;
            }
            if ((squared = (b = 2.0 * (u * x0 + v * y0)) * b - 4.0 * (a = u * u + v * v) * (c = x0 * x0 + y0 * y0 - rhoTo * rhoTo)) >= 0.0) {
                d[numPoints++] = (-b + Math.sqrt(squared)) / (2.0 * a);
                d[numPoints++] = (-b - Math.sqrt(squared)) / (2.0 * a);
            }
            for (j = 0; j < numPoints - 1; ++j) {
                for (int k = j + 1; k < numPoints; ++k) {
                    if (!(d[k] < d[j])) continue;
                    double temp = d[k];
                    d[k] = d[j];
                    d[j] = temp;
                }
            }
            for (j = 0; j < numPoints; ++j) {
                if (!(d[j] >= 0.0) || j >= numPoints - 1) continue;
                this.x[0][i] = (float)(x0 + d[j] * u);
                this.y[0][i] = (float)(y0 + d[j] * v);
                this.z[0][i] = (float)(z0 + d[j] * w);
                this.x[1][i] = (float)(x0 + d[j + 1] * u);
                this.y[1][i] = (float)(y0 + d[j + 1] * v);
                this.z[1][i] = (float)(z0 + d[j + 1] * w);
                continue block0;
            }
        }
    }

    protected void finalizeConstruction() {
        super.finalizeConstruction();
        this.innerTrack = new AHelix[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            double p = AMath.getPFromPttL(this.pT[i], AMath.tanLambda(AMath.eta(this.z[0][i], this.rho[0][i])));
            double pTCorrected = (double)this.pT[i] * (p + 3.7) / p;
            this.innerTrack[i] = new AHelix(0.0f, (float)APar.get("Event", "ZVtx").getD(), (float)Math.toDegrees(this.phi[0][i]), (float)AMath.tanLambda(AMath.eta(this.z[0][i], this.rho[0][i])), (float)pTCorrected);
        }
    }

    protected void applyCuts() {
        AData.printCut("SNP", this.numDraw);
        this.cutIndex();
        this.cut("CutsInDet", "STrType", " STr Type", this.particleType);
        this.cut("CutsInDet", "STr", " STr id", this.id);
        this.cut("CutsInDet", "Pt", " |Pt|", this.pT);
        this.cut("CutsInDet", "SVx", " Vertex", this.originVertex);
        this.cutPhi(this.phi[1]);
        float[] phiStart = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int iMax = 0;
            if (this.rho[1][list] > this.rho[0][list]) {
                iMax = 1;
            }
            int iMin = 1 - iMax;
            phiStart[list] = this.phi[iMin][list];
        }
        this.cutPhi(phiStart);
        this.cutEta(this.rho[1], this.z[1]);
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorByIndex(this.index);
        } else if (colorFunction == 2) {
            this.colorBy("ParticleColors", this.particleType);
        }
        return 2;
    }

    public String getHitInfo(int index) {
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n Type = ");
        msg.append(APDGTable.getName(this.code[index]));
        if (this.innerTrack != null) {
            msg.append(this.innerTrack[index].toString());
        }
        msg.append("\n pT (muon spectrometer) = ");
        msg.append(AMath.d2s(this.pT[index], 3));
        msg.append(" GeV");
        return msg.toString();
    }

    protected void cutStartRadius() {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (!((double)Math.min(Math.abs(this.z[0][this.listdl[i]] / this.rho[0][this.listdl[i]]), Math.abs(this.z[1][this.listdl[i]] / this.rho[1][this.listdl[i]])) < 1.3369565217391306)) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut(" Start rho", this.numDraw);
    }

    protected void cutStartRadius2() {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (!((double)Math.max(Math.abs(this.z[0][this.listdl[i]] / this.rho[0][this.listdl[i]]), Math.abs(this.z[1][this.listdl[i]] / this.rho[1][this.listdl[i]])) > 1.3369565217391306)) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut(" Start rho", this.numDraw);
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        this.cutStartRadius();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.x[j][list];
                hv[1][j][i] = this.y[j][list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        int numSplit = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiDiff = Math.abs((double)this.phi[0][list] - phiMid);
            double sign0 = -1.0;
            if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                sign0 = 1.0;
            }
            phiDiff = Math.abs((double)this.phi[1][list] - phiMid);
            double sign1 = -1.0;
            if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                sign1 = 1.0;
            }
            if (sign0 == sign1) continue;
            ++numSplit;
        }
        int numPoints = 100;
        double[][][] hv = new double[2][this.numDraw + numSplit][];
        int[] index = new int[this.numDraw + numSplit];
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int j;
            int list = this.listdl[i];
            double phiDiff = Math.abs((double)this.phi[0][list] - phiMid);
            double sign0 = -1.0;
            if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                sign0 = 1.0;
            }
            phiDiff = Math.abs((double)this.phi[1][list] - phiMid);
            double sign1 = -1.0;
            if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                sign1 = 1.0;
            }
            if (sign0 == sign1) {
                hv[0][num] = AMath.splitLineIntoPieces(new double[]{this.z[1][list], this.z[0][list]}, numPoints);
                double[] xx = AMath.splitLineIntoPieces(new double[]{this.x[1][list], this.x[0][list]}, numPoints);
                double[] yy = AMath.splitLineIntoPieces(new double[]{this.y[1][list], this.y[0][list]}, numPoints);
                hv[1][num] = new double[xx.length];
                for (int j2 = 0; j2 < xx.length; ++j2) {
                    hv[1][num][j2] = sign0 * Math.sqrt(xx[j2] * xx[j2] + yy[j2] * yy[j2]);
                }
                index[num++] = list;
                continue;
            }
            double a = Math.cos(phiMid);
            double b = Math.sin(phiMid);
            double x0 = this.x[0][list];
            double y0 = this.y[0][list];
            double z0 = this.z[0][list];
            double dx = (double)this.x[1][list] - x0;
            double dy = (double)this.y[1][list] - y0;
            double dz = (double)this.z[1][list] - z0;
            double mag = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double d = -(a * x0 + b * y0) / (a * (dx /= mag) + b * (dy /= mag));
            double xMid = x0 + d * dx;
            double yMid = y0 + d * dy;
            double zMid = z0 + d * (dz /= mag);
            hv[0][num] = AMath.splitLineIntoPieces(new double[]{zMid, this.z[0][list]}, numPoints);
            double[] xx = AMath.splitLineIntoPieces(new double[]{xMid, this.x[0][list]}, numPoints);
            double[] yy = AMath.splitLineIntoPieces(new double[]{yMid, this.y[0][list]}, numPoints);
            hv[1][num] = new double[xx.length];
            for (j = 0; j < xx.length; ++j) {
                hv[1][num][j] = sign0 * Math.sqrt(xx[j] * xx[j] + yy[j] * yy[j]);
            }
            index[num++] = list;
            hv[0][num] = AMath.splitLineIntoPieces(new double[]{this.z[1][list], zMid}, numPoints);
            xx = AMath.splitLineIntoPieces(new double[]{this.x[1][list], xMid}, numPoints);
            yy = AMath.splitLineIntoPieces(new double[]{this.y[1][list], yMid}, numPoints);
            hv[1][num] = new double[xx.length];
            for (j = 0; j < xx.length; ++j) {
                hv[1][num][j] = sign1 * Math.sqrt(xx[j] * xx[j] + yy[j] * yy[j]);
            }
            index[num++] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 6);
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        this.cutStartRadius();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int iMax = 0;
            if (this.rho[1][list] > this.rho[0][list]) {
                iMax = 1;
            }
            int iMin = 1 - iMax;
            double rho1 = this.rho[iMin][list];
            double rho2 = this.rho[iMax][list];
            if (rho1 > 2.0) {
                hv[0][0][i] = rho1;
                hv[1][0][i] = Math.toDegrees(this.phi[iMin][list]);
            } else {
                double[] rpz = this.calculateRhoPhiZAtStart(list);
                hv[0][0][i] = rpz[0];
                hv[1][0][i] = Math.toDegrees(rpz[1]);
            }
            hv[0][1][i] = rho2;
            hv[1][1][i] = Math.toDegrees(this.phi[iMax][list]);
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FR");
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        double cosPhi0 = Math.cos(phi0);
        double sinPhi0 = Math.sin(phi0);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = (double)this.x[j][list] * cosPhi0 + (double)this.y[j][list] * sinPhi0;
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getYZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        double cosPhi0 = Math.cos(phi0);
        double sinPhi0 = Math.sin(phi0);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = (double)this.y[j][list] * cosPhi0 - (double)this.x[j][list] * sinPhi0;
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        this.cutStartRadius2();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int iMin;
            double rho1;
            int list = this.listdl[i];
            int iMax = 0;
            if (this.rho[1][list] > this.rho[0][list]) {
                iMax = 1;
            }
            if ((rho1 = (double)this.rho[iMin = 1 - iMax][list]) > 2.0) {
                hv[0][0][i] = this.z[iMin][list];
                hv[1][0][i] = Math.toDegrees(this.phi[iMin][list]);
            } else {
                double[] rpz = this.calculateRhoPhiZAtStart(list);
                hv[0][0][i] = rpz[2];
                hv[1][0][i] = Math.toDegrees(rpz[1]);
            }
            hv[0][1][i] = this.z[iMax][list];
            hv[1][1][i] = Math.toDegrees(this.phi[iMax][list]);
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FZ");
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionVP) {
            ag.draw(window.calculateDisplay(this.getVPUser(window, projection)));
        } else {
            super.draw(window, ag, projection);
        }
    }

    protected ACoord getVPUser(AWindow window, AProjection projection) {
        this.makeDrawList();
        double[][][] hv = new double[2][2 * this.numDraw][];
        int[] index = new int[2 * this.numDraw];
        int num = 0;
        for (int j = 0; j < this.numDraw; ++j) {
            int list = this.listdl[j];
            ADHelix dhelix = new ADHelix(this.innerTrack[list], this.event);
            double s1 = dhelix.getAStart();
            double s2 = 179.0;
            s1 = dhelix.intersectWithRadialCylinder(((AProjection2D)projection).getMinRho(), s1, s2);
            double sEnd = dhelix.intersectWithCylinder(true, AProjectionVP.getRhoVPlot(), true, AProjectionVP.getZVPlot());
            s2 = Math.max(Math.min(s2, sEnd), s1);
            if (s1 == 0.0 && s2 == 180.0) {
                s2 = 179.0;
            }
            if (APar.get("VP", "ShortV").getStatus() && !APar.get("Data", "S3D").getStatus()) {
                s1 = s2 - APar.get("VP", "ShortV").getD() * (s2 - s1);
            }
            if (!(s2 > s1)) continue;
            int signMin = -1;
            int signMax = 1;
            for (int sign = signMin; sign <= signMax; sign += 2) {
                AProjectionVP.sign = sign;
                ACoord pointsOnHelix = dhelix.drawHelix(window, (AProjection2D)projection, s1, s2);
                hv[0][num] = pointsOnHelix.hv[0][0];
                hv[1][num] = pointsOnHelix.hv[1][0];
                index[num] = list;
                ++num;
            }
        }
        return window.calculateUser(new ACoord(hv, index, (ADrawable)this, 6)).includePhiWrapAround(projection.getName());
    }

    private double[] calculateRhoPhiZAtStart(int index) {
        double[] rpz = new double[3];
        double rho1 = this.rho[0][index];
        double phi1 = this.phi[0][index];
        double z1 = this.z[0][index];
        double rho2 = this.rho[1][index];
        double phi2 = this.phi[1][index];
        double z2 = this.z[1][index];
        double x1 = rho1 * Math.cos(phi1);
        double y1 = rho1 * Math.sin(phi1);
        double x2 = rho2 * Math.cos(phi2);
        double y2 = rho2 * Math.sin(phi2);
        double fract = (2.0 - rho1) / (rho2 - rho1);
        double x = x1 + fract * (x2 - x1);
        double y = y1 + fract * (y2 - y1);
        double z = z1 + fract * (z2 - z1);
        double phi = Math.atan2(y, x);
        if (phi < 0.0) {
            phi += Math.PI * 2;
        }
        rpz[0] = 2.0;
        rpz[1] = phi;
        rpz[2] = z;
        return rpz;
    }

    public String getVPHitInfo() {
        this.makeDrawList();
        if (this.numDraw == 0) {
            return "";
        }
        double sumP = 0.0;
        double sumPt = 0.0;
        for (int i = 0; i < this.numDraw; ++i) {
            sumPt += (double)Math.abs(this.pT[this.listdl[i]]);
            double invLambda = (this.rho[1][this.listdl[i]] - this.rho[0][this.listdl[i]]) / (this.z[1][this.listdl[i]] - this.z[0][this.listdl[i]]);
            sumP += Math.abs((double)this.pT[this.listdl[i]] / Math.cos(Math.atan(1.0 / invLambda)));
        }
        String msg = this.numDraw + " " + this.getNameScreenName();
        msg = msg + "  sum(PT) = " + AMath.d2s(sumPt, 1) + "  sum(P) = " + AMath.d2s(sumP, 1);
        return msg;
    }

    public A4Vector get4Vector(int num, int[] list) {
        A4Vector sum = new A4Vector();
        for (int i = 0; i < num; ++i) {
            int k = list[i];
            A3Vector start = new A3Vector().setCylindrical(this.rho[0][k], this.phi[0][k], this.z[0][k]);
            A3Vector stop = new A3Vector().setCylindrical(this.rho[1][k], this.phi[1][k], this.z[1][k]);
            A3Vector v = stop.subtract(start).normalize();
            double p = (double)this.pT[k] / Math.sqrt(1.0 - v.z * v.z);
            sum.add(new A4Vector(v.scale(p), 0.0));
        }
        return sum;
    }

    public String getType(int index) {
        return APDGTable.getName(this.code[index]);
    }

    public double getP(int index) {
        return AMath.getPFromPttL(this.pT[index], this.tL[index]);
    }

    public double getPt(int index) {
        return this.pT[index];
    }

    public double getPhi(int index) {
        return this.phi0[index];
    }

    public double gettL(int index) {
        return this.tL[index];
    }

    public double getEta(int index) {
        return this.eta[index];
    }
}

