/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.ASVxData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.projection.AProjectionXZ;
import atlantis.utils.A3Vector;
import atlantis.utils.A4Vector;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.APDGTable;

public class ASNPData
extends AData {
    private static ALogger logger = ALogger.getLogger(ASNPData.class);
    private static final double START_RADIUS = 2.0;
    protected int[] code;
    protected int[] particleType;
    protected int[] originVertex;
    protected float[] pT;
    protected float[][] rho = new float[2][];
    protected float[][] phi = new float[2][];
    protected float[][] z = new float[2][];
    protected float[][] x = new float[2][this.numData];
    protected float[][] y = new float[2][this.numData];
    protected int[] type;
    private float[] temp;
    private int[] index;
    protected float[] phi0;
    protected float[] eta;
    protected float[] tL;

    public float[] getPt() {
        return this.pT;
    }

    public String getParameterGroup() {
        return "SNP";
    }

    public String getName() {
        return "SNP";
    }

    public String getNameScreenName() {
        return "SimNeutralTrack";
    }

    ASNPData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        this.rho[0] = p.getFloatArray("rhoVertex");
        this.phi[0] = p.getFloatArray("phiVertex");
        this.z[0] = p.getFloatArray("zVertex");
        this.pT = p.getFloatArray("pt");
        this.code = p.getIntArray("code");
        this.type = new int[this.numData];
        this.particleType = new int[this.numData];
        this.originVertex = p.getIntArray("simulatedVertex");
        this.temp = new float[this.numData];
        for (int i2 = 0; i2 < this.numData; ++i2) {
            if (Math.abs(this.code[i2]) <= 10) continue;
            this.particleType[i2] = APDGTable.getParticleType(this.code[i2]);
        }
        this.calculateReasonableEndpoints(p.getFloatArray("phi"), p.getFloatArray("eta"));
        double[] phiD = new double[this.numData];
        float[] phiF = p.getFloatArray("phi");
        for (i = 0; i < this.numData; ++i) {
            phiD[i] = phiF[i];
        }
        this.index = this.indexBy(phiD);
        this.calculateXY(this.rho[0], this.phi[0], this.x[0], this.y[0]);
        this.calculateXY(this.rho[1], this.phi[1], this.x[1], this.y[1]);
        this.phi0 = p.getFloatArray("phi");
        this.eta = p.getFloatArray("eta");
        this.tL = new float[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.tL[i] = (float)(1.0 / Math.tan(2.0 * Math.atan(Math.exp(-this.eta[i]))));
        }
    }

    protected void calculateRhoPhi() {
        this.calculateRhoPhi(this.x[0], this.y[0], this.rho[0], this.phi[0]);
        this.calculateRhoPhi(this.x[1], this.y[1], this.rho[1], this.phi[1]);
    }

    public static AHashMap createSNP(AHashMap p) {
        float[] pt = p.getFloatArray("pt");
        float[] phi = p.getFloatArray("phi");
        float[] eta = p.getFloatArray("eta");
        float[] rhoVertex = p.getFloatArray("rhoVertex");
        float[] phiVertex = p.getFloatArray("phiVertex");
        float[] zVertex = p.getFloatArray("zVertex");
        int[] id = p.getIntArray("id");
        int[] code = p.getIntArray("code");
        int numNeutral = 0;
        for (int i = 0; i < code.length; ++i) {
            int charge = code[i];
            try {
                if (Math.abs(code[i]) >= 10) {
                    charge = APDGTable.getCharge(code[i]);
                }
                if (charge != 0) continue;
                ++numNeutral;
                continue;
            }
            catch (APDGTable.ParticleNotFoundError pnf) {
                logger.debug(pnf.getMessage());
            }
        }
        int[] simulatedVertex = ASVxData.assignVertexNumbers(phiVertex, rhoVertex, zVertex);
        int[] idN = new int[numNeutral];
        float[] rhoVertexN = new float[numNeutral];
        float[] phiVertexN = new float[numNeutral];
        float[] zVertexN = new float[numNeutral];
        float[] ptN = new float[numNeutral];
        float[] phiN = new float[numNeutral];
        float[] etaN = new float[numNeutral];
        int[] codeN = new int[numNeutral];
        int[] simulatedVertexN = new int[numNeutral];
        numNeutral = 0;
        for (int i = 0; i < code.length; ++i) {
            double charge = code[i];
            try {
                if (Math.abs(code[i]) >= 10) {
                    charge = APDGTable.getCharge(code[i]);
                }
                if (charge != 0.0) continue;
                idN[numNeutral] = id[i];
                rhoVertexN[numNeutral] = rhoVertex[i];
                phiVertexN[numNeutral] = phiVertex[i];
                zVertexN[numNeutral] = zVertex[i];
                ptN[numNeutral] = pt[i];
                phiN[numNeutral] = phi[i];
                etaN[numNeutral] = eta[i];
                codeN[numNeutral] = code[i];
                simulatedVertexN[numNeutral] = simulatedVertex[i];
                ++numNeutral;
                continue;
            }
            catch (APDGTable.ParticleNotFoundError pnf) {
                logger.debug(pnf.getMessage());
            }
        }
        AHashMap newP = new AHashMap(10);
        newP.put("numData", new Integer(numNeutral));
        newP.put("id", idN);
        newP.put("rhoVertex", rhoVertexN);
        newP.put("phiVertex", phiVertexN);
        newP.put("zVertex", zVertexN);
        newP.put("pt", ptN);
        newP.put("phi", phiN);
        newP.put("eta", etaN);
        newP.put("code", codeN);
        newP.put("simulatedVertex", simulatedVertexN);
        return newP;
    }

    private void calculateReasonableEndpoints(float[] dirPhi, float[] dirEta) {
        double rhoTo = APar.get("RTr", "RadiusTr").getD();
        double zTo = APar.get("RTr", "ZTr").getD();
        this.rho[1] = (float[])this.rho[0].clone();
        this.phi[1] = (float[])this.phi[0].clone();
        this.z[1] = (float[])this.z[0].clone();
        for (int i = 0; i < this.numData; ++i) {
            if (this.particleType[i] == 5) {
                rhoTo = 150.0;
                zTo = 370.0;
            } else {
                rhoTo = 228.0;
                zTo = 426.2;
            }
            if ((double)this.rho[0][i] > rhoTo || (double)Math.abs(this.z[0][i]) > zTo) continue;
            double rho2 = rhoTo;
            double tanLambda = AMath.tanLambda(dirEta[i]);
            double zz = (double)this.z[0][i] + (rho2 - (double)this.rho[0][i]) * tanLambda;
            if (zz > zTo) {
                rho2 = (zTo - (double)this.z[0][i]) / tanLambda + (double)this.rho[0][i];
            }
            if (zz < -zTo) {
                rho2 = (-zTo - (double)this.z[0][i]) / tanLambda + (double)this.rho[0][i];
            }
            double x = (double)this.rho[0][i] * Math.cos(this.phi[0][i]);
            double y = (double)this.rho[0][i] * Math.sin(this.phi[0][i]);
            double m = Math.tan(dirPhi[i]);
            double c = y - m * x;
            double a = m * m + 1.0;
            double b = 2.0 * m * c;
            double cc = c * c - rho2 * rho2;
            double d = Math.sqrt(b * b - 4.0 * a * cc);
            double x1 = (-b + d) / (a * 2.0);
            double x2 = (-b - d) / (a * 2.0);
            double y1 = m * x1 + c;
            double y2 = m * x2 + c;
            double xx = x1;
            double yy = y1;
            if ((x2 - x) * Math.cos(dirPhi[i]) + (y2 - y) * Math.sin(dirPhi[i]) > 0.0) {
                xx = x2;
                yy = y2;
            }
            zz = (double)this.z[0][i] + (rho2 - (double)this.rho[0][i]) * tanLambda;
            this.rho[1][i] = (float)Math.sqrt(xx * xx + yy * yy);
            this.phi[1][i] = (float)Math.atan2(yy, xx);
            if ((double)this.phi[1][i] < 0.0) {
                float[] fArray = this.phi[1];
                int n = i;
                fArray[n] = (float)((double)fArray[n] + Math.PI * 2);
            }
            this.z[1][i] = (float)zz;
        }
    }

    protected void applyCuts() {
        AData.printCut("SNP", this.numDraw);
        this.cutIndex();
        this.cut("CutsInDet", "STrType", " STr Type", this.particleType);
        this.cut("CutsInDet", "STr", " STr id", this.id);
        this.cut("CutsInDet", "Pt", " |Pt|", this.pT);
        this.cut("CutsInDet", "SVx", " Vertex", this.originVertex);
        this.cut("CutsInDet", "d0", " |d0|", this.getD0());
        this.cut("CutsInDet", "d0Loose", " |d0Loose|", this.getD0());
        this.cut("CutsInDet", "z0-zVtx", " |z0-zVtx|", this.getZ0Primary());
        this.cut("CutsInDet", "z0", " |z0|", this.getZ0());
        this.cutPhi(this.phi[1]);
        float[] phiStart = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            int iMin;
            int list = this.listdl[i];
            int iMax = 0;
            if (this.rho[1][list] > this.rho[0][list]) {
                iMax = 1;
            }
            if ((double)this.rho[iMin = 1 - iMax][list] > 2.0) {
                phiStart[list] = this.phi[iMin][list];
                continue;
            }
            double[] rpz = this.calculateRhoPhiZAtStart(list);
            phiStart[list] = (float)rpz[1];
        }
        this.cutPhi(phiStart);
        this.cutEta(this.rho[1], this.z[1]);
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorByIndex(this.index);
        } else if (colorFunction == 2) {
            this.colorBy(this.getPt());
        } else if (colorFunction == 3) {
            this.colorBy("ParticleColors", this.particleType);
        } else if (colorFunction == 4) {
            this.colorBy(this.originVertex);
        }
        return 3;
    }

    public String getHitInfo(int index) {
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n Type = ");
        msg.append(APDGTable.getName(this.code[index]));
        msg.append("\n PT = ");
        msg.append(AMath.d2s(this.pT[index], 3));
        msg.append(" GeV");
        return msg.toString();
    }

    protected void cutStartRadius() {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (!((double)Math.max(this.rho[0][this.listdl[i]], this.rho[1][this.listdl[i]]) > 2.0)) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut(" Start rho", this.numDraw);
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.x[j][list];
                hv[1][j][i] = this.y[j][list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiDiff = Math.abs((double)this.phi[1][list] - phiMid);
            double sign = phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469 ? 1.0 : -1.0;
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = sign * (double)this.rho[j][list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        this.cutStartRadius();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int iMax = 0;
            if (this.rho[1][list] > this.rho[0][list]) {
                iMax = 1;
            }
            int iMin = 1 - iMax;
            double rho1 = this.rho[iMin][list];
            double rho2 = this.rho[iMax][list];
            if (rho1 > 2.0) {
                hv[0][0][i] = rho1;
                hv[1][0][i] = Math.toDegrees(this.phi[iMin][list]);
            } else {
                double[] rpz = this.calculateRhoPhiZAtStart(list);
                hv[0][0][i] = rpz[0];
                hv[1][0][i] = Math.toDegrees(rpz[1]);
            }
            hv[0][1][i] = rho2;
            hv[1][1][i] = Math.toDegrees(this.phi[iMax][list]);
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FR");
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        double cosPhi0 = Math.cos(phi0);
        double sinPhi0 = Math.sin(phi0);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = (double)this.x[j][list] * cosPhi0 + (double)this.y[j][list] * sinPhi0;
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getYZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        double cosPhi0 = Math.cos(phi0);
        double sinPhi0 = Math.sin(phi0);
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = (double)this.y[j][list] * cosPhi0 - (double)this.x[j][list] * sinPhi0;
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        this.cutStartRadius();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int iMin;
            double rho1;
            int list = this.listdl[i];
            int iMax = 0;
            if (this.rho[1][list] > this.rho[0][list]) {
                iMax = 1;
            }
            if ((rho1 = (double)this.rho[iMin = 1 - iMax][list]) > 2.0) {
                hv[0][0][i] = this.z[iMin][list];
                hv[1][0][i] = Math.toDegrees(this.phi[iMin][list]);
            } else {
                double[] rpz = this.calculateRhoPhiZAtStart(list);
                hv[0][0][i] = rpz[2];
                hv[1][0][i] = Math.toDegrees(rpz[1]);
            }
            hv[0][1][i] = this.z[iMax][list];
            hv[1][1][i] = Math.toDegrees(this.phi[iMax][list]);
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FZ");
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = AMath.eta(this.z[1][list], this.rho[1][list]);
            v[i] = Math.toDegrees(this.phi[1][list]);
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("VP");
    }

    private double[] calculateRhoPhiZAtStart(int index) {
        double[] rpz = new double[3];
        double rho1 = this.rho[0][index];
        double phi1 = this.phi[0][index];
        double z1 = this.z[0][index];
        double rho2 = this.rho[1][index];
        double phi2 = this.phi[1][index];
        double z2 = this.z[1][index];
        double x1 = rho1 * Math.cos(phi1);
        double y1 = rho1 * Math.sin(phi1);
        double x2 = rho2 * Math.cos(phi2);
        double y2 = rho2 * Math.sin(phi2);
        double fract = (2.0 - rho1) / (rho2 - rho1);
        double x = x1 + fract * (x2 - x1);
        double y = y1 + fract * (y2 - y1);
        double z = z1 + fract * (z2 - z1);
        double phi = Math.atan2(y, x);
        if (phi < 0.0) {
            phi += Math.PI * 2;
        }
        rpz[0] = 2.0;
        rpz[1] = phi;
        rpz[2] = z;
        return rpz;
    }

    public String getVPHitInfo() {
        this.makeDrawList();
        if (this.numDraw == 0) {
            return "";
        }
        double sumP = 0.0;
        double sumPt = 0.0;
        for (int i = 0; i < this.numDraw; ++i) {
            sumPt += (double)Math.abs(this.pT[this.listdl[i]]);
            double invLambda = (this.rho[1][this.listdl[i]] - this.rho[0][this.listdl[i]]) / (this.z[1][this.listdl[i]] - this.z[0][this.listdl[i]]);
            sumP += Math.abs((double)this.pT[this.listdl[i]] / Math.cos(Math.atan(1.0 / invLambda)));
        }
        String msg = this.numDraw + " " + this.getNameScreenName();
        msg = msg + "  sum(PT) = " + AMath.d2s(sumPt, 1) + "  sum(P) = " + AMath.d2s(sumP, 1);
        return msg;
    }

    public A4Vector get4Vector(int num, int[] list) {
        A4Vector sum = new A4Vector();
        for (int i = 0; i < num; ++i) {
            int k = list[i];
            A3Vector start = new A3Vector().setCylindrical(this.rho[0][k], this.phi[0][k], this.z[0][k]);
            A3Vector stop = new A3Vector().setCylindrical(this.rho[1][k], this.phi[1][k], this.z[1][k]);
            A3Vector v = stop.subtract(start).normalize();
            double p = (double)this.pT[k] / Math.sqrt(1.0 - v.z * v.z);
            sum.add(new A4Vector(v.scale(p), 0.0));
        }
        return sum;
    }

    private float[] getZ0() {
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double[] poca = this.getPoca(list);
            this.temp[list] = (float)poca[2];
        }
        return this.temp;
    }

    private float[] getZ0Primary() {
        double[] primary = this.event.getPrimaryVertex();
        double c = primary[2];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double[] poca = this.getPoca(list);
            this.temp[list] = (float)(poca[2] - c);
        }
        return this.temp;
    }

    private float[] getD0() {
        double[] primary = this.event.getPrimaryVertex();
        double a = primary[0];
        double b = primary[1];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double[] poca = this.getPoca(list);
            this.temp[list] = (float)AMath.distance(a, b, poca[0], poca[1]);
        }
        return this.temp;
    }

    private double[] getPoca(int i) {
        double my;
        double mx;
        double yMin;
        double xMin;
        double[] primary = this.event.getPrimaryVertex();
        double a = primary[0];
        double b = primary[1];
        double dx = this.x[1][i] - this.x[0][i];
        if (dx == 0.0) {
            xMin = this.x[0][i];
            yMin = b;
        } else {
            double m = (double)(this.y[1][i] - this.y[0][i]) / dx;
            double c = (double)this.y[0][i] - m * (double)this.x[0][i];
            xMin = (a + (b - c) * m) / (m * m + 1.0);
            yMin = m * xMin + c;
        }
        double dz = this.z[1][i] - this.z[0][i];
        double zMin = dz == 0.0 ? (double)this.z[0][i] : ((mx = (double)(this.x[1][i] - this.x[0][i]) / dz) != 0.0 ? (double)this.z[0][i] + (xMin - (double)this.x[0][i]) / mx : ((my = (double)(this.y[1][i] - this.y[0][i]) / dz) != 0.0 ? (double)this.z[0][i] + (yMin - (double)this.y[0][i]) / my : (double)this.z[0][i]));
        return new double[]{xMin, yMin, zMin};
    }

    public String getType(int index) {
        return APDGTable.getName(this.code[index]);
    }

    public double getP(int index) {
        return AMath.getPFromPttL(this.pT[index], this.tL[index]);
    }

    public double getPt(int index) {
        return this.pT[index];
    }

    public double getPhi(int index) {
        return this.phi0[index];
    }

    public double gettL(int index) {
        return this.tL[index];
    }

    public double getEta(int index) {
        return this.eta[index];
    }
}

