/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.ASVxData;
import atlantis.data.ATrackData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.parameters.APar;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.APDGTable;

public class ASTrData
extends ATrackData {
    private static ALogger logger = ALogger.getLogger(ASTrData.class);
    public static final int UNDERLYING_EVENT = 0;
    public static final int NORMAL = 1;
    protected int[] code;
    protected int[] type;
    protected int[] particleType;
    protected int[] originVertex;

    public String getParameterGroup() {
        return "STr";
    }

    public String getName() {
        return "STr";
    }

    public String getNameScreenName() {
        return "SimChargedTrack";
    }

    ASTrData(AHashMap p, AEvent e) throws AAtlantisException {
        super(p, e);
        this.code = p.getIntArray("code");
        this.originVertex = p.getIntArray("originVertex");
        this.type = p.getIntArray("type");
        this.particleType = new int[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            this.particleType[i] = APDGTable.getParticleType(this.code[i]);
        }
    }

    public static AHashMap createSTr(AHashMap p) {
        float[] pt = p.getFloatArray("pt");
        float[] phi = p.getFloatArray("phi");
        float[] eta = p.getFloatArray("eta");
        float[] rhoVertex = p.getFloatArray("rhoVertex");
        float[] phiVertex = p.getFloatArray("phiVertex");
        float[] zVertex = p.getFloatArray("zVertex");
        int[] id = p.getIntArray("id");
        int[] code = p.getIntArray("code");
        float[] rhoEndVertex = p.get("rhoEndVertex") != null ? p.getFloatArray("rhoEndVertex") : null;
        int numCharged = 0;
        for (int i = 0; i < code.length; ++i) {
            int charge = code[i];
            try {
                if (Math.abs(code[i]) >= 10 || Math.abs(code[i]) == 1) {
                    charge = APDGTable.getCharge(code[i]);
                }
                if (charge != 1 && charge != -1) continue;
                ++numCharged;
                continue;
            }
            catch (APDGTable.ParticleNotFoundError pnf) {
                logger.debug(pnf.getMessage());
            }
        }
        int[] simulatedVertex = ASVxData.assignVertexNumbers(phiVertex, rhoVertex, zVertex);
        int[] idC = new int[numCharged];
        int[] typeC = new int[numCharged];
        float[] rhoVertexC = new float[numCharged];
        float[] rhoEndVertexC = new float[numCharged];
        float[] phiVertexC = new float[numCharged];
        float[] zVertexC = new float[numCharged];
        float[] ptC = new float[numCharged];
        float[] phiC = new float[numCharged];
        float[] etaC = new float[numCharged];
        int[] chargeC = new int[numCharged];
        int[] codeC = new int[numCharged];
        int[] simulatedVertexC = new int[numCharged];
        numCharged = 0;
        for (int i = 0; i < code.length; ++i) {
            int charge = code[i];
            try {
                if (Math.abs(code[i]) >= 10 || Math.abs(code[i]) == 1) {
                    charge = APDGTable.getCharge(code[i]);
                }
                if (charge != 1 && charge != -1) continue;
                if (id[i] > 0) {
                    idC[numCharged] = id[i];
                    typeC[numCharged] = 1;
                } else {
                    idC[numCharged] = 0;
                    typeC[numCharged] = 0;
                }
                rhoVertexC[numCharged] = rhoVertex[i];
                rhoEndVertexC[numCharged] = rhoEndVertex != null ? rhoEndVertex[i] : 0.0f;
                phiVertexC[numCharged] = phiVertex[i];
                zVertexC[numCharged] = zVertex[i];
                ptC[numCharged] = pt[i];
                phiC[numCharged] = phi[i];
                etaC[numCharged] = eta[i];
                codeC[numCharged] = code[i];
                chargeC[numCharged] = charge;
                simulatedVertexC[numCharged] = simulatedVertex[i];
                ++numCharged;
                continue;
            }
            catch (APDGTable.ParticleNotFoundError pnf) {
                logger.debug(pnf.getMessage());
            }
        }
        AHashMap newP = new AHashMap(12);
        newP.put("numData", new Integer(numCharged));
        newP.put("id", idC);
        newP.put("type", typeC);
        newP.put("rhoVertex", rhoVertexC);
        newP.put("rhoEndVertex", rhoEndVertexC);
        newP.put("phiVertex", phiVertexC);
        newP.put("zVertex", zVertexC);
        newP.put("pt", ptC);
        newP.put("phi", phiC);
        newP.put("eta", etaC);
        newP.put("code", codeC);
        newP.put("charge", chargeC);
        newP.put("originVertex", simulatedVertexC);
        return newP;
    }

    public int getMaxSumPtVertex() {
        int maxVertex = 0;
        for (int i = 0; i < this.numData; ++i) {
            if (this.type[i] != 1 || this.originVertex[i] <= maxVertex) continue;
            maxVertex = this.originVertex[i];
        }
        double[] sumPt = new double[maxVertex + 1];
        for (int i = 0; i < this.numData; ++i) {
            if (this.type[i] != 1 || !(Math.abs(this.h[i].d0) < 2.0)) continue;
            int n = this.originVertex[i];
            sumPt[n] = sumPt[n] + Math.abs(this.h[i].pT);
        }
        int VtxIndex = 0;
        for (int i = 0; i < sumPt.length; ++i) {
            if (!(sumPt[i] > sumPt[VtxIndex])) continue;
            VtxIndex = i;
        }
        return VtxIndex;
    }

    protected void applyCuts() {
        super.applyCuts();
        super.cutRhoVertexAfterInDetRadius();
        AData.printCut("STr", this.numDraw);
        this.cut("CutsInDet", "STr", " STr id", this.id);
        this.cut("CutsInDet", "STrCode", " STr code", this.code);
        this.cut("CutsInDet", "STrType", " STr Type", this.particleType);
        this.cut("CutsInDet", "SVx", " Vertex", this.originVertex);
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        switch (colorFunction) {
            case 0: {
                this.colorByConstant();
                break;
            }
            case 1: {
                this.colorByIndex(this.index);
                break;
            }
            case 2: {
                this.colorBy(this.getPt());
                break;
            }
            case 3: {
                this.colorBy("ParticleColors", this.particleType);
                break;
            }
            case 4: {
                this.colorBy(this.originVertex);
            }
        }
        return 4;
    }

    public String getHitInfo(int index) {
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (barcode/id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n Type = ");
        msg.append(APDGTable.getName(this.code[index]));
        msg.append(" (type code ");
        msg.append(this.code[index]);
        msg.append(")");
        msg.append(this.h[index].toString());
        return msg.toString();
    }

    public String getType(int index) {
        return APDGTable.getName(this.code[index]);
    }
}

