/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.A3DPointData;
import atlantis.data.Vertex;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;
import java.util.HashMap;

public class ASVxData
extends A3DPointData {
    public String getParameterGroup() {
        return "SVx";
    }

    public String getName() {
        return "SVx";
    }

    public String getNameScreenName() {
        return "SimVertex";
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n" + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + "\n " + "z = " + AMath.d2s(this.z[index], 3) + " cm\n" + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        return this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")" + "\n x = " + AMath.d2s(this.x[index], 5) + " cm" + "\n y = " + AMath.d2s(this.y[index], 5) + " cm" + "\n z = " + AMath.d2s(this.z[index], 5) + " cm" + "\n " + "\u03c1" + " = " + AMath.d2s(this.rho[index], 5) + " cm" + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 5) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 5) + " rad)";
    }

    ASVxData(AHashMap p, AEvent e) {
        super(p, e);
    }

    public static AHashMap createSVx(AHashMap p) {
        float[] rhoVertex = p.getFloatArray("rhoVertex");
        float[] phiVertex = p.getFloatArray("phiVertex");
        float[] zVertex = p.getFloatArray("zVertex");
        int[] sv = ASVxData.assignVertexNumbers(phiVertex, rhoVertex, zVertex);
        int numVertex = 0;
        for (int i = 0; i < sv.length; ++i) {
            if (sv[i] < numVertex) continue;
            numVertex = sv[i] + 1;
        }
        float[] rho = new float[numVertex];
        float[] phi = new float[numVertex];
        float[] z = new float[numVertex];
        for (int i = 0; i < sv.length; ++i) {
            rho[sv[i]] = rhoVertex[i];
            phi[sv[i]] = phiVertex[i];
            z[sv[i]] = zVertex[i];
        }
        AHashMap newP = new AHashMap(4);
        newP.put("numData", new Integer(numVertex));
        newP.put("rho", rho);
        newP.put("phi", phi);
        newP.put("z", z);
        return newP;
    }

    public static int[] assignVertexNumbers(float[] phi, float[] rho, float[] z) {
        int[] sv = new int[phi.length];
        Vertex[] key = new Vertex[phi.length];
        HashMap<Vertex, Integer> vertices = new HashMap<Vertex, Integer>();
        int num = 1;
        for (int i = 0; i < sv.length; ++i) {
            key[i] = new Vertex(rho[i], phi[i], z[i]);
            Object value = vertices.get(key[i]);
            if (value == null) {
                sv[i] = num;
                vertices.put(key[i], new Integer(num++));
                continue;
            }
            sv[i] = (Integer)value;
        }
        return sv;
    }

    protected int internalColor() {
        this.colorByConstant();
        return 1;
    }

    protected void applyCuts() {
        AData.printCut("SVx", this.numDraw);
        this.cutIndex();
        this.cutPhi(this.phi);
        this.cutEta(this.rho, this.z);
        this.cut("CutsInDet", "SVx", " Vertex", this.id);
    }

    public double[] getVertex(int index) {
        double[] vertex = new double[3];
        if (index > -1 && index < this.numData) {
            vertex[0] = this.x[index];
            vertex[1] = this.y[index];
            vertex[2] = this.z[index];
        }
        return vertex;
    }
}

