/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.projection.AProjectionXZ;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public abstract class ASegmentData
extends AData {
    protected float[] x;
    protected float[] y;
    protected float[] z;
    protected float[] theta;
    protected float[] phi;
    protected int[] hits;
    protected int[] numHits;

    ASegmentData(AHashMap p, AEvent e) {
        super(p, e);
        this.x = p.getFloatArray("x");
        this.y = p.getFloatArray("y");
        this.z = p.getFloatArray("z");
        this.phi = p.getFloatArray("phi");
        this.theta = p.getFloatArray("theta");
        this.numHits = p.getIntArray("numHits");
        this.hits = p.getIntArray("hits");
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        switch (colorFunction) {
            case 0: {
                this.colorByConstant();
                break;
            }
            case 1: {
                this.colorByIndex();
            }
        }
        return 1;
    }

    protected void applyCuts() {
        this.cutIndex();
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n" + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        return this.getName() + " (index: " + index + ")\n" + " storegate key = " + this.storeGateKey + "\n" + " " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "  (" + AMath.d2s(this.phi[index], 3) + " rad)" + "\n" + " tL = " + AMath.d2s(Math.toDegrees(1.0 / Math.tan(this.theta[index])), 3) + "\n" + " x = " + AMath.d2s(this.x[index], 3) + " cm\n" + " y = " + AMath.d2s(this.y[index], 3) + " cm\n" + " z = " + AMath.d2s(this.z[index], 3) + " cm\n" + " hits = " + this.numHits[index] + "\n";
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        double length = APar.get(this.PARAMETER_GROUP, "SegmentLength").getD();
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            double dx = length * Math.sin(this.theta[j]) * Math.cos(this.phi[j]);
            double dy = length * Math.sin(this.theta[j]) * Math.sin(this.phi[j]);
            hv[0][i] = new double[]{(double)this.x[j] - dx, (double)this.x[j] - dx / 2.0, this.x[j], (double)this.x[j] + dx / 2.0, (double)this.x[j] + dx};
            hv[1][i] = new double[]{(double)this.y[j] - dy, (double)this.y[j] - dy / 2.0, this.y[j], (double)this.y[j] + dy / 2.0, (double)this.y[j] + dy};
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this, 6);
    }

    protected ACoord getFRUser() {
        return this.getYXUser().convertYXToFR().includePhiWrapAround("FR");
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        double length = APar.get(this.PARAMETER_GROUP, "SegmentLength").getD();
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            double dx = length * Math.sin(this.theta[j]) * Math.cos(this.phi[j]);
            double dy = length * Math.sin(this.theta[j]) * Math.sin(this.phi[j]);
            double dz = length * Math.cos(this.theta[j]);
            double r = (double)AMath.getRhoSign(this.x[j], this.y[j]) * Math.sqrt(this.x[j] * this.x[j] + this.y[j] * this.y[j]);
            double dr = (double)AMath.getRhoSign(this.x[j], this.y[j]) * Math.sqrt(dx * dx + dy * dy);
            hv[0][i] = new double[]{(double)this.z[j] - dz, (double)this.z[j] + dz};
            hv[1][i] = new double[]{r - dr, r + dr};
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        double length = APar.get(this.PARAMETER_GROUP, "SegmentLength").getD();
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            double dx = length * Math.sin(this.theta[j]) * Math.cos(this.phi[j]);
            double dy = length * Math.sin(this.theta[j]) * Math.sin(this.phi[j]);
            double dz = length * Math.cos(this.theta[j]);
            double s = (double)this.x[j] * Math.cos(phi0) + (double)this.y[j] * Math.sin(phi0);
            double ds = dx * Math.cos(phi0) + dy * Math.sin(phi0);
            if (this.z[j] < 0.0f) {
                hv[0][i] = new double[]{(double)this.z[j] + dz, (double)this.z[j] - dz};
                hv[1][i] = new double[]{s - ds, s + ds};
            } else {
                hv[0][i] = new double[]{(double)this.z[j] - dz, (double)this.z[j] + dz};
                hv[1][i] = new double[]{s - ds, s + ds};
            }
            index[i] = j;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }
}

