/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AHitData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjectionVP;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;

public class ASiClusterData
extends AHitData {
    private static ALogger logger = ALogger.getLogger(ASiClusterData.class);
    private float[][] x;
    private float[][] y;
    private float[][] z;
    private float[] width;
    private int[] etaModule;
    private int[] phiModule;
    private int[] side;
    private float[][] rho;
    private float[][] phi;
    private int[] layer;
    public static final int U_CLUSTER = -1;
    public static final int PHI_CLUSTER = 0;
    public static final int V_CLUSTER = 1;
    public static final int ENDCAP_MINUS = 0;
    public static final int BARREL = 1;
    public static final int ENDCAP_PLUS = 2;

    public String getParameterGroup() {
        return "SiCluster";
    }

    public String getName() {
        return "SiCluster";
    }

    public String getNameScreenName() {
        return "SCT_Cluster";
    }

    public float[][] getX() {
        return this.x;
    }

    public float[][] getY() {
        return this.y;
    }

    public float[][] getZ() {
        return this.z;
    }

    ASiClusterData(AHashMap p, AEvent e) {
        super(p, e);
        this.x = new float[][]{p.getFloatArray("x0"), p.getFloatArray("x1")};
        this.y = new float[][]{p.getFloatArray("y0"), p.getFloatArray("y1")};
        this.z = new float[][]{p.getFloatArray("z0"), p.getFloatArray("z1")};
        this.width = p.getFloatArray("width");
        this.rho = new float[2][this.numData];
        this.phi = new float[2][this.numData];
        this.layer = new int[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            this.sub[i] = this.getSub(this.id[i]);
            this.layer[i] = this.getLayer(this.id[i]);
        }
        this.etaModule = p.get("etaModule") != null ? p.getIntArray("etaModule") : null;
        this.phiModule = p.get("phiModule") != null ? p.getIntArray("phiModule") : null;
        this.side = p.get("side") != null ? p.getIntArray("side") : null;
    }

    protected void calculateRhoPhi() {
        this.calculateRhoPhi(this.x[0], this.y[0], this.rho[0], this.phi[0]);
        this.calculateRhoPhi(this.x[1], this.y[1], this.rho[1], this.phi[1]);
        for (int i = 0; i < this.numData; ++i) {
            if (!((double)Math.abs(this.phi[1][i] - this.phi[0][i]) > Math.PI)) continue;
            if (this.phi[1][i] - this.phi[0][i] > 0.0f) {
                float[] fArray = this.phi[0];
                int n = i;
                fArray[n] = (float)((double)fArray[n] + Math.PI * 2);
                continue;
            }
            float[] fArray = this.phi[1];
            int n = i;
            fArray[n] = (float)((double)fArray[n] + Math.PI * 2);
        }
    }

    private void cutSubdetector() {
        AParameter par = APar.get("CutsInDet", "SCT");
        if (par.getI() != -1) {
            this.cutArray(this.sub, par.getI(), "Barrel/Endcap");
        }
    }

    protected void applyCuts() {
        AData.printCut("SiCluster", this.numDraw);
        this.cutIndex();
        this.cutOrientation();
        this.cutSubdetector();
        this.cut("CutsInDet", "Layer", "Layer", this.layer);
        this.cutSimulatedTracks();
        this.cutReconstructedTracks();
        this.cutPhi(this.phi[0]);
        this.cutEta();
    }

    private void cutEta() {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        if (!par.getStatus()) {
            return;
        }
        double etaCut = par.getD();
        double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
        double etaLowerCut = etaMid - etaCut;
        double etaUpperCut = etaMid + etaCut;
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double eta1 = AMath.eta(this.z[0][list], this.rho[0][list]);
            double eta2 = AMath.eta(this.z[1][list], this.rho[1][list]);
            double etaLower = Math.min(eta1, eta2);
            double etaUpper = Math.max(eta1, eta2);
            if (!(etaUpper > etaLowerCut) || !(etaLower < etaUpperCut)) continue;
            this.listdl[num++] = list;
        }
        this.numDraw = num;
        AData.printCut(" Eta", this.numDraw);
    }

    public int getLayer(int id) {
        int layer = (id & 0x1E00000) >> 21;
        int sub = this.getSub(id);
        layer = sub == 1 ? (layer += 3) : (layer += 11);
        return layer;
    }

    public int getSub(int id) {
        return (id & 0x6000000) >> 25;
    }

    public int getOrientation(int id) {
        int side = (id & 0x400) >> 10;
        int sub = this.getSub(id);
        if (side == 1 && sub == 1 || side == 0 && sub != 1) {
            return 0;
        }
        int layer = this.getLayer(id);
        if (layer % 2 == 1) {
            return -1;
        }
        return 1;
    }

    protected void cutOrientation() {
        int num = 0;
        AParameter stereoAnglePar = APar.get("SiCluster", "Stereo");
        if (!stereoAnglePar.getStatus()) {
            return;
        }
        int orientation = stereoAnglePar.getI();
        for (int i = 0; i < this.numDraw; ++i) {
            if (orientation != this.getOrientation(this.id[this.listdl[i]])) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut("Orientation", this.numDraw);
    }

    protected int internalColor() {
        int numColorTypes = super.internalColor();
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == numColorTypes + 1) {
            this.colorBy(this.layer);
        } else if (colorFunction == numColorTypes + 2) {
            this.colorByOrientation();
        }
        return numColorTypes + 2;
    }

    protected void colorByOrientation() {
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = (byte)col[this.getOrientation(this.id[i]) + 1 % numColors];
        }
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index;
        }
        String temp = this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")\n" + " orientation = " + this.getOrientation(this.id[index]);
        temp = temp + "\n x = " + this.x[0][index] + "  " + this.x[1][index];
        temp = temp + "\n y = " + this.y[0][index] + "  " + this.y[1][index];
        temp = temp + "\n z = " + this.z[0][index] + "  " + this.z[1][index];
        temp = temp + "\n \u03c1 = " + this.rho[0][index] + "  " + this.rho[1][index];
        temp = temp + "\n \u03b7 module = ";
        temp = temp + (this.etaModule != null ? Integer.toString(this.etaModule[index]) : "n/a");
        temp = temp + "\n \u03a6 module = ";
        temp = temp + (this.phiModule != null ? Integer.toString(this.phiModule[index]) : "n/a");
        temp = temp + "\n side = ";
        temp = temp + (this.side != null ? Integer.toString(this.side[index]) : "n/a");
        temp = temp + "\n width = ";
        temp = temp + (this.width != null ? Float.toString(this.width[index]) : "n/a");
        temp = temp + super.getHitInfo(index);
        return temp;
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.x[j][list];
                hv[1][j][i] = this.y[j][list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiDiff = Math.abs((double)this.phi[1][list] - phiMid);
            double sign = phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469 ? 1.0 : -1.0;
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = sign * (double)this.rho[j][list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.rho[j][list];
                hv[1][j][i] = Math.toDegrees(AMath.getPhiStereo(this.rho[j][list], this.phi[j][list], this.z[j][list]));
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FR");
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = Math.toDegrees(AMath.getPhiStereo(this.rho[j][list], this.phi[j][list], this.z[j][list]));
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FZ");
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        int numTotal = 2 * this.numDraw;
        double[][][] hv = new double[2][numTotal][2];
        int[] index = new int[numTotal];
        double[] sign = new double[]{-1.0, 1.0};
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int k = 0; k < 2; ++k) {
                double deltaEta = AProjectionVP.getDeltaEta(this.rho[k][list], this.z[k][list]);
                double eta = AMath.eta(this.z[k][list], this.rho[k][list]);
                for (int j = 0; j < 2; ++j) {
                    hv[0][2 * i + j][k] = eta + sign[j] * deltaEta;
                    hv[1][2 * i + j][k] = Math.toDegrees(this.phi[k][list]);
                    index[2 * i + j] = list;
                }
            }
        }
        return new ACoord(hv, index, (ADrawable)this, 3).includePhiWrapAround("VP");
    }
}

