/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AHitData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjectionVP;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;

public class ASiClusterRDOData
extends AHitData {
    private static ALogger logger = ALogger.getLogger(ASiClusterRDOData.class);
    private float[][] x = null;
    private float[][] y = null;
    private float[][] z = null;
    private int[] etaModule = null;
    private int[] phiModule = null;
    private int[] BCIDError = null;
    private int[] firstHitError = null;
    private int[] formatterError = null;
    private int[] lvl1Error = null;
    private int[] preambleError = null;
    private int[] secondHitError = null;
    private int[] syncError = null;
    private int[] timeBin = null;
    private int[] layer;
    private float[][] rho;
    private float[][] phi;
    public static final int U_CLUSTER = -1;
    public static final int PHI_CLUSTER = 0;
    public static final int V_CLUSTER = 1;
    public static final int ENDCAP_MINUS = 0;
    public static final int BARREL = 1;
    public static final int ENDCAP_PLUS = 2;

    public String getParameterGroup() {
        return "SiClusterRDO";
    }

    public String getName() {
        return "SiClusterRDO";
    }

    public String getNameScreenName() {
        return "SiClusterRDO";
    }

    ASiClusterRDOData(AHashMap p, AEvent e) {
        super(p, e);
        this.x = new float[][]{p.getFloatArray("x0"), p.getFloatArray("x1")};
        this.y = new float[][]{p.getFloatArray("y0"), p.getFloatArray("y1")};
        this.z = new float[][]{p.getFloatArray("z0"), p.getFloatArray("z1")};
        this.etaModule = p.getIntArray("etaModule");
        this.phiModule = p.getIntArray("phiModule");
        this.BCIDError = p.getIntArray("BCIDError");
        this.firstHitError = p.getIntArray("firstHitError");
        this.formatterError = p.getIntArray("formatterError");
        this.lvl1Error = p.getIntArray("lvl1Error");
        this.preambleError = p.getIntArray("preambleError");
        this.secondHitError = p.getIntArray("secondHitError");
        this.syncError = p.getIntArray("syncError");
        this.timeBin = p.getIntArray("timeBin");
        this.rho = new float[2][this.numData];
        this.phi = new float[2][this.numData];
        this.layer = new int[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            this.sub[i] = this.getSub(this.id[i]);
            this.layer[i] = this.getLayer(this.id[i]);
        }
    }

    protected void calculateRhoPhi() {
        this.calculateRhoPhi(this.x[0], this.y[0], this.rho[0], this.phi[0]);
        this.calculateRhoPhi(this.x[1], this.y[1], this.rho[1], this.phi[1]);
        for (int i = 0; i < this.numData; ++i) {
            if (!((double)Math.abs(this.phi[1][i] - this.phi[0][i]) > Math.PI)) continue;
            if (this.phi[1][i] - this.phi[0][i] > 0.0f) {
                float[] fArray = this.phi[0];
                int n = i;
                fArray[n] = (float)((double)fArray[n] + Math.PI * 2);
                continue;
            }
            float[] fArray = this.phi[1];
            int n = i;
            fArray[n] = (float)((double)fArray[n] + Math.PI * 2);
        }
    }

    private void cutSubdetector() {
        AParameter par = APar.get("CutsInDet", "SCT");
        if (par.getI() != -1) {
            this.cutArray(this.sub, par.getI(), "Barrel/Endcap");
        }
    }

    protected void applyCuts() {
        AData.printCut("SiClusterRDO", this.numDraw);
        this.cutIndex();
        this.cutOrientation();
        this.cutSubdetector();
        this.cut("CutsInDet", "Layer", "Layer", this.layer);
        this.cutPhi(this.phi[0]);
        this.cutEta();
    }

    private void cutEta() {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        if (!par.getStatus()) {
            return;
        }
        double etaCut = par.getD();
        double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
        double etaLowerCut = etaMid - etaCut;
        double etaUpperCut = etaMid + etaCut;
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double eta1 = AMath.eta(this.z[0][list], this.rho[0][list]);
            double eta2 = AMath.eta(this.z[1][list], this.rho[1][list]);
            double etaLower = Math.min(eta1, eta2);
            double etaUpper = Math.max(eta1, eta2);
            if (!(etaUpper > etaLowerCut) || !(etaLower < etaUpperCut)) continue;
            this.listdl[num++] = list;
        }
        this.numDraw = num;
        AData.printCut(" Eta", this.numDraw);
    }

    public int getLayer(int id) {
        int layer = (id & 0x1E00000) >> 21;
        int sub = this.getSub(id);
        layer = sub == 1 ? (layer += 3) : (layer += 11);
        return layer;
    }

    public int getSub(int id) {
        return (id & 0x6000000) >> 25;
    }

    public int getOrientation(int id) {
        int side = (id & 0x400) >> 10;
        int sub = this.getSub(id);
        if (side == 1 && sub == 1 || side == 0 && sub != 1) {
            return 0;
        }
        int layer = this.getLayer(id);
        if (layer % 2 == 1) {
            return -1;
        }
        return 1;
    }

    protected void cutOrientation() {
        int num = 0;
        AParameter stereoAnglePar = APar.get("SiCluster", "Stereo");
        if (!stereoAnglePar.getStatus()) {
            return;
        }
        int orientation = stereoAnglePar.getI();
        for (int i = 0; i < this.numDraw; ++i) {
            if (orientation != this.getOrientation(this.id[this.listdl[i]])) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut("Orientation", this.numDraw);
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == 0) {
            this.colorByConstant();
        } else if (colorFunction == 1) {
            this.colorByError();
        } else if (colorFunction == 2) {
            this.colorByOrientation();
        }
        return 3;
    }

    protected void colorByError() {
        int constantColor = APar.get(this.PARAMETER_GROUP, "Constant").getI();
        int errorColor = APar.get(this.PARAMETER_GROUP, "Error").getI();
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = this.BCIDError[i] != 0 || this.firstHitError[i] != 0 || this.formatterError[i] != 0 || this.lvl1Error[i] != 0 || this.preambleError[i] != 0 || this.secondHitError[i] != 0 || this.syncError[i] != 0 ? (byte)errorColor : (byte)constantColor;
        }
    }

    protected void colorByOrientation() {
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = (byte)col[this.getOrientation(this.id[i]) + 1 % numColors];
        }
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index;
        }
        String temp = this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")\n" + " orientation = " + this.getOrientation(this.id[index]) + "\n" + " x = " + this.x[0][index] + "  " + this.x[1][index] + "\n" + " y = " + this.y[0][index] + "  " + this.y[1][index] + "\n" + " z = " + this.z[0][index] + "  " + this.z[1][index] + "\n" + " " + "\u03c1" + " = " + this.rho[0][index] + "  " + this.rho[1][index] + "\n" + " " + "\u03b7" + " module = " + this.etaModule[index] + "\n" + " " + "\u03a6" + " module = " + this.phiModule[index] + "\n" + " BCID error = " + this.BCIDError[index] + "\n" + " first hit error = " + this.firstHitError[index] + "\n" + " formatter error = " + this.formatterError[index] + "\n" + " lvl1 error = " + this.lvl1Error[index] + "\n" + " preamble error = " + this.preambleError[index] + "\n" + " second hit error = " + this.secondHitError[index] + "\n" + " sync error = " + this.syncError[index] + "\n" + " time bin = " + this.timeBin[index];
        return temp;
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.x[j][list];
                hv[1][j][i] = this.y[j][list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiDiff = Math.abs((double)this.phi[1][list] - phiMid);
            double sign = phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469 ? 1.0 : -1.0;
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = sign * (double)this.rho[j][list];
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.rho[j][list];
                hv[1][j][i] = Math.toDegrees(AMath.getPhiStereo(this.rho[j][list], this.phi[j][list], this.z[j][list]));
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FR");
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            for (int j = 0; j < 2; ++j) {
                hv[0][j][i] = this.z[j][list];
                hv[1][j][i] = Math.toDegrees(AMath.getPhiStereo(this.rho[j][list], this.phi[j][list], this.z[j][list]));
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FZ");
    }

    protected ACoord getVPUser() {
        this.makeDrawList();
        int numTotal = 2 * this.numDraw;
        int numPoints = 10;
        double[][][] hv = new double[2][numTotal][numPoints];
        int[] index = new int[numTotal];
        double[] sign = new double[]{-1.0, 1.0};
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double xx = this.x[0][list];
            double delx = (this.x[1][list] - this.x[0][list]) / (float)(numPoints - 1);
            double yy = this.y[0][list];
            double dely = (this.y[1][list] - this.y[0][list]) / (float)(numPoints - 1);
            double zz = this.z[0][list];
            double delz = (this.z[1][list] - this.z[0][list]) / (float)(numPoints - 1);
            for (int k = 0; k < numPoints; ++k) {
                double xxx = xx + (double)k * delx;
                double yyy = yy + (double)k * dely;
                double zzz = zz + (double)k * delz;
                double rrr = Math.sqrt(xxx * xxx + yyy * yyy);
                double ppp = Math.atan2(yyy, xxx);
                double deltaEta = AProjectionVP.getDeltaEta(rrr, zzz);
                double eta = AMath.eta(zzz, rrr);
                for (int j = 0; j < 2; ++j) {
                    hv[0][2 * i + j][k] = eta + sign[j] * deltaEta;
                    hv[1][2 * i + j][k] = Math.toDegrees(ppp);
                    index[2 * i + j] = list;
                }
            }
        }
        return new ACoord(hv, index, (ADrawable)this, 3).includePhiWrapAround("VP");
    }
}

