/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.data.AMuonHitData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.parameters.APar;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;

public class ATGCData
extends AMuonHitData {
    float[] swidth;
    float[] lwidth;
    float[] length;
    int[] gasGap;
    private static ALogger logger = ALogger.getLogger(ATGCData.class);

    public String getParameterGroup() {
        return "TGC";
    }

    public String getName() {
        return "TGC";
    }

    public String getNameScreenName() {
        return "TGC";
    }

    ATGCData(AHashMap p, AEvent e) {
        super(p, e);
        this.swidth = p.getFloatArray("swidth");
        this.length = p.getFloatArray("length");
        this.lwidth = p.getFloatArray("lwidth");
        this.gasGap = new int[this.numData];
        for (int i = 0; i < this.numData; ++i) {
            this.gasGap[i] = this.getGasGap(i);
        }
    }

    protected int getStation(int index) {
        try {
            String stationName = AIdHelper.stationName(this.id[index]);
            return (stationName.charAt(1) - 48) % 4;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding TGC identifier", e);
            return 0;
        }
    }

    protected int getSub(int index) {
        try {
            if (AIdHelper.stationEta(this.id[index]) < 0) {
                return 0;
            }
            return 1;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding TGC identifier", e);
            return 0;
        }
    }

    public int getSector(int index) {
        try {
            int retval;
            String stationName = AIdHelper.stationName(this.id[index]);
            int stationPhi = AIdHelper.stationPhi(this.id[index]);
            if (stationName.equals("T4E")) {
                int temp = stationPhi % 24;
                retval = 2 * (temp / 3);
            } else if (stationName.charAt(2) == 'F') {
                int temp = stationPhi % 24;
                retval = 2 * (temp / 3);
                if (temp % 3 > 1) {
                    ++retval;
                }
            } else {
                int temp = (stationPhi + 1) % 48;
                retval = 2 * (temp / 6);
                if (temp % 6 > 3) {
                    ++retval;
                }
            }
            return retval;
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding TGC identifier", e);
            return 0;
        }
    }

    protected int getGasGap(int index) {
        try {
            return AIdHelper.tgcGasGap(this.id[index]);
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding TGC identifier", e);
            return 0;
        }
    }

    protected boolean getMeasuresPhi(int index) {
        try {
            if (AIdHelper.tgcIsStrip(this.id[index]) == 1) {
                return true;
            }
        }
        catch (AAtlantisException e) {
            logger.error("Problem decoding TGC identifier", e);
        }
        return false;
    }

    public void applyCuts() {
        super.applyCuts();
        if (APar.get("CutsATLAS", "CutPhi").getStatus()) {
            this.cutPhi(this.phi, this.getDPhi());
        }
        if (APar.get("CutsATLAS", "CutEta").getStatus()) {
            this.cutEtaDRho(this.rho, this.z, this.getDRho());
        }
    }

    private float[] getDPhi() {
        float[] dphi = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            dphi[list] = (float)Math.abs(Math.atan2((double)(this.swidth[list] + this.lwidth[list]) / 4.0, this.rho[list]));
        }
        return dphi;
    }

    private float[] getDRho() {
        float[] drho = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            drho[list] = (float)((double)this.length[list] / 2.0);
        }
        return drho;
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        this.cutArray(this.measuresPhi, true, " Strip");
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list;
            index[i] = list = this.listdl[i];
            double deltaPhi = (double)(this.swidth[list] + this.lwidth[list]) / 4.0 / (double)this.rho[list];
            hv[0][0][i] = this.z[list];
            hv[1][0][i] = Math.toDegrees((double)this.phi[list] - deltaPhi);
            hv[0][1][i] = this.z[list];
            hv[1][1][i] = Math.toDegrees((double)this.phi[list] + deltaPhi);
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FZ");
    }

    private void makeDrawListYX() {
        int mode = APar.get("YX", "Mode").getI();
        if (mode == 0 || mode >= 5) {
            this.numDraw = 0;
        } else {
            this.makeDrawList();
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                if (mode != this.station[this.listdl[i]] + 1) continue;
                this.listdl[num++] = this.listdl[i];
            }
            this.numDraw = num;
        }
        this.cut("YX", "TGCGasGap", " TGC Gas Gap", this.gasGap);
    }

    protected ACoord getYXUser() {
        return this.getYXUser(0);
    }

    protected ACoord getYXUser(int flag) {
        boolean splitIt;
        this.makeDrawListYX();
        int[] split = new int[]{6, 1, 6, 1};
        int numPoints = 4;
        boolean bl = splitIt = APar.get("YX", "FishEye").getStatus() || flag == 1;
        if (splitIt) {
            numPoints = 14;
        }
        double[] temp = new double[4];
        double[][][] hv = new double[2][this.numDraw][numPoints];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list;
            index[i] = list = this.listdl[i];
            double cosPhi = Math.cos(this.phi[list]);
            double sinPhi = Math.sin(this.phi[list]);
            double rMid = this.rho[list];
            double dR = (double)this.length[list] / 2.0;
            double r = rMid - dR;
            double d = (double)this.swidth[list] / 2.0;
            double x = r * cosPhi;
            double y = r * sinPhi;
            double dx = d * sinPhi;
            double dy = d * cosPhi;
            hv[0][i][0] = x + dx;
            hv[1][i][0] = y - dy;
            hv[0][i][1] = x - dx;
            hv[1][i][1] = y + dy;
            r = rMid + dR;
            x = r * cosPhi;
            y = r * sinPhi;
            d = (double)this.lwidth[list] / 2.0;
            dx = d * sinPhi;
            dy = d * cosPhi;
            hv[0][i][2] = x - dx;
            hv[1][i][2] = y + dy;
            hv[0][i][3] = x + dx;
            hv[1][i][3] = y - dy;
            if (!splitIt) continue;
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 4; ++k) {
                    temp[k] = hv[j][i][k];
                }
                AMath.splitArrayIntoPieces(temp, hv[j][i], split);
            }
        }
        return new ACoord(hv, index, (ADrawable)this);
    }

    protected ACoord getFRUser() {
        return this.getYXUser(1).convertYXToFR().includePhiWrapAround("FR");
    }

    protected ACoord getXZRZUser(int[] sign) {
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        try {
            for (int i = 0; i < this.numDraw; ++i) {
                int j;
                index[i] = j = this.listdl[i];
                double rho = Math.sqrt(this.x[j] * this.x[j] + this.y[j] * this.y[j]);
                if (AIdHelper.tgcIsStrip(this.id[j]) == 1) {
                    double drho = (double)this.length[j] / 2.0;
                    hv[0][i] = new double[]{this.z[j], this.z[j]};
                    hv[1][i] = new double[]{(double)sign[i] * (rho - drho), (double)sign[i] * (rho + drho)};
                    continue;
                }
                hv[0][i] = new double[]{this.z[j]};
                hv[1][i] = new double[]{(double)sign[i] * rho};
            }
            return new ACoord(hv, index, (ADrawable)this);
        }
        catch (AAtlantisException e) {
            AOutput.append("Error decoding TGC identifier: " + e.getMessage(), "BAD_COMMAND");
            return ACoord.NO_DATA;
        }
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        this.cutMuonSector(this.sector);
        int[] sign = new int[this.numDraw];
        int sect = (int)Math.round(APar.get("XZ", "Phi").getD() / 22.5);
        for (int i = 0; i < this.numDraw; ++i) {
            sign[i] = this.sector[this.listdl[i]] == sect ? 1 : -1;
        }
        return this.getXZRZUser(sign);
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        int[] sign = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int j = this.listdl[i];
            sign[i] = AMath.getRhoSign(this.x[j], this.y[j]);
        }
        return this.getXZRZUser(sign);
    }
}

