/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.ACalorimeterData;
import atlantis.data.ACalorimeterRPSPLT;
import atlantis.event.AEvent;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.APulseShapePlot;
import atlantis.utils.AUtilities;
import com.Ostermiller.util.CSVParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class ATILEData
extends ACalorimeterData {
    private static ALogger logger = ALogger.getLogger(ATILEData.class);
    private float[] pmt1Energy = null;
    private float[] pmt2Energy = null;
    private float[] pmt1Chi2 = null;
    private float[] pmt2Chi2 = null;
    private float[] pmt1Time = null;
    private float[] pmt2Time = null;
    private float[] pmt1RawTime = null;
    private float[] pmt2RawTime = null;
    private float[] pmt1RawAmplitude = null;
    private float[] pmt2RawAmplitude = null;
    private int[][] adcCounts1 = null;
    private int[][] adcCounts2 = null;
    private int[] pmt1Gain = null;
    private int[] pmt2Gain = null;
    private float[] pmt1Pedestal = null;
    private float[] pmt2Pedestal = null;
    private int[] pmt1Number = null;
    private int[] pmt2Number = null;
    private int[] pmt1ADCStatus = null;
    private int[] pmt2ADCStatus = null;
    private static boolean pulseShapesDataAvailable = false;
    private static final String LOOKUP_TABLE_FILE = Atlantis.getHomeDirectory() + "configuration" + Atlantis.FILE_SEPAR + "rpsplt_tile.csv";
    private static final short NUMBER_OF_LOOKUP_VALUES = 401;

    ATILEData(AHashMap p, AEvent e) {
        super(p, e);
        int i;
        for (i = 0; i < this.numData; ++i) {
            try {
                this.side[i] = (byte)AIdHelper.tileSide(this.id[i]);
                this.etaIndex[i] = (short)AIdHelper.tileTower(this.id[i]);
                this.phiIndex[i] = (short)AIdHelper.tileModule(this.id[i]);
                this.sampling[i] = AIdHelper.tileSampling(this.id[i]);
                continue;
            }
            catch (AAtlantisException ex) {
                System.out.println("Problem decoding ID " + this.id[i] + " in " + this.CALORIMETER_NAME + ": " + ex.getMessage());
                this.side[i] = 0;
                this.etaIndex[i] = -1;
                this.phiIndex[i] = -1;
                this.sampling[i] = -1;
            }
        }
        this.makeHitToGeometryMapping();
        for (i = 0; i < this.et.length; ++i) {
            this.et[i] = Math.abs(this.energy[i] / (float)Math.cosh(this.eta[i]));
        }
        for (i = 0; i < ACalorimeterDetector.count(); ++i) {
            if (ACalorimeterDetector.get(i).getName().indexOf(this.CALORIMETER_NAME) >= 0) {
                if (this.innerR == 0.0 || ACalorimeterDetector.get(i).getRMin() < this.innerR) {
                    this.innerR = ACalorimeterDetector.get(i).getRMin();
                }
                if (this.phiGranularity == 0.0 || ACalorimeterDetector.get(i).getDeltaPhi() < this.phiGranularity) {
                    this.phiGranularity = ACalorimeterDetector.get(i).getDeltaPhi();
                }
                if (this.etaGranularity == 0.0 || ACalorimeterDetector.get(i).getDeltaEta() < this.etaGranularity) {
                    this.etaGranularity = ACalorimeterDetector.get(i).getDeltaEta();
                }
                if (this.outerEta == 0.0 || ACalorimeterDetector.get(i).getEtaMax() > this.outerEta) {
                    this.outerEta = ACalorimeterDetector.get(i).getEtaMax();
                }
            }
            if (this.outerR == 0.0 || ACalorimeterDetector.get(i).getRMax() > this.outerR) {
                this.outerR = ACalorimeterDetector.get(i).getRMax();
            }
            if (this.outerZ != 0.0 && !(ACalorimeterDetector.get(i).getZMax() > this.outerZ)) continue;
            this.outerZ = ACalorimeterDetector.get(i).getZMax();
        }
        this.outerEta += this.etaGranularity;
        this.readPulseShapePlotData(p);
        this.pmt1ADCStatus = p.get("pmt1ADCStatus") != null ? p.getIntArray("pmt1ADCStatus") : null;
        this.pmt2ADCStatus = p.get("pmt2ADCStatus") != null ? p.getIntArray("pmt2ADCStatus") : null;
    }

    protected static void readLookupTableFile() throws AAtlantisException {
        try {
            InputStream is = AUtilities.getFileAsStream(LOOKUP_TABLE_FILE);
            CSVParser parser = new CSVParser(is);
            parser.setCommentStart("#");
            String arrayName = null;
            while ((arrayName = parser.nextValue()) != null) {
                String valueArray = parser.nextValue();
                CSVParser parserArray = new CSVParser((Reader)new StringReader(valueArray));
                String[][] s = parserArray.getAllValues();
                if ("TILE_AMPLITUDE".equals(arrayName)) {
                    ACalorimeterRPSPLT.TILE_AMPLITUDE = ATILEData.getLookupTableArray(s, 401);
                    continue;
                }
                if (!"TILE_TIME".equals(arrayName)) continue;
                ACalorimeterRPSPLT.TILE_TIME = ATILEData.getLookupTableArray(s, 401);
            }
        }
        catch (FileNotFoundException e) {
            throw new AAtlantisException("could not find file: " + LOOKUP_TABLE_FILE);
        }
        catch (IOException e) {
            throw new AAtlantisException("exception while reading file: " + LOOKUP_TABLE_FILE);
        }
        catch (AAtlantisException e) {
            throw e;
        }
    }

    private void readPulseShapePlotData(AHashMap p) {
        this.pmt1Energy = p.get("pmt1Energy") != null ? p.getFloatArray("pmt1Energy") : null;
        this.pmt2Energy = p.get("pmt2Energy") != null ? p.getFloatArray("pmt2Energy") : null;
        this.pmt1Chi2 = p.get("pmt1Chi2") != null ? p.getFloatArray("pmt1Chi2") : null;
        this.pmt2Chi2 = p.get("pmt2Chi2") != null ? p.getFloatArray("pmt2Chi2") : null;
        this.pmt1Time = p.get("pmt1Time") != null ? p.getFloatArray("pmt1Time") : null;
        this.pmt2Time = p.get("pmt2Time") != null ? p.getFloatArray("pmt2Time") : null;
        this.pmt1Gain = p.get("pmt1Gain") != null ? p.getIntArray("pmt1Gain") : null;
        this.pmt2Gain = p.get("pmt2Gain") != null ? p.getIntArray("pmt2Gain") : null;
        this.pmt1Pedestal = p.get("pmt1Pedestal") != null ? p.getFloatArray("pmt1Pedestal") : null;
        this.pmt2Pedestal = p.get("pmt2Pedestal") != null ? p.getFloatArray("pmt2Pedestal") : null;
        this.pmt1Number = p.get("pmt1Number") != null ? p.getIntArray("pmt1Number") : null;
        this.pmt2Number = p.get("pmt2Number") != null ? p.getIntArray("pmt2Number") : null;
        int[] adc1 = p.get("adcCounts1") != null ? p.getIntArray("adcCounts1") : null;
        int[] adc2 = p.get("adcCounts2") != null ? p.getIntArray("adcCounts2") : null;
        this.pmt1RawTime = p.get("pmt1RawTime") != null ? p.getFloatArray("pmt1RawTime") : null;
        this.pmt2RawTime = p.get("pmt2RawTime") != null ? p.getFloatArray("pmt2RawTime") : null;
        this.pmt1RawAmplitude = p.get("pmt1RawAmplitude") != null ? p.getFloatArray("pmt1RawAmplitude") : null;
        float[] fArray = this.pmt2RawAmplitude = p.get("pmt2RawAmplitude") != null ? p.getFloatArray("pmt2RawAmplitude") : null;
        if (adc1 != null && adc2 != null) {
            this.adcCounts1 = new int[this.numData][0];
            this.adcCounts2 = new int[this.numData][0];
            int multiple = adc1.length / this.numData;
            int num = 0;
            for (int i = 0; i < this.numData; ++i) {
                this.adcCounts1[i] = new int[multiple];
                this.adcCounts2[i] = new int[multiple];
                for (int j = 0; j < multiple; ++j) {
                    this.adcCounts1[i][j] = adc1[num];
                    this.adcCounts2[i][j] = adc2[num];
                    ++num;
                }
            }
        }
        pulseShapesDataAvailable = false;
        if (this.adcCounts1 != null && this.adcCounts2 != null && this.adcCounts1.length != 0 && this.adcCounts2.length != 0 && this.adcCounts1[0].length != 0 && this.adcCounts2[0].length != 0 && this.pmt1Number != null && this.pmt2Number != null && this.pmt1Energy != null && this.pmt2Energy != null && this.pmt1Time != null && this.pmt2Time != null && this.pmt1Pedestal != null && this.pmt2Pedestal != null && this.pmt1Gain != null && this.pmt2Gain != null && this.pmt1RawAmplitude != null && this.pmt2RawAmplitude != null) {
            pulseShapesDataAvailable = true;
            logger.debug(this.CALORIMETER_NAME + ": data for real pulse shape plots available");
            if (ACalorimeterRPSPLT.areTileLookupTablesInitialized()) {
                logger.debug(this.CALORIMETER_NAME + ": lookup tables have already been read in");
            } else {
                logger.debug(this.CALORIMETER_NAME + ": lookup table values have not been read in yet\n" + "  trying to read file: " + LOOKUP_TABLE_FILE);
                try {
                    ATILEData.readLookupTableFile();
                    logger.debug(this.CALORIMETER_NAME + ": values from " + LOOKUP_TABLE_FILE + " successfully read in");
                }
                catch (AAtlantisException ex) {
                    logger.error(this.CALORIMETER_NAME + ": reading " + LOOKUP_TABLE_FILE + " failed, real pulse shapes plots will not " + "be available, reason: " + ex.getMessage(), ex);
                    pulseShapesDataAvailable = false;
                }
            }
        }
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsCalo", "TileET", "TileET", this.et);
        this.cut("CutsCalo", "TileEnergyBottom", "TileEnergyBottom", this.energy);
        this.cut("CutsCalo", "TileEnergyUp", "TileEnergyUp", this.energy);
        if (this.pmt1ADCStatus != null && this.pmt2ADCStatus != null) {
            this.cut("CutsCalo", "TilePMTADC", "TilePMTADC", this.pmt1ADCStatus);
            this.cut("CutsCalo", "TilePMTADC", "TilePMTADC", this.pmt2ADCStatus);
        }
    }

    public String getParameterGroup() {
        return "TILE";
    }

    public String getName() {
        return "TILE";
    }

    public String getNameScreenName() {
        return "TILE";
    }

    public String getCalorimeterType(int index) {
        return "HCAL";
    }

    protected double getTime(int hit) {
        if (this.pmt1Time == null) {
            return 0.0;
        }
        if (this.pmt2Time == null) {
            return 0.0;
        }
        if ((double)this.pmt1Time[hit] != 0.0 && (double)this.pmt2Time[hit] != 0.0) {
            return (double)(this.pmt1Time[hit] + this.pmt2Time[hit]) / 2.0;
        }
        if ((double)this.pmt1Time[hit] == 0.0 && (double)this.pmt2Time[hit] != 0.0) {
            return this.pmt2Time[hit];
        }
        if ((double)this.pmt1Time[hit] != 0.0 && (double)this.pmt2Time[hit] == 0.0) {
            return this.pmt1Time[hit];
        }
        return 0.0;
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n ET=" + AMath.d2s(this.et[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Ex=" + AMath.d2s((double)this.et[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Ey=" + AMath.d2s((double)this.et[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Ez=" + AMath.d2s((double)this.et[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String t = "";
        String pmt1Info = "";
        String pmt2Info = "";
        String decodedId = AIdHelper.getDecodedTileIndentifier(this.id[index]);
        t = decodedId + "  " + super.getHitInfoNoDecode(index);
        pmt1Info = pmt1Info + "\n PMT1 ADC status = ";
        pmt1Info = pmt1Info + (this.pmt1ADCStatus != null ? Integer.toString(this.pmt1ADCStatus[index]) : "n/a");
        pmt1Info = pmt1Info + "\n PMT1 energy = ";
        pmt1Info = pmt1Info + (this.pmt1Energy != null ? Float.toString(this.pmt1Energy[index]) + " GeV" : "n/a");
        pmt1Info = pmt1Info + "\n PMT1 chi2 = ";
        pmt1Info = pmt1Info + (this.pmt1Chi2 != null ? Float.toString(this.pmt1Chi2[index]) : "n/a");
        pmt1Info = pmt1Info + "\n PMT1 time = ";
        pmt1Info = pmt1Info + (this.pmt1Time != null ? Float.toString(this.pmt1Time[index]) + " ns" : "n/a");
        pmt1Info = pmt1Info + "\n PMT1 gain = ";
        pmt1Info = pmt1Info + (this.pmt1Gain != null ? Integer.toString(this.pmt1Gain[index]) : "n/a");
        pmt1Info = pmt1Info + "\n PMT1 pedestal = ";
        pmt1Info = pmt1Info + (this.pmt1Pedestal != null ? Float.toString(this.pmt1Pedestal[index]) + " ADC counts" : "n/a");
        pmt2Info = pmt2Info + "\n PMT2 ADC status = ";
        pmt2Info = pmt2Info + (this.pmt2ADCStatus != null ? Integer.toString(this.pmt2ADCStatus[index]) : "n/a");
        pmt2Info = pmt2Info + "\n PMT2 energy = ";
        pmt2Info = pmt2Info + (this.pmt2Energy != null ? Float.toString(this.pmt2Energy[index]) + " GeV" : "n/a");
        pmt2Info = pmt2Info + "\n PMT2 chi2 = ";
        pmt2Info = pmt2Info + (this.pmt2Chi2 != null ? Float.toString(this.pmt2Chi2[index]) : "n/a");
        pmt2Info = pmt2Info + "\n PMT2 time = ";
        pmt2Info = pmt2Info + (this.pmt2Time != null ? Float.toString(this.pmt2Time[index]) + " ns" : "n/a");
        pmt2Info = pmt2Info + "\n PMT2 gain = ";
        pmt2Info = pmt2Info + (this.pmt2Gain != null ? Integer.toString(this.pmt2Gain[index]) : "n/a");
        pmt2Info = pmt2Info + "\n PMT2 pedestal = ";
        pmt2Info = pmt2Info + (this.pmt2Pedestal != null ? Float.toString(this.pmt2Pedestal[index]) + " ADC counts" : "n/a");
        pmt2Info = pmt2Info + (pulseShapesDataAvailable ? "" : "\n data for real pulse shapes plot n/a");
        pmt2Info = pmt2Info + "\n calc time = " + this.getTime(index);
        return t + pmt1Info + pmt2Info;
    }

    private double getPhysicsPulseShape(double xTime, double pmtTime, double pmtPedestal, double pmtEnergy, float[] amplitude, float[] time) throws AAtlantisException {
        double tdiv = 0.0;
        int lookup = 0;
        double localTime = 0.0;
        double xpulse = 0.0;
        double centerOfSamples = ((double)this.adcCounts1[0].length + 1.0) / 2.0;
        localTime = (xTime - centerOfSamples) * 25.0 - pmtTime;
        tdiv = time[1] - time[0];
        lookup = (int)((localTime - (double)time[0]) / tdiv);
        if (lookup < 0) {
            lookup = 0;
        }
        if (lookup >= 400) {
            lookup = 399;
        }
        try {
            xpulse = lookup == 0 || lookup == 399 ? (double)amplitude[lookup] : (double)amplitude[lookup] + (double)(amplitude[lookup + 1] - amplitude[lookup]) / tdiv * (localTime - (double)time[lookup]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            String m = "ATILEData.getPhysicsPulseShape():\n  lookup index out of bound: lookup = " + lookup;
            throw new AAtlantisException(m);
        }
        return xpulse * pmtEnergy + pmtPedestal;
    }

    protected ACoord[] getUserHistograms(AProjection2D projection) {
        ACoord[] data = ACoord.NO_HISTOGRAMS;
        if (projection instanceof AProjectionYX && APar.get("YX", "Mode").getI() == 0) {
            data = this.getYXHistograms();
        } else if (projection instanceof AProjectionFR) {
            data = this.getFRHistograms();
        } else if (projection instanceof AProjectionRZ) {
            data = this.getRZHistograms();
        }
        return projection.nonLinearTransform(data);
    }

    protected String getPulseTitleString(int index) {
        String[] decodedId = AIdHelper.getFullIdentifier(this.id[index]);
        String title = this.CALORIMETER_NAME + " cell: " + decodedId[0];
        return title;
    }

    protected int[][] getADCCounts(int index) {
        if (pulseShapesDataAvailable) {
            return new int[][]{this.adcCounts1[index], this.adcCounts2[index]};
        }
        return null;
    }

    protected double[][] getPulseShape(int index) {
        if (!pulseShapesDataAvailable) {
            return null;
        }
        double step = this.getPulseStep(index);
        double[][] realPulseRaw = new double[2][401];
        double d = 1.0;
        if (this.pmt1RawTime == null || this.pmt2RawTime == null) {
            logger.warn("No raw time values available");
            return null;
        }
        float pmt1PedestalLocal = this.pmt1Pedestal[index];
        float pmt2PedestalLocal = this.pmt2Pedestal[index];
        if (pmt1PedestalLocal == 0.0f && pmt2PedestalLocal == 0.0f) {
            logger.debug("TILE pmt[1,2]Pedestal are not available (i.e. are 0.0f), using minimum of first and last adcCount digit as pedestal.");
            float last1 = this.adcCounts1[index][this.adcCounts1[index].length - 1];
            float last2 = this.adcCounts2[index][this.adcCounts2[index].length - 1];
            pmt1PedestalLocal = Math.min((float)this.adcCounts1[index][0], last1);
            pmt2PedestalLocal = Math.min((float)this.adcCounts2[index][0], last2);
        }
        try {
            for (int i = 0; i < 401; ++i) {
                realPulseRaw[0][i] = this.getPhysicsPulseShape(d += step, (double)this.pmt1RawTime[index], (double)pmt1PedestalLocal, this.pmt1RawAmplitude[index], ACalorimeterRPSPLT.TILE_AMPLITUDE, ACalorimeterRPSPLT.TILE_TIME);
                realPulseRaw[1][i] = this.getPhysicsPulseShape(d, (double)this.pmt2RawTime[index], (double)pmt2PedestalLocal, this.pmt2RawAmplitude[index], ACalorimeterRPSPLT.TILE_AMPLITUDE, ACalorimeterRPSPLT.TILE_TIME);
            }
        }
        catch (AAtlantisException aaex) {
            AOutput.append(aaex.getMessage(), "WARNING");
            return null;
        }
        return realPulseRaw;
    }

    protected double[][] getPulseShapeCellTime(int index) {
        if (!pulseShapesDataAvailable) {
            return null;
        }
        double step = this.getPulseStep(index);
        double[][] realPulse = new double[2][401];
        double d = 1.0;
        float pmt1PedestalLocal = this.pmt1Pedestal[index];
        float pmt2PedestalLocal = this.pmt2Pedestal[index];
        if (pmt1PedestalLocal == 0.0f && pmt2PedestalLocal == 0.0f) {
            logger.debug("TILE pmt[1,2]Pedestal are not available (i.e. are 0.0f), using minimum of first and last adcCount digit as pedestal.");
            float last1 = this.adcCounts1[index][this.adcCounts1[index].length - 1];
            float last2 = this.adcCounts2[index][this.adcCounts2[index].length - 1];
            pmt1PedestalLocal = Math.min((float)this.adcCounts1[index][0], last1);
            pmt2PedestalLocal = Math.min((float)this.adcCounts2[index][0], last2);
        }
        try {
            for (int i = 0; i < 401; ++i) {
                realPulse[0][i] = this.getPhysicsPulseShape(d += step, (double)this.pmt1Time[index], (double)pmt1PedestalLocal, this.pmt1RawAmplitude[index], ACalorimeterRPSPLT.TILE_AMPLITUDE, ACalorimeterRPSPLT.TILE_TIME);
                realPulse[1][i] = this.getPhysicsPulseShape(d, (double)this.pmt2Time[index], (double)pmt2PedestalLocal, this.pmt2RawAmplitude[index], ACalorimeterRPSPLT.TILE_AMPLITUDE, ACalorimeterRPSPLT.TILE_TIME);
            }
        }
        catch (AAtlantisException aaex) {
            AOutput.append(aaex.getMessage(), "WARNING");
            return null;
        }
        return realPulse;
    }

    protected double getPulseStep(int index) {
        return (float)(this.adcCounts1[index].length - 1) / 401.0f;
    }

    protected String[] getPulseSubtitle(int index) {
        String cap1 = "Real pulse shape PMT " + this.pmt1Number[index] + " gain " + this.pmt1Gain[index];
        String cap2 = "Real pulse shape PMT " + this.pmt2Number[index] + " gain " + this.pmt2Gain[index];
        return new String[]{cap1, cap2};
    }

    public void plotPulseShapesWithTiming(int index) {
        int[][] adc = this.getADCCounts(index);
        double[][] raw = this.getPulseShape(index);
        double[][] cell = this.getPulseShapeCellTime(index);
        if (adc == null || raw == null || cell == null) {
            logger.warn("Pulse shapes with raw/cell times requested but no data available, falling back to regular pulse shapes");
            this.plotPulseShapes(index, true);
        } else {
            APulseShapePlot.plotRawCellPulseShapes(adc, raw, cell, this.getPulseStep(index), this.getPulseSubtitle(index), this.getPulseTitleString(index));
        }
    }
}

