/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.data.AHitData;
import atlantis.data.AInDetTrackData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.list.AList;
import atlantis.list.AListManager;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.AIdHelper;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.tree.DefaultMutableTreeNode;

public class ATRTData
extends AHitData {
    protected float[] phi = null;
    protected float[] rhoz = null;
    protected float[] driftR = null;
    protected int[] threshold = null;
    protected int[] noise = null;
    protected int[] bitPattern = null;
    protected float[] timeOverThreshold = null;
    protected HashMap driftSign = new HashMap();
    protected HashMap isOutlier = new HashMap();
    private final int NO_DATA = -99;

    public String getParameterGroup() {
        return "TRT";
    }

    public String getName() {
        return "TRT";
    }

    public String getNameScreenName() {
        return "TRT_DriftCircle";
    }

    public int getDriftSign(int index) {
        int[] data;
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections");
        String currentSelection = listBox.getCurrentText();
        if (this.driftSign != null && !currentSelection.equals("All") && (data = (int[])this.driftSign.get(currentSelection)) != null) {
            return data[index];
        }
        return -99;
    }

    public int getIsOutlier(int index) {
        int[] data;
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections");
        String currentSelection = listBox.getCurrentText();
        if (this.isOutlier != null && !currentSelection.equals("All") && (data = (int[])this.isOutlier.get(currentSelection)) != null) {
            return data[index];
        }
        return -99;
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n" + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        String[] decodedId = AIdHelper.getFullIdentifier(this.id[index]);
        String s = this.getNameScreenName() + " (id: " + decodedId[0] + " index: " + index + ")";
        for (int i = 1; i < decodedId.length; ++i) {
            s = s + "\n " + decodedId[i];
        }
        s = this.sub[index] == 1 || this.sub[index] == 2 ? s + "\n \u03c1 = " + AMath.d2s(this.rhoz[index], 1) + " cm" : s + "\n z = " + AMath.d2s(this.rhoz[index], 1) + " cm";
        s = s + "\n \u03a6 = " + AMath.d2s(Math.toDegrees(this.phi[index]), 1) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 3) + " rad)" + "\n drift radius = " + AMath.d2s(this.driftR[index], 3) + " cm" + "\n threshold = " + this.threshold[index] + "\n sub = " + this.sub[index];
        s = s + super.getHitInfo(index);
        int d = this.getDriftSign(index);
        s = s + (d != -99 ? "\n driftSign = " + d : "\n driftSign = n/a");
        int o = this.getIsOutlier(index);
        s = s + (o != -99 ? "\n isOutlier = " + o : "\n isOutlier = n/a");
        s = s + "\n noise = " + (this.noise != null ? Integer.valueOf(this.noise[index]) : "n/a");
        s = s + "\n time over threshold = " + (this.timeOverThreshold != null ? Float.valueOf(this.timeOverThreshold[index]) : "n/a");
        return s;
    }

    public ATRTData(AHashMap p, AEvent e) {
        super(p, e);
        this.phi = p.getFloatArray("phi");
        this.rhoz = p.getFloatArray("rhoz");
        this.driftR = p.getFloatArray("driftR");
        this.threshold = p.getUnknownIntArray("threshold");
        this.noise = p.getUnsureIntArray("noise");
        if (p.getIntArray("sub") == null) {
            for (int i = 0; i < this.numData; ++i) {
                this.sub[i] = this.getSub(this.id[i]);
            }
        }
        this.timeOverThreshold = p.getFloatArray("timeOverThreshold");
    }

    protected int internalColor() {
        int numColorTypes;
        block4: {
            int colorFunction;
            block6: {
                block5: {
                    block3: {
                        numColorTypes = super.internalColor();
                        colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
                        if (colorFunction != numColorTypes + 1) break block3;
                        this.colorBy(this.getSegments());
                        break block4;
                    }
                    if (colorFunction != numColorTypes + 2) break block5;
                    for (int i = 0; i < this.numDraw; ++i) {
                        int list = this.listdl[i];
                        int iO = this.getIsOutlier(list);
                        this.color[list] = iO == 0 ? 21 : (iO == 1 ? 20 : (byte)APar.get(this.PARAMETER_GROUP, "Constant").getI());
                    }
                    break block4;
                }
                if (colorFunction != numColorTypes + 3) break block6;
                for (int i = 0; i < this.numDraw; ++i) {
                    int list = this.listdl[i];
                    int ds = this.getDriftSign(list);
                    this.color[list] = ds == -1 ? 21 : (ds == 1 ? 20 : (byte)APar.get(this.PARAMETER_GROUP, "Constant").getI());
                }
                break block4;
            }
            if (colorFunction != numColorTypes + 4) break block4;
            for (int i = 0; i < this.numDraw; ++i) {
                int list = this.listdl[i];
                this.color[list] = this.threshold[list] == 1 ? 20 : (byte)APar.get(this.PARAMETER_GROUP, "Constant").getI();
            }
        }
        return numColorTypes + 1;
    }

    public int getLayer(int id) {
        try {
            return AIdHelper.trtLayerWheel(id);
        }
        catch (AAtlantisException e) {
            return 0;
        }
    }

    public int getSub(int id) {
        try {
            return AIdHelper.trtBarrelEndcap(id);
        }
        catch (AAtlantisException e) {
            return 0;
        }
    }

    protected void applyCuts() {
        AData.printCut("TRT", this.numDraw);
        this.cutIndex();
        this.cut("CutsInDet", "Threshold", " Threshold", this.threshold);
        this.cutSimulatedTracks();
        this.cutReconstructedTracks();
        this.cutSegments();
        this.cutPhi(this.phi);
        this.cutEta();
        if (this.noise != null && APar.get("CutsInDet", "Noise").getStatus()) {
            this.cutArray(this.noise, 0, "TRT Noise Cut");
        }
        this.cut("CutsInDet", "TRTTimeOverThreshold", "TRTTimeOverThreshold", this.timeOverThreshold);
    }

    private void keepBarrel() {
        int num = 0;
        int cutSub = APar.get("CutsInDet", "TRT").getI();
        for (int i = 0; i < this.numDraw; ++i) {
            if (this.sub[this.listdl[i]] != 1 && this.sub[this.listdl[i]] != 2 || cutSub != -1 && this.sub[this.listdl[i]] != cutSub) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
    }

    private void keepEndcap() {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (this.sub[this.listdl[i]] != 0 && this.sub[this.listdl[i]] != 3) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
    }

    private void cutEta() {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        if (!par.getStatus()) {
            return;
        }
        double etaCut = par.getD();
        double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
        double etaLowerCut = etaMid - etaCut;
        double etaUpperCut = etaMid + etaCut;
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            double r2;
            double r1;
            double z2;
            double z1;
            int list = this.listdl[i];
            if (this.sub[list] == 0 || this.sub[list] == 3) {
                z1 = this.rhoz[list];
                z2 = this.rhoz[list];
                r1 = 64.0;
                if ((double)Math.abs(this.rhoz[list]) > 280.0) {
                    r1 = 48.0;
                }
                r2 = 103.0;
            } else {
                z1 = 0.35;
                if (this.rhoz[list] < 62.0f) {
                    z1 = 40.0;
                }
                z2 = 74.2;
                if (this.sub[list] == 1) {
                    z1 *= -1.0;
                    z2 *= -1.0;
                }
                r1 = this.rhoz[list];
                r2 = this.rhoz[list];
            }
            double eta1 = AMath.eta(z1, r1);
            double eta2 = AMath.eta(z2, r2);
            double etaLower = Math.min(eta1, eta2);
            double etaUpper = Math.max(eta1, eta2);
            if (!(etaUpper > etaLowerCut) || !(etaLower < etaUpperCut)) continue;
            this.listdl[num++] = list;
        }
        this.numDraw = num;
        AData.printCut(" Eta", this.numDraw);
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        this.keepBarrel();
        double zoomScaling = 0.0;
        Point2D.Double[] corners = ACanvas.getCanvas().getPaintingWindow().getUserCorners();
        double widthx = corners[1].x - corners[0].x;
        double widthy = corners[0].y - corners[2].y;
        double width = Math.sqrt(widthx * widthx + widthy * widthy);
        zoomScaling = 100.0 / width;
        if (zoomScaling > 0.25) {
            return this.getYXUserCircle();
        }
        return this.getYXUserNormal();
    }

    private ACoord getYXUserNormal() {
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double r = this.rhoz[list];
            double cosPhi = Math.cos(this.phi[list]);
            double sinPhi = Math.sin(this.phi[list]);
            double d = this.driftR[list];
            double x = r * cosPhi;
            double y = r * sinPhi;
            hv[0][0][i] = x + d * sinPhi;
            hv[1][0][i] = y - d * cosPhi;
            hv[0][1][i] = x - d * sinPhi;
            hv[1][1][i] = y + d * cosPhi;
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    private ACoord getYXUserCircle() {
        int numPoints = 48;
        int[] index = new int[this.numDraw];
        double[][][] hv = new double[2][this.numDraw][];
        for (int i = 0; i < this.numDraw; ++i) {
            int j;
            int list = this.listdl[i];
            int ds = this.getDriftSign(list);
            if (this.sub[list] == 1) {
                ds *= -1;
            }
            if (ds == 1 || ds == -1) {
                hv[0][i] = new double[numPoints + 3];
                hv[1][i] = new double[numPoints + 3];
            } else {
                hv[0][i] = new double[numPoints];
                hv[1][i] = new double[numPoints];
                ds = 0;
            }
            double r = this.rhoz[list];
            double cosPhi = Math.cos(this.phi[list]);
            double sinPhi = Math.sin(this.phi[list]);
            double d = this.driftR[list];
            double x = r * cosPhi;
            double y = r * sinPhi;
            int jstart = 0;
            if (ds == 1 || ds == -1) {
                jstart = (int)((double)this.phi[list] / (Math.PI * 2 / (double)(numPoints - 1)));
                d *= (double)ds;
            }
            int count = 0;
            for (j = jstart; j < numPoints; ++j) {
                hv[0][i][count] = x + d * Math.sin(Math.PI * 2 * (double)j / (double)(numPoints - 1));
                hv[1][i][count] = y - d * Math.cos(Math.PI * 2 * (double)j / (double)(numPoints - 1));
                ++count;
            }
            for (j = 0; j < jstart; ++j) {
                hv[0][i][count] = x + d * Math.sin(Math.PI * 2 * (double)(j + 1) / (double)(numPoints - 1));
                hv[1][i][count] = y - d * Math.cos(Math.PI * 2 * (double)(j + 1) / (double)(numPoints - 1));
                ++count;
            }
            index[i] = list;
            if (ds != 1 && ds != -1) continue;
            hv[0][i][numPoints] = hv[0][i][2 * (numPoints - 1) / 5];
            hv[1][i][numPoints] = hv[1][i][2 * (numPoints - 1) / 5];
            hv[0][i][numPoints + 1] = hv[0][i][numPoints - 1];
            hv[1][i][numPoints + 1] = hv[1][i][numPoints - 1];
            hv[0][i][numPoints + 2] = hv[0][i][3 * (numPoints - 1) / 5];
            hv[1][i][numPoints + 2] = hv[1][i][3 * (numPoints - 1) / 5];
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getRZUser() {
        if (!APar.get("RZ", "TRT").getStatus()) {
            return ACoord.NO_DATA;
        }
        this.makeDrawList();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            if (this.sub[list] == 0 || this.sub[list] == 3) {
                hv[0][0][i] = this.rhoz[list];
                hv[0][1][i] = this.rhoz[list];
                double phiDiff = Math.abs((double)this.phi[list] - phiMid);
                double r1 = 64.0;
                if ((double)Math.abs(this.rhoz[list]) > 280.0) {
                    r1 = 48.0;
                }
                double r2 = 103.0;
                if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                    hv[1][0][i] = r1;
                    hv[1][1][i] = r2;
                } else {
                    hv[1][0][i] = -r1;
                    hv[1][1][i] = -r2;
                }
            } else {
                double z1 = 0.35;
                if (this.rhoz[list] < 62.0f) {
                    z1 = 40.0;
                }
                double z2 = 74.2;
                if (this.sub[list] == 1) {
                    z1 *= -1.0;
                    z2 *= -1.0;
                }
                hv[0][0][i] = z1;
                hv[0][1][i] = z2;
                double phiDiff = Math.abs((double)this.phi[list] - phiMid);
                if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                    hv[1][0][i] = this.rhoz[list];
                    hv[1][1][i] = this.rhoz[list];
                } else {
                    hv[1][0][i] = -this.rhoz[list];
                    hv[1][1][i] = -this.rhoz[list];
                }
            }
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2);
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        this.keepBarrel();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        double[] pVtx = this.event.getPrimaryVertex();
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double r = this.rhoz[list];
            double p = this.phi[list];
            double x = r * Math.cos(p);
            double y = r * Math.sin(p);
            double dx = x - pVtx[0];
            double dy = y - pVtx[1];
            r = Math.sqrt(dx * dx + dy * dy);
            p = Math.atan2(dy, dx);
            if (p < 0.0) {
                p += Math.PI * 2;
            }
            double delPhi = (double)this.driftR[list] / r;
            hv[0][0][i] = r;
            hv[1][0][i] = Math.toDegrees(p - delPhi);
            hv[0][1][i] = r;
            hv[1][1][i] = Math.toDegrees(p + delPhi);
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FR");
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        this.keepEndcap();
        double[][][] hv = new double[2][2][this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double z = this.rhoz[list];
            double averageRho = 81.0;
            if (Math.abs(z) > 280.0) {
                averageRho = 70.0;
            }
            double p = this.phi[list];
            double delPhi = (double)this.driftR[list] / averageRho;
            hv[0][0][i] = z;
            hv[1][0][i] = Math.toDegrees(p - delPhi);
            hv[0][1][i] = z;
            hv[1][1][i] = Math.toDegrees(p + delPhi);
            index[i] = list;
        }
        return new ACoord(hv, index, (ADrawable)this, 2).includePhiWrapAround("FZ");
    }

    public Action[] getActions(Collection nodes) {
        if (nodes.size() != 1) {
            return new Action[0];
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.iterator().next();
        AList[] list = AListManager.getInstance().getChildren(node);
        if (list == null) {
            return new Action[0];
        }
        HashSet<Integer> hits = new HashSet<Integer>();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].getSource() == this) {
                for (int j = 0; j < list[i].getItems().length; ++j) {
                    hits.add(new Integer(list[i].getItems()[j]));
                }
                continue;
            }
            return new Action[0];
        }
        int numHits = hits.size();
        if (numHits < 2) {
            return new Action[0];
        }
        final int[] h = new int[numHits];
        Iterator i = hits.iterator();
        int n = 0;
        while (i.hasNext()) {
            h[n++] = (Integer)i.next();
        }
        Action[] action = new Action[]{new AbstractAction("Find Eta"){

            public void actionPerformed(ActionEvent e) {
                double MIN = 9999.0;
                double MAX = -9999.0;
                double minRho = 9999.0;
                double maxRho = -9999.0;
                double minZ = 9999.0;
                double maxZ = -9999.0;
                for (int i = 0; i < h.length; ++i) {
                    if (ATRTData.this.sub[h[i]] == 1 || ATRTData.this.sub[h[i]] == 2) {
                        minRho = Math.min(minRho, (double)ATRTData.this.rhoz[h[i]]);
                        maxRho = Math.max(maxRho, (double)ATRTData.this.rhoz[h[i]]);
                        continue;
                    }
                    minZ = Math.min(minZ, (double)ATRTData.this.rhoz[h[i]]);
                    maxZ = Math.max(maxZ, (double)ATRTData.this.rhoz[h[i]]);
                }
                AOutput.append("Eta results:\n  minRho = " + AMath.d2s(minRho, 3) + "  maxRho = " + AMath.d2s(maxRho, 3) + "\n" + "  minZ = " + AMath.d2s(minZ, 3) + "  maxZ = " + AMath.d2s(maxZ, 3) + "\n", "NORMAL");
            }
        }};
        return action;
    }

    protected void finalizeConstruction() {
        super.finalizeConstruction();
        Vector keys = (Vector)this.event.getCollections().get("InDetTrack");
        if (keys != null) {
            for (String trackCollec : keys) {
                AInDetTrackData data = (AInDetTrackData)this.event.get("InDetTrack" + trackCollec);
                int[][] hits = this.event.getAssociationManager().get("InDetTrack" + trackCollec, this.getName());
                int[][] drifts = this.event.getAssociationManager().get("InDetTrack" + trackCollec + "Drift", this.getName());
                int[][] outliers = this.event.getAssociationManager().get("InDetTrack" + trackCollec + "Outlier", this.getName());
                if (drifts != null || outliers != null) {
                    int i;
                    int[] driftSignData = new int[this.numData];
                    int[] isOutlierData = new int[this.numData];
                    for (i = 0; i < this.numData; ++i) {
                        driftSignData[i] = -99;
                        isOutlierData[i] = -99;
                    }
                    for (i = 0; i < data.getNumData(); ++i) {
                        for (int j = 0; j < hits[i].length; ++j) {
                            int list = this.getIndexFromId(hits[i][j]);
                            if (list == -1) continue;
                            if (drifts != null) {
                                driftSignData[list] = drifts[i][j];
                            }
                            if (outliers == null) continue;
                            isOutlierData[list] = outliers[i][j];
                        }
                    }
                    if (drifts != null) {
                        this.driftSign.put(trackCollec, driftSignData);
                    }
                    if (outliers != null) {
                        this.isOutlier.put(trackCollec, isOutlierData);
                    }
                }
                if (drifts == null) {
                    this.driftSign.put(trackCollec, null);
                }
                if (outliers != null) continue;
                this.isOutlier.put(trackCollec, null);
            }
        }
    }

    public float[] getPhi() {
        return this.phi;
    }

    public float[] getRhoZ() {
        return this.rhoz;
    }

    public float[] getDriftR() {
        return this.driftR;
    }

    public int[] getThreshold() {
        return this.threshold;
    }

    public int[] getSub() {
        return this.sub;
    }
}

