/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.AAODData;
import atlantis.event.AEvent;
import atlantis.parameters.APar;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;
import java.util.Vector;

public class ATauJetData
extends AAODData {
    private float[] charge;
    private int[] integerCharge;
    private int[] numTracks;
    private float[] isolFrac;
    private float[] logLhRatio;
    private String[] label;
    private Vector<Enum> isTauEnum = new Vector();

    ATauJetData(AHashMap p, AEvent e) {
        super(p, e);
        this.charge = p.getFloatArray("charge");
        this.integerCharge = new int[this.charge.length];
        for (int i = 0; i < this.charge.length; ++i) {
            this.integerCharge[i] = (int)this.charge[i];
        }
        this.numTracks = p.getUnknownIntArray("numTracks");
        this.isolFrac = p.getUnsureFloatArray("isolFrac");
        this.logLhRatio = p.getUnsureFloatArray("logLhRatio");
        this.label = p.getUnsureStringArray("label");
        String[] isTauString = p.getUnsureStringArray("isTauString");
        if (isTauString != null) {
            for (String s : isTauString) {
                try {
                    this.isTauEnum.add(isTau.valueOf(s));
                }
                catch (IllegalArgumentException q) {
                    this.isTauEnum.add(isTau.none);
                }
            }
        } else {
            for (int i = 0; i < this.numData; ++i) {
                this.isTauEnum.add(isTau.none);
            }
        }
    }

    public String getParameterGroup() {
        return "TauJet";
    }

    public String getName() {
        return "TauJet";
    }

    public float getCharge(int index) {
        return this.charge[index];
    }

    public int getNumTracks(int index) {
        return this.numTracks[index];
    }

    public float getIsolFrac(int index) {
        if (this.isolFrac != null) {
            return this.isolFrac[index];
        }
        return -100.0f;
    }

    public float getLogLhRatio(int index) {
        if (this.logLhRatio != null) {
            return this.logLhRatio[index];
        }
        return -100.0f;
    }

    public String getisTau(int index) {
        return this.isTauEnum.get(index).toString();
    }

    protected void applyCuts() {
        super.applyCuts();
        this.cut("CutsObjects", "TauJetPt", " |ET|", this.pT);
        this.cut("CutsObjects", "TauJetCharge", " |Charge|", this.integerCharge);
        this.cut("CutsObjects", "TauJetNumTracks", " |NumTracks|", this.numTracks);
        if (this.isolFrac != null) {
            this.cut("CutsObjects", "TauJetisolFrac", " isolFrac", this.isolFrac);
        }
        if (this.logLhRatio != null) {
            this.cut("CutsObjects", "TauJetlogLhRatio", " logLhRatio", this.logLhRatio);
        }
        if (APar.get("CutsObjects", "TauJetisTauString").getStatus()) {
            int cutSub = APar.get("CutsObjects", "TauJetisTauString").getI();
            this.cutArrayEnum(this.isTauEnum, cutSub, "TauJet isTauString");
        }
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            String output = this.getNameScreenName() + " index: " + index;
            if (Atlantis.SIMPLE_OUTPUT == 1 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n PT=" + AMath.d2s(this.pT[index], 3) + " GeV\n " + "\u03b7" + " = " + AMath.d2s(this.eta[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
            }
            if (Atlantis.SIMPLE_OUTPUT == 2 || Atlantis.SIMPLE_OUTPUT == 3) {
                output = output + "\n Px=" + AMath.d2s((double)this.pT[index] * Math.cos(this.phi[index]), 3) + " GeV " + "\n Py=" + AMath.d2s((double)this.pT[index] * Math.sin(this.phi[index]), 3) + " GeV " + "\n Pz=" + AMath.d2s((double)this.pT[index] * Math.sinh(this.eta[index]), 3) + " GeV ";
            }
            return output;
        }
        String k = this.getStoreGateKey();
        String sgKey = k != null ? k : "n/a";
        StringBuffer msg = new StringBuffer(this.getNameScreenName());
        msg.append(" (id: " + this.id[index] + " index: " + index + ")");
        msg.append("\n storegate key: ");
        msg.append(sgKey);
        msg.append("\n PT = ");
        msg.append(AMath.d2s(this.pT[index], 3));
        msg.append(" GeV\n P = ");
        msg.append(AMath.d2s(Math.abs((double)this.pT[index] / Math.cos(AMath.lambda(this.eta[index]))), 3));
        msg.append(" GeV\n Charge = ");
        msg.append(this.integerCharge[index]);
        msg.append("\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(this.eta[index], 3));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi[index]), 3));
        msg.append("\u00b0");
        msg.append("  (" + AMath.d2s(this.phi[index], 3) + " rad)");
        msg.append("\n numTracks = ");
        msg.append(this.numTracks[index]);
        if (this.label != null) {
            msg.append("\n label = ");
            msg.append(this.label[index]);
        }
        if (this.isolFrac != null) {
            msg.append("\n isolFrac = ");
            msg.append(this.isolFrac[index]);
        }
        if (this.logLhRatio != null) {
            msg.append("\n logLhRatio = ");
            msg.append(this.logLhRatio[index]);
        }
        return msg.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum isTau {
        TauCutSafeTight,
        TauCutSafeMedium,
        TauCutSafeLoose,
        none;

    }
}

