/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.ADHelix;
import atlantis.data.AHelix;
import atlantis.data.AInDetTrackData;
import atlantis.data.ATrackResidualData;
import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjection3D;
import atlantis.projection.AProjectionLegoPlot;
import atlantis.projection.AProjectionPhi;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionXZ;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.A4Vector;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AHashMap;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;

public abstract class ATrackData
extends AData {
    private static ALogger logger = ALogger.getLogger(ATrackData.class);
    public static final int DRAW_HELIX = 0;
    public static final int DRAW_POLYLINE = 1;
    public static final int DRAW_SMOOTH = 2;
    public static final int ADD_HELIX_POINTS = 10;
    private boolean hasResidual = false;
    protected ATrackResidualData[] residuals = null;
    protected boolean polylinedTrack = false;
    protected float[][] x = null;
    protected float[][] y = null;
    protected float[][] z = null;
    protected float[][] rho = null;
    protected float[][] phi = null;
    protected int[] numHelix = null;
    protected boolean[] cosmic = null;
    protected AHelix[] h = null;
    protected float[] rhoVertex = null;
    protected int[] index = null;
    protected float[] chi2 = null;
    protected int[] numDoF = null;

    ATrackData(AHashMap p, AEvent e) throws AAtlantisException {
        super(p, e);
        double[] phi;
        int[] numPolyline;
        int i;
        String assocKey = this.getName() + this.getStoreGateKey();
        if (p.get("barcode") != null) {
            this.event.getAssociationManager().add(new AAssociation(assocKey, "STr", p.getUnknownIntArray("barcode"), this.event));
        }
        if (p.get("numTsos") != null && p.get("tsosPullLoc1") != null) {
            this.hasResidual = true;
            this.residuals = new ATrackResidualData[this.numData];
            int[] numTsos = p.getIntArray("numTsos");
            float[] tsosPullLoc1 = p.getFloatArray("tsosPullLoc1");
            float[] tsosResLoc1 = p.getFloatArray("tsosResLoc1");
            float[] tsosPullLoc2 = p.getFloatArray("tsosPullLoc2");
            float[] tsosResLoc2 = p.getFloatArray("tsosResLoc2");
            String[] tsosDetType = p.getUnsureStringArray("tsosDetType");
            int num = 0;
            for (i = 0; i < this.numData; ++i) {
                int numPoints = numTsos[i];
                float[] pullLoc1 = new float[numPoints];
                float[] resLoc1 = new float[numPoints];
                float[] pullLoc2 = new float[numPoints];
                float[] resLoc2 = new float[numPoints];
                String[] detType = null;
                if (tsosDetType != null) {
                    detType = new String[numPoints];
                }
                for (int j = 0; j < numPoints; ++j) {
                    pullLoc1[j] = tsosPullLoc1[num];
                    resLoc1[j] = tsosResLoc1[num];
                    pullLoc2[j] = tsosPullLoc2[num];
                    resLoc2[j] = tsosResLoc2[num];
                    if (tsosDetType != null) {
                        detType[j] = tsosDetType[num];
                    }
                    ++num;
                }
                this.residuals[i] = new ATrackResidualData(this, i, numPoints, pullLoc1, resLoc1, pullLoc2, resLoc2, detType);
            }
        }
        if (p.get("d0") != null) {
            this.h = new AHelix[this.numData];
            float[] d0 = p.getFloatArray("d0");
            float[] phi0 = p.getFloatArray("phi0");
            float[] tl = p.getFloatArray("cotTheta");
            float[] pt = p.getFloatArray("pt");
            float[] z0 = p.getFloatArray("z0");
            if ("TrigInDetTrack".equals((String)p.get("storeGateKey"))) {
                for (int i2 = 0; i2 < tl.length; ++i2) {
                    if (!Float.isInfinite(tl[i2])) continue;
                    tl[i2] = 0.0f;
                }
            }
            if (p.get("covMatrix") != null) {
                int i3;
                float[][][] cov = new float[this.numData][5][5];
                float[] covMatrix = p.getFloatArray("covMatrix");
                for (i = 0; i < covMatrix.length; ++i) {
                    covMatrix[i] = covMatrix[i] / 10000.0f;
                }
                int n = 0;
                for (i3 = 0; i3 < this.numData; ++i3) {
                    for (int j = 0; j < 5; ++j) {
                        for (int k = 0; k < j + 1; ++k) {
                            cov[i3][j][k] = covMatrix[n++];
                            cov[i3][k][j] = cov[i3][j][k];
                        }
                    }
                }
                if (p.get("numHits") != null) {
                    int[] numHits = p.getIntArray("numHits");
                    for (int i4 = 0; i4 < this.numData; ++i4) {
                        this.h[i4] = new AHelix(d0[i4], z0[i4], (float)AMath.radiansToDegrees(phi0[i4]), tl[i4], pt[i4], numHits[i4], cov[i4]);
                    }
                } else {
                    for (i3 = 0; i3 < this.numData; ++i3) {
                        this.h[i3] = new AHelix(d0[i3], z0[i3], (float)AMath.radiansToDegrees(phi0[i3]), tl[i3], pt[i3], cov[i3]);
                    }
                }
            } else if (p.get("numHits") != null) {
                int[] numHits = p.getIntArray("numHits");
                for (int i5 = 0; i5 < this.numData; ++i5) {
                    this.h[i5] = new AHelix(d0[i5], z0[i5], (float)AMath.radiansToDegrees(phi0[i5]), tl[i5], pt[i5], numHits[i5]);
                }
            } else {
                for (int i6 = 0; i6 < this.numData; ++i6) {
                    this.h[i6] = new AHelix(d0[i6], z0[i6], (float)AMath.radiansToDegrees(phi0[i6]), tl[i6], pt[i6]);
                }
            }
        } else if (p.get("rhoVertex") != null) {
            this.h = new AHelix[this.numData];
            this.rhoVertex = p.getFloatArray("rhoVertex");
            float[] rhoEndVertex = p.getFloatArray("rhoEndVertex");
            float[] pt = p.getFloatArray("pt");
            float[] phi2 = p.getFloatArray("phi");
            float[] eta = p.getFloatArray("eta");
            float[] phiVertex = p.getFloatArray("phiVertex");
            float[] zVertex = p.getFloatArray("zVertex");
            int[] charge = p.getIntArray("charge");
            for (i = 0; i < this.numData; ++i) {
                this.h[i] = (double)rhoEndVertex[i] != 0.0 ? new AHelix(this.rhoVertex[i], phiVertex[i], zVertex[i], pt[i], phi2[i], eta[i], charge[i], rhoEndVertex[i]) : new AHelix(this.rhoVertex[i], phiVertex[i], zVertex[i], pt[i], phi2[i], eta[i], charge[i]);
            }
        }
        if (p.get("numPolyline") != null && (numPolyline = p.getIntArray("numPolyline")).length > 0) {
            this.polylinedTrack = true;
            this.x = new float[this.numData][];
            this.y = new float[this.numData][];
            this.z = new float[this.numData][];
            this.rho = new float[this.numData][];
            this.phi = new float[this.numData][];
            this.rhoVertex = new float[this.numData];
            this.numHelix = new int[this.numData];
            this.cosmic = new boolean[this.numData];
            float[] polyX = p.getFloatArray("polylineX");
            float[] polyY = p.getFloatArray("polylineY");
            float[] polyZ = p.getFloatArray("polylineZ");
            int num = 0;
            for (int i7 = 0; i7 < this.numData; ++i7) {
                this.numHelix[i7] = 0;
                this.cosmic[i7] = false;
                if (numPolyline[i7] >= 2) {
                    int next;
                    int first = num;
                    for (next = num + 1; next < numPolyline[i7] && polyX[next] == polyX[first] && polyY[next] == polyY[first]; ++next) {
                    }
                    float rStart = (float)Math.sqrt(polyX[first] * polyX[first] + polyY[first] * polyY[first]);
                    float rDir = (float)Math.sqrt(polyX[next] * polyX[next] + polyY[next] * polyY[next]) - rStart;
                    float zDir = Math.abs(polyZ[next]) - Math.abs(polyZ[first]);
                    if (rDir > 0.0f && zDir > 0.0f && this.h != null && this.h[i7] != null && (double)rStart - Math.abs(this.h[i7].d0) > 1.0 && this instanceof AInDetTrackData) {
                        this.numHelix[i7] = 10;
                    }
                    if (rDir < 0.0f) {
                        this.cosmic[i7] = true;
                    }
                } else if (this.h != null && this.h[i7] != null && this instanceof AInDetTrackData) {
                    this.numHelix[i7] = 10;
                }
                this.x[i7] = new float[numPolyline[i7] + this.numHelix[i7]];
                this.y[i7] = new float[numPolyline[i7] + this.numHelix[i7]];
                this.z[i7] = new float[numPolyline[i7] + this.numHelix[i7]];
                this.rho[i7] = new float[numPolyline[i7] + this.numHelix[i7]];
                this.phi[i7] = new float[numPolyline[i7] + this.numHelix[i7]];
                for (int j = 0; j < numPolyline[i7]; ++j) {
                    this.x[i7][j + this.numHelix[i7]] = polyX[num];
                    this.y[i7][j + this.numHelix[i7]] = polyY[num];
                    this.z[i7][j + this.numHelix[i7]] = polyZ[num];
                    this.rho[i7][j + this.numHelix[i7]] = (float)Math.sqrt(polyX[num] * polyX[num] + polyY[num] * polyY[num]);
                    ++num;
                    if (j != 0) continue;
                    this.rhoVertex[i7] = (float)Math.sqrt(this.x[i7][this.numHelix[i7]] * this.x[i7][this.numHelix[i7]] + this.y[i7][this.numHelix[i7]] * this.y[i7][this.numHelix[i7]]);
                }
                if (this.numHelix[i7] > 0) {
                    double R = AMath.getCurvature() * Math.abs(this.h[i7].pT);
                    double S = AMath.getSign(this.h[i7].pT);
                    double xC = (S * this.h[i7].d0 - R) * Math.cos(Math.toRadians(this.h[i7].phi0) + S * Math.PI / 2.0);
                    double yC = (S * this.h[i7].d0 - R) * Math.sin(Math.toRadians(this.h[i7].phi0) + S * Math.PI / 2.0);
                    double Rmax = numPolyline[i7] > 0 ? Math.min(APar.get("RTr", "RadiusTr").getD(), Math.abs(Math.sqrt(this.x[i7][this.numHelix[i7]] * this.x[i7][this.numHelix[i7]] + this.y[i7][this.numHelix[i7]] * this.y[i7][this.numHelix[i7]]) - 1.0)) : APar.get("RTr", "RadiusTr").getD();
                    double d = Math.sqrt(xC * xC + yC * yC);
                    double xI = (Rmax * Rmax - R * R + d * d) / (2.0 * d);
                    double yI = Math.sqrt(Rmax * Rmax - xI * xI);
                    double phiMax = Math.atan2(S * yI, d - xI);
                    double dphi = phiMax / (double)this.numHelix[i7];
                    for (int j = 0; j < this.numHelix[i7]; ++j) {
                        this.x[i7][j] = (float)(xC + R * Math.cos(Math.toRadians(this.h[i7].phi0) + S * Math.PI / 2.0 - (double)j * dphi));
                        this.y[i7][j] = (float)(yC + R * Math.sin(Math.toRadians(this.h[i7].phi0) + S * Math.PI / 2.0 - (double)j * dphi));
                        this.rho[i7][j] = (float)Math.sqrt(this.x[i7][j] * this.x[i7][j] + this.y[i7][j] * this.y[i7][j]);
                        this.z[i7][j] = (float)(this.h[i7].z0 + this.h[i7].tL * ((double)this.rho[i7][j] - this.h[i7].d0));
                    }
                }
                for (int j = 0; j < numPolyline[i7] + this.numHelix[i7]; ++j) {
                    this.phi[i7][j] = (float)Math.atan2(this.y[i7][j], this.x[i7][j]);
                    if (j <= 0 || !((double)Math.abs(this.phi[i7][j - 1] - this.phi[i7][j]) > Math.PI)) continue;
                    if (this.phi[i7][j] > this.phi[i7][j - 1]) {
                        float[] fArray = this.phi[i7];
                        int n = j;
                        fArray[n] = (float)((double)fArray[n] - Math.PI * 2);
                        continue;
                    }
                    float[] fArray = this.phi[i7];
                    int n = j;
                    fArray[n] = (float)((double)fArray[n] + Math.PI * 2);
                }
            }
        }
        if (this.h != null) {
            phi = new double[this.numData];
            for (int i8 = 0; i8 < this.numData; ++i8) {
                phi[i8] = this.h[i8].phi0;
            }
            this.index = this.indexBy(phi);
        } else if (this.x != null && this.y != null) {
            phi = new double[this.numData];
            for (int i9 = 0; i9 < this.numData; ++i9) {
                if (this.x[i9].length <= 0 || this.y[i9].length <= 0) {
                    String m = this.getName() + ":" + this.getStoreGateKey() + " datatype rejected\n" + "(no polyline coordinates).";
                    throw new AAtlantisException(m, false);
                }
                phi[i9] = Math.toDegrees(Math.atan2(this.y[i9][0], this.x[i9][0]));
            }
            this.index = this.indexBy(phi);
        }
        if (p.get("chi2") != null) {
            this.chi2 = p.getFloatArray("chi2");
        }
        if (p.get("numDoF") != null) {
            this.numDoF = p.getIntArray("numDoF");
        }
    }

    public float[][] getX() {
        return this.x;
    }

    public float[][] getY() {
        return this.y;
    }

    public float[][] getZ() {
        return this.z;
    }

    public float[][] getRho() {
        return this.rho;
    }

    public float[][] getPhi() {
        return this.phi;
    }

    public boolean getResidualStatus() {
        return this.hasResidual;
    }

    public ATrackResidualData getTrackResidual(int index) {
        return this.residuals[index];
    }

    protected void calculateRhoPhi() {
        if (!this.polylinedTrack) {
            super.calculateRhoPhi();
        }
    }

    protected void applyCuts() {
        this.cutIndex();
        if (this.h != null) {
            this.cut("CutsInDet", "z0-zVtx", " |z0-zVtx|", this.getZ0Primary());
            this.cut("CutsInDet", "z0", " |z0|", this.getZ0());
            this.cut("CutsInDet", "Pt", " |Pt|", this.getPt());
            this.cut("CutsInDet", "d0", " |d0|", this.getD0());
            this.cut("CutsInDet", "d0Loose", " |d0Loose|", this.getD0());
        }
        this.cutPhi();
        this.cutEta();
        this.cutNextInDrawList();
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + (this.h != null ? this.h[index].toString() : "");
        }
        String msg = this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")";
        msg = msg + "\n storegate key: ";
        msg = msg + (this.storeGateKey == null ? "n/a" : this.storeGateKey);
        if (this.h != null) {
            msg = msg + this.h[index].toString();
        }
        if (this.chi2 != null && this.numDoF != null) {
            msg = msg + "\n chi2/numDoF = " + this.chi2[index] / (float)this.numDoF[index];
        }
        return msg;
    }

    protected ACoord getYXUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int numPoints = this.x[list].length;
            hv[0][i] = new double[numPoints];
            hv[1][i] = new double[numPoints];
            for (int j = 0; j < numPoints; ++j) {
                hv[0][i][j] = this.x[list][j];
                hv[1][i][j] = this.y[list][j];
            }
            index[i] = list;
        }
        if (APar.get(this.PARAMETER_GROUP, "DrawnAs").getI() == 2) {
            return new ACoord(hv, index, (ADrawable)this, 6);
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getFRUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int numPoints = this.x[list].length;
            int skip = 0;
            for (skip = 0; skip < numPoints && !((double)this.rho[list][skip] > 2.0); ++skip) {
            }
            hv[0][i] = new double[numPoints - skip];
            hv[1][i] = new double[numPoints - skip];
            double phiStart = 0.0;
            if (numPoints > 0) {
                phiStart = this.phi[list][0];
            }
            for (int j = skip; j < numPoints; ++j) {
                double phiTemp = this.phi[list][j];
                if (phiTemp - phiStart > Math.PI) {
                    phiTemp -= Math.PI * 2;
                }
                if (phiTemp - phiStart < -Math.PI) {
                    phiTemp += Math.PI * 2;
                }
                hv[0][i][j - skip] = this.rho[list][j];
                hv[1][i][j - skip] = Math.toDegrees(phiTemp);
            }
            index[i] = list;
        }
        if (APar.get(this.PARAMETER_GROUP, "DrawnAs").getI() == 2) {
            return new ACoord(hv, index, (ADrawable)this, 6).includePhiWrapAround("FR");
        }
        return new ACoord(hv, index, (ADrawable)this, 3).includePhiWrapAround("FR");
    }

    protected ACoord getFZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int numPoints = this.x[list].length;
            int skip = 0;
            for (skip = 0; skip < numPoints && !((double)this.rho[list][skip] > 2.0); ++skip) {
            }
            hv[0][i] = new double[numPoints - skip];
            hv[1][i] = new double[numPoints - skip];
            double phiStart = 0.0;
            if (numPoints > 0) {
                phiStart = this.phi[list][0];
            }
            for (int j = skip; j < numPoints; ++j) {
                hv[0][i][j - skip] = this.z[list][j];
                double phiTemp = this.phi[list][j];
                if (phiTemp - phiStart > Math.PI) {
                    phiTemp -= Math.PI * 2;
                }
                if (phiTemp - phiStart < -Math.PI) {
                    phiTemp += Math.PI * 2;
                }
                hv[1][i][j - skip] = Math.toDegrees(phiTemp);
            }
            index[i] = list;
        }
        if (APar.get(this.PARAMETER_GROUP, "DrawnAs").getI() == 2) {
            return new ACoord(hv, index, (ADrawable)this, 6).includePhiWrapAround("FZ");
        }
        return new ACoord(hv, index, (ADrawable)this, 3).includePhiWrapAround("FZ");
    }

    protected ACoord getRZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int numPoints = this.rho[list].length;
            hv[0][i] = new double[numPoints];
            hv[1][i] = new double[numPoints];
            if (numPoints > 0) {
                int sign = AMath.getRhoSign(this.x[list][numPoints - 1], this.y[list][numPoints - 1]);
                for (int j = 0; j < numPoints; ++j) {
                    if (this.cosmic != null && this.cosmic[i]) {
                        sign = AMath.getRhoSign(this.x[list][j], this.y[list][j]);
                    }
                    hv[0][i][j] = this.z[list][j];
                    hv[1][i][j] = this.rho[list][j] * (float)sign;
                }
            }
            index[i] = list;
        }
        if (APar.get(this.PARAMETER_GROUP, "DrawnAs").getI() == 2) {
            return new ACoord(hv, index, (ADrawable)this, 6);
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getXZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int numPoints = this.rho[list].length;
            hv[0][i] = new double[numPoints];
            hv[1][i] = new double[numPoints];
            for (int j = 0; j < numPoints; ++j) {
                hv[0][i][j] = this.z[list][j];
                hv[1][i][j] = (double)this.rho[list][j] * Math.cos((double)this.phi[list][j] - phi0);
            }
            index[i] = list;
        }
        if (APar.get(this.PARAMETER_GROUP, "DrawnAs").getI() == 2) {
            return new ACoord(hv, index, (ADrawable)this, 6);
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getYZUser() {
        this.makeDrawList();
        double[][][] hv = new double[2][this.numDraw][];
        int[] index = new int[this.numDraw];
        double phi0 = Math.toRadians(AProjectionXZ.getPhi());
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            int numPoints = this.rho[list].length;
            hv[0][i] = new double[numPoints];
            hv[1][i] = new double[numPoints];
            for (int j = 0; j < numPoints; ++j) {
                hv[0][i][j] = this.z[list][j];
                hv[1][i][j] = (double)this.rho[list][j] * Math.sin((double)this.phi[list][j] - phi0);
            }
            index[i] = list;
        }
        if (APar.get(this.PARAMETER_GROUP, "DrawnAs").getI() == 2) {
            return new ACoord(hv, index, (ADrawable)this, 6);
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (this.h != null && (projection instanceof AProjectionVP || projection instanceof AProjection3D)) {
            this.drawHelix(window, ag, projection);
        } else if (this.polylinedTrack && (this.h == null || APar.get(this.PARAMETER_GROUP, "DrawnAs").getI() != 0)) {
            ag.draw(window.calculateDisplay(this.getUser(projection)));
        } else if (this.h != null) {
            this.drawHelix(window, ag, projection);
        }
    }

    protected void cutRhoVertexAfterInDetRadius() {
        int num = 0;
        int wrong = 0;
        int list = 0;
        double rho = 108.0;
        double parRhoTr = APar.get("RTr", "RadiusTr").getD();
        for (int i = 0; i < this.numDraw; ++i) {
            list = this.listdl[i];
            if ((double)this.rhoVertex[list] > Math.min(rho, parRhoTr)) {
                ++wrong;
                continue;
            }
            this.listdl[num++] = list;
        }
        if (wrong > 0) {
            logger.debug("AHelix.cutRhoVertexAfterInDetRadius()");
            String key = this.getStoreGateKey();
            key = key != null ? ":" + key : "";
            logger.debug("  " + this.numDraw + " " + this.getName() + key + " before test, " + wrong + " removed\n");
        }
        this.numDraw = num;
    }

    protected int internalColor() {
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        switch (colorFunction) {
            case 0: {
                this.colorByConstant();
                break;
            }
            case 1: {
                this.colorByIndex(this.index);
                break;
            }
            case 2: {
                this.colorBy(this.getPt());
                break;
            }
            case 3: {
                this.colorByCollection();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (APar.get("RVx", "ColorFunction").getI() != 1) {
                    APar.get("RVx", "ColorFunction").setI(1);
                    String msg = "Coloring Tracks by Vertex so ";
                    msg = msg + "ATLAS->RVx->Color Function changed to color by index";
                    AOutput.append("\n" + msg + "\n", "WARNING");
                }
                this.colorBy("RVx");
                break;
            }
            case 6: {
                if (APar.get("Jet", "ColorFunction").getI() != 1) {
                    APar.get("Jet", "ColorFunction").setI(1);
                    String msg = "Coloring Tracks by jet so ";
                    msg = msg + "ATLAS->Jet->Color Function changed to color by index";
                    AOutput.append("\n" + msg + "\n", "WARNING");
                }
                this.colorBy(this.getJets());
                break;
            }
            case 7: {
                this.colorByObjects();
            }
        }
        return 7;
    }

    public int[] getDrawList() {
        int[] temp = new int[this.numDraw];
        System.arraycopy(this.listdl, 0, temp, 0, this.numDraw);
        return temp;
    }

    protected void cutNextInDrawList() {
        int nextTrk;
        AParameter nextTrkPar = APar.get(this.PARAMETER_GROUP, "NextTrack");
        if (!nextTrkPar.getStatus()) {
            return;
        }
        if (this.numDraw == 0) {
            return;
        }
        int nextTrkIndex = nextTrk = nextTrkPar.getI() % this.numData;
        boolean hasFound = false;
        while (!hasFound) {
            for (int i = 0; i < this.numDraw; ++i) {
                if (this.listdl[i] != nextTrk) continue;
                nextTrkIndex = nextTrk;
                hasFound = true;
            }
            if (hasFound) continue;
            nextTrk = (nextTrk + 1) % this.numData;
        }
        nextTrkPar.setI(nextTrkIndex);
        this.numDraw = 1;
        this.listdl[0] = nextTrkIndex;
    }

    protected void cutPhi() {
        AParameter par = APar.get("CutsATLAS", "CutPhi");
        boolean usePhiCut = par.getStatus();
        if (usePhiCut) {
            double phiCut = par.getD();
            double phiMid = AMath.nearestPhiDegrees(APar.get("CutsATLAS", "PhiMiddle").getD());
            AProjection2D projection = (AProjection2D)AProjectionsManager.getProjection("VP");
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                int list = this.listdl[i];
                ADHelix dH = new ADHelix(this.h[list], this.event);
                double s1 = dH.getAStart();
                double s2 = dH.getAEnd();
                s1 = dH.intersectWithRadialCylinder(projection.getMinRho(), s1, s2);
                double sEnd = dH.intersectWithCylinder(true, AProjectionVP.getRhoVPlot(), true, AProjectionVP.getZVPlot());
                s2 = Math.max(Math.min(s2, sEnd), s1);
                double phiDiffStart = Math.abs(AMath.nearestPhiDegrees(dH.getPhi(s1), phiMid) - phiMid);
                double phiDiffEnd = Math.abs(AMath.nearestPhiDegrees(dH.getPhi(s2), phiMid) - phiMid);
                double phiDiffMiddle = Math.abs(AMath.nearestPhiDegrees(dH.getPhi((s1 + s2) / 2.0), phiMid) - phiMid);
                int numPointsInside = 0;
                if (phiDiffStart < phiCut) {
                    ++numPointsInside;
                }
                if (phiDiffMiddle < phiCut) {
                    ++numPointsInside;
                }
                if (phiDiffEnd < phiCut) {
                    ++numPointsInside;
                }
                if (numPointsInside <= 1) continue;
                this.listdl[num++] = list;
            }
            this.numDraw = num;
            AData.printCut(" Phi", this.numDraw);
        }
    }

    protected void cutEta() {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        if (par.getStatus()) {
            AProjection2D projection = (AProjection2D)AProjectionsManager.getProjection("VP");
            double etaCut = par.getD();
            double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
            double etaC1 = etaMid - etaCut;
            double etaC2 = etaMid + etaCut;
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                int list = this.listdl[i];
                ADHelix dH = new ADHelix(this.h[list], this.event);
                double s1 = dH.getAStart();
                double s2 = dH.getAEnd();
                s1 = dH.intersectWithRadialCylinder(projection.getMinRho(), s1, s2);
                double sEnd = dH.intersectWithCylinder(true, AProjectionVP.getRhoVPlot(), true, AProjectionVP.getZVPlot());
                s2 = Math.max(Math.min(s2, sEnd), s1);
                double[] etaPoints = new double[]{dH.getEta(s1), dH.getEta((s1 + s2) / 2.0), dH.getEta(s2)};
                int numPointsInside = 0;
                for (int j = 0; j < etaPoints.length; ++j) {
                    if (!(etaC1 < etaPoints[j]) || !(etaPoints[j] < etaC2)) continue;
                    ++numPointsInside;
                }
                if (numPointsInside <= true) continue;
                this.listdl[num++] = list;
            }
            this.numDraw = num;
            AData.printCut(" Eta", this.numDraw);
        }
    }

    private float[] getZ0Primary() {
        double[] pVtx = this.event.getPrimaryVertex();
        float[] temp = new float[this.numData];
        double zVertex = pVtx[2];
        for (int i = 0; i < this.numDraw; ++i) {
            temp[this.listdl[i]] = (float)(this.h[this.listdl[i]].z0 - zVertex);
        }
        return temp;
    }

    private float[] getZ0() {
        float[] temp = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            temp[this.listdl[i]] = (float)this.h[this.listdl[i]].z0;
        }
        return temp;
    }

    protected float[] getPt() {
        float[] temp = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            temp[this.listdl[i]] = (float)this.h[this.listdl[i]].pT;
        }
        return temp;
    }

    private float[] getD0() {
        double[] pVtx = this.event.getPrimaryVertex();
        float[] temp = new float[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            double phi0 = Math.toRadians(this.h[this.listdl[i]].phi0);
            temp[this.listdl[i]] = (float)(-this.h[this.listdl[i]].d0 + pVtx[1] * Math.cos(phi0) - pVtx[0] * Math.sin(phi0));
        }
        return temp;
    }

    public ADHelix[] getHelices() {
        this.makeDrawList();
        ADHelix[] tempList = new ADHelix[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            if (this.h != null && this.h[this.listdl[i]] != null) {
                tempList[i] = new ADHelix(this.h[this.listdl[i]], this.event);
                if (tempList[i].getAStart() != tempList[i].getAEnd()) continue;
                tempList[i] = null;
                continue;
            }
            tempList[i] = null;
        }
        return tempList;
    }

    public AHelix getModifiableHelix(int i) {
        if (this.h != null) {
            return this.h[i];
        }
        return null;
    }

    public String getVPHitInfo() {
        this.makeDrawList();
        if (this.numDraw == 0) {
            return "";
        }
        double sumP = 0.0;
        double sumPt = 0.0;
        for (int i = 0; i < this.numDraw; ++i) {
            sumPt += Math.abs(this.h[this.listdl[i]].pT);
            sumP += AMath.getPFromPttL(this.h[this.listdl[i]].pT, this.h[this.listdl[i]].tL);
        }
        String msg = this.numDraw + " " + this.getFullName();
        msg = msg + "  sum(PT) = " + AMath.d2s(sumPt, 1) + "  sum(P) = " + AMath.d2s(sumP, 1);
        return msg;
    }

    public A4Vector get4Vector(int num, int[] list) {
        A4Vector sum = new A4Vector();
        for (int i = 0; i < num; ++i) {
            if (this.h == null || this.h[list[i]] == null) continue;
            sum.add(new A4Vector(this.h[list[i]].getP(), 0.14));
        }
        return sum;
    }

    public A4Vector get4Vector(int num, int[] list, double mass) {
        A4Vector sum = new A4Vector();
        for (int i = 0; i < num; ++i) {
            if (this.h == null || this.h[list[i]] == null) continue;
            sum.add(new A4Vector(this.h[list[i]].getP(), mass));
        }
        return sum;
    }

    public void zoomAroundTracks() {
        AWindow window = ACanvas.getCanvas().getCurrentWindow();
        AProjection projection = window.getProjection();
        if (projection instanceof AProjectionLegoPlot) {
            AOutput.append("Zoom Next Track unavailable for LegoPlot\n", "NORMAL");
        } else if (projection instanceof AProjection2D) {
            int i;
            ACoord user = projection instanceof AProjectionVP ? window.calculateUser(this.getVPDisplayHelices(window, (AProjection2D)projection)) : (this.polylinedTrack ? this.getUser((AProjection2D)projection) : window.calculateUser(this.getDisplayHelices(window, (AProjection2D)projection)));
            double[] min = new double[2];
            double[] max = new double[2];
            min[1] = 100000.0;
            min[0] = 100000.0;
            max[1] = -100000.0;
            max[0] = -100000.0;
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < user.hv[i].length; ++j) {
                    for (int k = 0; k < user.hv[i][j].length; ++k) {
                        if (user.hv[i][j][k] < min[i]) {
                            min[i] = user.hv[i][j][k];
                        }
                        if (!(user.hv[i][j][k] > max[i])) continue;
                        max[i] = user.hv[i][j][k];
                    }
                }
            }
            for (i = 0; i < 2; ++i) {
                double diff = (max[i] - min[i]) / 2.0;
                double middle = (max[i] + min[i]) / 2.0;
                if (!(diff > 0.0)) continue;
                max[i] = middle + 1.1 * diff;
                min[i] = middle - 1.1 * diff;
            }
            if (projection instanceof AProjectionPhi) {
                min[1] = min[1] - 0.5;
                max[1] = max[1] + 0.5;
            }
            if (max[0] - min[0] > 0.0 && max[1] - min[1] > 0.0) {
                window.setUserCorners(min[0], max[0], min[1], max[1]);
            }
        }
    }

    public void drawHelix(AWindow window, AGraphics ag, AProjection2D projection) {
        if (projection instanceof AProjectionVP) {
            ag.draw(window.calculateDisplay(window.calculateUser(this.getVPDisplayHelices(window, projection)).includePhiWrapAround(projection.getName())));
        } else if (projection instanceof AProjectionRZ) {
            ag.draw(this.getRZDisplayHelices(window, projection));
        } else if (projection instanceof AProjectionPhi) {
            ag.draw(window.calculateDisplay(window.calculateUser(this.getDisplayHelices(window, projection)).includePhiWrapAround(projection.getName())));
        } else {
            ag.draw(this.getDisplayHelices(window, projection));
        }
    }

    private ACoord getRZDisplayHelices(AWindow window, AProjection2D projection) {
        int i;
        ACoord display = this.getDisplayHelices(window, projection);
        ACoord user = projection.inverseNonLinearTransform(window.calculateUser(display));
        double[][] rho = user.hv[1];
        int extraTrackSegments = 0;
        for (int i2 = 0; i2 < rho.length; ++i2) {
            for (int j = 1; j < rho[i2].length - 2; ++j) {
                if (!(rho[i2][j] * rho[i2][j + 1] < 0.0) || !(Math.abs(rho[i2][j]) > 2.0)) continue;
                ++extraTrackSegments;
            }
        }
        double[][][] hv = new double[2][rho.length + extraTrackSegments][];
        int[] index = new int[rho.length + extraTrackSegments];
        extraTrackSegments = 0;
        for (i = 0; i < rho.length; ++i) {
            int k;
            int startOfSegment = 0;
            int endOfLastSegment = rho[i].length - 1;
            for (int j = 0; j < rho[i].length - 1; ++j) {
                if (!(rho[i][j] * rho[i][j + 1] < 0.0) || !(Math.abs(rho[i][j]) > 2.0)) continue;
                if (j == 0) {
                    if (!(Math.abs(rho[i][0]) > 1.0)) continue;
                    startOfSegment = 1;
                    continue;
                }
                if (j == rho[i].length - 2) {
                    endOfLastSegment = rho[i].length - 2;
                    continue;
                }
                for (int k2 = 0; k2 < hv.length; ++k2) {
                    hv[k2][i + extraTrackSegments] = new double[j + 1 - startOfSegment];
                    System.arraycopy(user.hv[k2][i], startOfSegment, hv[k2][i + extraTrackSegments], 0, j + 1 - startOfSegment);
                }
                index[i + extraTrackSegments] = user.index[i];
                startOfSegment = j + 1;
                ++extraTrackSegments;
            }
            if (startOfSegment == 0 && endOfLastSegment == rho[i].length - 1) {
                for (k = 0; k < hv.length; ++k) {
                    hv[k][i + extraTrackSegments] = user.hv[k][i];
                }
                index[i + extraTrackSegments] = user.index[i];
                continue;
            }
            for (k = 0; k < hv.length; ++k) {
                hv[k][i + extraTrackSegments] = new double[endOfLastSegment - startOfSegment + 1];
                System.arraycopy(user.hv[k][i], startOfSegment, hv[k][i + extraTrackSegments], 0, endOfLastSegment - startOfSegment + 1);
            }
            index[i + extraTrackSegments] = user.index[i];
        }
        rho = hv[1];
        for (i = 0; i < rho.length; ++i) {
            int k;
            int j;
            for (j = 0; j < rho[i].length && Math.abs(rho[i][j]) < 2.0; ++j) {
            }
            if (j >= rho[i].length) continue;
            if (rho[i][j] > 0.0) {
                for (k = 0; k < j; ++k) {
                    rho[i][k] = Math.abs(rho[i][k]);
                }
                continue;
            }
            for (k = 0; k < j; ++k) {
                rho[i][k] = -Math.abs(rho[i][k]);
            }
        }
        return window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv, index, (ADrawable)this, 3)));
    }

    protected ACoord getDisplayHelices(AWindow window, AProjection2D projection) {
        ADHelix[] dhelix = this.getHelices();
        double[][][] hv = new double[2][dhelix.length][0];
        int[] index = this.getDrawList();
        for (int j = 0; j < dhelix.length; ++j) {
            if (dhelix[j] == null) continue;
            double s1 = dhelix[j].getAStart();
            double s2 = dhelix[j].getAEnd();
            s1 = dhelix[j].intersectWithRadialCylinder(projection.getMinRho(), s1, s2);
            dhelix[j].setPhiStart(s1, s2);
            ACoord pointsOnHelix = dhelix[j].drawHelix(window, projection, s1, s2);
            hv[0][j] = pointsOnHelix.hv[0][0];
            hv[1][j] = pointsOnHelix.hv[1][0];
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }

    protected ACoord getVPDisplayHelices(AWindow window, AProjection2D projection) {
        boolean drawApex = APar.get("VP", "DrawApex").getStatus();
        ADHelix[] dhelix = this.getHelices();
        int size = 2 * dhelix.length;
        if (drawApex) {
            size = 3 * dhelix.length;
        }
        double[][][] hv = new double[2][size][0];
        int[] index = new int[size];
        int[] indexIn = this.getDrawList();
        int num = 0;
        for (int j = 0; j < dhelix.length; ++j) {
            if (dhelix[j] == null) continue;
            double s1 = dhelix[j].getAStart();
            double s2 = dhelix[j].getAEnd();
            int mode = APar.get("VP", "Mode").getI();
            if (mode <= 10 && mode >= 3) {
                s2 = 179.0;
            }
            s1 = dhelix[j].intersectWithRadialCylinder(projection.getMinRho(), s1, s2);
            double sEnd = dhelix[j].intersectWithCylinder(true, AProjectionVP.getRhoVPlot(), true, AProjectionVP.getZVPlot());
            s2 = Math.max(Math.min(s2, sEnd), s1);
            if (s1 == 0.0 && s2 == 180.0) {
                s2 = 179.0;
            }
            if (APar.get("VP", "ShortV").getStatus() && !APar.get("Data", "S3D").getStatus()) {
                s1 = s2 - APar.get("VP", "ShortV").getD() * (s2 - s1);
            }
            if (!(s2 > s1)) continue;
            int signMin = -1;
            int signMax = 1;
            double h = 0.0;
            double v = 0.0;
            for (int sign = signMin; sign <= signMax; sign += 2) {
                AProjectionVP.sign = sign;
                ACoord pointsOnHelix = dhelix[j].drawHelix(window, projection, s1, s2);
                hv[0][num] = pointsOnHelix.hv[0][0];
                hv[1][num] = pointsOnHelix.hv[1][0];
                index[num] = indexIn[j];
                h = hv[0][num][hv[0][num].length - 1];
                v = hv[1][num][hv[0][num].length - 1];
                ++num;
            }
            if (!drawApex) continue;
            int a = 3;
            int b = 7;
            hv[0][num] = new double[]{h - (double)a, h + (double)a, h, h, h - (double)a, h + (double)a};
            hv[1][num] = new double[]{v - (double)b, v - (double)b, v - (double)b, v + (double)b, v + (double)b, v + (double)b};
            index[num] = indexIn[j];
            ++num;
        }
        return new ACoord(hv, index, (ADrawable)this, 3);
    }
}

