/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.data.ATrackData;
import atlantis.graphics.AGraphics;
import atlantis.graphics.APickingGraphics2D;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjectionTrackResidual;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;

public class ATrackResidualData {
    public static String PULL_X = "P_X";
    public static String RESIDUAL_X = "R_X";
    private ATrackData track;
    private int trackIndex;
    private String showType = RESIDUAL_X;
    private int numPoints;
    private float[] pullLoc1;
    private float[] resLoc1;
    private float[] pullLoc2;
    private float[] resLoc2;
    private String[] detType;
    private double logMagnitudeMin;
    private int pickedIndex;
    private byte pickedGroup;
    private double minDiff;

    ATrackResidualData(ATrackData track, int trackIndex, int points, float[] pullLoc1, float[] resLoc1, float[] pullLoc2, float[] resLoc2, String[] detType) {
        this.track = track;
        this.trackIndex = trackIndex;
        this.numPoints = points;
        this.pullLoc1 = pullLoc1;
        this.resLoc1 = resLoc1;
        this.pullLoc2 = pullLoc2;
        this.resLoc2 = resLoc2;
        this.detType = detType;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public float[] getPullLoc1() {
        return this.pullLoc1;
    }

    public float[] getResLoc1() {
        return this.resLoc1;
    }

    public float[] getPullLoc2() {
        return this.pullLoc2;
    }

    public float[] getResLoc2() {
        return this.resLoc2;
    }

    public void setLogMagnitudeMin(double logMagnitudeMin) {
        this.logMagnitudeMin = logMagnitudeMin;
    }

    public double getLogMagnitudeMin() {
        return this.logMagnitudeMin;
    }

    public void draw(AWindow window, AGraphics ag, AProjectionTrackResidual projection) {
        Color[] colorMap = AColorMap.getColors();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = projection.getXLength();
        double y2 = 0.0;
        Point2D.Double from = window.calculateDisplay(x1, y1);
        Point2D.Double to = window.calculateDisplay(x2, y2);
        ag.setColor(colorMap[22]);
        ag.drawLine(from.x, from.y, to.x, to.y);
        AParameter showExtraPar = APar.get("TrackResidual", "ShowExtra");
        if (projection.getResidualType().equals(RESIDUAL_X)) {
            this.showType = RESIDUAL_X;
            float[] temp1 = this.resLoc1;
            float[] temp2 = this.pullLoc1;
            this.drawResidual(window, ag, temp1, temp2, colorMap, false);
            if (showExtraPar.getStatus()) {
                temp1 = this.resLoc2;
                temp2 = this.pullLoc2;
                this.drawResidual(window, ag, temp1, temp2, colorMap, true);
            }
        } else {
            this.showType = PULL_X;
            float[] temp1 = this.pullLoc1;
            this.drawResidual(window, ag, temp1, null, colorMap, false);
            if (showExtraPar.getStatus()) {
                temp1 = this.pullLoc2;
                this.drawResidual(window, ag, temp1, null, colorMap, true);
            }
        }
        if (ag.getGraphics2D() instanceof APickingGraphics2D && APar.get("Event", "PickingMode").getI() == 0) {
            APickingGraphics2D.mode = 3;
            APickingGraphics2D.setPicked(this);
        }
    }

    public void drawResidual(AWindow window, AGraphics ag, float[] res, float[] pull, Color[] colorMap, boolean drawExtra) {
        double[] h = new double[4];
        double[] v = new double[4];
        int pixelOffset = 1;
        Point clickedPoint = null;
        if (ag.getGraphics2D() instanceof APickingGraphics2D && APar.get("Event", "PickingMode").getI() == 0) {
            APickingGraphics2D cfr_ignored_0 = (APickingGraphics2D)ag.getGraphics2D();
            clickedPoint = APickingGraphics2D.pickedPoint;
        }
        Color colValid = colorMap[20];
        Color colInvalid = colorMap[26];
        for (int i = 0; i < this.numPoints; ++i) {
            double y;
            if (res[i] == -99.0f) {
                ag.setColor(colInvalid);
                y = 0.0;
            } else {
                if (this.detType != null) {
                    String det = this.detType[i];
                    if ("unident".equals(det)) {
                        ag.setColor(colorMap[14]);
                    } else {
                        AParameter detColor = APar.get("Det", det + "Fill");
                        if (detColor != null) {
                            ag.setColor(colorMap[detColor.getI()]);
                        } else {
                            ag.setColor(colValid);
                        }
                    }
                } else {
                    ag.setColor(colValid);
                }
                if (APar.get("TrackResidual", "Scale").getI() == 0) {
                    y = res[i];
                } else {
                    y = res[i] != 0.0f ? Math.log10(Math.abs(res[i])) - this.logMagnitudeMin : (double)res[i];
                    if (res[i] < 0.0f) {
                        y = -y;
                    }
                }
            }
            double tempX = !drawExtra ? window.calculateDisplay((double)((double)i), (double)y).x : window.calculateDisplay((double)((double)i + 0.25), (double)y).x;
            double tempY = window.calculateDisplay((double)((double)i), (double)y).y;
            h[0] = tempX - (double)pixelOffset;
            v[0] = tempY + (double)pixelOffset;
            h[1] = tempX - (double)pixelOffset;
            v[1] = tempY - (double)pixelOffset;
            h[2] = tempX + (double)pixelOffset;
            v[2] = tempY - (double)pixelOffset;
            h[3] = tempX + (double)pixelOffset;
            v[3] = tempY + (double)pixelOffset;
            ag.fillPolygon(h, v, h.length);
            AParameter showErrorBarPar = APar.get("TrackResidual", "ErrorBar");
            if (this.showType.equals(RESIDUAL_X) && showErrorBarPar.getStatus() && pull != null) {
                double error = 0.0;
                if (pull[i] != 0.0f && pull[i] != -99.0f && y != 0.0) {
                    error = res[i] / pull[i];
                }
                if (error != 0.0) {
                    double[][] vLine = new double[2][2];
                    vLine[0][0] = tempX;
                    vLine[0][1] = tempX;
                    vLine[1][0] = window.calculateDisplay((double)((double)i), (double)(y + error)).y;
                    vLine[1][1] = window.calculateDisplay((double)((double)i), (double)(y - error)).y;
                    ag.drawPolyline(vLine[0], vLine[1], vLine[0].length);
                    double xMinus = tempX - (double)(2 * pixelOffset);
                    double xPlus = tempX + (double)(2 * pixelOffset);
                    double yTop = vLine[1][0];
                    double yBottom = vLine[1][1];
                    ag.drawLine(xMinus, yTop, xPlus, yTop);
                    ag.drawLine(xMinus, yBottom, xPlus, yBottom);
                }
            }
            if (!(ag.getGraphics2D() instanceof APickingGraphics2D) || APar.get("Event", "PickingMode").getI() != 0) continue;
            if (i == 0 && !drawExtra) {
                this.pickedIndex = i;
                this.pickedGroup = 1;
                this.minDiff = Math.abs((double)clickedPoint.x - tempX);
                APickingGraphics2D.pickedH = tempX;
                APickingGraphics2D.pickedV = tempY;
                continue;
            }
            double diff = Math.abs((double)clickedPoint.x - tempX);
            if (!(this.minDiff > diff)) continue;
            this.pickedIndex = i;
            this.pickedGroup = drawExtra ? (byte)2 : (byte)1;
            this.minDiff = diff;
            APickingGraphics2D.pickedH = tempX;
            APickingGraphics2D.pickedV = tempY;
        }
    }

    public String getHitInfo() {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.track.getNameScreenName() + " index: " + this.trackIndex + "\n storegate key: " + (this.track.getStoreGateKey() == null ? "n/a" : this.track.getStoreGateKey());
        }
        StringBuffer msg = new StringBuffer(this.track.getNameScreenName() + " (index: ");
        msg.append(this.trackIndex);
        msg.append(")");
        msg.append("\n storegate key: ");
        msg.append(this.track.getStoreGateKey() == null ? "n/a" : this.track.getStoreGateKey());
        if (this.showType.equals(RESIDUAL_X)) {
            msg.append("\n Residual" + this.pickedGroup + "(" + "index: " + this.pickedIndex + ") = ");
            if (this.pickedGroup == 1) {
                msg.append(this.resLoc1[this.pickedIndex] == -99.0f ? "unavailable" : this.resLoc1[this.pickedIndex] + "(mm)");
            } else {
                msg.append(this.resLoc2[this.pickedIndex] == -99.0f ? "unavailable" : this.resLoc2[this.pickedIndex] + "(mm)");
            }
        } else {
            msg.append("\n Pull" + this.pickedGroup + "(" + "index: " + this.pickedIndex + ") = ");
            if (this.pickedGroup == 1) {
                msg.append(this.pullLoc1[this.pickedIndex] == -99.0f ? "unavailable" : this.pullLoc1[this.pickedIndex] + "(mm)");
            } else {
                msg.append(this.pullLoc2[this.pickedIndex] == -99.0f ? "unavailable" : this.pullLoc2[this.pickedIndex] + "(mm)");
            }
        }
        return msg.toString();
    }
}

