/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import atlantis.Atlantis;
import atlantis.data.A3DPointData;
import atlantis.event.AAssociation;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AHashMap;
import atlantis.utils.AMath;

public class ATrigS3DData
extends A3DPointData {
    private int[][] clusters = null;
    protected int[] layer = null;
    private boolean[] pixel = null;
    public static final int PIXEL = -1;

    public String getParameterGroup() {
        return "TrigS3D";
    }

    public String getName() {
        return "TrigS3D";
    }

    public String getNameScreenName() {
        return "TrigSiSpacePoint";
    }

    public String getHitInfo(int index) {
        if (Atlantis.SIMPLE_OUTPUT > 0) {
            return this.getNameScreenName() + " index: " + index + "\n" + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + "\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0";
        }
        String clId = " (" + this.clusters[index][0] + ", " + this.clusters[index][1] + ")";
        String type = this.pixel[index] ? " (Pixel)" : " (SCT)";
        String r = "";
        r = r + this.getNameScreenName() + " (id: " + this.id[index] + " index: " + index + ")" + clId + type + "\n " + "x = " + AMath.d2s(this.x[index], 3) + " cm\n " + "y = " + AMath.d2s(this.y[index], 3) + " cm\n " + "z = " + AMath.d2s(this.z[index], 3) + " cm\n " + "\u03c1" + " = " + AMath.d2s(this.rho[index], 3) + " cm\n " + "\u03a6" + " = " + AMath.d2s(Math.toDegrees(this.phi[index]), 3) + "\u00b0" + "  (" + AMath.d2s(this.phi[index], 3) + " rad)\n " + " layer = " + this.layer[index];
        r = r + super.getHitInfo(index);
        return r;
    }

    ATrigS3DData(AHashMap p, AEvent e) {
        super(p, e);
        this.layer = p.getUnknownIntArray("layer");
        if (p.get("clusters") != null) {
            this.pixel = new boolean[this.numData];
            this.clusters = new int[this.numData][];
            int[][] assocClusters = new int[this.numData][];
            int[] temp = p.getIntArray("clusters");
            for (int i = 0; i < this.numData; ++i) {
                this.clusters[i] = new int[]{temp[2 * i], temp[2 * i + 1]};
                if (temp[2 * i + 1] != -1) {
                    assocClusters[i] = new int[]{temp[2 * i], temp[2 * i + 1]};
                    continue;
                }
                this.pixel[i] = true;
                assocClusters[i] = new int[]{temp[2 * i]};
            }
            AAssociation assoc = new AAssociation(this.getName(), "SiCluster", assocClusters, this.event);
            this.event.getAssociationManager().add(assoc);
        }
    }

    protected void finalizeConstruction() {
        super.finalizeConstruction();
        super.calculateAssociationViaClusters();
    }

    protected int internalColor() {
        int numColorTypes = super.internalColor();
        int colorFunction = APar.get(this.PARAMETER_GROUP, "ColorFunction").getI();
        if (colorFunction == numColorTypes + 1) {
            this.colorBy(this.layer);
        }
        return numColorTypes + 1;
    }

    protected void applyCuts() {
        AData.printCut("TrigS3D", this.numDraw);
        this.cutIndex();
        this.cutSubdetector();
        this.cut("CutsInDet", "Layer", "Layer", this.layer);
        this.cutPhi(this.phi);
        this.cutEta(this.rho, this.z);
        this.cutSimulatedTracks();
        this.cutReconstructedTracks();
    }

    private void cutSubdetector() {
        AParameter subPar = APar.get("CutsInDet", "SCT");
        if (subPar.getI() != -1) {
            this.cutArray(this.sub, subPar.getI(), "Barrel/Endcap");
        }
    }

    public int[] getLayer(int[] layer) {
        for (int i = 0; i < this.numDraw; ++i) {
            layer[i] = this.layer[this.listdl[i]];
        }
        return layer;
    }

    public int getSub(int id) {
        if (id > -1) {
            return id >> 25 & 3;
        }
        return id >> 29 & 3;
    }

    protected ACoord getFRUser() {
        if (!APar.get("SiCluster", "Stereo").getStatus()) {
            return super.getFRUser();
        }
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.rho[list];
            v[i] = Math.toDegrees(AMath.getPhiStereo(this.rho[list], this.phi[list], this.z[list]));
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FR");
    }

    protected ACoord getFZUser() {
        if (!APar.get("SiCluster", "Stereo").getStatus()) {
            return super.getFZUser();
        }
        this.makeDrawList();
        double[] h = new double[this.numDraw];
        double[] v = new double[this.numDraw];
        int[] index = new int[this.numDraw];
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            h[i] = this.z[list];
            v[i] = Math.toDegrees(AMath.getPhiStereo(this.rho[list], this.phi[list], this.z[list]));
            index[i] = list;
        }
        return new ACoord(h, v, index, this).includePhiWrapAround("FZ");
    }
}

