/*
 * Decompiled with CFR 0.152.
 */
package atlantis.data;

import Jama.Matrix;
import atlantis.parameters.APar;
import atlantis.projection.AProjection3D;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionXZ;
import atlantis.projection.AProjectionYX;
import atlantis.projection.AProjectionYZ;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AMath;

public class AVertex {
    private static final int SIZE = 3;
    private double[] position = null;
    private double chi2 = 1.0E10;
    private Matrix covErrMatrix = null;
    private Matrix weightMatrix = null;
    private double phi;
    private double rho;

    public AVertex(double[] p) {
        this.position = new double[3];
        if (p.length != 3) {
            throw new IllegalArgumentException("p.length=" + p.length);
        }
        for (int i = 0; i < 3; ++i) {
            this.position[i] = p[i];
        }
    }

    public AVertex(double[] p, double[][] c, double chiSquared) {
        this(p, c);
        this.chi2 = chiSquared;
    }

    public AVertex(double[] p, double[][] c) {
        int i;
        this.testInputArrays(p, c);
        this.position = new double[3];
        double[][] covErr = new double[3][3];
        for (i = 0; i < 3; ++i) {
            this.position[i] = p[i];
        }
        this.phi = Math.atan2(p[1], p[0]);
        if (this.phi < 0.0) {
            this.phi += Math.PI * 2;
        }
        this.rho = Math.sqrt(p[0] * p[0] + p[1] * p[1]);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                covErr[i][j] = c[i][j];
            }
        }
        this.covErrMatrix = new Matrix(covErr);
        this.weightMatrix = this.covErrMatrix.inverse();
    }

    public AVertex(double chiSquared, double[] p, double[][] c) throws AAtlantisException {
        this.testInputArrays(p, c);
        this.chi2 = chiSquared;
        this.position = new double[3];
        for (int i = 0; i < 3; ++i) {
            this.position[i] = p[i];
        }
        this.phi = Math.atan2(p[1], p[0]);
        if (this.phi < 0.0) {
            this.phi += Math.PI * 2;
        }
        this.rho = Math.sqrt(p[0] * p[0] + p[1] * p[1]);
        double[][] covErr = new double[3][3];
        for (int x = 0; x < 3; ++x) {
            covErr[x] = (double[])c[x].clone();
        }
        try {
            this.covErrMatrix = new Matrix(covErr);
            this.weightMatrix = this.covErrMatrix.inverse();
        }
        catch (Exception ex) {
            String msg = "Error when creating covariance and/or weight\nmatrix in AVertex class.\nReason: " + ex.getMessage();
            throw new AAtlantisException(msg);
        }
    }

    private void testInputArrays(double[] p, double[][] c) throws IllegalArgumentException {
        if (p.length != 3) {
            throw new IllegalArgumentException("p.length = " + p.length);
        }
        if (c.length != 3) {
            throw new IllegalArgumentException("c.length = " + c.length);
        }
        for (int i = 0; i < 3; ++i) {
            if (c[i].length == 3) continue;
            throw new IllegalArgumentException("c[" + i + "].length = " + c[i].length);
        }
    }

    public double[] getPosition() {
        return (double[])this.position.clone();
    }

    public Matrix getCovErrMatrix() {
        return this.covErrMatrix;
    }

    public double getRho() {
        return this.rho;
    }

    public double getPhi() {
        return this.phi;
    }

    public String toString() {
        StringBuffer msg = new StringBuffer(" x = ");
        msg.append(AMath.d2s(this.position[0], 5));
        msg.append(" ");
        msg.append("\u00b1");
        msg.append(" ");
        msg.append(AMath.d2s(Math.sqrt(this.covErrMatrix.get(0, 0)), 3));
        msg.append(" cm\n y = ");
        msg.append(AMath.d2s(this.position[1], 5));
        msg.append(" ");
        msg.append("\u00b1");
        msg.append(" ");
        msg.append(AMath.d2s(Math.sqrt(this.covErrMatrix.get(1, 1)), 3));
        msg.append(" cm\n z = ");
        msg.append(AMath.d2s(this.position[2], 5));
        msg.append(" ");
        msg.append("\u00b1");
        msg.append(" ");
        msg.append(AMath.d2s(Math.sqrt(this.covErrMatrix.get(2, 2)), 3));
        msg.append(" cm\n ");
        msg.append("\u03b7");
        msg.append(" = ");
        msg.append(AMath.d2s(AMath.eta(this.position[2], this.rho), 4));
        msg.append("\n ");
        msg.append("\u03a6");
        msg.append(" = ");
        msg.append(AMath.d2s(Math.toDegrees(this.phi), 1));
        msg.append("\u00b0");
        msg.append("\n chi2 = ");
        msg.append(AMath.d2s(this.chi2, 1));
        return msg.toString();
    }

    private double[][] getEllipse(Matrix rM, int[] axisMapping) {
        Matrix parPrime = rM.times(new Matrix(this.position, this.position.length));
        double a1 = this.weightMatrix.get(axisMapping[0], axisMapping[0]);
        double a2 = this.weightMatrix.get(axisMapping[1], axisMapping[1]);
        double a3 = this.weightMatrix.get(axisMapping[2], axisMapping[2]);
        double a4 = 2.0 * this.weightMatrix.get(axisMapping[0], axisMapping[1]);
        double a5 = 2.0 * this.weightMatrix.get(axisMapping[0], axisMapping[2]);
        double a6 = 2.0 * this.weightMatrix.get(axisMapping[1], axisMapping[2]);
        double b1 = a1 - a5 * a5 / (4.0 * a3);
        double b2 = a2 - a6 * a6 / (4.0 * a3);
        double b3 = a4 - 2.0 * a5 * a6 / (4.0 * a3);
        double[][] hv = new double[2][3600];
        double sigma = APar.get("RVx", "NumSigma").getD();
        for (int i = 0; i < 3600; ++i) {
            double thetat = Math.toRadians((double)i / 10.0);
            double tt = Math.tan(thetat);
            double x = Math.sqrt(sigma * sigma / (b1 + b2 * tt * tt + b3 * tt));
            if (i > 900 && i <= 2700) {
                x *= -1.0;
            }
            hv[0][i] = x + parPrime.get(axisMapping[0], 0);
            hv[1][i] = x * tt + parPrime.get(axisMapping[1], 0);
        }
        return hv;
    }

    public double[][] getYXEllipse() {
        Matrix rM = new Matrix(AProjectionYX.getRotationMatrix());
        int[] axisMapping = AProjectionYX.getAxisMapping();
        return this.getEllipse(rM, axisMapping);
    }

    public double[][] getYZEllipse() {
        Matrix rM = new Matrix(AProjectionYZ.getRotationMatrix());
        int[] axisMapping = AProjectionYZ.getAxisMapping();
        return this.getEllipse(rM, axisMapping);
    }

    public double[][] getXZEllipse() {
        Matrix rM = new Matrix(AProjectionXZ.getRotationMatrix());
        int[] axisMapping = AProjectionXZ.getAxisMapping();
        return this.getEllipse(rM, axisMapping);
    }

    public double[][] getRZEllipse() {
        Matrix rM = new Matrix(AProjectionRZ.getRotationMatrix());
        int[] axisMapping = AProjectionRZ.getAxisMapping();
        return this.getEllipse(rM, axisMapping);
    }

    public double[][] get3DEllipse() {
        Matrix rM = new Matrix(AProjection3D.getRotationMatrix());
        int[] axisMapping = AProjection3D.getAxisMapping();
        return this.getEllipse(rM, axisMapping);
    }
}

