/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.event.AAssociation;
import atlantis.utils.ALogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class AAssociationManager {
    private static ALogger logger = ALogger.getLogger(AAssociationManager.class);
    private HashMap associations = new HashMap();

    public void clear() {
        this.associations = new HashMap();
    }

    public void add(AAssociation a) {
        this.associations.put(a.getName(), a);
    }

    public void remove(String key) {
        this.associations.remove(key);
    }

    public int[][] get(String a, String b) {
        Object o = this.associations.get(a + b);
        if (o != null) {
            return ((AAssociation)o).getData();
        }
        o = this.associations.get(b + a);
        if (o != null) {
            AAssociation ass = ((AAssociation)o).invert();
            if (ass != null) {
                this.add(ass);
                return ass.getData();
            }
            String name = "AAssociationManager.get(): ";
            logger.warn(name + "No association " + "found between " + a + " and " + b);
            return null;
        }
        return null;
    }

    public AAssociation getAssociation(String a, String b) {
        return (AAssociation)this.associations.get(a + b);
    }

    public void correct() {
        Collection c = this.associations.values();
        for (AAssociation a : c) {
            a.purgeIDNotInData();
        }
    }

    public String[] getKnownAssociations(String a) {
        Collection c = this.associations.values();
        Iterator i = c.iterator();
        TreeSet<String> list = new TreeSet<String>();
        while (i.hasNext()) {
            AAssociation ass = (AAssociation)i.next();
            if (ass.getFrom().equals(a)) {
                list.add(ass.getTo());
                continue;
            }
            if (!ass.getTo().equals(a)) continue;
            list.add(ass.getFrom());
        }
        return list.toArray(new String[list.size()]);
    }

    public String getAllKnownAssociations() {
        Collection col = this.associations.values();
        Iterator i = col.iterator();
        String r = "";
        int c = 0;
        while (i.hasNext()) {
            AAssociation ass = (AAssociation)i.next();
            r = r + ++c + " association from " + ass.getFrom() + " to " + ass.getTo() + " (name: " + ass.getName() + ")\n";
        }
        return r;
    }
}

