/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.event.AEvent;
import atlantis.event.AEventInfo;
import atlantis.event.AEventSource;
import atlantis.utils.ALogger;
import atlantis.utils.AOutput;
import java.util.Vector;

public abstract class ABufferedEventSource
implements AEventSource {
    private static final ALogger logger = ALogger.getLogger(ABufferedEventSource.class);
    private static int currentEvent = -1;
    private static int maxNumberOfEvents = 10;
    private static Vector<AEvent> eventContainer = new Vector();
    private AEventSource.NavigationMode eventNavigationMode = AEventSource.NavigationMode.SEQUENTIAL;

    protected abstract AEvent readNext(AEventInfo var1) throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException;

    protected abstract AEvent readPrevious(AEventInfo var1) throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException;

    public AEvent nextEvent() throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        if (currentEvent == eventContainer.size() - 1) {
            AEvent event;
            block4: {
                event = null;
                try {
                    event = this.readNext(this.getCurrentEventInfo());
                }
                catch (OutOfMemoryError oom) {
                    logger.error("Ran out of memory while reading event data");
                    if (this.getNumberOfEvents() <= 0) break block4;
                    logger.info("Clearing event cache and retry...");
                    this.clearEventContainer();
                    System.gc();
                    event = this.readNext(null);
                }
            }
            this.addEvent(event, false);
        } else {
            this.setCurrentEvent(currentEvent + 1);
        }
        return eventContainer.get(currentEvent);
    }

    public AEvent previousEvent() throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        if (currentEvent <= 0) {
            AEvent event;
            block4: {
                event = null;
                try {
                    event = this.readPrevious(this.getCurrentEventInfo());
                }
                catch (OutOfMemoryError oom) {
                    logger.error("Ran out of memory while reading event data");
                    if (this.getNumberOfEvents() <= 0) break block4;
                    logger.info("Clearing event cache and retry...");
                    this.clearEventContainer();
                    System.gc();
                    event = this.readPrevious(null);
                }
            }
            this.addEvent(event, true);
        } else {
            this.setCurrentEvent(currentEvent - 1);
        }
        return eventContainer.get(currentEvent);
    }

    public AEventSource.NavigationMode getNavigationMode() {
        return this.eventNavigationMode;
    }

    public void setNavigationMode(AEventSource.NavigationMode mode) throws AEventSource.InvalidEventSourceException {
        if (!this.supportsNavigationMode(mode)) {
            throw new AEventSource.InvalidEventSourceException("Mode '" + mode.name() + "' not supported by current source");
        }
        AEventSource.NavigationMode oldMode = this.getNavigationMode();
        this.eventNavigationMode = mode;
        this.clearEventContainer();
    }

    public abstract boolean supportsNavigationMode(AEventSource.NavigationMode var1);

    public int getNumberOfEvents() {
        return eventContainer != null ? eventContainer.size() : 0;
    }

    private synchronized void addEvent(AEvent event, boolean asFirst) {
        if (eventContainer == null) {
            eventContainer = new Vector();
        }
        if (eventContainer.size() == maxNumberOfEvents) {
            if (asFirst) {
                eventContainer.remove(eventContainer.lastElement());
            } else {
                eventContainer.remove(0);
            }
        }
        int index = asFirst ? 0 : eventContainer.size();
        eventContainer.add(index, event);
        logger.debug(eventContainer.size() + " event(s) in memory");
        this.setCurrentEvent(index);
    }

    protected synchronized void clearEventContainer() {
        if (eventContainer != null) {
            String msg = "Clearing event container with " + this.getNumberOfEvents() + " events.";
            logger.warn(msg);
            AOutput.append(msg, "WARNING");
            eventContainer.clear();
        }
        currentEvent = -1;
        System.gc();
    }

    private void setCurrentEvent(int index) {
        if (index < 0 || index >= eventContainer.size()) {
            throw new ArrayIndexOutOfBoundsException("Cannot set index " + index + " in event container of size " + eventContainer.size());
        }
        currentEvent = index;
    }

    private AEventInfo getCurrentEventInfo() {
        try {
            return eventContainer.get(currentEvent);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }
}

