/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.data.AClusterData;
import atlantis.data.ACompositeParticleData;
import atlantis.data.AJetData;
import atlantis.data.ATrackData;
import atlantis.event.AAssociation;
import atlantis.event.AEvent;
import atlantis.event.AObjectsAssociation;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.ADrawable;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.gui.AExceptionHandler;
import atlantis.list.AListManager;
import atlantis.list.AListProcessor;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjection3D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionXZ;
import atlantis.projection.AProjectionYX;
import atlantis.projection.AProjectionYZ;
import atlantis.utils.A4Vector;
import atlantis.utils.AHashMap;
import atlantis.utils.AIntHashtable;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Action;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AData
implements ADrawable,
AListProcessor {
    private static final ALogger logger = ALogger.getLogger(AData.class);
    protected final AEvent event;
    protected static final int NO_INVERSE = -1;
    protected int numData;
    protected int numDraw;
    protected int[] listdl;
    protected byte[] color;
    protected int[] id;
    protected AIntHashtable indexFromId;
    protected String storeGateKey = null;
    protected static final AParameter TEST_CUTS = APar.get("CutsATLAS", "Summary");
    protected final String PARAMETER_GROUP = this.getParameterGroup();
    protected AProjection2D currentProjection;

    protected abstract int internalColor();

    protected abstract void applyCuts();

    public abstract String getNameScreenName();

    public abstract String getHitInfo(int var1);

    public abstract String getParameterGroup();

    public void remove(int[] index) {
    }

    protected void finalizeConstruction() {
    }

    protected void calculateRhoPhi() {
    }

    public String getVPHitInfo() {
        return "";
    }

    public AData(AHashMap p, AEvent e) {
        this.event = e;
        this.numDraw = this.numData = p.getInt("numData");
        this.listdl = new int[this.numData];
        this.color = new byte[this.numData];
        this.storeGateKey = (String)p.get("storeGateKey");
        if ("".equals(this.storeGateKey) || this.storeGateKey == null) {
            this.storeGateKey = null;
        }
        if (p.get("id") != null) {
            this.id = p.getIntArray("id");
        } else {
            this.id = new int[this.numData];
            for (int i = 0; i < this.numData; ++i) {
                this.id[i] = i;
            }
        }
        this.indexFromId = new AIntHashtable(this.id);
    }

    AData(Node node, AEvent e) {
        int i;
        this.event = e;
        this.numData = 0;
        NodeList children = node.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            ++this.numData;
        }
        this.numDraw = this.numData;
        this.listdl = new int[this.numData];
        this.color = new byte[this.numData];
        this.id = new int[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.id[i] = i;
        }
        this.indexFromId = new AIntHashtable(this.id);
    }

    public AEvent getEvent() {
        return this.event;
    }

    public int getIndexFromId(int id) {
        return this.indexFromId.get(id);
    }

    public final A4Vector get4Vector() {
        this.makeDrawList();
        return this.get4Vector(this.numDraw, this.listdl);
    }

    public A4Vector get4Vector(int num, int[] list) {
        return null;
    }

    public A4Vector get4Vector(int num, int[] list, double mass) {
        return null;
    }

    public int getNumData() {
        return this.numData;
    }

    public int getNumDraw() {
        return this.numDraw;
    }

    public int getDrawIndex(int index) {
        return this.listdl[index];
    }

    public int[] getID() {
        return this.id;
    }

    protected int getNum(String name, int index) {
        int[][] ass = this.event.getAssociationManager().get(this.getFullName(), name);
        if (ass != null && ass[index] != null) {
            return ass[index].length;
        }
        return 0;
    }

    protected int[] getNum(String name) {
        int[][] ass = this.event.getAssociationManager().get(this.getFullName(), name);
        int[] num = new int[this.numData];
        if (ass != null) {
            for (int i = 0; i < ass.length; ++i) {
                if (ass[i] == null) continue;
                num[i] = ass[i].length;
            }
        }
        return num;
    }

    public byte[] getColor() {
        this.color();
        byte[] temp = new byte[this.id.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.color[this.getIndexFromId(this.id[i])];
        }
        return temp;
    }

    @Override
    public int[] getColor(int[] dl) {
        this.color();
        int[] temp = new int[dl.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.color[dl[i]];
        }
        return temp;
    }

    public int getColor(int index) {
        return this.color[index];
    }

    public void makeDrawList() {
        this.calculateRhoPhi();
        this.constructDefaultDrawlist();
        this.applyCuts();
    }

    public void constructDefaultDrawlist() {
        if (!APar.get("CutsATLAS", "ByList").getStatus()) {
            int[][] temp = AListManager.getInstance().getColorMapping(this);
            int[] index = temp[0];
            int[] ctemp = temp[1];
            if (index.length > 0) {
                int i;
                int[] c = new int[this.numData];
                int NONE = -999;
                for (i = 0; i < this.numData; ++i) {
                    c[i] = -999;
                }
                for (i = 0; i < index.length; ++i) {
                    c[index[i]] = ctemp[i];
                }
                this.numDraw = 0;
                for (i = 0; i < this.numData; ++i) {
                    if (c[i] != -999) continue;
                    this.listdl[this.numDraw++] = i;
                }
                for (i = 0; i < this.numData; ++i) {
                    if (c[i] == -999 || c[i] == -2) continue;
                    this.listdl[this.numDraw++] = i;
                }
            } else {
                this.numDraw = this.numData;
                for (int i = 0; i < this.numDraw; ++i) {
                    this.listdl[i] = i;
                }
            }
        } else {
            boolean[] selected = AListManager.getInstance().getSelection(this);
            this.numDraw = 0;
            for (int i = 0; i < selected.length; ++i) {
                if (!selected[i]) continue;
                this.listdl[this.numDraw++] = i;
            }
        }
    }

    protected boolean[] isDrawn() {
        boolean[] drawn = new boolean[this.numData];
        for (int i = 0; i < this.numDraw; ++i) {
            drawn[this.listdl[i]] = true;
        }
        return drawn;
    }

    public boolean isDrawn(int index) {
        boolean[] drawn = this.isDrawn();
        return drawn[index];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cut(String groupName, String parameterName, String text, float[] array) {
        AParameter par = APar.get(groupName, parameterName);
        if (!par.getStatus() || array == null) return;
        double value = par.getD();
        String operator = par.getOperator();
        int num = 0;
        if (par.isModulus()) {
            if (operator.equals("<")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (!((double)Math.abs(array[this.listdl[i]]) < value)) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else {
                if (!operator.equals(">")) throw new Error(operator + " operator not sensible for floats");
                for (int i = 0; i < this.numDraw; ++i) {
                    if (!((double)Math.abs(array[this.listdl[i]]) >= value)) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            }
        } else if (operator.equals("<")) {
            for (int i = 0; i < this.numDraw; ++i) {
                if (!((double)array[this.listdl[i]] < value)) continue;
                this.listdl[num++] = this.listdl[i];
            }
        } else {
            if (!operator.equals(">")) throw new Error(operator + " operator not sensible for floats");
            for (int i = 0; i < this.numDraw; ++i) {
                if (!((double)array[this.listdl[i]] >= value)) continue;
                this.listdl[num++] = this.listdl[i];
            }
        }
        this.numDraw = num;
        AData.printCut(text, this.numDraw);
    }

    protected void cut(String groupName, String parameterName, String text, int[] array) {
        AParameter par = APar.get(groupName, parameterName);
        if (par.getStatus() && array != null) {
            int value = par.getI();
            if (parameterName.endsWith("isEM")) {
                if (!this.isEMValidate(value)) {
                    return;
                }
                String binaryString = Integer.toBinaryString(value);
                Vector possibleValues = this.getPossibleValues(binaryString);
                this.cutIsEM(text, array, possibleValues);
            } else {
                String operator = par.getOperator();
                boolean modulus = par.isModulus();
                this.cut(text, modulus, array, operator, value);
            }
        }
    }

    protected void cut(String text, int[] array, String operator, int value) {
        this.cut(text, false, array, operator, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cut(String text, boolean modulus, int[] array, String operator, int value) {
        int num = 0;
        if (modulus) {
            if (operator.equals("<")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (Math.abs(array[this.listdl[i]]) >= value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals(">")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (Math.abs(array[this.listdl[i]]) <= value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals("=") || operator.equals("==")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (Math.abs(array[this.listdl[i]]) != value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals("!=") || operator.equals("\u2260")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (Math.abs(array[this.listdl[i]]) == value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals("<=") || operator.equals("\u2264")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (Math.abs(array[this.listdl[i]]) > value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else {
                if (!operator.equals(">=") && !operator.equals("\u2265")) throw new Error(operator + " operator not sensible for integers");
                for (int i = 0; i < this.numDraw; ++i) {
                    if (Math.abs(array[this.listdl[i]]) < value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            }
        } else if (operator.equals("<")) {
            for (int i = 0; i < this.numDraw; ++i) {
                if (array[this.listdl[i]] >= value) continue;
                this.listdl[num++] = this.listdl[i];
            }
        } else if (operator.equals(">")) {
            for (int i = 0; i < this.numDraw; ++i) {
                if (array[this.listdl[i]] <= value) continue;
                this.listdl[num++] = this.listdl[i];
            }
        } else if (operator.equals("=") || operator.equals("==")) {
            for (int i = 0; i < this.numDraw; ++i) {
                if (array[this.listdl[i]] != value) continue;
                this.listdl[num++] = this.listdl[i];
            }
        } else if (operator.equals("!=") || operator.equals("\u2260")) {
            for (int i = 0; i < this.numDraw; ++i) {
                if (array[this.listdl[i]] == value) continue;
                this.listdl[num++] = this.listdl[i];
            }
        } else if (operator.equals("<=") || operator.equals("\u2264")) {
            for (int i = 0; i < this.numDraw; ++i) {
                if (array[this.listdl[i]] > value) continue;
                this.listdl[num++] = this.listdl[i];
            }
        } else {
            if (!operator.equals(">=") && !operator.equals("\u2265")) throw new Error(operator + " operator not sensible for integers");
            for (int i = 0; i < this.numDraw; ++i) {
                if (array[this.listdl[i]] < value) continue;
                this.listdl[num++] = this.listdl[i];
            }
        }
        this.numDraw = num;
        AData.printCut(text, this.numDraw);
    }

    public void cutIndex() {
        AParameter par = APar.get("CutsATLAS", "Index");
        if (par.getStatus()) {
            int value = par.getI();
            String operator = par.getOperator();
            int num = 0;
            if (operator.equals("<")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (this.listdl[i] >= value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals(">")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (this.listdl[i] <= value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals("=") || operator.equals("==")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (this.listdl[i] != value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals("!=") || operator.equals("\u2260")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (this.listdl[i] == value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals("<=") || operator.equals("\u2264")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (this.listdl[i] > value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else if (operator.equals(">=") || operator.equals("\u2265")) {
                for (int i = 0; i < this.numDraw; ++i) {
                    if (this.listdl[i] < value) continue;
                    this.listdl[num++] = this.listdl[i];
                }
            } else {
                throw new Error(operator + " operator not sensible for integers");
            }
            this.numDraw = num;
            AData.printCut(" Index", this.numDraw);
        }
    }

    protected void cutArray(int[] value, int cutValue, String description) {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (value[this.listdl[i]] != cutValue) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut(description, this.numDraw);
    }

    protected void cutArray(byte[] value, int cutValue, String description) {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (value[this.listdl[i]] != cutValue) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut(description, this.numDraw);
    }

    protected void cutArrayEnum(Vector<Enum> value, int cutValue, String description) {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (value.get(this.listdl[i]).ordinal() > cutValue) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut(description, this.numDraw);
    }

    protected void cutArray(boolean[] value, boolean cutValue, String description) {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (value[this.listdl[i]] != cutValue) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut(description, this.numDraw);
    }

    protected void cutArrayOR(int[] value, int cutValue1, int cutValue2, String description) {
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            if (value[this.listdl[i]] != cutValue1 && value[this.listdl[i]] != cutValue2) continue;
            this.listdl[num++] = this.listdl[i];
        }
        this.numDraw = num;
        AData.printCut(description, this.numDraw);
    }

    protected void cutPhi(float[] phi, float[] dphi) {
        AParameter par = APar.get("CutsATLAS", "CutPhi");
        if (!par.getStatus()) {
            return;
        }
        double phiCut = Math.toRadians(par.getD());
        double phiMid = Math.toRadians(AMath.nearestPhiDegrees(APar.get("CutsATLAS", "PhiMiddle").getD()));
        double phiLowerCut = phiMid - phiCut;
        double phiUpperCut = phiMid + phiCut;
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double phiHit = AMath.nearestPhiRadians(phi[list], phiMid);
            double phiLower = phiHit - (double)dphi[list];
            double phiUpper = phiHit + (double)dphi[list];
            if (!(phiUpper - phiLowerCut > 1.0E-6) || !(phiUpperCut - phiLower > 1.0E-6)) continue;
            this.listdl[num++] = list;
        }
        this.numDraw = num;
        AData.printCut(" Phi", this.numDraw);
    }

    public void cutPhi(float[] phi) {
        AParameter par = APar.get("CutsATLAS", "CutPhi");
        boolean usePhiCut = par.getStatus();
        if (usePhiCut) {
            double phiCut = Math.toRadians(Math.abs(par.getD()));
            double phiMid = Math.toRadians(AMath.nearestPhiDegrees(APar.get("CutsATLAS", "PhiMiddle").getD()));
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                double phiDiff = Math.abs(AMath.nearestPhiRadians(phi[this.listdl[i]], phiMid) - phiMid);
                if (!(phiCut - phiDiff > 1.0E-6)) continue;
                this.listdl[num++] = this.listdl[i];
            }
            this.numDraw = num;
            AData.printCut(" Phi", this.numDraw);
        }
    }

    public void cutEta(float[] eta) {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        boolean useEtaCut = par.getStatus();
        if (useEtaCut) {
            double etaCut = Math.abs(par.getD());
            double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                double etaDiff = Math.abs((double)eta[this.listdl[i]] - etaMid);
                if (!(etaCut - etaDiff > 1.0E-6)) continue;
                this.listdl[num++] = this.listdl[i];
            }
            this.numDraw = num;
            AData.printCut(" Eta", this.numDraw);
        }
    }

    protected void colorByConstant() {
        if (!this.PARAMETER_GROUP.equals("CompositeParticle")) {
            int constantColor = APar.get(this.PARAMETER_GROUP, "Constant").getI();
            for (int i = 0; i < this.numData; ++i) {
                this.color[i] = (byte)constantColor;
            }
        } else {
            ACompositeParticleData compositeParticles = (ACompositeParticleData)this;
            compositeParticles.makeDrawList();
            block11: for (int e = 0; e < compositeParticles.getNumDraw(); ++e) {
                int list = compositeParticles.getDrawIndex(e);
                switch (Math.abs(compositeParticles.getPdgId(list))) {
                    case 13: {
                        this.color[list] = (byte)APar.get("Muon", "Constant").getI();
                        continue block11;
                    }
                    case 11: {
                        this.color[list] = (byte)APar.get("Electron", "Constant").getI();
                        continue block11;
                    }
                    case 22: {
                        this.color[list] = (byte)APar.get("Photon", "Constant").getI();
                        continue block11;
                    }
                    case 5: {
                        this.color[list] = (byte)APar.get("BJet", "Constant").getI();
                        continue block11;
                    }
                    case 15: {
                        this.color[list] = (byte)APar.get("TauJet", "Constant").getI();
                        continue block11;
                    }
                    case 24: {
                        this.color[list] = (byte)APar.get("CompositeParticle", "ConstantW").getI();
                        continue block11;
                    }
                    case 6: {
                        this.color[list] = (byte)APar.get("CompositeParticle", "ConstantTop").getI();
                        continue block11;
                    }
                    case 25: {
                        this.color[list] = (byte)APar.get("CompositeParticle", "ConstantH").getI();
                        continue block11;
                    }
                    default: {
                        this.color[list] = compositeParticles.getTypeEV(list).equals("EVParticleJet") ? (byte)APar.get("Jet", "Constant").getI() : (byte)APar.get("CompositeParticle", "Constant").getI();
                    }
                }
            }
        }
    }

    protected void colorByIndex(int[] index) {
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            this.color[index[i]] = (byte)col[i % numColors];
        }
    }

    protected void colorByIndex() {
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = (byte)col[i % numColors];
        }
    }

    protected void colorByCollection() {
        int constantColor = APar.get(this.PARAMETER_GROUP, "Constant").getI();
        int numColors = APar.get("HitColors", "Number").getI();
        int[] col = APar.getArray("HitColors", "C1", numColors);
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        Vector v = (Vector)ev.getCollections().get(this.getName());
        int keyIndex = 0;
        if (v != null && (keyIndex = v.indexOf(this.getStoreGateKey())) != -1) {
            keyIndex += constantColor;
            for (int i = 0; i < this.numData; ++i) {
                this.color[i] = (byte)col[keyIndex % numColors];
            }
        } else {
            logger.debug("colorByCollection(): can't colour by collection");
        }
    }

    protected void colorByAssociation(byte[] col, int[][] id, byte unconnectedColor, byte sharedColor) {
        if (id == null) {
            for (int i = 0; i < col.length; ++i) {
                col[i] = unconnectedColor;
            }
            return;
        }
        for (int i = 0; i < id.length; ++i) {
            if (id[i] != null) {
                boolean shared = false;
                for (int j = 1; j < id[i].length; ++j) {
                    if (id[i][j] == id[i][0]) continue;
                    shared = true;
                }
                if (shared) {
                    col[i] = sharedColor;
                    continue;
                }
                int ident = id[i][0];
                int inverse = this.indexFromId.get(ident);
                if (inverse != -1) {
                    col[i] = this.color[inverse];
                    continue;
                }
                col[i] = unconnectedColor;
                continue;
            }
            col[i] = unconnectedColor;
        }
    }

    protected void colorByAssociation(byte[] col, int[][] id, byte unconnectedColor, byte sharedColor, boolean[] passedCuts) {
        if (id == null) {
            for (int i = 0; i < col.length; ++i) {
                col[i] = unconnectedColor;
            }
            return;
        }
        for (int i = 0; i < id.length; ++i) {
            if (id[i] != null) {
                boolean shared = false;
                for (int j = 1; j < id[i].length; ++j) {
                    if (id[i][j] == id[i][0]) continue;
                    shared = true;
                }
                if (shared) {
                    int counter = 0;
                    int passedPosition = -1;
                    for (int j = 0; j < id[i].length; ++j) {
                        if (!passedCuts[id[i][j]]) continue;
                        ++counter;
                        passedPosition = id[i][j];
                    }
                    if (counter > 1) {
                        col[i] = sharedColor;
                        continue;
                    }
                    if (counter == 1) {
                        int inverse = this.indexFromId.get(passedPosition);
                        if (inverse != -1) {
                            col[i] = this.color[inverse];
                            continue;
                        }
                        col[i] = unconnectedColor;
                        continue;
                    }
                    col[i] = unconnectedColor;
                    continue;
                }
                int ident = id[i][0];
                int inverse = this.indexFromId.get(ident);
                if (inverse != -1 && passedCuts[id[i][0]]) {
                    col[i] = this.color[inverse];
                    continue;
                }
                col[i] = unconnectedColor;
                continue;
            }
            col[i] = unconnectedColor;
        }
    }

    protected void setColor(int index, byte color) {
        if (index >= 0 && index < this.color.length) {
            this.color[index] = color;
        } else {
            logger.debug(this.getClass().getName() + ":  Set color for data with index = " + index);
        }
    }

    protected void setColor(byte color) {
        for (int i = 0; i < this.color.length; ++i) {
            this.color[i] = color;
        }
    }

    protected void colorBy(int[] coloringVariable) {
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = (byte)col[coloringVariable[i] % numColors];
        }
    }

    protected void colorBy(String colorGroup, int[] coloringVariable) {
        int numColors = APar.get(colorGroup, "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray(colorGroup, "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            this.color[i] = (byte)col[coloringVariable[i] % numColors];
        }
    }

    protected void colorBy(float[] Pt) {
        int numColors = APar.get("HitColors", "Number").getI();
        numColors = Math.min(7, numColors);
        int[] col = APar.getArray("HitColors", "C1", numColors);
        for (int i = 0; i < this.numData; ++i) {
            int icol = 0;
            icol = Math.abs(Pt[i]) < 2.0f ? 4 : (Math.abs(Pt[i]) < 4.0f ? 2 : (Math.abs(Pt[i]) < 10.0f ? 5 : (Math.abs(Pt[i]) < 40.0f ? 3 : 0)));
            this.color[i] = (byte)col[icol];
        }
    }

    public String getName() {
        return this.getParameterGroup();
    }

    public String getStoreGateKey() {
        return this.storeGateKey;
    }

    protected void calculateXY(float[] rho, float[] phi, float[] x, float[] y) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = (float)((double)rho[i] * Math.cos(phi[i]));
            y[i] = (float)((double)rho[i] * Math.sin(phi[i]));
        }
    }

    protected void calculateRhoPhi(float[] x, float[] y, float[] rho, float[] phi) {
        for (int i = 0; i < rho.length; ++i) {
            double dx = x[i];
            double dy = y[i];
            rho[i] = (float)Math.sqrt(dx * dx + dy * dy);
            phi[i] = (float)Math.atan2(dy, dx);
            if (!((double)phi[i] < 0.0)) continue;
            int n = i;
            phi[n] = (float)((double)phi[n] + Math.PI * 2);
        }
    }

    @Override
    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        ag.draw(window.calculateDisplay(this.getUser(projection)));
    }

    protected ACoord getUserNoTransform(AProjection projection) {
        ACoord data = ACoord.NO_DATA;
        if (projection instanceof AProjectionYX) {
            data = this.getYXUser();
        } else if (projection instanceof AProjectionFR) {
            data = this.getFRUser();
        } else if (projection instanceof AProjectionRZ) {
            data = this.getRZUser();
        } else if (projection instanceof AProjectionXZ) {
            data = this.getXZUser();
        } else if (projection instanceof AProjectionYZ) {
            data = this.getYZUser();
        } else if (projection instanceof AProjectionFZ) {
            data = this.getFZUser();
        } else if (projection instanceof AProjectionVP) {
            data = this.getVPUser();
        } else if (projection instanceof AProjection3D) {
            data = this.get3DUser();
        }
        return data;
    }

    protected ACoord getUser(AProjection2D projection) {
        this.currentProjection = projection;
        return projection.nonLinearTransform(this.getUserNoTransform(projection));
    }

    protected int getDrawOrFill() {
        return 0;
    }

    public String navigate(int index) {
        String temp = "";
        String assocKey = this.getName() + (this.getStoreGateKey() != null ? this.getStoreGateKey() : "");
        String[] knownAssoc = this.event.getAssociationManager().getKnownAssociations(assocKey);
        temp = " associated to:\n";
        for (int i = 0; i < knownAssoc.length; ++i) {
            int[][] ass;
            AData source = Atlantis.getEventManager().getCurrentEvent().get(knownAssoc[i]);
            if (source == null || (ass = this.event.getAssociationManager().get(assocKey, knownAssoc[i])) == null || ass[index] == null) continue;
            for (int x = 0; x < ass[index].length; ++x) {
                temp = temp + "   " + knownAssoc[i] + " id: " + ass[index][x] + " index: " + source.getIndexFromId(ass[index][x]) + "\n";
            }
        }
        return temp;
    }

    private boolean isEMValidate(int inputValue) {
        if (inputValue > 65535) {
            String displayMessage = "isEM is a 16-bit binary data, maximum is 65535";
            AExceptionHandler.processException("warning", displayMessage.toString());
            return false;
        }
        return true;
    }

    private Vector getPossibleValues(String bStr) {
        Vector<String> possibleValues = new Vector<String>();
        if (bStr.length() == 1) {
            possibleValues.add("0");
            if (bStr.charAt(0) == '1') {
                possibleValues.add("1");
            }
        } else {
            Vector possibleValuesWithoutFirstChar = this.getPossibleValues(bStr.substring(1));
            for (int i = 0; i < possibleValuesWithoutFirstChar.size(); ++i) {
                String str = (String)possibleValuesWithoutFirstChar.get(i);
                possibleValues.add("0" + str);
                if (bStr.charAt(0) != '1') continue;
                possibleValues.add("1" + str);
            }
        }
        return possibleValues;
    }

    private void cutIsEM(String text, int[] array, Vector possibleValues) {
        int num = 0;
        block0: for (int i = 0; i < this.numDraw; ++i) {
            for (int j = 0; j < possibleValues.size(); ++j) {
                String str = (String)possibleValues.get(j);
                int value = Integer.parseInt(str, 2);
                if (array[this.listdl[i]] != value) continue;
                this.listdl[num++] = this.listdl[i];
                continue block0;
            }
        }
        this.numDraw = num;
        AData.printCut(text, this.numDraw);
    }

    protected String getReconstructedTracks() {
        ATrackData tracks = Atlantis.getEventManager().getCurrentEvent().getTrackData("InDetTrack");
        String r = null;
        if (tracks != null) {
            r = tracks.getName() + tracks.getStoreGateKey();
        }
        return r;
    }

    protected String getJets() {
        AJetData jets = Atlantis.getEventManager().getCurrentEvent().getJetData();
        String r = null;
        if (jets != null) {
            r = ((AData)jets).getName() + jets.getStoreGateKey();
        }
        return r;
    }

    protected AData getObjectCollection(String type) {
        return Atlantis.getEventManager().getCurrentEvent().getData(type);
    }

    protected String getClusters() {
        AClusterData clusters = Atlantis.getEventManager().getCurrentEvent().getClusterData();
        String r = null;
        if (clusters != null) {
            r = ((AData)clusters).getName() + clusters.getStoreGateKey();
        }
        return r;
    }

    public int[] getDrawList() {
        return this.listdl;
    }

    protected void cutEta(float[] rho, float[] z) {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        boolean useEtaCut = par.getStatus();
        if (useEtaCut) {
            double etaCut = Math.abs(par.getD());
            double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
            double etaLower = etaMid - etaCut;
            double etaUpper = etaMid + etaCut;
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                int list = this.listdl[i];
                double eta = AMath.eta(z[list], rho[list]);
                if (!(eta - etaLower > 1.0E-6) || !(etaUpper - eta > 1.0E-6)) continue;
                this.listdl[num++] = list;
            }
            this.numDraw = num;
            AData.printCut(" Eta", this.numDraw);
        }
    }

    protected void cutEtaDRho(float[] rho, float[] z, float[] drho) {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        boolean useEtaCut = par.getStatus();
        if (useEtaCut) {
            double etaCut = Math.abs(par.getD());
            double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
            double etaLowerCut = etaMid - etaCut;
            double etaUpperCut = etaMid + etaCut;
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                int list = this.listdl[i];
                double eta1 = AMath.eta(z[list], rho[list] + drho[list]);
                double eta2 = AMath.eta(z[list], rho[list] - drho[list]);
                double etaLower = Math.min(eta1, eta2);
                double etaUpper = Math.max(eta1, eta2);
                if (!(etaUpper - etaLowerCut > 1.0E-6) || !(etaUpperCut - etaLower > 1.0E-6)) continue;
                this.listdl[num++] = list;
            }
            this.numDraw = num;
            AData.printCut(" Eta", this.numDraw);
        }
    }

    protected void cutEtaDZ(float[] rho, float[] z, float[] dz) {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        boolean useEtaCut = par.getStatus();
        if (useEtaCut) {
            double etaCut = Math.abs(par.getD());
            double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
            double etaLowerCut = etaMid - etaCut;
            double etaUpperCut = etaMid + etaCut;
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                int list = this.listdl[i];
                double etaLower = AMath.eta(z[list] - dz[list], rho[list]);
                double etaUpper = AMath.eta(z[list] + dz[list], rho[list]);
                if (!(etaUpper - etaLowerCut > 1.0E-6) || !(etaUpperCut - etaLower > 1.0E-6)) continue;
                this.listdl[num++] = list;
            }
            this.numDraw = num;
            AData.printCut(" Eta", this.numDraw);
        }
    }

    protected void cutEtaDEta(float[] eta, float[] deta) {
        AParameter par = APar.get("CutsATLAS", "CutEta");
        if (!par.getStatus()) {
            return;
        }
        double etaCut = Math.abs(par.getD());
        double etaMid = APar.get("CutsATLAS", "EtaMiddle").getD();
        double etaLowerCut = etaMid - etaCut;
        double etaUpperCut = etaMid + etaCut;
        int num = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int list = this.listdl[i];
            double etaLower = eta[list] - deta[list];
            double etaUpper = eta[list] + deta[list];
            if (!(etaUpper - etaLowerCut > 1.0E-6) || !(etaUpperCut - etaLower > 1.0E-6)) continue;
            this.listdl[num++] = list;
        }
        this.numDraw = num;
        AData.printCut(" Eta", this.numDraw);
    }

    protected void cutByAssociationTo(String sourceDatatype, String beingCutDatatype, int cutOption) {
        if (cutOption == 0) {
            return;
        }
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        AData source = ev.get(sourceDatatype);
        int[][] assoc = this.event.getAssociationManager().get(beingCutDatatype, sourceDatatype);
        if (assoc == null || source == null) {
            AData being = ev.get(beingCutDatatype);
            String screenName = being != null ? being.getNameScreenName() : "null";
            logger.warn(screenName + " - null (" + beingCutDatatype + " - " + sourceDatatype + ") association, nothing to draw");
            this.numDraw = 0;
            return;
        }
        if (cutOption == 1) {
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                if (assoc[this.listdl[i]] == null) continue;
                this.listdl[num++] = this.listdl[i];
            }
            this.numDraw = num;
            this.numDraw = source.cutByAssociation(this.numDraw, this.listdl, assoc);
        } else if (cutOption == 2) {
            int num = 0;
            for (int i = 0; i < this.numDraw; ++i) {
                if (assoc[this.listdl[i]] != null) continue;
                this.listdl[num++] = this.listdl[i];
            }
            this.numDraw = num;
        }
    }

    private int cutByAssociation(int numDraw, int[] listdl, int[][] id) {
        this.makeDrawList();
        boolean[] drawn = this.isDrawn();
        int num = 0;
        for (int i = 0; i < numDraw; ++i) {
            int inverse;
            int j;
            int list = listdl[i];
            if (id[list] == null || (j = 0) >= id[list].length || (inverse = this.indexFromId.get(id[list][j])) == -1 || !drawn[inverse]) continue;
            listdl[num++] = list;
        }
        numDraw = num;
        return numDraw;
    }

    public static void printCut(String text, int numPassing) {
        if (TEST_CUTS.getStatus()) {
            if (text.length() > 0 && text.charAt(0) != ' ') {
                logger.info("");
            }
            while (text.length() < 10) {
                text = text + " ";
            }
            logger.info(text + " = " + numPassing);
        }
    }

    @Override
    public ADrawParameters getDrawParameters(int layer, int type) {
        boolean draw = true;
        int singleColor = -1;
        int size = 10;
        int lineWidth = 1;
        int symbol = 0;
        int frameWidth = 0;
        boolean forceSymbols = false;
        int minSize = 0;
        AParameter forceSymbolsPar = APar.getUnknown(this.PARAMETER_GROUP, "ForceSymbols");
        AParameter symbolSize = APar.getUnknown(this.PARAMETER_GROUP, "SymbolSize");
        AParameter symbolType = APar.getUnknown(this.PARAMETER_GROUP, "Symbol");
        AParameter lineWidthPar = APar.getUnknown(this.PARAMETER_GROUP, "LineWidth");
        if (forceSymbolsPar != null && (forceSymbols = forceSymbolsPar.getStatus()) && symbolSize != null) {
            minSize = Math.max(symbolSize.getI(), 1);
        }
        if (symbolSize != null) {
            size = symbolSize.getI();
        }
        if (symbolType != null) {
            symbol = symbolType.getI();
        }
        if (lineWidthPar != null) {
            lineWidth = lineWidthPar.getI();
        }
        if (lineWidth <= 0) {
            lineWidth = 1;
        }
        if (type == 0) {
            AParameter noiseSymbolType = APar.getUnknown(this.PARAMETER_GROUP, "Noise");
            if (noiseSymbolType != null && noiseSymbolType.getStatus()) {
                AParameter noiseSymbolSize = APar.getUnknown(this.PARAMETER_GROUP, "NoiseSize");
                AParameter noiseWidth = APar.getUnknown(this.PARAMETER_GROUP, "NoiseWidth");
                if (noiseSymbolSize != null) {
                    size = noiseSymbolSize.getI();
                }
                if (noiseWidth != null) {
                    lineWidth = noiseWidth.getI();
                }
                symbol = noiseSymbolType.getI();
            } else {
                AParameter noiseWidth = APar.getUnknown(this.PARAMETER_GROUP, "NoiseWidth");
                if (noiseWidth != null && noiseWidth.getStatus()) {
                    lineWidth = noiseWidth.getI();
                }
            }
        }
        if (layer == 0) {
            AParameter frameWidthPar = APar.getUnknown(this.PARAMETER_GROUP, "FrameWidth");
            if (APar.get(this.PARAMETER_GROUP, "Frame") != null) {
                boolean drawFrame = APar.get(this.PARAMETER_GROUP, "Frame").getStatus();
                singleColor = APar.get(this.PARAMETER_GROUP, "Frame").getI();
                if (drawFrame && AColorMap.drawFrames() && frameWidthPar != null) {
                    frameWidth = frameWidthPar.getI();
                }
            }
        }
        return new ADrawParameters(draw, singleColor, size, lineWidth, frameWidth, symbol, forceSymbols, minSize, this.getDrawOrFill());
    }

    protected int[] indexBy(double[] a) {
        int i;
        int[] index = new int[a.length];
        for (i = 0; i < a.length; ++i) {
            index[i] = i;
        }
        if (a.length > 1000) {
            return index;
        }
        for (i = 0; i < a.length - 1; ++i) {
            for (int j = i + 1; j < a.length; ++j) {
                if (!(a[index[i]] > a[index[j]])) continue;
                int temp = index[i];
                index[i] = index[j];
                index[j] = temp;
            }
        }
        return index;
    }

    protected void colorBy(String association) {
        AData source = Atlantis.getEventManager().getCurrentEvent().get(association);
        byte unconnected = (byte)APar.get(this.PARAMETER_GROUP, "Unconnected").getI();
        if (source != null) {
            byte shared = (byte)APar.get(this.PARAMETER_GROUP, "Shared").getI();
            String assocKey = this.getName();
            assocKey = assocKey + (this.getStoreGateKey() != null ? this.getStoreGateKey() : "");
            int[][] assoc = this.event.getAssociationManager().get(assocKey, association);
            source.color();
            boolean[] drawn = source.isDrawn();
            source.colorByAssociation(this.color, assoc, unconnected, shared, drawn);
        } else {
            for (int i = 0; i < this.numData; ++i) {
                this.color[i] = unconnected;
            }
        }
    }

    protected void colorByObjects() {
        byte unconnectedColor = (byte)APar.get(this.PARAMETER_GROUP, "Unconnected").getI();
        this.setColor(unconnectedColor);
        String[] objectList = new String[]{"Jet", "BJet", "TauJet", "Photon", "Electron", "Muon"};
        for (int i = 0; i < objectList.length; ++i) {
            if (!APar.get("Data", objectList[i]).getStatus()) continue;
            this.colorByObject(this.getObjectCollection(objectList[i]));
        }
    }

    private void colorByObject(AData objectData) {
        if (objectData == null) {
            return;
        }
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get(this.getName(), this.getName() + "Collections");
        String selectedCollection = listBox.getCurrentText();
        if (!"All".equals(selectedCollection) && !"None".equals(selectedCollection)) {
            AAssociation assoc;
            String assName = this.getName();
            if (this.getName().indexOf("Track") >= 0) {
                assName = "Track";
            }
            if ((assoc = this.event.getAssociationManager().getAssociation(objectData.getName() + objectData.getStoreGateKey(), assName)) != null) {
                if (!(assoc instanceof AObjectsAssociation)) {
                    logger.warn(this.getClass().getName() + ":  no objects association is found!");
                    return;
                }
                int[][] associatedIndex = ((AObjectsAssociation)assoc).getData();
                String[] associatedKey = ((AObjectsAssociation)assoc).getKey();
                int objectIndex = 0;
                int i = 0;
                while (i < associatedKey.length) {
                    if ("none".equals(associatedKey[i])) {
                        ++i;
                        ++objectIndex;
                        continue;
                    }
                    if (associatedKey[i].equals(selectedCollection)) {
                        for (int j = 0; j < associatedIndex[objectIndex].length; ++j) {
                            this.setColor(associatedIndex[objectIndex][j], objectData.getColor()[objectIndex]);
                        }
                    }
                    i += associatedIndex[objectIndex++].length;
                }
            }
        }
    }

    public String getFullName() {
        String k = this.getStoreGateKey();
        String full = this.getName() + (k != null ? k : "");
        return full;
    }

    public int getIdFromIndex(int index) {
        return this.id[index];
    }

    protected final void color() {
        this.internalColor();
        int[][] temp = AListManager.getInstance().getColorMapping(this);
        int[] index = temp[0];
        int[] c = temp[1];
        for (int i = 0; i < index.length; ++i) {
            if (c[i] < 0) continue;
            this.color[index[i]] = (byte)c[i];
        }
        int others = AListManager.getInstance().getColorOfOthers();
        if (others >= 0 && APar.get("Data", this.getName()).getStatus()) {
            int i;
            boolean[] inList = new boolean[this.numData];
            for (i = 0; i < index.length; ++i) {
                inList[index[i]] = true;
            }
            for (i = 0; i < this.numData; ++i) {
                if (inList[i]) continue;
                this.color[i] = (byte)others;
            }
        }
    }

    @Override
    public int[] getType(int[] dl) {
        return new int[dl.length];
    }

    protected ACoord getYXUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getRZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getYZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getXZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord get3DUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getUserUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getUserUser2() {
        return ACoord.NO_DATA;
    }

    protected ACoord getFRUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getFZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getVPUser() {
        return ACoord.NO_DATA;
    }

    @Override
    public int getNumTypes() {
        return 1;
    }

    @Override
    public Action[] getActions(Collection nodes) {
        return new Action[0];
    }

    public String[] splitItems(String origItems) {
        char[] origItemsChar = origItems.toCharArray();
        int origItemsLength = origItems.length();
        int spacePosition = 0;
        int noOfItems = 0;
        int count = 0;
        for (int i = 0; i < origItemsLength; ++i) {
            if ((i == 0 || origItemsChar[i] != '-') && (i != origItemsLength - 1 || origItemsChar[i] == '-')) continue;
            ++noOfItems;
        }
        if (noOfItems > 0) {
            String[] newItems = new String[noOfItems];
            for (int i = 0; i < origItemsLength; ++i) {
                if (i == 0 && origItemsChar[i] == '-') {
                    spacePosition = i + 1;
                    continue;
                }
                if (i == origItemsLength - 1 && origItemsChar[i] != '-') {
                    newItems[count] = origItems.substring(spacePosition, i + 1);
                    spacePosition = i + 1;
                    ++count;
                    continue;
                }
                if (origItemsChar[i] != '-' || i == 0) continue;
                newItems[count] = origItems.substring(spacePosition, i);
                spacePosition = i + 1;
                ++count;
            }
            return newItems;
        }
        return null;
    }
}

