/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.Atlantis;
import atlantis.data.ACSCDData;
import atlantis.data.ACalorimeterData;
import atlantis.data.AClusterData;
import atlantis.data.AFCALData;
import atlantis.data.AHECData;
import atlantis.data.AJetData;
import atlantis.data.ALArData;
import atlantis.data.ALVL1JetElementData;
import atlantis.data.ALVL1ResultData;
import atlantis.data.ALVL1TriggerTowerData;
import atlantis.data.AMBTSData;
import atlantis.data.AMDTData;
import atlantis.data.APixelClusterData;
import atlantis.data.ARPCData;
import atlantis.data.ARVxData;
import atlantis.data.AS3DData;
import atlantis.data.ASMTrData;
import atlantis.data.ASNPData;
import atlantis.data.ASTrData;
import atlantis.data.ASVxData;
import atlantis.data.ASiClusterData;
import atlantis.data.ATGCData;
import atlantis.data.ATILEData;
import atlantis.data.ATRTData;
import atlantis.data.ATrackData;
import atlantis.data.ATrigS3DData;
import atlantis.data.ATriggerInfoData;
import atlantis.event.AAssociationManager;
import atlantis.event.AData;
import atlantis.event.AEventInfo;
import atlantis.list.AListManager;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionLegoPlot;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class AEvent
extends AEventInfo {
    private static ALogger logger = ALogger.getLogger(AEvent.class);
    private Map data = new HashMap();
    private Hashtable collections = new Hashtable();
    private AAssociationManager assocmgr = new AAssociationManager();

    public AEvent(String eventNumber, String runNumber, String dateTime, String sourceName, String lumiBlock, String eventProperties) {
        super(Integer.parseInt(eventNumber), Integer.parseInt(runNumber), dateTime, sourceName, lumiBlock, eventProperties);
    }

    public Hashtable getCollections() {
        return this.collections;
    }

    public void add(AData dataSet) throws AAtlantisException {
        String name = dataSet.getClass().getName();
        int index = name.lastIndexOf(46);
        if (index >= 0 && index < name.length() - 1) {
            name = name.substring(index + 1);
        }
        name = name.substring(1, name.length() - 4);
        String newKey = dataSet.getStoreGateKey();
        if (newKey == null) {
            this.data.put(name, dataSet);
        } else {
            if (this.data.containsKey(name + newKey)) {
                String msg = "Error - datatype " + name + " with storeGateKey\n" + newKey + " already exists in this event.";
                AAtlantisException aaex = new AAtlantisException(msg);
                logger.error("\n" + msg, aaex);
                throw aaex;
            }
            this.data.put(name + newKey, dataSet);
            Vector keys = new Vector();
            if (this.collections.containsKey(name)) {
                keys = (Vector)this.collections.get(name);
                if (keys.contains(newKey)) {
                    String msg = "Previously read datatype " + name + "\n" + "(different collection) contained " + "storeGateKey " + newKey + ". Error.";
                    AAtlantisException aaex = new AAtlantisException(msg);
                    logger.error(msg, aaex);
                    throw aaex;
                }
                keys.add(newKey);
                this.collections.put(name, keys);
            } else {
                keys.add(newKey);
                this.collections.put(name, keys);
            }
        }
    }

    public AData get(String name) {
        return (AData)this.data.get(name);
    }

    public AData[] getData() {
        AData[] aData = new AData[this.data.size()];
        Collection collection = this.data.values();
        return collection.toArray(aData);
    }

    public AJetData getJetData() {
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get("Jet", "JetCollections");
        String selectedKey = listBox.getCurrentText();
        if ("All".equals(selectedKey) || "None".equals(selectedKey)) {
            logger.debug("AEvent.getJetData(): " + selectedKey + " is selected in Jet->JetCollection, no association " + " to Jet is taken into account, null is returned");
            return null;
        }
        AJetData jet = (AJetData)this.data.get("Jet" + selectedKey);
        return jet;
    }

    public AData getData(String type) {
        String selectedKey;
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get(type, type + "Collections");
        String string = selectedKey = listBox == null ? "" : listBox.getCurrentText();
        if ("All".equals(selectedKey) || "None".equals(selectedKey)) {
            logger.debug("AEvent.getData(String type): " + selectedKey + " is selected in " + type + "->" + type + " Collections, " + "no association to " + type + " is taken into account.");
            return null;
        }
        return (AData)this.data.get(type + selectedKey);
    }

    public AClusterData getClusterData() {
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get("Cluster", "ClusterCollections");
        String selectedKey = listBox.getCurrentText();
        if ("All".equals(selectedKey) || "None".equals(selectedKey)) {
            logger.debug("AEvent.getClusterData(): " + selectedKey + " is selected in Cluster->ClusterCollection, no association " + " to Cluster is taken into account, null is returned");
            return null;
        }
        AClusterData cluster = (AClusterData)this.data.get("Cluster" + selectedKey);
        return cluster;
    }

    public ATrackData getTrackData(String type) {
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get(type, type + "Collections");
        String selectedKey = listBox.getCurrentText();
        if ("All".equals(selectedKey) || "None".equals(selectedKey)) {
            logger.debug("AEvent.getTrackData(" + type + "): " + selectedKey + " is selected in Track->TrackCollection, no association " + " to Track is taken into account, null is returned");
            return null;
        }
        ATrackData track = (ATrackData)this.data.get(type + selectedKey);
        return track;
    }

    public ATrackData getTrackData(String type, String key) {
        Vector keys = (Vector)this.collections.get(type);
        if (keys == null) {
            logger.warn("AEvent: " + type + " datatype doesn't exist " + "in current event");
            return null;
        }
        if (keys.contains(key)) {
            return (ATrackData)this.data.get(type + key);
        }
        logger.warn("AEvent: " + type + " datatype: storeGateKey " + key + " doesn't exist in current event");
        return null;
    }

    public ASTrData getSTrData() {
        return (ASTrData)this.data.get("STr");
    }

    public ASMTrData getSMTrData() {
        return (ASMTrData)this.data.get("SMTr");
    }

    public ASNPData getSNPData() {
        return (ASNPData)this.data.get("SNP");
    }

    public APixelClusterData getPixelClusterData() {
        return (APixelClusterData)this.data.get("PixelCluster");
    }

    public ASiClusterData getSiClusterData() {
        return (ASiClusterData)this.data.get("SiCluster");
    }

    public AS3DData getS3DData() {
        return (AS3DData)this.data.get("S3D");
    }

    public ATRTData getTRTData() {
        return (ATRTData)this.data.get("TRT");
    }

    public ALArData getLArData() {
        return (ALArData)this.data.get("LAr");
    }

    public ATILEData getTILEData() {
        return (ATILEData)this.data.get("TILE");
    }

    public AHECData getHECData() {
        return (AHECData)this.data.get("HEC");
    }

    public AFCALData getFCALData() {
        return (AFCALData)this.data.get("FCAL");
    }

    public AMBTSData getMBTSData() {
        return (AMBTSData)this.data.get("MBTS");
    }

    public AMDTData getMDTData() {
        Vector<String> storeGateKeys = new Vector<String>();
        Set keys = this.data.keySet();
        for (Object entry : keys) {
            if (!entry.toString().startsWith("MDT")) continue;
            storeGateKeys.add(entry.toString());
        }
        if (storeGateKeys.size() == 1) {
            return (AMDTData)this.data.get(storeGateKeys.get(0));
        }
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get("MDT", "MDTCollections");
        String selectedKey = listBox.getCurrentText();
        if ("All".equals(selectedKey) || "None".equals(selectedKey)) {
            logger.debug("AEvent.getMDTata(): " + selectedKey + " is selected in MDT->RPCCollection, no association " + " to RPC is taken into account, null is returned");
            return null;
        }
        AMDTData mdt = (AMDTData)this.data.get("MDT" + selectedKey);
        return mdt;
    }

    public ARPCData getRPCData() {
        Vector<String> storeGateKeys = new Vector<String>();
        Set keys = this.data.keySet();
        for (Object entry : keys) {
            if (!entry.toString().startsWith("RPC")) continue;
            storeGateKeys.add(entry.toString());
        }
        if (storeGateKeys.size() == 1) {
            return (ARPCData)this.data.get(storeGateKeys.get(0));
        }
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get("RPC", "RPCCollections");
        String selectedKey = listBox.getCurrentText();
        if ("All".equals(selectedKey) || "None".equals(selectedKey)) {
            logger.debug("AEvent.getRPCData(): " + selectedKey + " is selected in RPC->RPCCollection, no association " + " to RPC is taken into account, null is returned");
            return null;
        }
        ARPCData rpc = (ARPCData)this.data.get("RPC" + selectedKey);
        return rpc;
    }

    public ATGCData getTGCData() {
        Vector<String> storeGateKeys = new Vector<String>();
        Set keys = this.data.keySet();
        for (Object entry : keys) {
            if (!entry.toString().startsWith("TGC")) continue;
            storeGateKeys.add(entry.toString());
        }
        if (storeGateKeys.size() == 1) {
            return (ATGCData)this.data.get(storeGateKeys.get(0));
        }
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get("TGC", "RPCCollections");
        String selectedKey = listBox.getCurrentText();
        if ("All".equals(selectedKey) || "None".equals(selectedKey)) {
            logger.debug("AEvent.getRPCData(): " + selectedKey + " is selected in TGC->TGCCollection, no association " + " to TGC is taken into account, null is returned");
            return null;
        }
        ATGCData tgc = (ATGCData)this.data.get("TGC" + selectedKey);
        return tgc;
    }

    public ACSCDData getCSCDData() {
        Vector<String> storeGateKeys = new Vector<String>();
        Set keys = this.data.keySet();
        for (Object entry : keys) {
            if (!entry.toString().startsWith("CSC")) continue;
            storeGateKeys.add(entry.toString());
        }
        if (storeGateKeys.size() == 1) {
            return (ACSCDData)this.data.get(storeGateKeys.get(0));
        }
        AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get("CSC", "CSCCollections");
        String selectedKey = listBox.getCurrentText();
        if ("All".equals(selectedKey) || "None".equals(selectedKey)) {
            logger.debug("AEvent.getCSCData(): " + selectedKey + " is selected in CSC->CSCCollection, no association " + " to TGC is taken into account, null is returned");
            return null;
        }
        ACSCDData csc = (ACSCDData)this.data.get("CSC" + selectedKey);
        return csc;
    }

    public ASVxData getSVxData() {
        return (ASVxData)this.data.get("SVx");
    }

    public ARVxData getRVxData() {
        return (ARVxData)this.data.get("RVx");
    }

    public ATrigS3DData getTrigS3DData() {
        return (ATrigS3DData)this.data.get("TrigS3D");
    }

    public ALVL1TriggerTowerData getLvl1TriggerTowerData() {
        return (ALVL1TriggerTowerData)this.data.get("LVL1TriggerTower");
    }

    public ALVL1ResultData getLvl1ResultData() {
        return (ALVL1ResultData)this.data.get("LVL1Result");
    }

    public ALVL1JetElementData getLvl1JetElementData() {
        return (ALVL1JetElementData)this.data.get("LVL1JetElement");
    }

    public ATriggerInfoData getTriggerInfoData() {
        return (ATriggerInfoData)this.data.get("TriggerInfo");
    }

    public String[] getActiveCollectionNames(String collectionType) {
        boolean collectionStatus = collectionType.equals("LVL1Result");
        if (!collectionStatus) {
            collectionStatus = APar.get("Data", collectionType).getStatus();
        }
        if (collectionStatus) {
            return this.getCollectionNames(collectionType);
        }
        return new String[0];
    }

    public String[] getCollectionNames(String collectionType) {
        Vector keys = (Vector)this.getCollections().get(collectionType);
        if (keys != null) {
            int i;
            String[] collec = keys.toArray(new String[keys.size()]);
            AEnumeratorParameter listBox = (AEnumeratorParameter)APar.get(collectionType, collectionType + "Collections");
            String currentSelection = listBox.getCurrentText();
            int count = 0;
            for (i = 0; i < collec.length; ++i) {
                if (!"All".equals(currentSelection) && !collec[i].equals(currentSelection)) continue;
                ++count;
            }
            String[] col = new String[count];
            count = 0;
            for (i = 0; i < collec.length; ++i) {
                if (!"All".equals(currentSelection) && !collec[i].equals(currentSelection)) continue;
                col[count] = collectionType + collec[i];
                ++count;
            }
            return col;
        }
        return new String[0];
    }

    public List getCalorimeters() {
        ArrayList<ACalorimeterData> v = new ArrayList<ACalorimeterData>();
        for (Object o : this.data.values()) {
            ACalorimeterData calorimeter;
            if (!(o instanceof ACalorimeterData) || !APar.get("Data", (calorimeter = (ACalorimeterData)o).getCalorimeterName()).getStatus() || APar.getUnknown("Det", calorimeter.getCalorimeterName() + "Fill") != null && !APar.get("Det", calorimeter.getCalorimeterName() + "Fill").getStatus()) continue;
            v.add(calorimeter);
        }
        return v;
    }

    public List getHitsAndTracks(AProjection projection) {
        int mode = APar.get(projection.getName(), "Mode").getI();
        String[][] det = new String[0][0];
        String[] simTr = new String[]{};
        String[] recTr = new String[]{};
        String[] hits = new String[]{};
        String[] aod = new String[]{};
        if (mode == 0 || projection instanceof AProjectionVP || projection instanceof AProjectionLegoPlot) {
            simTr = new String[]{"STr", "SNP", "SMTr"};
            recTr = new String[]{"InDetSegment", "MuonSegment", "InDetTrack", "MuonTrack"};
            aod = new String[]{"CompositeParticle", "BJet", "TauJet", "Photon", "Electron", "Muon"};
            hits = APar.get("InDetDrawingOrder", "SpacePoints").getI() == 0 ? new String[]{"UserHit", "RVx", "TRT", "SiCluster", "SiClusterRDO", "S3D", "PixelCluster", "PixelRDO", "TrigS3D", "MDT", "CSCD", "CSC", "RPC", "R3D", "TGC", "T3D", "SVx", "Jet", "EmTauROI", "Particle", "Cluster", "ETMis", "JetROI", "MuonROI", "LVL1TriggerTower", "LVL1JetElement"} : new String[]{"UserHit", "RVx", "TRT", "SiCluster", "SiClusterRDO", "TrigS3D", "S3D", "PixelCluster", "PixelRDO", "MDT", "CSCD", "CSC", "RPC", "R3D", "TGC", "T3D", "SVx", "Jet", "EmTauROI", "Particle", "Cluster", "ETMis", "JetROI", "MuonROI", "LVL1TriggerTower", "LVL1JetElement"};
        } else if (projection instanceof AProjectionYX || projection instanceof AProjectionFR) {
            if (mode >= 5 && mode <= 8) {
                simTr = new String[]{"SMTr", "SMTr"};
                recTr = new String[]{"MuonTrack", "MuonSegment"};
                hits = mode == 5 ? new String[]{"MDT", "CSCD", "CSC"} : new String[]{"MDT"};
            } else if (mode < 5) {
                simTr = new String[]{"SMTr", "SMTr"};
                recTr = new String[]{"MuonTrack", "MuonSegment"};
                hits = new String[]{"TGC", "T3D"};
            }
        } else if (projection instanceof AProjectionFZ) {
            if (mode >= 4) {
                simTr = new String[]{"SMTr", "SMTr"};
                recTr = new String[]{"MuonTrack", "MuonSegment"};
                hits = new String[]{"MDT"};
            } else {
                simTr = new String[]{"SMTr", "SMTr"};
                recTr = new String[]{"MuonTrack", "MuonSegment"};
                hits = new String[]{"RPC", "R3D"};
            }
        }
        det = APar.get("InDetDrawingOrder", "SpacePointsTracks").getI() == 0 ? new String[][]{simTr, recTr, hits, aod} : (APar.get("InDetDrawingOrder", "SpacePointsTracks").getI() == 1 ? new String[][]{simTr, hits, recTr, aod} : new String[][]{recTr, hits, simTr, aod});
        AEnumeratorParameter listBox = null;
        ArrayList v = new ArrayList();
        for (int i = 0; i < det.length; ++i) {
            for (int j = 0; j < det[i].length; ++j) {
                if (this.collections.containsKey(det[i][j])) {
                    Vector keys = (Vector)this.collections.get(det[i][j]);
                    String[] array = keys.toArray(new String[keys.size()]);
                    listBox = (AEnumeratorParameter)APar.get(det[i][j], det[i][j] + "Collections");
                    String currentSelection = listBox.getCurrentText();
                    for (int c = 0; c < array.length; ++c) {
                        if (!"All".equals(currentSelection) && !array[c].equals(currentSelection)) continue;
                        Object o = this.data.get(det[i][j] + array[c]);
                        this.processDataSet(v, o);
                    }
                    continue;
                }
                Object o = this.data.get(det[i][j]);
                this.processDataSet(v, o);
            }
        }
        return v;
    }

    private void processDataSet(List v, Object o) {
        AData a;
        if (o != null && o instanceof AData && APar.getUnknown("Data", (a = (AData)o).getName()) != null && APar.get("Data", a.getName()).getStatus() && (APar.getUnknown("Det", a.getName() + "Fill") == null || APar.get("Det", a.getName() + "Fill").getStatus())) {
            v.add(o);
        }
    }

    public List getElectromagneticCalorimeters() {
        ArrayList v = new ArrayList();
        for (Object o : this.data.values()) {
            if (!(o instanceof ALArData) && !(o instanceof AFCALData)) continue;
            v.add(o);
        }
        return v;
    }

    public List getHadronicCalorimeters() {
        ArrayList v = new ArrayList();
        for (Object o : this.data.values()) {
            if (!(o instanceof ATILEData) && !(o instanceof AHECData) && !(o instanceof AFCALData) && !(o instanceof AMBTSData)) continue;
            v.add(o);
        }
        return v;
    }

    public void setPrimaryVertex() {
        double[] vtx = null;
        if (this.getRVxData() != null) {
            vtx = this.getRVxData().getPrimaryVertex();
        }
        if (vtx == null && this.getSTrData() != null) {
            int vtxIndex = this.getSTrData().getMaxSumPtVertex();
            vtx = this.getSVxData().getVertex(vtxIndex);
            if (vtx[0] * vtx[0] + vtx[1] * vtx[1] > 4.0) {
                logger.info("replacing primary with first");
                logger.info("  was " + vtx[0] + " " + vtx[1] + " " + vtx[2]);
                vtx = this.getSVxData().getVertex(0);
                if (vtx[0] * vtx[0] + vtx[1] * vtx[1] > 4.0) {
                    vtx[0] = 0.0;
                    vtx[1] = 0.0;
                    vtx[2] = 0.0;
                }
                logger.info("  now is " + vtx[0] + " " + vtx[1] + " " + vtx[2]);
            }
        }
        if (vtx == null) {
            vtx = new double[]{0.0, 0.0, 0.0};
        }
        APar.get("Event", "XVtx").setD(vtx[0]);
        APar.get("Event", "YVtx").setD(vtx[1]);
        APar.get("Event", "ZVtx").setD(vtx[2]);
        AOutput.append("\n\nPrimary vertex set for projection \u03a6\u03b7:\n  XVtx = " + AMath.d2s(vtx[0], 5) + " cm\n" + "  YVtx = " + AMath.d2s(vtx[1], 5) + " cm\n" + "  ZVtx = " + AMath.d2s(vtx[2], 5) + " cm\n", "WARNING");
    }

    public AEvent finalizeEvent() {
        this.setPrimaryVertex();
        Iterator iter = this.data.values().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof AData)) continue;
            try {
                ((AData)o).finalizeConstruction();
            }
            catch (Exception e) {
                String ObjName = ((AData)o).getFullName();
                logger.error("Exception while finalizing construction of " + ObjName, e);
                AOutput.append("\n\nError while constructing " + ObjName + "\n", "WARNING");
                AOutput.append(" - object will not be shown!\n", "WARNING");
                iter.remove();
            }
        }
        if (!Atlantis.isAtlantisHeadless()) {
            AListManager.getInstance().resetAndPreserveInvisible();
        }
        if (this.getRVxData() != null) {
            this.getRVxData().cutTracksToRVx(this);
        }
        this.assocmgr.correct();
        this.updateCollectionsListBoxes();
        AEnumeratorParameter drawnAs = (AEnumeratorParameter)APar.get("InDetTrack", "DrawnAs");
        APar.get("InDetTrack", "DrawnAs").setI((int)drawnAs.getValue("Polyline"));
        AEnumeratorParameter trackCollections = (AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections");
        APar.get("InDetTrack", "InDetTrackCollections").setI((int)trackCollections.getValue("Tracks"));
        AEnumeratorParameter muons = (AEnumeratorParameter)APar.get("MuonTrack", "MuonTrackCollections");
        APar.get("MuonTrack", "MuonTrackCollections").setI((int)muons.getValue("StacoTrackParticles"));
        AEnumeratorParameter objectMuonCollections = (AEnumeratorParameter)APar.get("Muon", "MuonCollections");
        APar.get("Muon", "MuonCollections").setI((int)objectMuonCollections.getValue("StacoMuonCollection"));
        AEnumeratorParameter objectJetCollections = (AEnumeratorParameter)APar.get("Jet", "JetCollections");
        APar.get("Jet", "JetCollections").setI((int)objectJetCollections.getValue("AntiKt4LCTopoJets_AOD"));
        AEnumeratorParameter objectElectronCollections = (AEnumeratorParameter)APar.get("Electron", "ElectronCollections");
        APar.get("Electron", "ElectronCollections").setI((int)objectElectronCollections.getValue("ElectronAOD"));
        return this;
    }

    private void updateCollectionsListBoxes() {
        Iterator iter = this.collections.keySet().iterator();
        String dataTypeName = null;
        String listBoxName = null;
        Hashtable listBoxPreviousContents = null;
        Vector keys = null;
        String[] keysArray = null;
        AEnumeratorParameter listBox = null;
        boolean contentsChanged = false;
        while (iter.hasNext()) {
            int i;
            contentsChanged = false;
            dataTypeName = (String)iter.next();
            listBoxName = dataTypeName + "Collections";
            keys = (Vector)this.collections.get(dataTypeName);
            listBox = (AEnumeratorParameter)APar.get(dataTypeName, listBoxName);
            keysArray = keys.toArray(new String[keys.size()]);
            listBoxPreviousContents = listBox.getValuesHashtable();
            for (i = 0; i < listBoxPreviousContents.size(); ++i) {
                String item = (String)listBoxPreviousContents.get(new Integer(i));
                if (keys.contains(item) || "All".equals(item)) continue;
                contentsChanged = true;
                listBox.removeItem(item);
            }
            for (i = 0; i < keysArray.length; ++i) {
                if (listBoxPreviousContents.containsValue(keysArray[i])) continue;
                contentsChanged = true;
                listBox.addItem(listBox.size(), keysArray[i]);
            }
            if (!contentsChanged || dataTypeName.endsWith("Segment")) continue;
            listBox.removeItem("All");
            listBox.addItem(listBox.size(), "All");
            listBox.initialize();
        }
    }

    public String[][] getInfo() {
        AData[] sources = this.getData();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.clear();
        for (int i = 0; i < sources.length; ++i) {
            String sg = sources[i].getStoreGateKey();
            String a = sources[i].getNameScreenName();
            a = a + (sg != null ? ":" + sg : "");
            m.put(a, String.valueOf(sources[i].getNumData()));
        }
        TreeMap<String, String> tm = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        tm.clear();
        tm.putAll(m);
        String[][] s = new String[tm.size()][2];
        int i = 0;
        Iterator iter = tm.keySet().iterator();
        while (iter.hasNext()) {
            String key;
            s[i][0] = key = iter.next().toString();
            s[i][1] = tm.get(key).toString();
            ++i;
        }
        return s;
    }

    public String[][] getInfoDraw() {
        AData[] sources = this.getData();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.clear();
        LinkedHashMap<String, String> mDraw = new LinkedHashMap<String, String>();
        mDraw.clear();
        for (int i = 0; i < sources.length; ++i) {
            String sg = sources[i].getStoreGateKey();
            String a = sources[i].getNameScreenName();
            a = a + (sg != null ? ":" + sg : "");
            m.put(a, String.valueOf(sources[i].getNumData()));
            mDraw.put(a, String.valueOf(sources[i].getNumDraw()));
        }
        TreeMap<String, String> tm = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        tm.clear();
        tm.putAll(m);
        TreeMap<String, String> tmDraw = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        tmDraw.clear();
        tmDraw.putAll(mDraw);
        String[][] s = new String[tm.size()][3];
        int i = 0;
        Iterator iter = tm.keySet().iterator();
        while (iter.hasNext()) {
            String key;
            s[i][0] = key = iter.next().toString();
            s[i][1] = tm.get(key).toString();
            s[i][2] = tmDraw.get(key).toString();
            ++i;
        }
        return s;
    }

    public double[] getPrimaryVertex() {
        double[] primaryVertex = new double[]{APar.get("Event", "XVtx").getD(), APar.get("Event", "YVtx").getD(), APar.get("Event", "ZVtx").getD()};
        return primaryVertex;
    }

    public AAssociationManager getAssociationManager() {
        return this.assocmgr;
    }

    public String getName() {
        return this.getSourceName();
    }
}

