/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;

public class AEventInfo {
    private final long runNumber;
    private final long eventNumber;
    private final String dateTime;
    private final String sourceName;
    private final String lumiBlock;
    private final String eventProperties;
    public static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");

    AEventInfo(long event, long run, String time, String source, String lumiBlock, String eventProperties) {
        this.runNumber = run;
        this.eventNumber = event;
        this.dateTime = time != null ? time : "n/a";
        this.sourceName = source != null ? source : "n/a";
        this.lumiBlock = this.checkString(lumiBlock);
        this.eventProperties = this.checkString(eventProperties);
    }

    AEventInfo(AEventInfo event) {
        this(event.getEventNumber(), event.getRunNumber(), event.getDateTime(), event.getSourceName(), event.getLumiBlock(), event.getEventProperties());
    }

    public long getRunNumber() {
        return this.runNumber;
    }

    public long getEventNumber() {
        return this.eventNumber;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getLumiBlock() {
        return this.lumiBlock;
    }

    public String getEventProperties() {
        return this.eventProperties;
    }

    public String checkString(String recievedString) {
        String temp = recievedString == null || recievedString.endsWith("-1") ? "default" : recievedString;
        return temp;
    }

    public boolean equals(AEventInfo info) {
        if (info == null) {
            return false;
        }
        return info.getRunNumber() == this.runNumber && info.getEventNumber() == this.eventNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.eventNumber ^ this.eventNumber >>> 32);
        result = 31 * result + (int)(this.runNumber ^ this.runNumber >>> 32);
        return result;
    }

    public static class DateTimeComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            AEventInfo info1 = (AEventInfo)o1;
            AEventInfo info2 = (AEventInfo)o2;
            if (info1.equals(info2)) {
                return 0;
            }
            Date date1 = null;
            Date date2 = null;
            try {
                date1 = dateTimeFormat.parse(info1.getDateTime());
                date2 = dateTimeFormat.parse(info2.getDateTime());
            }
            catch (ParseException pex) {
                throw new ClassCastException("Parse exception when comparing dates");
            }
            if (date1 == null || date2 == null) {
                throw new ClassCastException("Could not parse valid date comparing " + info1.getDateTime() + " to " + info2.getDateTime());
            }
            return date1.compareTo(date2);
        }
    }

    public static class RunEventNumberComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            AEventInfo info1 = (AEventInfo)o1;
            AEventInfo info2 = (AEventInfo)o2;
            Long run = info1.getRunNumber();
            if (run.compareTo(info2.getRunNumber()) != 0) {
                return run.compareTo(info2.getRunNumber());
            }
            Long event = info2.getEventNumber();
            return event.compareTo(info2.getEventNumber());
        }
    }
}

