/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.Atlantis;
import atlantis.event.AEvent;
import atlantis.event.AEventSource;
import atlantis.event.AFileEventSource;
import atlantis.event.ANewEventListener;
import atlantis.event.ANewEventSourceListener;
import atlantis.event.AURLEventSource;
import atlantis.event.AZipEventSource;
import atlantis.event.oncrpc.AONCRPCEventSource;
import atlantis.event.xmlrpc.AXMLRPCEventSource;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.ALogger;
import java.util.Vector;

public class AEventManager {
    private static final ALogger logger = ALogger.getLogger(AEventManager.class);
    private AEventSource eventSource = null;
    private AEvent currentEvent = null;
    private Vector<ANewEventListener> NewEventListeners = new Vector();
    private Vector<ANewEventSourceListener> NewEventSourceListeners = new Vector();

    public synchronized AEvent getCurrentEvent() {
        return this.currentEvent;
    }

    private synchronized void setCurrentEvent(AEvent event) {
        this.currentEvent = event;
        this.fireNewEvent(this.getCurrentEvent());
    }

    public synchronized AEventSource getEventSource() {
        return this.eventSource;
    }

    public synchronized void setEventSource(AEventSource source) {
        this.eventSource = source;
        this.fireNewEventSource(this.getEventSource());
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void setEventSource(String sourceName) throws AEventSource.InvalidEventSourceException {
        String theSourceName = sourceName.toLowerCase().trim();
        if (theSourceName.startsWith("xmlrpc://")) {
            this.eventSource = new AXMLRPCEventSource(sourceName);
        } else if (theSourceName.startsWith("oncrpc://")) {
            this.eventSource = new AONCRPCEventSource(sourceName);
        } else if (theSourceName.startsWith("http://")) {
            this.eventSource = theSourceName.endsWith(".xml") ? new AURLEventSource(sourceName) : (theSourceName.endsWith(".zip") ? new AZipEventSource(sourceName) : new AURLEventSource(sourceName));
        } else {
            if (!theSourceName.startsWith("file://")) {
                String msg = "Could not identify event source: " + sourceName;
                logger.error(msg);
                throw new AEventSource.InvalidEventSourceException(msg);
            }
            if (theSourceName.endsWith(".xml")) {
                this.eventSource = new AFileEventSource(sourceName);
            } else if (theSourceName.endsWith(".zip")) {
                this.eventSource = new AZipEventSource(sourceName);
            } else {
                if (!theSourceName.endsWith(".gz") && !theSourceName.endsWith(".gzip")) {
                    String msg = "Could not identify event source: " + sourceName;
                    logger.error(msg);
                    throw new AEventSource.InvalidEventSourceException(msg);
                }
                this.eventSource = new AFileEventSource(sourceName);
            }
        }
        this.fireNewEventSource(this.getEventSource());
    }

    public synchronized void setNavigationMode(AEventSource.NavigationMode mode) throws AEventSource.InvalidEventSourceException {
        if (this.eventSource == null) {
            throw new AEventSource.InvalidEventSourceException("Current event source is NULL");
        }
        AEventSource.NavigationMode oldMode = this.eventSource.getNavigationMode();
        if (oldMode != mode) {
            if (this.eventSource.supportsNavigationMode(mode)) {
                this.eventSource.setNavigationMode(mode);
                this.fireNewEventSource(this.getEventSource());
                try {
                    this.nextEvent();
                }
                catch (AEventSource.NoMoreEventsException nme) {
                    String msg = "No more events from current source";
                    logger.error(msg);
                }
                catch (AEventSource.ReadEventException re) {
                    String msg = "Error while reading the event";
                    logger.error(msg);
                }
            } else {
                throw new AEventSource.InvalidEventSourceException("Current event source does not support the selected display mode");
            }
        }
    }

    public synchronized AEventSource.NavigationMode getNavigationMode() throws AEventSource.InvalidEventSourceException {
        if (this.eventSource == null) {
            throw new AEventSource.InvalidEventSourceException("Current event source is NULL");
        }
        return this.eventSource.getNavigationMode();
    }

    public boolean supportseventNavigationMode(AEventSource.NavigationMode mode) throws AEventSource.InvalidEventSourceException {
        if (this.eventSource == null) {
            throw new AEventSource.InvalidEventSourceException("Current event source is NULL");
        }
        return this.eventSource.supportsNavigationMode(mode);
    }

    public void nextEvent() throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        if (this.eventSource == null) {
            throw new AEventSource.InvalidEventSourceException("Current event source is NULL");
        }
        this.setCurrentEvent(this.eventSource.nextEvent());
        HTrackMomentaWindow.toolBar.updateToolBarEventName(Atlantis.getEventManager().getEventSource().getSourceName() + Atlantis.FILE_SEPAR + Atlantis.getEventManager().getCurrentEvent().getSourceName());
    }

    public void previousEvent() throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        if (this.eventSource == null) {
            throw new AEventSource.InvalidEventSourceException("Current event source is NULL");
        }
        this.setCurrentEvent(this.eventSource.previousEvent());
        HTrackMomentaWindow.toolBar.updateToolBarEventName(Atlantis.getEventManager().getEventSource().getSourceName() + Atlantis.FILE_SEPAR + Atlantis.getEventManager().getCurrentEvent().getSourceName());
    }

    public void addNewEventListener(ANewEventListener listener) {
        this.NewEventListeners.addElement(listener);
        if (this.getCurrentEvent() == null) {
            return;
        }
        listener.newEvent(this.getCurrentEvent());
    }

    public void removeNewEventListener(ANewEventListener listener) {
        this.NewEventListeners.removeElement(listener);
    }

    private synchronized void fireNewEvent(AEvent event) {
        HTrackMomentaWindow.refresh();
        for (ANewEventListener listener : this.NewEventListeners) {
            listener.newEvent(event);
        }
    }

    public void addNewEventSourceListener(ANewEventSourceListener listener) {
        this.NewEventSourceListeners.addElement(listener);
        if (this.getEventSource() == null) {
            return;
        }
        listener.newEventSource(this.getEventSource());
    }

    public void removeNewEventSourceListener(ANewEventSourceListener listener) {
        this.NewEventSourceListeners.removeElement(listener);
    }

    private synchronized void fireNewEventSource(AEventSource eventSource) {
        for (ANewEventSourceListener listener : this.NewEventSourceListeners) {
            listener.newEventSource(eventSource);
        }
    }
}

