/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.data.AEventFromXML;
import atlantis.event.ABufferedEventSource;
import atlantis.event.AEvent;
import atlantis.event.AEventInfo;
import atlantis.event.AEventSource;
import atlantis.event.XMLFilenameFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.GZIPInputStream;

public class AFileEventSource
extends ABufferedEventSource {
    private File directory = null;
    private final XMLFilenameFilter filter = new XMLFilenameFilter();
    private Random randomGenerator = new Random();

    public AFileEventSource(String sourceName) throws AEventSource.InvalidEventSourceException {
        if (sourceName.startsWith("file://")) {
            sourceName = sourceName.substring(7);
            this.directory = new File(sourceName);
            if (!this.directory.canRead()) {
                throw new AEventSource.InvalidEventSourceException("Can not read from " + sourceName);
            }
        } else {
            throw new AEventSource.InvalidEventSourceException(sourceName + " is not in the form file://path");
        }
    }

    public String getSourceName() {
        return this.directory.getAbsolutePath();
    }

    public boolean supportsNavigationMode(AEventSource.NavigationMode mode) {
        return mode == AEventSource.NavigationMode.SEQUENTIAL || mode == AEventSource.NavigationMode.RANDOM || mode == AEventSource.NavigationMode.LOOP;
    }

    protected AEvent readEventFromFile(File file) throws AEventSource.ReadEventException, AEventSource.InvalidEventSourceException {
        String FullFileName = file.getAbsolutePath();
        try {
            InputStream is = new FileInputStream(FullFileName);
            if (file.getName().toLowerCase().endsWith(".gz") || file.getName().toLowerCase().endsWith(".gzip")) {
                is = new GZIPInputStream(is);
            }
            return AEventFromXML.read(is, file.getName());
        }
        catch (OutOfMemoryError oom) {
            if (this.getNumberOfEvents() > 0) {
                this.clearEventContainer();
            }
            System.gc();
            return this.readEventFromFile(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new AEventSource.InvalidEventSourceException("File not found: " + FullFileName, fnfe);
        }
        catch (IOException ioe) {
            throw new AEventSource.ReadEventException("I/O error readding file: " + FullFileName, ioe);
        }
    }

    private String[] getListOfFiles() {
        Object[] FileList = this.directory.list(this.filter);
        Arrays.sort(FileList);
        return FileList;
    }

    protected AEvent readRandom() throws AEventSource.ReadEventException, AEventSource.InvalidEventSourceException {
        File file = null;
        if (this.directory.isFile()) {
            file = this.directory.getAbsoluteFile();
            this.directory = file.getParentFile();
        } else {
            String[] FileList = this.getListOfFiles();
            if (FileList.length == 0) {
                throw new AEventSource.InvalidEventSourceException("No valid files in directory " + this.directory.getAbsolutePath());
            }
            int iName = this.randomGenerator.nextInt(FileList.length);
            file = new File(this.directory, FileList[iName]);
        }
        return this.readEventFromFile(file);
    }

    public AEvent readNext(AEventInfo currentEvent) throws AEventSource.NoMoreEventsException, AEventSource.ReadEventException, AEventSource.InvalidEventSourceException {
        if (this.getNavigationMode() == AEventSource.NavigationMode.RANDOM) {
            return this.readRandom();
        }
        File file = null;
        if (this.directory.isFile()) {
            file = this.directory.getAbsoluteFile();
            this.directory = file.getParentFile();
        } else {
            String[] FileList = this.getListOfFiles();
            if (FileList.length == 0) {
                throw new AEventSource.NoMoreEventsException("No valid files in directory " + this.directory.getAbsolutePath());
            }
            int iName = 0;
            while (currentEvent != null && currentEvent.getSourceName().compareTo(FileList[iName]) >= 0) {
                if (++iName != FileList.length) continue;
                if (this.getNavigationMode() == AEventSource.NavigationMode.LOOP) {
                    iName = 0;
                    break;
                }
                throw new AEventSource.NoMoreEventsException("No more files after" + currentEvent.getSourceName() + " in directory " + this.directory.getAbsolutePath());
            }
            file = new File(this.directory, FileList[iName]);
        }
        return this.readEventFromFile(file);
    }

    public AEvent readPrevious(AEventInfo currentEvent) throws AEventSource.NoMoreEventsException, AEventSource.ReadEventException, AEventSource.InvalidEventSourceException {
        if (this.getNavigationMode() == AEventSource.NavigationMode.RANDOM) {
            throw new AEventSource.NoMoreEventsException("No more random events left in the buffer");
        }
        File file = null;
        if (this.directory.isFile()) {
            file = this.directory.getAbsoluteFile();
            this.directory = file.getParentFile();
        } else {
            String[] FileList = this.getListOfFiles();
            if (FileList.length == 0) {
                throw new AEventSource.NoMoreEventsException("No valid files in directory " + this.directory.getAbsolutePath());
            }
            int iName = FileList.length - 1;
            while (currentEvent != null && currentEvent.getSourceName().compareTo(FileList[iName]) <= 0) {
                if (--iName >= 0) continue;
                if (this.getNavigationMode() == AEventSource.NavigationMode.LOOP) {
                    iName = FileList.length - 1;
                    break;
                }
                throw new AEventSource.NoMoreEventsException("No more files before" + currentEvent.getSourceName() + " in directory " + this.directory.getName());
            }
            file = new File(this.directory, FileList[iName]);
        }
        return this.readEventFromFile(file);
    }
}

