/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.data.AS3DData;
import atlantis.parameters.APar;
import atlantis.utils.AOutput;

public class AFilter {
    static final int FILTER_GROUP = 76;
    static int[] h = null;
    static int[] eta = null;
    static int[] phi = null;
    static int[] layer = null;
    static int[] group = null;
    static int[] skewGroup = null;
    static int[] groupMapping = null;
    static int[] bin = null;
    static int[] ll = null;
    static int[] hitLayers = null;
    static int[] id = null;
    static boolean[] good = null;
    static int numEtaBins = 0;
    static final int[] layerAsBits = new int[32];
    static final int[] countLUT;
    static final int maskByte = 255;

    public static void filter(AS3DData aS3DData) {
        if (aS3DData == null) {
            AOutput.append("AS3DData not found can't filter\n", "BAD_COMMAND");
            return;
        }
        int numUsefulPhiBins = APar.get("Fil", "NumPhi").getI();
        int numUsefulEtaBins = APar.get("Fil", "NumEta").getI();
        int numPhiBins = numUsefulPhiBins + 2;
        numEtaBins = numUsefulEtaBins + 2;
        double etaRange = APar.get("Fil", "EtaRange").getD();
        int requiredHitsInBin = APar.get("Fil", "NumHits").getI();
        int numSkewSteps = APar.get("Fil", "NumSkew").getI();
        double skewStepSize = APar.get("Fil", "SkewStep").getD();
        int numHits = aS3DData.makeFilterDrawList(etaRange);
        int maxBins = numHits + 1;
        if (h == null || h.length < numPhiBins * numEtaBins) {
            h = new int[numPhiBins * numEtaBins];
        }
        if (layer == null || layer.length < numHits) {
            layer = new int[numHits];
        }
        if (eta == null || eta.length < numHits) {
            eta = new int[numHits];
        }
        if (phi == null || phi.length < numHits) {
            phi = new int[numHits];
        }
        if (group == null || group.length < numHits) {
            group = new int[numHits];
        }
        if (skewGroup == null || skewGroup.length < numHits) {
            skewGroup = new int[numHits];
        }
        if (groupMapping == null || groupMapping.length < numHits) {
            groupMapping = new int[numHits];
        }
        if (bin == null || bin.length < maxBins) {
            bin = new int[maxBins];
        }
        if (hitLayers == null || hitLayers.length < maxBins) {
            hitLayers = new int[maxBins];
        }
        if (id == null || id.length < maxBins) {
            id = new int[maxBins];
        }
        if (ll == null || ll.length < maxBins) {
            ll = new int[maxBins];
        }
        if (good == null || good.length < maxBins) {
            good = new boolean[maxBins];
        }
        layer = aS3DData.getLayer(layer);
        eta = aS3DData.getIntegerEta(numUsefulEtaBins, etaRange, eta);
        for (int i = 0; i < numHits; ++i) {
            AFilter.group[i] = 0;
        }
        if (!APar.get("Fil", "Loop").getStatus()) {
            numSkewSteps = 0;
        }
        int numGroups = 0;
        for (int step = -numSkewSteps; step <= numSkewSteps; ++step) {
            int i;
            int i2;
            double skew = 0.0;
            if (numSkewSteps != 0) {
                skew = 1.0 / skewStepSize * (double)step / ((double)(numSkewSteps * 2) * 166.666);
            }
            for (int i3 = 0; i3 < maxBins; ++i3) {
                AFilter.hitLayers[i3] = 0;
                AFilter.good[i3] = false;
            }
            phi = aS3DData.getIntegerPhi(numUsefulPhiBins, skew, phi);
            int numBins = 1;
            for (int i4 = 0; i4 < numHits; ++i4) {
                int b = phi[i4] * numEtaBins + eta[i4];
                if (h[b] == 0) {
                    AFilter.h[b] = numBins;
                    AFilter.bin[numBins] = b;
                    ++numBins;
                }
                int n = h[b];
                hitLayers[n] = hitLayers[n] | layerAsBits[layer[i4]];
            }
            for (int e = 0; e < numEtaBins; ++e) {
                AFilter.h[0 * AFilter.numEtaBins + e] = h[numUsefulPhiBins * numEtaBins + e];
                AFilter.h[(numUsefulPhiBins + 1) * AFilter.numEtaBins + e] = h[1 * numEtaBins + e];
            }
            int ngood = 0;
            for (i2 = 1; i2 < numBins; ++i2) {
                int b = bin[i2];
                int hitLayersSummed = 0;
                for (int p = b - numEtaBins; p < b + 2 * numEtaBins; p += numEtaBins) {
                    for (int e = p - 1; e < p + 2; ++e) {
                        int ibin = h[e];
                        if (ibin <= 0) continue;
                        hitLayersSummed |= hitLayers[ibin];
                    }
                }
                if (AFilter.countBits(hitLayersSummed) < requiredHitsInBin) continue;
                AFilter.good[i2] = true;
                AFilter.ll[ngood++] = i2;
            }
            for (i2 = 0; i2 < ngood; ++i2) {
                AFilter.id[AFilter.ll[i2]] = 0;
            }
            int firstGroup = numGroups + 1;
            for (i = 0; i < ngood; ++i) {
                if (id[ll[i]] != 0) continue;
                AFilter.add(ll[i], ++numGroups);
            }
            for (int j = firstGroup; j <= numGroups; ++j) {
                int i5;
                int hls = 0;
                for (i5 = 0; i5 < ngood; ++i5) {
                    if (id[ll[i5]] != j) continue;
                    hls |= hitLayers[ll[i5]];
                }
                if (AFilter.countBits(hls) >= requiredHitsInBin) continue;
                for (i5 = 0; i5 < ngood; ++i5) {
                    if (id[ll[i5]] != j) continue;
                    AFilter.good[AFilter.ll[i5]] = false;
                }
            }
            for (i = 0; i < numHits; ++i) {
                int b = h[phi[i] * numEtaBins + eta[i]];
                AFilter.skewGroup[i] = good[b] ? id[b] : 0;
            }
            for (i = 1; i < numBins; ++i) {
                AFilter.h[AFilter.bin[i]] = 0;
            }
            for (int e = 0; e < numEtaBins; ++e) {
                AFilter.h[0 * AFilter.numEtaBins + e] = 0;
                AFilter.h[(numPhiBins - 1) * AFilter.numEtaBins + e] = 0;
            }
            group = AFilter.mergeGroups(numHits, numGroups, group, skewGroup);
        }
        group = AFilter.renumberGroups(numHits, group);
        int num = 0;
        for (int i = 0; i < numHits; ++i) {
            if (group[i] <= 0) continue;
            ++num;
        }
        AOutput.alwaysAppend("\nFiltering:\n Input hits = " + numHits + "\n Num grouped = " + num + "\n", "NORMAL_BOLD");
        aS3DData.setGroup(group);
    }

    public static void add(int i, int numGroup) {
        AFilter.id[i] = numGroup;
        int b = bin[i];
        for (int p = b - numEtaBins; p < b + 2 * numEtaBins; p += numEtaBins) {
            for (int e = p - 1; e < p + 2; ++e) {
                int ibin = h[e];
                if (!good[ibin] || id[ibin] != 0) continue;
                AFilter.add(ibin, numGroup);
            }
        }
    }

    public static int[] mergeGroups(int numHits, int numGroups, int[] group, int[] skewgroup) {
        int i;
        for (i = 1; i <= numGroups; ++i) {
            AFilter.groupMapping[i] = i;
        }
        for (i = 0; i < numHits; ++i) {
            int g2;
            int g1;
            if (skewGroup[i] <= 0 || group[i] <= 0 || (g1 = groupMapping[group[i]]) == (g2 = groupMapping[skewGroup[i]])) continue;
            for (int g = 1; g <= numGroups; ++g) {
                if (groupMapping[g] != g1 && groupMapping[g] != g2) continue;
                AFilter.groupMapping[g] = g1;
            }
        }
        for (i = 0; i < numHits; ++i) {
            if (skewGroup[i] <= 0 && group[i] <= 0) continue;
            int g = skewGroup[i];
            if (g == 0) {
                g = group[i];
            }
            group[i] = groupMapping[g];
        }
        return group;
    }

    public static int[] renumberGroups(int numHits, int[] group) {
        int i;
        int numGroups = 0;
        for (i = 0; i < numHits; ++i) {
            if (group[i] <= 0) continue;
            int g = group[i];
            ++numGroups;
            for (int j = i; j < numHits; ++j) {
                if (group[j] != g) continue;
                group[j] = -numGroups;
            }
        }
        for (i = 0; i < numHits; ++i) {
            group[i] = -group[i];
        }
        return group;
    }

    public static int countBits(int bits) {
        return countLUT[bits & 0xFF] + countLUT[bits >>> 8 & 0xFF] + countLUT[bits >>> 16 & 0xFF];
    }

    static {
        AFilter.layerAsBits[0] = 1;
        for (int i = 1; i < 32; ++i) {
            AFilter.layerAsBits[i] = 2 * layerAsBits[i - 1];
        }
        countLUT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    }
}

