/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.event.AEvent;
import atlantis.event.AEventInfo;
import atlantis.event.ANewEventListener;
import atlantis.graphics.encoders.AImageEncoder;
import atlantis.utils.ALogger;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AImageProducer
implements ANewEventListener {
    private static final ALogger logger = ALogger.getLogger(AImageProducer.class);
    private static final String filePrefix = "atlantis";
    private static final int encodeNumberDigits = 6;
    private final File directory;
    private final Dimension imageSize;
    private final double scaleFactor;
    private final String fixedFileName;
    private final AImageEncoder imageEncoder = new AImageEncoder();

    public AImageProducer(String dir, Dimension size, double scale, String fileName) throws InstantiationException {
        this.directory = new File(dir);
        if (!this.directory.exists()) {
            throw new InstantiationException("Directory " + dir + " doesn't exist");
        }
        if (!this.directory.isDirectory()) {
            throw new InstantiationException(dir + " is not a directory");
        }
        if (!this.directory.canWrite()) {
            throw new InstantiationException("Cannot write to directory " + dir);
        }
        if (scale <= 0.0) {
            throw new InstantiationException("Negative or zero scale factor");
        }
        this.imageSize = size;
        this.scaleFactor = scale;
        this.fixedFileName = fileName;
    }

    private String getEventFileName(AEventInfo evt) {
        String nameFormat = String.format("%%s_%%0%dd_%%0%dd", 6, 6);
        return String.format(nameFormat, filePrefix, evt.getRunNumber(), evt.getEventNumber());
    }

    private void saveDataIntoFile(byte[] data, File file) throws IOException {
        if (data == null || file == null) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream os = new BufferedOutputStream(fos);
        ((OutputStream)os).write(data);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newEvent(AEvent event) {
        File pngFile;
        if (this.imageSize.height < 0) {
            this.imageSize.setSize(this.imageSize.width, ACanvas.getCanvas().getRespectiveHeight(this.imageSize.width));
        }
        if (this.fixedFileName == null) {
            String pngName = String.format("%s%s%s.png", this.directory, Atlantis.FILE_SEPAR, this.getEventFileName(event));
            pngFile = new File(pngName);
            if (pngFile.exists()) {
                logger.warn("File " + pngName + " already exists - will not overwrite");
                return;
            }
        } else {
            try {
                pngFile = File.createTempFile("atlantis_", ".png", this.directory);
            }
            catch (IOException ex) {
                logger.warn("Failed to create temporary file in " + this.directory.getAbsolutePath());
                return;
            }
        }
        byte[] pngData = this.imageEncoder.getScaledPNGData(this.imageSize.width, this.imageSize.height, this.scaleFactor);
        try {
            this.saveDataIntoFile(pngData, pngFile);
            if (this.fixedFileName != null) {
                File fixedFile = new File(this.directory, this.fixedFileName);
                if (fixedFile.exists() && !fixedFile.delete()) {
                    throw new IOException("Failed to delete existing file " + fixedFile.getAbsolutePath());
                }
                if (!pngFile.renameTo(fixedFile)) {
                    throw new IOException("Failed to rename temporary file to " + fixedFile.getAbsolutePath());
                }
            }
        }
        catch (IOException ioe) {
            logger.warn("Could not save PNG files for history\n" + ioe.toString());
        }
        finally {
            if (this.fixedFileName != null) {
                pngFile.delete();
            }
        }
    }

    public class InstantiationException
    extends Exception {
        InstantiationException(String what) {
            super(what);
        }
    }
}

