/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.data.AEventFromXML;
import atlantis.event.ABufferedEventSource;
import atlantis.event.AEvent;
import atlantis.event.AEventInfo;
import atlantis.event.AEventSource;
import atlantis.utils.ALogger;
import atlantis.utils.AOutput;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AURLEventSource
extends ABufferedEventSource {
    private static final ALogger logger = ALogger.getLogger(AURLEventSource.class);
    private String directoryURL = null;
    private Random randomGenerator = new Random();

    @Override
    public boolean supportsNavigationMode(AEventSource.NavigationMode mode) {
        return mode == AEventSource.NavigationMode.SEQUENTIAL || mode == AEventSource.NavigationMode.RANDOM || mode == AEventSource.NavigationMode.LOOP;
    }

    public AURLEventSource(String sourceName) throws AEventSource.InvalidEventSourceException {
        if (!sourceName.toLowerCase().startsWith("http://")) {
            throw new AEventSource.InvalidEventSourceException("URL event source name doesnot start with \"http://\"");
        }
        this.directoryURL = sourceName;
    }

    @Override
    public String getSourceName() {
        return this.directoryURL;
    }

    private ArrayList<String> getEventListForURL(String url) throws AEventSource.InvalidEventSourceException {
        String baseUrl = url;
        if (url.endsWith(".xml")) {
            baseUrl = url.substring(0, url.lastIndexOf(47));
        }
        InputStreamReader urlStream = null;
        BufferedReader br = null;
        logger.info("Trying to get directory listing from " + baseUrl);
        ArrayList<String> eventList = new ArrayList<String>();
        try {
            urlStream = new InputStreamReader(new URL(baseUrl).openStream());
            br = new BufferedReader(urlStream);
            Pattern pattern = Pattern.compile("<a href=\"(.*\\.xml)\">");
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                eventList.add(matcher.group(1));
            }
            logger.debug("List of " + eventList.size() + " events loaded from " + baseUrl);
        }
        catch (MalformedURLException mue) {
            String msg = "Incorrect URL address: " + baseUrl;
            logger.error(msg);
            AOutput.alwaysAppend("\n" + msg + "\n", "WARNING");
            throw new AEventSource.InvalidEventSourceException(msg, mue);
        }
        catch (IOException ioe) {
            String msg = "IO error while reading URL: " + baseUrl;
            logger.error(msg);
            AOutput.alwaysAppend("\n" + msg + "\n", "WARNING");
            throw new AEventSource.InvalidEventSourceException(msg, ioe);
        }
        finally {
            try {
                br.close();
                urlStream.close();
            }
            catch (Throwable t) {}
        }
        if (eventList.size() == 0) {
            throw new AEventSource.InvalidEventSourceException("No events found at " + baseUrl);
        }
        Collections.sort(eventList);
        return eventList;
    }

    private AEvent readEventFromURL(String fileName, String directoryURL) throws AEventSource.ReadEventException {
        InputStream urlStream = null;
        BufferedInputStream buffStream = null;
        AEvent event = null;
        try {
            String fullURL = directoryURL + "/" + fileName;
            URL eventURL = new URL(fullURL);
            urlStream = eventURL.openStream();
            buffStream = new BufferedInputStream(urlStream);
            logger.debug("Reading event data stream from " + eventURL.toString() + "...");
            event = AEventFromXML.read(buffStream, fileName);
        }
        catch (FileNotFoundException fnfe) {
            String msg = "File not found at " + directoryURL + "/" + fileName;
            logger.error(msg);
            AOutput.alwaysAppend("\n" + msg + "\n", "WARNING");
            throw new AEventSource.ReadEventException(msg, fnfe);
        }
        catch (IOException ioe) {
            String msg = "IO error when reading " + directoryURL;
            logger.error(msg);
            AOutput.alwaysAppend("\n" + msg + "\n", "WARNING");
            throw new AEventSource.ReadEventException(msg, ioe);
        }
        finally {
            try {
                if (urlStream != null) {
                    urlStream.close();
                }
                if (buffStream != null) {
                    buffStream.close();
                }
            }
            catch (Throwable t) {}
        }
        return event;
    }

    protected AEvent readRandom() throws AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        String fileName = null;
        if (this.directoryURL.endsWith(".xml")) {
            fileName = this.directoryURL.substring(this.directoryURL.lastIndexOf(47) + 1, this.directoryURL.length());
            this.directoryURL = this.directoryURL.substring(0, this.directoryURL.lastIndexOf(47));
        } else {
            ArrayList<String> eventList = this.getEventListForURL(this.directoryURL);
            if (eventList.size() == 0) {
                throw new AEventSource.InvalidEventSourceException("No valid files at " + this.directoryURL);
            }
            int iName = this.randomGenerator.nextInt(eventList.size());
            fileName = eventList.get(iName);
        }
        return this.readEventFromURL(fileName, this.directoryURL);
    }

    @Override
    public AEvent readNext(AEventInfo currentEvent) throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        if (this.getNavigationMode() == AEventSource.NavigationMode.RANDOM) {
            return this.readRandom();
        }
        String fileName = null;
        if (this.directoryURL.endsWith(".xml")) {
            fileName = this.directoryURL.substring(this.directoryURL.lastIndexOf(47) + 1, this.directoryURL.length());
            this.directoryURL = this.directoryURL.substring(0, this.directoryURL.lastIndexOf(47));
        } else {
            ArrayList<String> eventList = this.getEventListForURL(this.directoryURL);
            if (eventList.size() == 0) {
                throw new AEventSource.NoMoreEventsException("No valid files at " + this.directoryURL);
            }
            int iName = 0;
            while (currentEvent != null && currentEvent.getSourceName().compareTo(eventList.get(iName)) >= 0) {
                if (++iName != eventList.size()) continue;
                if (this.getNavigationMode() == AEventSource.NavigationMode.LOOP) {
                    iName = 0;
                    break;
                }
                throw new AEventSource.NoMoreEventsException("No more files after " + currentEvent.getSourceName() + " in directory " + this.directoryURL);
            }
            fileName = eventList.get(iName);
        }
        return this.readEventFromURL(fileName, this.directoryURL);
    }

    @Override
    public AEvent readPrevious(AEventInfo currentEvent) throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        if (this.getNavigationMode() == AEventSource.NavigationMode.RANDOM) {
            throw new AEventSource.NoMoreEventsException("No more random events left in the buffer");
        }
        String fileName = null;
        if (this.directoryURL.endsWith(".xml")) {
            fileName = this.directoryURL.substring(this.directoryURL.lastIndexOf(47) + 1, this.directoryURL.length());
            this.directoryURL = this.directoryURL.substring(0, this.directoryURL.lastIndexOf(47));
        } else {
            ArrayList<String> eventList = this.getEventListForURL(this.directoryURL);
            if (eventList.size() == 0) {
                throw new AEventSource.NoMoreEventsException("No valid files at " + this.directoryURL);
            }
            int iName = eventList.size() - 1;
            while (currentEvent != null && currentEvent.getSourceName().compareTo(eventList.get(iName)) <= 0) {
                if (--iName >= 0) continue;
                if (this.getNavigationMode() == AEventSource.NavigationMode.LOOP) {
                    iName = eventList.size() - 1;
                    break;
                }
                throw new AEventSource.NoMoreEventsException("No more files before " + currentEvent.getSourceName() + " in directory " + this.directoryURL);
            }
            fileName = eventList.get(iName);
        }
        return this.readEventFromURL(fileName, this.directoryURL);
    }
}

