/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event;

import atlantis.data.AEventFromXML;
import atlantis.event.AEvent;
import atlantis.event.AEventSource;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class AZipEventSource
implements AEventSource {
    private AEventSource.NavigationMode eventNavigationMode = AEventSource.NavigationMode.SEQUENTIAL;
    private Random randomGenerator = new Random();
    ArrayList<ZipEntry> ZipEntries = new ArrayList();
    int eventIndex = -1;
    SourceType sourceType = null;
    String eventSource = null;

    public AEventSource.NavigationMode getNavigationMode() {
        return this.eventNavigationMode;
    }

    public void setNavigationMode(AEventSource.NavigationMode mode) throws AEventSource.InvalidEventSourceException {
        if (!this.supportsNavigationMode(mode)) {
            throw new AEventSource.InvalidEventSourceException("Mode '" + (Object)((Object)mode) + "' not supported by current source");
        }
        this.eventNavigationMode = mode;
        this.eventIndex = -1;
    }

    public boolean supportsNavigationMode(AEventSource.NavigationMode mode) {
        return mode == AEventSource.NavigationMode.SEQUENTIAL || mode == AEventSource.NavigationMode.RANDOM || mode == AEventSource.NavigationMode.LOOP;
    }

    public AZipEventSource(String sourceName) throws AEventSource.InvalidEventSourceException {
        ZipFile zipfile = null;
        ZipInputStream stream = null;
        try {
            if (sourceName.startsWith("http://")) {
                stream = this.openNetworkStream(sourceName);
                this.readEntriesFromStream(stream);
                this.sourceType = SourceType.ZIP_NETWORK_FILE;
            } else if (sourceName.startsWith("file://")) {
                File file = new File(sourceName = sourceName.substring(7));
                if (file.exists() && file.canRead()) {
                    zipfile = new ZipFile(sourceName);
                    this.readEntriesFromFile(zipfile);
                    this.sourceType = SourceType.ZIP_FILE;
                } else {
                    stream = this.openJarStream(sourceName);
                    this.readEntriesFromStream(stream);
                    this.sourceType = SourceType.JAR_FILE;
                }
            }
        }
        catch (AAtlantisException ae) {
            throw new AEventSource.InvalidEventSourceException("Atlantis exception reading from: " + this.eventSource, ae);
        }
        catch (MalformedURLException mue) {
            throw new AEventSource.InvalidEventSourceException("An unknown protocol is specified: " + this.eventSource, mue);
        }
        catch (ZipException zfe) {
            throw new AEventSource.InvalidEventSourceException("ZIP format error has occurred: " + this.eventSource, zfe);
        }
        catch (IOException ioe) {
            throw new AEventSource.InvalidEventSourceException("I/O error has occurred reading: " + this.eventSource, ioe);
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable t) {}
        }
        if (this.sourceType == null) {
            throw new AEventSource.InvalidEventSourceException("Could not identify source type of " + sourceName);
        }
        if (this.ZipEntries.size() == 0) {
            throw new AEventSource.InvalidEventSourceException("No entries in ZIP archive: " + sourceName);
        }
        this.eventSource = sourceName;
        this.eventIndex = -1;
    }

    public String getSourceName() {
        return this.eventSource;
    }

    private ZipInputStream openJarStream(String sourceName) throws AAtlantisException {
        return new ZipInputStream(AUtilities.getFileAsStream(sourceName));
    }

    private ZipInputStream openNetworkStream(String sourceName) throws ZipException, MalformedURLException, IOException {
        return new ZipInputStream(new URL(sourceName).openStream());
    }

    private boolean checkZipEntry(ZipEntry entry) {
        if (entry.isDirectory()) {
            return false;
        }
        return entry.getName().toLowerCase().endsWith(".xml");
    }

    private void readEntriesFromStream(ZipInputStream zis) throws AEventSource.InvalidEventSourceException {
        try {
            ZipEntry next = null;
            while ((next = zis.getNextEntry()) != null) {
                if (!this.checkZipEntry(next)) continue;
                this.ZipEntries.add(next);
            }
        }
        catch (ZipException ze) {
            throw new AEventSource.InvalidEventSourceException("ZIP exception reading entry from zip stream", ze);
        }
        catch (IOException ioe) {
            throw new AEventSource.InvalidEventSourceException("I/O exception reading entry from zip stream", ioe);
        }
    }

    private void readEntriesFromFile(ZipFile file) throws AEventSource.InvalidEventSourceException {
        try {
            Enumeration<? extends ZipEntry> myenum = file.entries();
            while (myenum.hasMoreElements()) {
                ZipEntry next = myenum.nextElement();
                if (!this.checkZipEntry(next)) continue;
                this.ZipEntries.add(next);
            }
        }
        catch (IllegalStateException ise) {
            throw new AEventSource.InvalidEventSourceException("Zip file was cleased while trying to read entries: " + file.getName());
        }
    }

    private AEvent readEventFromStream() throws AEventSource.ReadEventException {
        ZipInputStream zis = null;
        AEvent event = null;
        try {
            if (this.sourceType == SourceType.JAR_FILE) {
                zis = this.openJarStream(this.eventSource);
            } else if (this.sourceType == SourceType.ZIP_NETWORK_FILE) {
                zis = this.openNetworkStream(this.eventSource);
            } else {
                throw new AEventSource.ReadEventException("Trying to read stream from neither jar file nor network file:" + this.eventSource);
            }
            ZipEntry entry = null;
            for (int i = 0; i <= this.eventIndex; ++i) {
                entry = zis.getNextEntry();
            }
            if (entry == null) {
                throw new AEventSource.ReadEventException("Reached EOF while skippeng to entry #" + this.eventIndex + " with name " + this.ZipEntries.get(this.eventIndex).getName() + " in " + this.eventSource);
            }
            if (!entry.getName().equals(this.ZipEntries.get(this.eventIndex).getName())) {
                throw new AEventSource.ReadEventException("Content of zip stream changed since opening it:" + this.eventSource);
            }
            event = AEventFromXML.read(zis, entry.getName());
        }
        catch (AAtlantisException ae) {
            throw new AEventSource.ReadEventException("Atlantis exception reading from: " + this.eventSource, ae);
        }
        catch (ZipException ze) {
            throw new AEventSource.ReadEventException("A ZIP format error has occurred reading entry " + this.ZipEntries.get(this.eventIndex).getName() + " from " + this.eventSource, ze);
        }
        catch (IllegalStateException ise) {
            throw new AEventSource.ReadEventException("The zip file has been closed while reading entry" + this.ZipEntries.get(this.eventIndex).getName() + " from " + this.eventSource, ise);
        }
        catch (IOException ioe) {
            throw new AEventSource.ReadEventException("I/O exception reading from: " + this.eventSource, ioe);
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Throwable t) {}
        }
        return event;
    }

    private AEvent readEventFromFile() throws AEventSource.ReadEventException {
        ZipFile file = null;
        AEvent event = null;
        try {
            file = new ZipFile(this.eventSource);
            InputStream stream = file.getInputStream(this.ZipEntries.get(this.eventIndex));
            String eventName = this.ZipEntries.get(this.eventIndex).getName();
            event = AEventFromXML.read(stream, eventName);
        }
        catch (ZipException ze) {
            throw new AEventSource.ReadEventException("A ZIP format error has occurred reading entry " + this.ZipEntries.get(this.eventIndex).getName() + " from " + this.eventSource, ze);
        }
        catch (IllegalStateException ise) {
            throw new AEventSource.ReadEventException("The zip file has been closed while reading entry" + this.ZipEntries.get(this.eventIndex).getName() + " from " + this.eventSource, ise);
        }
        catch (IOException ioe) {
            throw new AEventSource.ReadEventException("I/O error reading entry " + this.ZipEntries.get(this.eventIndex).getName() + " from " + this.eventSource, ioe);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (Throwable t) {}
        }
        return event;
    }

    protected AEvent randomEvent() throws AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        if (this.sourceType == null || this.eventSource == null) {
            throw new AEventSource.InvalidEventSourceException("No valid input source");
        }
        this.eventIndex = this.randomGenerator.nextInt(this.ZipEntries.size());
        switch (this.sourceType) {
            case JAR_FILE: {
                return this.readEventFromStream();
            }
            case ZIP_NETWORK_FILE: {
                return this.readEventFromStream();
            }
            case ZIP_FILE: {
                return this.readEventFromFile();
            }
        }
        throw new AEventSource.ReadEventException("Unknown event source type");
    }

    public AEvent nextEvent() throws AEventSource.InvalidEventSourceException, AEventSource.NoMoreEventsException, AEventSource.ReadEventException {
        if (this.getNavigationMode() == AEventSource.NavigationMode.RANDOM) {
            return this.randomEvent();
        }
        if (this.sourceType == null || this.eventSource == null) {
            throw new AEventSource.InvalidEventSourceException("No valid input source");
        }
        if (this.getNavigationMode() == AEventSource.NavigationMode.LOOP && this.eventIndex >= this.ZipEntries.size() - 1) {
            this.eventIndex = 0;
        } else {
            if (this.eventIndex >= this.ZipEntries.size() - 1) {
                String msg = "Already at last event in archive";
                AOutput.alwaysAppend("\n" + msg + "\n", "WARNING");
                throw new AEventSource.NoMoreEventsException(msg);
            }
            ++this.eventIndex;
        }
        switch (this.sourceType) {
            case JAR_FILE: {
                return this.readEventFromStream();
            }
            case ZIP_NETWORK_FILE: {
                return this.readEventFromStream();
            }
            case ZIP_FILE: {
                return this.readEventFromFile();
            }
        }
        throw new AEventSource.ReadEventException("Unknown event source type");
    }

    public AEvent previousEvent() throws AEventSource.InvalidEventSourceException, AEventSource.NoMoreEventsException, AEventSource.ReadEventException {
        if (this.getNavigationMode() == AEventSource.NavigationMode.RANDOM) {
            throw new AEventSource.NoMoreEventsException("Cannot go back in random mode");
        }
        if (this.sourceType == null || this.eventSource == null) {
            throw new AEventSource.InvalidEventSourceException("No valid input source");
        }
        if (this.getNavigationMode() == AEventSource.NavigationMode.LOOP && this.eventIndex == 0) {
            this.eventIndex = this.ZipEntries.size() - 1;
        } else {
            if (this.eventIndex == 0) {
                String msg = "Already at first event in archive";
                AOutput.alwaysAppend("\n" + msg + "\n", "WARNING");
                throw new AEventSource.NoMoreEventsException(msg);
            }
            --this.eventIndex;
        }
        switch (this.sourceType) {
            case JAR_FILE: {
                return this.readEventFromStream();
            }
            case ZIP_NETWORK_FILE: {
                return this.readEventFromStream();
            }
            case ZIP_FILE: {
                return this.readEventFromFile();
            }
        }
        throw new AEventSource.ReadEventException("Unknown event source type");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SourceType {
        JAR_FILE,
        ZIP_FILE,
        ZIP_NETWORK_FILE;

    }
}

