/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event.oncrpc;

import atlantis.data.AEventFromXML;
import atlantis.event.ABufferedEventSource;
import atlantis.event.AEvent;
import atlantis.event.AEventInfo;
import atlantis.event.AEventSource;
import atlantis.event.AStreamedEventSource;
import atlantis.event.oncrpc.Event;
import atlantis.event.oncrpc.EventRequest;
import atlantis.event.oncrpc.Streams;
import atlantis.utils.ALogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Vector;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrVoid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AONCRPCEventSource
extends ABufferedEventSource
implements AStreamedEventSource {
    private static final ALogger logger = ALogger.getLogger(AONCRPCEventSource.class);
    private OncRpcTcpClient client = null;
    private static final int DEFAULT_TIMEOUT = 2000;
    private String currentStream = null;

    public AONCRPCEventSource(String sourceName) throws AEventSource.InvalidEventSourceException {
        sourceName = sourceName.replaceFirst("oncrpc://", "");
        String[] sourceParams = sourceName.split(":");
        if (sourceParams.length > 3) {
            throw new AEventSource.InvalidEventSourceException("Invalid <server[:port][:stream]> specification: " + sourceName);
        }
        int port = 0;
        if (sourceParams.length > 1 && sourceParams[1].length() > 0) {
            try {
                port = Integer.decode(sourceParams[1]);
            }
            catch (NumberFormatException nfe) {
                throw new AEventSource.InvalidEventSourceException("Invalid port number: " + sourceParams[1]);
            }
        }
        if (port < 0) {
            throw new AEventSource.InvalidEventSourceException("Invalid port number: " + port);
        }
        if (sourceParams.length > 2) {
            this.currentStream = sourceParams[2];
        }
        this.createClient(sourceParams[0], port, 2000);
    }

    public AONCRPCEventSource(String hostName, int port, int timeout) throws AEventSource.InvalidEventSourceException {
        this.createClient(hostName, port, timeout);
    }

    @Override
    public String getSourceName() {
        return "oncrpc://" + this.client.getHost().getHostName() + ":" + this.client.getPort() + (this.currentStream != null ? ":" + this.currentStream : "");
    }

    @Override
    public boolean supportsNavigationMode(AEventSource.NavigationMode mode) {
        return mode == AEventSource.NavigationMode.SEQUENTIAL;
    }

    private void createClient(String hostName, int port, int timeout) throws AEventSource.InvalidEventSourceException {
        try {
            this.client = new OncRpcTcpClient(InetAddress.getByName(hostName), 200048965, 2, port);
        }
        catch (ConnectException e) {
            throw new AEventSource.InvalidEventSourceException("Could not connect to " + hostName, e);
        }
        catch (OncRpcProgramNotRegisteredException e) {
            throw new AEventSource.InvalidEventSourceException("Server not (yet) registered on " + hostName, e);
        }
        catch (OncRpcException e) {
            throw new AEventSource.InvalidEventSourceException("ONC/RPC exception while connecting to " + hostName, e);
        }
        catch (IOException e) {
            throw new AEventSource.InvalidEventSourceException("I/O Exception while connecting to " + hostName, e);
        }
        this.client.setTimeout(timeout);
    }

    @Override
    protected synchronized AEvent readNext(AEventInfo currentEvent) throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        logger.info("Call to remote server " + this.getSourceName());
        try {
            this.client.call(0, (XdrAble)XdrVoid.XDR_VOID, (XdrAble)XdrVoid.XDR_VOID);
        }
        catch (OncRpcException e) {
            logger.info("Failed to ping server " + this.getSourceName() + ", trying to recreate client");
            this.createClient(this.client.getHost().getHostName(), 0, this.client.getTimeout());
        }
        EventRequest eventReq = new EventRequest(-1L, -1L, this.getStream());
        if (currentEvent != null) {
            eventReq.EventNumber = currentEvent.getEventNumber();
            eventReq.RunNumber = currentEvent.getRunNumber();
        }
        Event event = new Event();
        long startTime = System.currentTimeMillis();
        try {
            this.client.call(3, (XdrAble)eventReq, (XdrAble)event);
        }
        catch (OncRpcException e) {
            throw new AEventSource.InvalidEventSourceException("Failed to get new event from server", e);
        }
        long callDuration = System.currentTimeMillis() - startTime;
        logger.debug("Received " + event.EventData.length + " bytes in " + callDuration + " ms");
        if (event.isIdentical) {
            throw new AEventSource.NoMoreEventsException("Already have event " + event.EventNumber + " from run " + event.RunNumber);
        }
        if (!event.isAvailable) {
            throw new AEventSource.InvalidEventSourceException("No event available for stream " + eventReq.StreamName);
        }
        if (event.isCompressed) {
            throw new UnsupportedOperationException("Support for compressed events not yet implemented");
        }
        event.EventData = new String(event.EventData).trim().getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(event.EventData);
        return AEventFromXML.read(bais, this.currentStream);
    }

    @Override
    protected AEvent readPrevious(AEventInfo currentEvent) throws AEventSource.NoMoreEventsException {
        throw new AEventSource.NoMoreEventsException("ONC/RPC server does not provide a previous event");
    }

    @Override
    public synchronized Vector<String> getAvailableStreams() throws AEventSource.InvalidEventSourceException {
        Streams streams = new Streams();
        try {
            this.client.call(2, (XdrAble)XdrVoid.XDR_VOID, (XdrAble)streams);
        }
        catch (OncRpcException e) {
            throw new AEventSource.InvalidEventSourceException("Failed to get new stream list from server", e);
        }
        return new Vector<String>(Arrays.asList(streams.StreamNames));
    }

    @Override
    public synchronized void setStream(String streamName) throws AStreamedEventSource.InvalidStreamException, AEventSource.InvalidEventSourceException {
        if (!this.getAvailableStreams().contains(streamName)) {
            throw new AStreamedEventSource.InvalidStreamException("Stream \"" + streamName + "\" not available at server");
        }
        this.currentStream = streamName;
    }

    @Override
    public synchronized String getStream() throws AEventSource.InvalidEventSourceException, AEventSource.NoMoreEventsException {
        if (this.currentStream == null) {
            Vector<String> streams = this.getAvailableStreams();
            if (streams.size() < 1) {
                throw new AEventSource.NoMoreEventsException("No streams available");
            }
            this.currentStream = streams.firstElement();
            logger.info("Stream not set, using '" + this.currentStream + "'");
        }
        return this.currentStream;
    }
}

