/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event.xmlrpc;

import atlantis.event.xmlrpc.ARemoteCallerException;
import atlantis.utils.ALogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.AsyncCallback;
import org.apache.xmlrpc.client.TimingOutCallback;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class AClientXMLRPC {
    private static final ALogger logger = ALogger.getLogger(AClientXMLRPC.class);
    private String methodName = "";
    private AsyncCallback caller = null;
    private int timeout = 6000;

    public AClientXMLRPC(String method) {
        this.methodName = method;
        this.caller = null;
    }

    public AClientXMLRPC(String method, AsyncCallback caller) {
        this.methodName = method;
        this.caller = caller;
    }

    public void setTimeout(int value) {
        this.timeout = value;
    }

    private void asynchronousCallXMLRPCServer(XmlRpcClient client, Vector params) throws ARemoteCallerException {
        String msg = "";
        logger.debug("Asynchronous XMLRPC call ...");
        try {
            client.executeAsync(this.methodName, (List)params, this.caller);
        }
        catch (Throwable t) {
            msg = t instanceof XmlRpcException ? "XMLRPC exception occured, performing the remote call failed." : "Unspecified exception occured, reason: " + t.getMessage();
            logger.debug(msg, t);
            throw new ARemoteCallerException(msg);
        }
    }

    private String synchronousCallXMLRPCServer(XmlRpcClient client, Vector params) throws ARemoteCallerException {
        String msg = "";
        String result = null;
        logger.debug("Synchronous timing-out XMLRPC call (timeout " + this.timeout / 1000 + "s) ...");
        TimingOutCallback callback = new TimingOutCallback((long)this.timeout);
        try {
            client.executeAsync(this.methodName, (List)params, (AsyncCallback)callback);
        }
        catch (XmlRpcException xmle) {
            msg = "XMLRPC exception occured, performing the remote call failed.";
            logger.debug(msg, xmle);
            throw new ARemoteCallerException(msg);
        }
        try {
            result = (String)callback.waitForResponse();
            logger.debug("Performing timing out XMLRPC call successful.");
        }
        catch (Throwable t) {
            msg = t instanceof InterruptedException ? "The request was interrupted, timed out after " + this.timeout / 1000 + "s, try increasing the timer." : (t instanceof TimingOutCallback.TimeoutException ? "No response was received after waiting " + this.timeout / 1000 + "s, try increasing the timer." : "An error was returned by the server, reason: " + t.getMessage());
            logger.debug(msg, t);
            throw new ARemoteCallerException(msg);
        }
        return result;
    }

    public String callXMLRPCServer(String serverName, int port, Vector params) throws ARemoteCallerException {
        XmlRpcClient client = null;
        String result = null;
        String msg = null;
        msg = "Calling " + serverName + ":" + port;
        logger.info(msg);
        try {
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(serverName + ":" + port));
            client = new XmlRpcClient();
            client.setConfig((XmlRpcClientConfig)config);
            logger.debug("XMLRPC client instantiated successfully.");
        }
        catch (Throwable t) {
            msg = t instanceof MalformedURLException ? "Could not create XMLRPC client, bad address  " + serverName + ":" + port + "\n" + "reason: " + t.getMessage() : "Unspecified exception occured\nreason: " + t.getMessage();
            logger.debug(msg, t);
            throw new ARemoteCallerException(msg);
        }
        if (this.caller != null) {
            this.asynchronousCallXMLRPCServer(client, params);
        } else {
            result = this.synchronousCallXMLRPCServer(client, params);
        }
        client = null;
        return result;
    }
}

