/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event.xmlrpc;

import atlantis.utils.ALogger;
import java.io.IOException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;

public class AServerXMLRPC {
    private static ALogger logger = ALogger.getLogger(AServerXMLRPC.class);
    private WebServer m_ws;

    public AServerXMLRPC(int port, Class handler) throws XmlRpcException {
        logger.debug("Attempting to create XMLRPC server on port " + port);
        logger.debug("Serving requests to handler of type " + handler.getName());
        this.m_ws = new WebServer(port);
        XmlRpcStreamServer xmlRpcServer = this.m_ws.getXmlRpcServer();
        PropertyHandlerMapping phm = new PropertyHandlerMapping();
        phm.addHandler(handler.getName(), handler);
        xmlRpcServer.setHandlerMapping((XmlRpcHandlerMapping)phm);
        logger.debug("XMLRPC server created successfully");
    }

    public void start() throws IOException {
        logger.debug("Attempting to start XMLRPC server");
        this.m_ws.start();
        logger.info("XMLRPC server started");
    }
}

