/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event.xmlrpc;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.data.AEventFromXML;
import atlantis.event.AEvent;
import atlantis.event.AEventManager;
import atlantis.event.AEventSource;
import atlantis.graphics.encoders.AImageEncoder;
import atlantis.utils.ALogger;
import java.io.ByteArrayInputStream;

public class AServerXMLRPCEventSource
implements AEventSource {
    private static ALogger logger = ALogger.getLogger(AServerXMLRPCEventSource.class);
    private AEventManager m_aem;
    private ACanvas m_canv;
    private AImageEncoder m_ie;
    private AEvent m_event = null;
    private String m_sourcename = "";
    private AEventSource.NavigationMode eventNavigationMode = AEventSource.NavigationMode.PUSH;

    public AServerXMLRPCEventSource() {
        this.m_aem = Atlantis.getEventManager();
        this.m_canv = ACanvas.getCanvas();
        this.m_ie = new AImageEncoder();
    }

    public String getVersion() {
        return Atlantis.versionAtlantisJava;
    }

    public boolean isReady() {
        return true;
    }

    public boolean shutdown() {
        logger.info("Exiting atlantis...");
        System.exit(0);
        return true;
    }

    public AEventSource.NavigationMode getNavigationMode() {
        return this.eventNavigationMode;
    }

    public boolean supportsNavigationMode(AEventSource.NavigationMode mode) {
        return mode == AEventSource.NavigationMode.PUSH;
    }

    public void setNavigationMode(AEventSource.NavigationMode mode) throws AEventSource.InvalidEventSourceException {
        if (mode != AEventSource.NavigationMode.PUSH) {
            throw new AEventSource.InvalidEventSourceException("Mode '" + mode.name() + "' not supported by current source");
        }
        this.eventNavigationMode = mode;
    }

    private void setEventFromBytes(byte[] eventdata, String sourcename) throws Exception {
        AEvent e;
        this.m_event = e = AEventFromXML.read(new ByteArrayInputStream(eventdata), sourcename);
        this.m_sourcename = sourcename;
        this.m_aem.setEventSource(this);
        this.m_aem.nextEvent();
    }

    private byte[] getSingleImage(int w, int h, String type, double s) throws Exception {
        if (type.equalsIgnoreCase("png")) {
            return this.m_ie.getPNGData(w, h);
        }
        if (type.equalsIgnoreCase("scaledpng")) {
            return this.m_ie.getScaledPNGData(w, h, s);
        }
        throw new Exception("Unknown image format: " + type);
    }

    private byte[] getSingleImageAspect(int w, String type, double s) throws Exception {
        int h = this.m_canv.getRespectiveHeight(w);
        return this.getSingleImage(w, h, type, s);
    }

    public byte[][] generateDefaultImages(byte[] eventdata, String sourcename, int width, double thumb_scale) {
        byte[][] ret = new byte[2][];
        try {
            this.setEventFromBytes(eventdata, sourcename);
            ret[0] = this.getSingleImageAspect(width, "png", 0.0);
            ret[1] = this.getSingleImageAspect(width, "scaledpng", thumb_scale);
        }
        catch (Exception e) {
            logger.error("Error while handling request to generateDefaultImages()", e);
            return null;
        }
        return ret;
    }

    public AEvent nextEvent() throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        if (this.m_event == null) {
            throw new AEventSource.InvalidEventSourceException();
        }
        return this.m_event;
    }

    public AEvent previousEvent() throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        throw new AEventSource.NoMoreEventsException();
    }

    public String getSourceName() {
        return this.m_sourcename;
    }
}

