/*
 * Decompiled with CFR 0.152.
 */
package atlantis.event.xmlrpc;

import atlantis.data.AEventFromXML;
import atlantis.event.ABufferedEventSource;
import atlantis.event.AEvent;
import atlantis.event.AEventInfo;
import atlantis.event.AEventSource;
import atlantis.event.xmlrpc.AClientXMLRPC;
import atlantis.event.xmlrpc.ARemoteCallerException;
import atlantis.utils.ALogger;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class AXMLRPCEventSource
extends ABufferedEventSource {
    private static final ALogger logger = ALogger.getLogger(AXMLRPCEventSource.class);
    private AClientXMLRPC XMLRPCClient = null;
    private static final String GETEVENTDATA = "getEventData";
    private static final int DEFAULT_TIMEOUT = 2000;
    private String localMachineName = "<unknown>";
    private String remoteMachineName = null;
    private Integer portNumber = null;
    private Integer timeOut = null;

    public AXMLRPCEventSource(String sourceName) throws AEventSource.InvalidEventSourceException {
        sourceName = sourceName.replaceFirst("xmlrpc://", "");
        String[] sourceParams = sourceName.split(":");
        if (sourceParams.length != 2) {
            throw new AEventSource.InvalidEventSourceException("Invalid <server:port> specification: " + sourceName);
        }
        int port = -1;
        try {
            port = Integer.decode(sourceParams[1]);
        }
        catch (NumberFormatException nfe) {
            throw new AEventSource.InvalidEventSourceException("Invalid port number: " + sourceParams[1]);
        }
        if (port < 0) {
            throw new AEventSource.InvalidEventSourceException("Invalid port number: " + port);
        }
        this.CreateXMLRPCEventSource(sourceParams[0], port, 2000);
    }

    public AXMLRPCEventSource(String serverName, int port, int timeout) throws AEventSource.InvalidEventSourceException {
        this.CreateXMLRPCEventSource(serverName, port, timeout);
    }

    public String getSourceName() {
        return "xmlrpc://" + this.remoteMachineName + ":" + this.portNumber;
    }

    public boolean supportsNavigationMode(AEventSource.NavigationMode mode) {
        return mode == AEventSource.NavigationMode.SEQUENTIAL;
    }

    private void CreateXMLRPCEventSource(String serverName, int port, int timeout) throws AEventSource.InvalidEventSourceException {
        this.remoteMachineName = serverName;
        this.portNumber = port;
        this.timeOut = timeout;
        try {
            this.localMachineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            String msg = "Unable to obtain local machine name, using \"" + this.localMachineName + "\" instead";
            logger.error(msg);
        }
        catch (Exception ex) {
            throw new AEventSource.InvalidEventSourceException("Exception trying to obtain local machine name", ex);
        }
        this.XMLRPCClient = new AClientXMLRPC(GETEVENTDATA);
    }

    protected AEvent readNext(AEventInfo currentEvent) throws AEventSource.NoMoreEventsException, AEventSource.InvalidEventSourceException, AEventSource.ReadEventException {
        logger.info("Call to remote server xmlrpc://" + this.remoteMachineName + ":" + this.portNumber.toString());
        Vector<String> parameters = new Vector<String>();
        parameters.add(this.localMachineName);
        long startTime = System.currentTimeMillis();
        String eventXMLData = null;
        try {
            eventXMLData = this.XMLRPCClient.callXMLRPCServer("http://" + this.remoteMachineName, this.portNumber, parameters);
        }
        catch (ARemoteCallerException ex) {
            String msg = "readNext(): Exception while calling remote server";
            logger.error(msg, ex);
            throw new AEventSource.InvalidEventSourceException(msg, ex);
        }
        long callDuration = System.currentTimeMillis() - startTime;
        logger.debug("Received " + eventXMLData.length() + " bytes in " + callDuration + " ms");
        if (eventXMLData.length() == 0) {
            throw new AEventSource.NoMoreEventsException("No event available from the server (yet)");
        }
        if (!eventXMLData.startsWith("<?xml")) {
            String msg = "Invalid event data received from JiveXML server";
            logger.error(msg);
            throw new AEventSource.ReadEventException(msg);
        }
        logger.info("Received data from remote server, going to process it ...");
        ByteArrayInputStream bais = new ByteArrayInputStream(eventXMLData.getBytes());
        AEvent event = AEventFromXML.read(bais, this.remoteMachineName + ":" + this.portNumber);
        if (event.equals(currentEvent)) {
            String msg = "Already have event " + event.getEventNumber() + " in run " + event.getRunNumber() + " - ignored!";
            throw new AEventSource.NoMoreEventsException(msg);
        }
        return event;
    }

    protected AEvent readPrevious(AEventInfo currentEvent) throws AEventSource.NoMoreEventsException {
        throw new AEventSource.NoMoreEventsException("XMLRPC server does not provide a previous event");
    }
}

