/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.config.ADefaultValues;
import atlantis.geometry.ABoxDetectors;
import atlantis.geometry.ADetectorSystem;
import atlantis.geometry.ADetectors;
import atlantis.geometry.AGeneralDetectors;
import atlantis.geometry.AGeometryFromXMLReader;
import atlantis.geometry.ATrapezoidDetectors;
import atlantis.utils.ALogger;
import java.util.regex.Pattern;

public class AAtlasDetector
extends ADetectorSystem {
    private static ALogger logger = ALogger.getLogger(AAtlasDetector.class);

    public AAtlasDetector(String geomIdCalo) {
        super(new ADetectors[]{new AGeneralDetectors(new AGeometryFromXMLReader().readDetectorGeometryFromXML(geomIdCalo))});
        logger.info("Using geometry file: " + geomIdCalo);
        AAtlasDetector.setGeometryName(geomIdCalo);
    }

    public AAtlasDetector(String geomIdCalo, String geomMuon) {
        super(new ADetectors[]{new ABoxDetectors(new AGeometryFromXMLReader().readDetectorGeometryFromXML(geomMuon)), new ATrapezoidDetectors(new AGeometryFromXMLReader().readDetectorGeometryFromXML(geomMuon)), new AGeneralDetectors(new AGeometryFromXMLReader().readDetectorGeometryFromXML(geomMuon)), new AGeneralDetectors(new AGeometryFromXMLReader().readDetectorGeometryFromXML(geomIdCalo))});
        logger.info("Using geometry file: " + geomIdCalo);
        logger.info("Using geometry file: " + geomMuon);
        AAtlasDetector.setGeometryName(geomIdCalo);
    }

    private static void setGeometryName(String absFileName) {
        String name = "AGeometry";
        String ext = ".xml";
        String pattern = ".*" + name + "_?.*" + ext;
        if (Pattern.compile(pattern).matcher(absFileName).matches()) {
            int s = absFileName.lastIndexOf(name);
            int e = absFileName.lastIndexOf(ext);
            String r = absFileName.substring(s + name.length(), e);
            if (r.startsWith("_")) {
                geometryName = r.substring(1);
                ADefaultValues.set("GeometryName", geometryName);
            } else if ("".equals(r)) {
                geometryName = "<default>";
                ADefaultValues.set("GeometryName", "");
            } else {
                geometryName = r;
                ADefaultValues.set("GeometryName", geometryName);
            }
        } else {
            logger.warn("Geometry name not matching regular expression: " + pattern + "\n  geometry name will be: n/a");
            geometryName = "n/a";
        }
    }
}

