/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.AClipper;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.utils.AMath;

public class ABarrelCalorimeterDetector
extends ACalorimeterDetector {
    public ABarrelCalorimeterDetector(String name, String color, int sampling, int region, double rMin, double rMax, double zMin, double zMax, double eta0, double deta, int neta, int meta, double phi0, int nphi) {
        super(name, color);
        this.sampling = Math.abs(sampling);
        this.region = Math.abs(region);
        this.rMin = rMin;
        this.rMax = rMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.eta0 = eta0;
        this.deltaEta = deta;
        this.numEta = neta;
        this.minEta = meta;
        this.phi0 = Math.toRadians(phi0);
        this.numPhi = nphi;
        this.deltaPhi = Math.PI * 2 / (double)this.numPhi;
        this.detEtaMin = AMath.etaAbs(this.zMax, this.rMax);
        this.detEtaMax = AMath.etaAbs(this.zMin, this.rMin);
        if (this.eta0 <= 0.0) {
            this.zMin = -this.zMax;
            this.detEtaMin = -this.detEtaMax;
        }
        this.clipper = new AClipper(this.zMin, this.zMax, this.rMin, this.rMax);
        if (this.name.indexOf("LAr") >= 0 && this.sampling < lar[1].length && this.region < lar[1][this.sampling].length) {
            ABarrelCalorimeterDetector.lar[1][this.sampling][this.region] = detectors.indexOf(this);
        } else if (this.name.equals("TILE Barrel") && this.sampling < tile.length) {
            ABarrelCalorimeterDetector.tile[this.sampling] = detectors.indexOf(this);
        } else if (this.name.equals("Extended TILE") && this.sampling < tile_ext.length) {
            ABarrelCalorimeterDetector.tile_ext[this.sampling] = detectors.indexOf(this);
        } else {
            System.out.println("Unknown calorimeter object: '" + this.name + "'" + " some hits might not be displayed correctly.");
        }
    }

    protected ACoord getYXUser() {
        int numPoints = 2 * (this.numPhi + 1);
        double[][] hv = new double[2][numPoints];
        for (int i = 0; i < this.numPhi + 1; ++i) {
            hv[0][i] = this.rMin * Math.cos(this.phi0 + (double)i * this.deltaPhi);
            hv[1][i] = this.rMin * Math.sin(this.phi0 + (double)i * this.deltaPhi);
            hv[0][this.numPhi + 1 + i] = this.rMax * Math.cos(this.phi0 - (double)i * this.deltaPhi);
            hv[1][this.numPhi + 1 + i] = this.rMax * Math.sin(this.phi0 - (double)i * this.deltaPhi);
        }
        return new ACoord(hv);
    }

    protected ACoord getRZUser() {
        double[] v;
        double[] h;
        double etaMax = this.eta0 + (double)this.numEta * this.deltaEta;
        double etaMin = this.eta0 <= 0.0 ? -etaMax : this.eta0;
        if (this.name.indexOf("TILE") >= 0) {
            h = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
            v = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        } else {
            double z0 = this.rMax * Math.sinh(etaMax);
            double z1 = this.rMax * Math.sinh(etaMin);
            double z2 = this.rMin * Math.sinh(etaMin);
            double z3 = this.rMin * Math.sinh(etaMax);
            h = new double[]{z0, z1, z2, z3};
            v = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        }
        ACoord coord = this.clipper.clipPolygon(h, v, h.length);
        coord = new ACoord(coord, coord.mirrorV());
        if (this.eta0 > 0.0) {
            coord = new ACoord(coord, coord.mirrorH());
        }
        return coord;
    }

    protected ACoord getFRUser() {
        double[][] hv = new double[][]{{this.rMin, this.rMax, this.rMax, this.rMin}, {360.0, 360.0, 0.0, 0.0}};
        return new ACoord(hv);
    }

    public ACoord getYXCell(int eta, int phi) {
        if (APar.get("YX", "Mode").getI() != 0) {
            return ACoord.NO_DATA;
        }
        double[][] hv = new double[2][];
        double phiMin = this.phi0 + (double)phi * this.deltaPhi;
        double phiMax = phiMin + this.deltaPhi;
        hv[0] = new double[]{this.rMax * Math.cos(phiMin), this.rMax * Math.cos(phiMax), this.rMin * Math.cos(phiMax), this.rMin * Math.cos(phiMin)};
        hv[1] = new double[]{this.rMax * Math.sin(phiMin), this.rMax * Math.sin(phiMax), this.rMin * Math.sin(phiMax), this.rMin * Math.sin(phiMin)};
        return new ACoord(hv);
    }

    public ACoord getRZCell(int eta, int phi, int side) {
        double etaMax;
        double etaMin;
        double[][] hv = new double[2][];
        int sign = this.getRSign(phi);
        if (side != 0) {
            side /= Math.abs(side);
        }
        if (this.name.indexOf("TILE") >= 0) {
            if (this.sampling == 2) {
                eta = this.minEta + (eta - this.minEta) / 2;
            }
            etaMin = this.eta0 + (double)(eta - this.minEta) * this.deltaEta;
            etaMax = etaMin + this.deltaEta;
            if (this.name.indexOf("Barrel") >= 0 && this.sampling == 1) {
                double dr = this.rMax - this.rMin;
                double r0 = this.rMin;
                double r1 = this.rMin + dr / 2.0;
                double r2 = this.rMax;
                double z0 = (this.rMin + dr / 4.0) * Math.sinh(etaMin);
                double z1 = (this.rMax - dr / 4.0) * Math.sinh(etaMin);
                double z2 = (this.rMin + dr / 4.0) * Math.sinh(etaMax);
                double z3 = (this.rMax - dr / 4.0) * Math.sinh(etaMax);
                if (eta == this.minEta && this.zMin > 0.0) {
                    z0 = z1 = this.zMin;
                }
                if (eta == this.minEta + this.numEta - 1) {
                    z2 = z3 = this.zMax;
                }
                hv[0] = new double[]{z3, z1, z1, z0, z0, z2, z2, z3};
                hv[1] = new double[]{r2, r2, r1, r1, r0, r0, r1, r1};
            } else {
                double zMin = (this.rMin + this.rMax) / 2.0 * Math.sinh(etaMin);
                double zMax = (this.rMin + this.rMax) / 2.0 * Math.sinh(etaMax);
                if (eta == this.minEta && this.zMin > 0.0) {
                    zMin = this.zMin;
                }
                if (eta == this.minEta + this.numEta - 1) {
                    zMax = this.zMax;
                }
                hv[0] = new double[]{zMax, zMin, zMin, zMax};
                hv[1] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
            }
        } else if (this.name.indexOf("LAr") >= 0) {
            etaMin = this.eta0 + (double)(eta - this.minEta) * this.deltaEta;
            etaMax = etaMin + this.deltaEta;
            hv[0] = new double[]{this.rMax * Math.sinh(etaMax), this.rMax * Math.sinh(etaMin), this.rMin * Math.sinh(etaMin), this.rMin * Math.sinh(etaMax)};
            hv[1] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        } else {
            return ACoord.NO_DATA;
        }
        ACoord coord = this.clipper.clipPolygon(hv[0], hv[1], hv[0].length);
        int i = 0;
        while (i < coord.hv[0][0].length) {
            double[] dArray = coord.hv[0][0];
            int n = i;
            dArray[n] = dArray[n] * (double)side;
            double[] dArray2 = coord.hv[1][0];
            int n2 = i++;
            dArray2[n2] = dArray2[n2] * (double)sign;
        }
        return coord;
    }

    public ACoord getVPCell(int eta, int phi, int side) {
        double[][] hv = new double[2][];
        double etaMin = this.eta0 + (double)(eta - this.minEta) * this.deltaEta;
        double etaMax = etaMin + this.deltaEta;
        double phiMin = Math.toDegrees(this.phi0 + (double)phi * this.deltaPhi);
        double phiMax = phiMin + Math.toDegrees(this.deltaPhi);
        side /= Math.abs(side);
        hv[0] = new double[]{(double)side * etaMax, (double)side * etaMin, (double)side * etaMin, (double)side * etaMax};
        hv[1] = new double[]{phiMax, phiMax, phiMin, phiMin};
        return new ACoord(hv);
    }

    public double getEta(int eta, int side) {
        if (side < 0) {
            return -this.getEta(eta, -side);
        }
        if (this.name.indexOf("TILE") >= 0 && this.sampling == 2) {
            eta = this.minEta + (eta - this.minEta) / 2;
        }
        return this.eta0 + ((double)(eta - this.minEta) + 0.5) * this.deltaEta;
    }
}

