/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.canvas.AWindow;
import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionYX;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ABarrelSiliconDetector
extends ADetector {
    private static List detectors = null;
    protected int layer;
    protected double length;
    protected double width;
    protected double thickness;
    protected int numZ;
    protected int numPhi;
    protected double tilt;
    protected double r0;
    protected double phi0;
    protected double zMin;
    protected double zMax;
    protected double deltaPhi;
    protected double deltaZ;
    protected double rMin;
    protected double rMax;

    public ABarrelSiliconDetector(String name, String color, int layer, double length, double width, double thickness, int numZ, int numPhi, double tilt, double r0, double phi0, double zMin, double zMax) {
        super(name, " ", color);
        if (detectors == null) {
            detectors = new ArrayList();
        }
        detectors.add(this);
        this.layer = layer;
        this.length = length;
        this.width = width;
        this.thickness = thickness;
        this.numZ = numZ;
        this.numPhi = numPhi;
        this.tilt = Math.toRadians(tilt);
        this.r0 = r0;
        this.phi0 = Math.toRadians(phi0);
        this.zMin = zMin;
        this.zMax = zMax;
        this.deltaPhi = Math.PI * 2 / (double)this.numPhi;
        this.deltaZ = (this.zMax - this.zMin) / (double)this.numZ;
        this.rMin = this.r0 - Math.abs(this.thickness * Math.cos(this.tilt)) - Math.abs(this.width * Math.sin(this.tilt));
        this.rMax = this.r0 + Math.abs(this.thickness * Math.cos(this.tilt)) + Math.abs(this.width * Math.sin(this.tilt));
    }

    public static void clear() {
        if (detectors != null) {
            detectors.clear();
        }
    }

    public static void drawAdditionalItems(AWindow window, AGraphics ag, AProjection2D projection) {
        AParameter inDetDetail = APar.getUnknown("Det", "SiliconDetail");
        if (inDetDetail != null && detectors != null && inDetDetail.getStatus()) {
            for (int i = 0; i < detectors.size(); ++i) {
                ACoord coord = ACoord.NO_DATA;
                ABarrelSiliconDetector detector = (ABarrelSiliconDetector)detectors.get(i);
                if (projection instanceof AProjectionYX) {
                    coord = detector.getYXDetail();
                } else if (projection instanceof AProjectionRZ) {
                    coord = detector.getRZDetail();
                } else if (projection instanceof AProjectionFZ) {
                    coord = detector.getFZDetail();
                } else if (projection instanceof AProjectionFR) {
                    coord = detector.getYXDetail().convertYXToFR().includePhiWrapAround("FR");
                }
                if (coord == ACoord.NO_DATA) continue;
                Color[] colorMap = AColorMap.getColors();
                ag.setColor(colorMap[APar.get("Det", "SiliconDetail").getI()]);
                ACoord display = window.calculateDisplay(projection.nonLinearTransform(coord));
                for (int j = 0; j < display.hv[0].length; ++j) {
                    ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
                }
            }
        }
    }

    protected boolean isVisible() {
        int cut = APar.get("CutsInDet", "SCT").getI();
        return cut == -1 || cut == 1;
    }

    protected ACoord getYXUser() {
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        if (APar.get("YX", "Mode").getI() != 0) {
            return ACoord.NO_DATA;
        }
        int numPoints = 2 * (this.numPhi + 1);
        double[][] hv = new double[2][numPoints];
        for (int i = 0; i < this.numPhi + 1; ++i) {
            hv[0][i] = this.rMin * Math.cos(this.phi0 + ((double)i + 0.5) * this.deltaPhi);
            hv[1][i] = this.rMin * Math.sin(this.phi0 + ((double)i + 0.5) * this.deltaPhi);
            hv[0][this.numPhi + 1 + i] = this.rMax * Math.cos(this.phi0 - ((double)i + 0.5) * this.deltaPhi);
            hv[1][this.numPhi + 1 + i] = this.rMax * Math.sin(this.phi0 - ((double)i + 0.5) * this.deltaPhi);
        }
        return new ACoord(hv);
    }

    protected ACoord getRZUser() {
        double[][][] hv = new double[2][2][];
        hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][0] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        hv[0][1] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][1] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        return new ACoord(hv);
    }

    protected ACoord getFZUser() {
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        double[][] hv = new double[][]{{this.zMax, this.zMin, this.zMin, this.zMax}, {360.0, 360.0, 0.0, 0.0}};
        return new ACoord(hv);
    }

    protected ACoord getFRUser() {
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        double[][] hv = new double[][]{{this.rMin, this.rMax, this.rMax, this.rMin}, {360.0, 360.0, 0.0, 0.0}};
        return new ACoord(hv);
    }

    protected ACoord getYXDetail() {
        if (APar.get("YX", "Mode").getI() != 0) {
            return ACoord.NO_DATA;
        }
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        double[][][] hv = new double[2][this.numPhi][];
        for (int i = 0; i < this.numPhi; ++i) {
            double phi = this.phi0 + (double)i * this.deltaPhi;
            double x1 = this.r0 * Math.cos(phi) + this.width / 2.0 * Math.sin(phi + this.tilt) + this.thickness / 2.0 * Math.cos(phi + this.tilt);
            double x2 = this.r0 * Math.cos(phi) - this.width / 2.0 * Math.sin(phi + this.tilt) + this.thickness / 2.0 * Math.cos(phi + this.tilt);
            double x3 = this.r0 * Math.cos(phi) - this.width / 2.0 * Math.sin(phi + this.tilt) - this.thickness / 2.0 * Math.cos(phi + this.tilt);
            double x4 = this.r0 * Math.cos(phi) + this.width / 2.0 * Math.sin(phi + this.tilt) - this.thickness / 2.0 * Math.cos(phi + this.tilt);
            double y1 = this.r0 * Math.sin(phi) - this.width / 2.0 * Math.cos(phi + this.tilt) + this.thickness / 2.0 * Math.sin(phi + this.tilt);
            double y2 = this.r0 * Math.sin(phi) + this.width / 2.0 * Math.cos(phi + this.tilt) + this.thickness / 2.0 * Math.sin(phi + this.tilt);
            double y3 = this.r0 * Math.sin(phi) + this.width / 2.0 * Math.cos(phi + this.tilt) - this.thickness / 2.0 * Math.sin(phi + this.tilt);
            double y4 = this.r0 * Math.sin(phi) - this.width / 2.0 * Math.cos(phi + this.tilt) - this.thickness / 2.0 * Math.sin(phi + this.tilt);
            hv[0][i] = new double[]{x1, x2, x3, x4};
            hv[1][i] = new double[]{y1, y2, y3, y4};
        }
        return new ACoord(hv);
    }

    protected ACoord getRZDetail() {
        double[][][] hv = new double[2][2 * this.numZ][];
        for (int i = 0; i < this.numZ; ++i) {
            hv[0][i] = new double[]{this.zMin + (double)(i + 1) * this.deltaZ, this.zMin + (double)i * this.deltaZ, this.zMin + (double)i * this.deltaZ, this.zMin + (double)(i + 1) * this.deltaZ};
            hv[1][i] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
            hv[0][this.numZ + i] = new double[]{this.zMin + (double)(i + 1) * this.deltaZ, this.zMin + (double)i * this.deltaZ, this.zMin + (double)i * this.deltaZ, this.zMin + (double)(i + 1) * this.deltaZ};
            hv[1][this.numZ + i] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        }
        return new ACoord(hv);
    }

    protected ACoord getFZDetail() {
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        double[][][] hv = new double[2][this.numZ + 1][2];
        for (int i = 0; i <= this.numZ; ++i) {
            hv[0][i][0] = this.zMin + (double)i * this.deltaZ;
            hv[1][i][0] = 360.0;
            hv[0][i][1] = this.zMin + (double)i * this.deltaZ;
            hv[1][i][1] = 0.0;
        }
        return new ACoord(hv).includePhiWrapAround("FZ");
    }
}

