/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.canvas.AWindow;
import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionYX;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ABarrelTRTDetector
extends ADetector {
    private static List detectors = null;
    protected int layer;
    protected int numPhi;
    protected double rMin;
    protected double rMax;
    protected double phiIn;
    protected double phiOut;
    protected double zMin;
    protected double zMax;
    protected double deltaPhi;

    public ABarrelTRTDetector(String name, String color, int layer, int numPhi, double rMin, double rMax, double phiIn, double phiOut, double zMin, double zMax) {
        super(name, " ", color);
        if (detectors == null) {
            detectors = new ArrayList();
        }
        detectors.add(this);
        this.layer = layer;
        this.numPhi = numPhi;
        this.rMin = rMin;
        this.rMax = rMax;
        this.phiIn = Math.toRadians(phiIn);
        this.phiOut = Math.toRadians(phiOut);
        this.zMin = zMin;
        this.zMax = zMax;
        this.deltaPhi = Math.PI * 2 / (double)numPhi;
    }

    public static void clear() {
        if (detectors != null) {
            detectors.clear();
        }
    }

    public static void drawAdditionalItems(AWindow window, AGraphics ag, AProjection2D projection) {
        AParameter inDetDetail = APar.getUnknown("Det", "TRTDetail");
        if (inDetDetail != null && detectors != null && inDetDetail.getStatus()) {
            for (int i = 0; i < detectors.size(); ++i) {
                ACoord coord = ACoord.NO_DATA;
                ABarrelTRTDetector detector = (ABarrelTRTDetector)detectors.get(i);
                if (projection instanceof AProjectionYX) {
                    coord = detector.getYXDetail();
                } else if (projection instanceof AProjectionFR) {
                    coord = detector.getYXDetail().convertYXToFR().includePhiWrapAround("FR");
                }
                if (coord == ACoord.NO_DATA) continue;
                Color[] colorMap = AColorMap.getColors();
                ag.setColor(colorMap[APar.get("Det", "TRTDetail").getI()]);
                ACoord display = window.calculateDisplay(projection.nonLinearTransform(coord));
                for (int j = 0; j < display.hv[0].length; ++j) {
                    ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
                }
            }
        }
    }

    protected ACoord getYXUser() {
        if (APar.get("YX", "Mode").getI() != 0) {
            return ACoord.NO_DATA;
        }
        int numPoints = 2 * (this.numPhi + 1);
        double[][] hv = new double[2][numPoints];
        for (int i = 0; i < this.numPhi + 1; ++i) {
            hv[0][i] = this.rMin * Math.cos(this.phiIn + (double)i * this.deltaPhi);
            hv[1][i] = this.rMin * Math.sin(this.phiIn + (double)i * this.deltaPhi);
            hv[0][this.numPhi + 1 + i] = this.rMax * Math.cos(this.phiOut - (double)i * this.deltaPhi);
            hv[1][this.numPhi + 1 + i] = this.rMax * Math.sin(this.phiOut - (double)i * this.deltaPhi);
        }
        return new ACoord(hv);
    }

    protected ACoord getRZUser() {
        double[][][] hv = new double[2][2][];
        hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][0] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        hv[0][1] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][1] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        return new ACoord(hv);
    }

    protected ACoord getFZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getFRUser() {
        double[][] hv = new double[][]{{this.rMin, this.rMax, this.rMax, this.rMin}, {360.0, 360.0, 0.0, 0.0}};
        return new ACoord(hv);
    }

    protected ACoord getYXDetail() {
        if (APar.get("YX", "Mode").getI() != 0) {
            return ACoord.NO_DATA;
        }
        double[][][] hv = new double[2][this.numPhi][];
        for (int i = 0; i < this.numPhi; ++i) {
            double phiMin = (double)i * this.deltaPhi;
            double phiMax = (double)(i + 1) * this.deltaPhi;
            double x1 = this.rMax * Math.cos(phiMin + this.phiOut);
            double x2 = this.rMax * Math.cos(phiMax + this.phiOut);
            double x3 = this.rMin * Math.cos(phiMax + this.phiIn);
            double x4 = this.rMin * Math.cos(phiMin + this.phiIn);
            double y1 = this.rMax * Math.sin(phiMin + this.phiOut);
            double y2 = this.rMax * Math.sin(phiMax + this.phiOut);
            double y3 = this.rMin * Math.sin(phiMax + this.phiIn);
            double y4 = this.rMin * Math.sin(phiMin + this.phiIn);
            hv[0][i] = new double[]{x1, x2, x3, x4};
            hv[1][i] = new double[]{y1, y2, y3, y4};
        }
        return new ACoord(hv);
    }
}

