/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AMath;

public class ABoxDetector
extends ADetector {
    double zMin;
    double zMax;
    double rMin;
    double rMax;
    double phi;
    double excl;
    double size;
    String stationName;
    int stationEta;
    int stationPhi;
    int sector;

    public ABoxDetector(String name, double zMin, double zMax, double rMin, double rMax, double phi, double excl, double size, int stationEta, int stationPhi) {
        super(name, " ", name.substring(0, 3));
        this.zMin = zMin;
        this.zMax = zMax;
        this.rMin = rMin;
        this.rMax = rMax;
        this.phi = phi;
        this.excl = excl;
        this.size = size;
        this.stationName = name.substring(4, 7);
        this.stationEta = stationEta;
        this.stationPhi = stationPhi;
        this.sector = (int)((phi + 0.19634954084936207) / 0.39269908169872414) % 16;
    }

    protected ACoord getFZUser() {
        double cosPhi = Math.cos(this.phi);
        double sinPhi = Math.sin(this.phi);
        double d = this.size / 2.0;
        double r = this.rMin;
        double x = r * cosPhi - this.excl * sinPhi;
        double y = r * sinPhi + this.excl * cosPhi;
        double dsinPhi = d * sinPhi;
        double dcosPhi = d * cosPhi;
        double phi1 = Math.toDegrees(Math.atan2(y - dcosPhi, x + dsinPhi));
        double phi2 = Math.toDegrees(Math.atan2(y + dcosPhi, x - dsinPhi));
        if (phi1 < 0.0) {
            phi1 += 360.0;
        }
        if (phi2 < 0.0) {
            phi2 += 360.0;
        }
        if (phi1 - phi2 > 180.0) {
            phi1 -= 360.0;
        }
        if (phi2 - phi1 > 180.0) {
            phi2 -= 360.0;
        }
        return new ACoord(AMath.xBox((this.zMin + this.zMax) / 2.0, (this.zMax - this.zMin) / 2.0), AMath.yBox((phi1 + phi2) / 2.0, (phi1 - phi2) / 2.0));
    }

    protected ACoord getRZUser() {
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        double phiDiff = Math.abs(this.phi - phiMid);
        double sign = -1.0;
        if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
            sign = 1.0;
        }
        return this.getXZRZUser(sign);
    }

    protected ACoord getXZUser() {
        AParameter p = APar.get("XZ", "Phi");
        if (p.getD() % 22.5 < 0.01) {
            int sect = (int)Math.round(p.getD() % 360.0 / 22.5);
            if (this.sector == sect) {
                return this.getXZRZUser(1.0);
            }
            if (this.sector == sect - 8 || this.sector == sect + 8) {
                return this.getXZRZUser(-1.0);
            }
        }
        return ACoord.NO_DATA;
    }

    protected ACoord getXZRZUser(double sign) {
        return new ACoord(AMath.xBox((this.zMin + this.zMax) / 2.0, (this.zMax - this.zMin) / 2.0), AMath.yBox(sign * (this.rMin + this.rMax) / 2.0, sign * (this.rMax - this.rMin) / 2.0));
    }

    protected ACoord getYXUser() {
        return this.getYXUser(0);
    }

    protected ACoord getFRUser() {
        return this.convertYXToFR(this.getYXUser(1));
    }

    private ACoord getYXUser(int flag) {
        boolean splitIt;
        int[] split = new int[]{12, 1, 12, 1};
        int numPoints = 4;
        boolean bl = splitIt = APar.get("YX", "FishEye").getStatus() || APar.get("YX", "Clock").getStatus() || flag == 1;
        if (splitIt) {
            numPoints = 26;
        }
        double[] temp = new double[4];
        double[][] hv = new double[2][numPoints];
        double cosPhi = Math.cos(this.phi);
        double sinPhi = Math.sin(this.phi);
        double d = this.size / 2.0;
        double r = this.rMin;
        double x = r * cosPhi - this.excl * sinPhi;
        double y = r * sinPhi + this.excl * cosPhi;
        double dx = d * sinPhi;
        double dy = d * cosPhi;
        hv[0][0] = x + dx;
        hv[1][0] = y - dy;
        hv[0][1] = x - dx;
        hv[1][1] = y + dy;
        r = this.rMax;
        x = r * cosPhi - this.excl * sinPhi;
        y = r * sinPhi + this.excl * cosPhi;
        hv[0][3] = x + dx;
        hv[1][3] = y - dy;
        hv[0][2] = x - dx;
        hv[1][2] = y + dy;
        if (splitIt) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 4; ++k) {
                    temp[k] = hv[j][k];
                }
                AMath.splitArrayIntoPieces(temp, hv[j], split);
            }
        }
        return new ACoord(hv);
    }

    protected boolean equalsYX(ADetector o) {
        if (o instanceof ABoxDetector) {
            ABoxDetector that = (ABoxDetector)o;
            return this.rMin == that.rMin && this.rMax == that.rMax && this.phi == that.phi && this.size == that.size && this.excl == that.excl;
        }
        return false;
    }

    protected boolean equalsRZ(ADetector o) {
        if (o instanceof ABoxDetector) {
            ABoxDetector that = (ABoxDetector)o;
            return this.rMin == that.rMin && this.rMax == that.rMax && this.zMin == that.zMin && this.zMax == that.zMax;
        }
        return false;
    }

    public double getZMin() {
        return this.zMin;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getRMin() {
        return this.rMin;
    }

    public double getRMax() {
        return this.rMax;
    }

    public double getPhi() {
        return this.phi;
    }

    public double getSize() {
        return this.size;
    }
}

