/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ABoxDetector;
import atlantis.geometry.ADetector;
import atlantis.geometry.ADetectors;
import atlantis.geometry.ATBxDetector;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import java.util.ArrayList;
import java.util.List;

public final class ABoxDetectors
extends ADetectors {
    private int numRZTypes;
    private int[] typeRZ;
    private int numYXTypes;
    private int[] typeYX;
    private ABoxDetector[] box;

    public ABoxDetectors(List detectors) {
        super(ABoxDetectors.filterBoxDetectors(detectors));
        int j;
        int i;
        this.box = new ABoxDetector[this.det.length];
        for (i = 0; i < this.box.length; ++i) {
            this.box[i] = (ABoxDetector)this.det[i];
        }
        this.typeYX = new int[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.typeYX[i] = -1;
        }
        this.numYXTypes = 0;
        for (i = 0; i < this.numData; ++i) {
            if (this.typeYX[i] != -1) continue;
            this.typeYX[i] = this.numYXTypes;
            for (j = i + 1; j < this.numData; ++j) {
                if (this.typeYX[j] != -1 || !this.det[i].equalsYX(this.det[j])) continue;
                this.typeYX[j] = this.numYXTypes;
            }
            ++this.numYXTypes;
        }
        this.typeRZ = new int[this.numData];
        for (i = 0; i < this.numData; ++i) {
            this.typeRZ[i] = -1;
        }
        this.numRZTypes = 0;
        for (i = 0; i < this.numData; ++i) {
            if (this.typeRZ[i] != -1) continue;
            this.typeRZ[i] = this.numRZTypes;
            for (j = i + 1; j < this.numData; ++j) {
                if (this.typeRZ[j] != -1 || !this.det[i].equalsRZ(this.det[j])) continue;
                this.typeRZ[j] = this.numRZTypes;
            }
            ++this.numRZTypes;
        }
    }

    private static ADetector[] filterBoxDetectors(List detectors) {
        ArrayList tempDetectors = new ArrayList(detectors.size());
        for (Object o : detectors) {
            if (!(o instanceof ABoxDetector) && !(o instanceof ATBxDetector)) continue;
            tempDetectors.add(o);
        }
        return tempDetectors.toArray(new ADetector[tempDetectors.size()]);
    }

    private void makeDrawListYX() {
        int mode = APar.get("YX", "Mode").getI();
        if (mode == 0) {
            this.numDraw = this.numYXTypes;
            for (int i = 0; i < this.numData; ++i) {
                this.listdl[this.typeYX[i]] = i;
            }
        } else {
            this.numDraw = 0;
        }
    }

    private void makeDrawListXZ() {
        AParameter p = APar.get("XZ", "Phi");
        if (p.getD() % 22.5 < 0.01) {
            int sect = (int)Math.round(p.getD() % 360.0 / 22.5);
            int num = 0;
            for (int i = 0; i < this.numData; ++i) {
                int s = this.box[i].sector;
                if (s != sect && s != sect - 8 && s != sect + 8) continue;
                this.listdl[num++] = i;
            }
            this.numDraw = num;
        } else {
            this.numDraw = 0;
        }
    }

    private void makeDrawListRZ() {
        int i;
        int[] pos = new int[this.typeRZ.length];
        int[] neg = new int[this.typeRZ.length];
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        for (i = 0; i < this.numRZTypes; ++i) {
            pos[i] = -1;
            neg[i] = -1;
        }
        for (i = 0; i < this.numData; ++i) {
            double phiDiff = Math.abs(this.box[i].phi - phiMid);
            if (phiDiff < 1.5707963267948966 || phiDiff > 4.71238898038469) {
                pos[this.typeRZ[i]] = i;
                continue;
            }
            neg[this.typeRZ[i]] = i;
        }
        int num = 0;
        for (int i2 = 0; i2 < this.numRZTypes; ++i2) {
            if (pos[i2] != -1) {
                this.listdl[num++] = pos[i2];
            }
            if (neg[i2] == -1) continue;
            this.listdl[num++] = neg[i2];
        }
        this.numDraw = num;
    }

    private void makeDrawListFZ() {
        int mode = APar.get("FZ", "Mode").getI();
        if (mode == 0) {
            this.numDraw = 0;
        } else {
            int num = 0;
            for (int i = 0; i < this.numData; ++i) {
                char type = this.det[i].getName().charAt(0);
                char station = this.det[i].getName().charAt(5);
                char io = this.det[i].getName().charAt(this.det[i].getName().length() - 1);
                if (mode == 1 && station == 'M' && io == 'I' && type == 'R' || mode == 2 && station == 'M' && io == 'O' && type == 'R' || mode == 3 && station == 'O' && type == 'R' || mode == 4 && (station == 'I' || station == 'E') && type == 'M' || mode == 5 && station == 'M' && type == 'M' || mode == 6 && station == 'O' && type == 'M') {
                    this.listdl[num++] = i;
                }
                this.numDraw = num;
            }
        }
    }

    protected void makeDrawList(String projection) {
        if (projection.equals("YX") || projection.equals("FR")) {
            this.makeDrawListYX();
        } else if (projection.equals("FZ")) {
            this.makeDrawListFZ();
        } else if (projection.equals("RZ")) {
            this.makeDrawListRZ();
        } else if (projection.equals("XZ")) {
            this.makeDrawListXZ();
        } else {
            this.numDraw = 0;
        }
    }
}

