/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.canvas.AWindow;
import atlantis.geometry.ADetector;
import atlantis.graphics.AClipper;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionYX;
import atlantis.utils.AAtlantisException;
import atlantis.utils.AIdHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public abstract class ACalorimeterDetector
extends ADetector {
    protected static List detectors = null;
    protected static int[][][] lar = null;
    protected static int[][] hec = null;
    protected static int[] tile = null;
    protected static int[] tile_ext = null;
    protected static int[][] tile_gap = null;
    protected static int[] mbts = null;
    protected int sampling;
    protected int region;
    protected double rMin;
    protected double rMax;
    protected double zMin;
    protected double zMax;
    protected double phi0;
    protected int numPhi;
    protected double deltaPhi;
    protected double eta0;
    protected double deltaEta;
    protected int numEta;
    protected int minEta;
    protected double detEtaMin;
    protected double detEtaMax;
    protected AClipper clipper;

    public ACalorimeterDetector(String name, String color) {
        super(name, " ", color);
        if (detectors == null) {
            int j;
            int i;
            detectors = new ArrayList(40);
            lar = new int[4][4][8];
            hec = new int[4][2];
            tile = new int[16];
            tile_ext = new int[16];
            tile_gap = new int[16][64];
            mbts = new int[2];
            for (i = 0; i < lar.length; ++i) {
                for (j = 0; j < lar[i].length; ++j) {
                    for (int k = 0; k < lar[i][j].length; ++k) {
                        ACalorimeterDetector.lar[i][j][k] = -1;
                    }
                }
            }
            for (i = 0; i < hec.length; ++i) {
                for (j = 0; j < hec[i].length; ++j) {
                    ACalorimeterDetector.hec[i][j] = -1;
                }
            }
            for (i = 0; i < tile.length; ++i) {
                ACalorimeterDetector.tile[i] = -1;
            }
            for (i = 0; i < tile_ext.length; ++i) {
                ACalorimeterDetector.tile_ext[i] = -1;
            }
            for (i = 0; i < tile_gap.length; ++i) {
                for (j = 0; j < tile_gap[i].length; ++j) {
                    ACalorimeterDetector.tile_gap[i][j] = -1;
                }
            }
            for (i = 0; i < mbts.length; ++i) {
                ACalorimeterDetector.mbts[i] = -1;
            }
        }
        detectors.add(this);
    }

    public static ACalorimeterDetector get(int index) {
        return (ACalorimeterDetector)detectors.get(index);
    }

    public static int count() {
        if (detectors != null) {
            return detectors.size();
        }
        return 0;
    }

    public static int getDetectorIndex(int id) {
        if (detectors == null) {
            return -1;
        }
        try {
            switch (AIdHelper.subDetector(id)) {
                case 4: {
                    switch (AIdHelper.larPart(id)) {
                        case 1: {
                            return lar[Math.abs(AIdHelper.larBarrelEndcap(id))][AIdHelper.larSampling(id)][AIdHelper.larRegion(id)];
                        }
                        case 2: {
                            return hec[AIdHelper.larSampling(id)][AIdHelper.larRegion(id)];
                        }
                        case 3: {
                            return -1;
                        }
                    }
                    return -1;
                }
                case 5: {
                    switch (AIdHelper.tileSection(id)) {
                        case 1: {
                            return tile[AIdHelper.tileSampling(id)];
                        }
                        case 2: {
                            return tile_ext[AIdHelper.tileSampling(id)];
                        }
                        case 3: {
                            return tile_gap[AIdHelper.tileSampling(id)][AIdHelper.tileTower(id)];
                        }
                        case 4: {
                            return -1;
                        }
                    }
                    return -1;
                }
            }
            return -1;
        }
        catch (AAtlantisException e) {
            return -1;
        }
    }

    public static void clear() {
        if (detectors != null) {
            detectors.clear();
        }
        detectors = null;
        lar = null;
        hec = null;
        tile = null;
        tile_ext = null;
        tile_gap = null;
        mbts = null;
    }

    public ACoord getCell(AProjection projection, int eta, int phi, int side) {
        if (projection instanceof AProjectionYX) {
            return this.getYXCell(eta, phi);
        }
        if (projection instanceof AProjectionRZ) {
            return this.getRZCell(eta, phi, side);
        }
        if (projection instanceof AProjectionFR) {
            return this.getFRCell(eta, phi);
        }
        if (projection instanceof AProjectionFZ) {
            return this.getFZCell(eta, phi, side);
        }
        if (projection instanceof AProjectionVP) {
            return this.getVPCell(eta, phi, side);
        }
        return ACoord.NO_DATA;
    }

    public ACoord getYXCell(int eta, int phi) {
        return ACoord.NO_DATA;
    }

    public ACoord getRZCell(int eta, int phi, int side) {
        return ACoord.NO_DATA;
    }

    public ACoord getFRCell(int eta, int phi) {
        return this.convertYXToFR(this.getYXCell(eta, phi));
    }

    public ACoord getFZCell(int eta, int phi, int side) {
        return ACoord.NO_DATA;
    }

    public ACoord getVPCell(int eta, int phi, int side) {
        return ACoord.NO_DATA;
    }

    public double getEta(int eta, int side) {
        if (side < 0) {
            return -this.getEta(eta, -side);
        }
        return this.eta0 + ((double)(eta - this.minEta) + 0.5) * this.deltaEta;
    }

    public double getEtaMin(int eta, int side) {
        if (side < 0) {
            return -this.getEtaMax(eta, -side);
        }
        return this.eta0 + (double)(eta - this.minEta) * this.deltaEta;
    }

    public double getEtaMax(int eta, int side) {
        if (side < 0) {
            return -this.getEtaMin(eta, -side);
        }
        return this.eta0 + (double)(eta - this.minEta + 1) * this.deltaEta;
    }

    public double getPhi(int phi) {
        return this.phi0 + ((double)phi + 0.5) * this.deltaPhi;
    }

    public double getPhiMin(int phi) {
        return this.phi0 + (double)phi * this.deltaPhi;
    }

    public double getPhiMax(int phi) {
        return this.phi0 + (double)(phi + 1) * this.deltaPhi;
    }

    public int getRSign(int phi) {
        double cellPhi = this.phi0 + (double)phi * this.deltaPhi + this.deltaPhi / 2.0;
        double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
        double phiDiff = Math.abs(cellPhi - phiMid);
        if (phiDiff <= 1.5707963267948966 || phiDiff > 4.71238898038469) {
            return 1;
        }
        return -1;
    }

    public int getNumPhi() {
        return this.numPhi;
    }

    public double getDeltaPhi() {
        return this.deltaPhi;
    }

    public int getNumEta() {
        return this.numEta;
    }

    public double getDeltaEta() {
        return this.deltaEta;
    }

    public double getR() {
        return (this.rMin + this.rMax) / 2.0;
    }

    public double getRMin() {
        return this.rMin;
    }

    public double getRMax() {
        return this.rMax;
    }

    public double getZ() {
        return (this.zMin + this.zMax) / 2.0;
    }

    public double getZMin() {
        return this.zMin;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getEtaMin() {
        return this.eta0;
    }

    public double getEtaMax() {
        return this.eta0 + (double)this.numEta * this.deltaEta;
    }

    public int getSampling() {
        return this.sampling;
    }

    public int getRegion() {
        return this.region;
    }

    public int getFirstEta() {
        return this.minEta;
    }

    public int getLastEta() {
        if (this.sampling == 2 && this.name.indexOf("TILE") >= 0) {
            return this.minEta + 2 * this.numEta;
        }
        return this.minEta + this.numEta - 1;
    }

    public int getFirstPhi() {
        return 0;
    }

    public int getLastPhi() {
        return this.numPhi - 1;
    }

    public static void drawAdditionalItems(AWindow window, AGraphics ag, AProjection2D projection) {
        AParameter caloDetail = APar.getUnknown("Det", "CaloDetail");
        if (caloDetail != null && detectors != null && caloDetail.getStatus()) {
            for (int i = 0; i < detectors.size(); ++i) {
                Color[] colorMap;
                int side;
                int phi;
                int eta;
                ACalorimeterDetector detector = (ACalorimeterDetector)detectors.get(i);
                if (projection instanceof AProjectionYX && detector.getRegion() == 0 || projection instanceof AProjectionFR) {
                    int mode = APar.get("YX", "Mode").getI();
                    int start = mode == 0 ? detector.getFirstEta() : (mode >= 12 && mode <= 19 ? detector.getLastEta() : 0);
                    if (mode == 0 || mode >= 12 && mode <= 19 || mode == 22) {
                        for (int eta2 = start; eta2 >= detector.getFirstEta(); --eta2) {
                            for (int phi2 = detector.getFirstPhi(); phi2 <= detector.getLastPhi(); ++phi2) {
                                ACoord coord = detector.getCell(projection, eta2, phi2, 1);
                                if (coord == ACoord.NO_DATA) continue;
                                ACoord display = projection instanceof AProjectionYX ? window.calculateDisplay(projection.nonLinearTransform(coord)) : window.calculateDisplay(projection.nonLinearTransform(coord.includePhiWrapAround("FR")));
                                Color[] colorMap2 = AColorMap.getColors();
                                ag.setColor(colorMap2[APar.get("Det", "CaloDetail").getI()]);
                                for (int j = 0; j < display.hv[0].length; ++j) {
                                    ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
                                }
                            }
                        }
                        continue;
                    }
                    if ((mode != 20 || !detector.getName().equals("LAr Endcap Presampler") && !detector.getName().equals("LAr_EC_Presampler")) && (mode != 21 || !detector.getName().equals("HEC") || detector.getSampling() != 0)) continue;
                    double etaBin = 0.1;
                    double phiBin = 0.09817477042468103;
                    int binvalue = mode == 21 ? APar.get("YX", "HECBin").getI() : APar.get("YX", "LArBin").getI();
                    if (binvalue == 3) {
                        etaBin = 0.1;
                        phiBin = 0.09817477042468103;
                    } else {
                        etaBin *= (double)binvalue;
                        phiBin *= (double)binvalue;
                    }
                    Color[] colorMap3 = AColorMap.getColors();
                    ag.setColor(colorMap3[APar.get("Det", "CaloDetail").getI()]);
                    double firstZMin = detector.getZMin();
                    if (binvalue == 3) {
                        ACalorimeterDetector.setEtaSplit();
                    }
                    for (double Eta = 1.2; Eta < 3.3; Eta += etaBin) {
                        if (binvalue == 3 && Eta >= APar.get("YX", "SplitEta").getD()) {
                            etaBin = 0.2;
                            phiBin = 0.19634954084936207;
                        }
                        double RMax = firstZMin / Math.sinh(Eta);
                        double RMin = firstZMin / Math.sinh(Eta + etaBin);
                        for (double Phi = 0.0; Phi < Math.PI * 2; Phi += phiBin) {
                            double[][] hv = new double[][]{{RMax * Math.cos(Phi), RMax * Math.cos(Phi + phiBin), RMin * Math.cos(Phi + phiBin), RMin * Math.cos(Phi)}, {RMax * Math.sin(Phi), RMax * Math.sin(Phi + phiBin), RMin * Math.sin(Phi + phiBin), RMin * Math.sin(Phi)}};
                            ACoord coord = new ACoord(hv);
                            ACoord display = projection instanceof AProjectionYX ? window.calculateDisplay(projection.nonLinearTransform(coord)) : window.calculateDisplay(projection.nonLinearTransform(coord.convertYXToFR().includePhiWrapAround("FR")));
                            for (int j = 0; j < display.hv[0].length; ++j) {
                                ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
                            }
                        }
                    }
                    continue;
                }
                if (projection instanceof AProjectionRZ) {
                    for (eta = detector.getFirstEta(); eta <= detector.getLastEta(); ++eta) {
                        for (phi = detector.getFirstPhi(); phi <= detector.getFirstPhi() + detector.getNumPhi() / 2; phi += detector.getNumPhi() / 2) {
                            for (side = -1; side <= 1; side += 2) {
                                ACoord coord = detector.getCell(projection, eta, phi, side);
                                if (coord == ACoord.NO_DATA) continue;
                                ACoord display = window.calculateDisplay(projection.nonLinearTransform(coord));
                                colorMap = AColorMap.getColors();
                                ag.setColor(colorMap[APar.get("Det", "CaloDetail").getI()]);
                                ag.drawPolygon(display.hv[0][0], display.hv[1][0], display.hv[0][0].length);
                            }
                        }
                    }
                    continue;
                }
                if (!(projection instanceof AProjectionFZ)) continue;
                eta = detector.getFirstEta();
                for (phi = detector.getFirstPhi(); phi <= detector.getLastPhi(); ++phi) {
                    for (side = -1; side <= 1; side += 2) {
                        ACoord coord = detector.getCell(projection, eta, phi, side).includePhiWrapAround("FZ");
                        if (coord == ACoord.NO_DATA) continue;
                        ACoord display = window.calculateDisplay(projection.nonLinearTransform(coord));
                        colorMap = AColorMap.getColors();
                        ag.setColor(colorMap[APar.get("Det", "CaloDetail").getI()]);
                        for (int j = 0; j < display.hv[0].length; ++j) {
                            ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
                        }
                    }
                }
            }
        }
    }

    public static void setEtaSplit() {
        if (APar.get("YX", "SplitEta").getD() < 1.2) {
            APar.get("YX", "SplitEta").setD(1.2);
        } else {
            int temp = (int)Math.floor(APar.get("YX", "SplitEta").getD() * 10.0);
            APar.get("YX", "SplitEta").setD((double)temp / 10.0);
        }
    }
}

