/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;

public abstract class ADetector {
    String name;
    String projection;
    String color;
    AParameter fillColorParameter;
    protected static final double[][] NO_DETECTORS = new double[2][0];

    ADetector(String name, String projection, String color) {
        this.name = name;
        this.projection = projection;
        this.color = color;
        this.fillColorParameter = APar.get("Det", color + "Fill");
    }

    protected ACoord getYXUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getRZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getYZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getXZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getFRUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getFZUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getVPUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getUser(String projection) {
        if (projection.equals("YX")) {
            return this.getYXUser();
        }
        if (projection.equals("RZ")) {
            return this.getRZUser();
        }
        if (projection.equals("XZ")) {
            return this.getXZUser();
        }
        if (projection.equals("YZ")) {
            return this.getYZUser();
        }
        if (projection.equals("FZ")) {
            return this.getFZUser();
        }
        if (projection.equals("FR")) {
            return this.getFRUser();
        }
        if (projection.equals("VP")) {
            return this.getVPUser();
        }
        return ACoord.NO_DATA;
    }

    public String getName() {
        return this.name;
    }

    public int getFillColor() {
        return this.fillColorParameter.getI();
    }

    protected boolean getDraw() {
        return this.fillColorParameter.getStatus();
    }

    protected boolean equalsYX(ADetector that) {
        return false;
    }

    protected boolean equalsRZ(ADetector that) {
        return false;
    }

    protected ACoord convertYXToFR(ACoord coord) {
        double phiLast = 0.0;
        for (int i = 0; i < coord.hv[0].length; ++i) {
            for (int j = 0; j < coord.hv[0][i].length; ++j) {
                double xx = coord.hv[0][i][j];
                double yy = coord.hv[1][i][j];
                double rho = Math.sqrt(xx * xx + yy * yy);
                double phi = Math.toDegrees(Math.atan2(yy, xx));
                if (phi < 0.0) {
                    phi += 360.0;
                }
                if (j > 0) {
                    if (phi - phiLast > 180.0) {
                        phi -= 360.0;
                    }
                    if (phi - phiLast < -180.0) {
                        phi += 360.0;
                    }
                }
                coord.hv[0][i][j] = rho;
                coord.hv[1][i][j] = phi;
                phiLast = phi;
            }
        }
        return coord;
    }

    protected double[][][] generateAnnulusTris(int numPhi, double phi0, double rMin, double rMax) {
        int numTris = 2 * numPhi;
        double[][][] hv = new double[2][numTris][3];
        double deltaPhi = Math.PI * 2 / (double)numPhi;
        for (int i = 0; i < numPhi; ++i) {
            hv[0][i][0] = rMax * Math.cos(phi0 + (double)i * deltaPhi);
            hv[1][i][0] = rMax * Math.sin(phi0 + (double)i * deltaPhi);
            hv[0][i][1] = rMax * Math.cos(phi0 + (double)(i + 1) * deltaPhi);
            hv[1][i][1] = rMax * Math.sin(phi0 + (double)(i + 1) * deltaPhi);
            float midi = (float)i + 0.5f;
            hv[0][i][2] = rMin * Math.cos(phi0 + (double)midi * deltaPhi);
            hv[1][i][2] = rMin * Math.sin(phi0 + (double)midi * deltaPhi);
            int offi = i + numPhi;
            hv[0][offi][0] = rMin * Math.cos(phi0 + (double)midi * deltaPhi);
            hv[1][offi][0] = rMin * Math.sin(phi0 + (double)midi * deltaPhi);
            hv[0][offi][1] = rMax * Math.cos(phi0 + (double)(i + 1) * deltaPhi);
            hv[1][offi][1] = rMax * Math.sin(phi0 + (double)(i + 1) * deltaPhi);
            hv[0][offi][2] = rMin * Math.cos(phi0 + (double)(midi + 1.0f) * deltaPhi);
            hv[1][offi][2] = rMin * Math.sin(phi0 + (double)(midi + 1.0f) * deltaPhi);
        }
        return hv;
    }
}

