/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.canvas.AWindow;
import atlantis.geometry.ABarrelSiliconDetector;
import atlantis.geometry.ABarrelTRTDetector;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.geometry.ADetectors;
import atlantis.geometry.AEndcapSiliconDetector;
import atlantis.geometry.AEndcapTRTDetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionYX;
import java.awt.Color;

public class ADetectorSystem {
    ADetectors[] detectors;
    protected static String geometryName = null;

    public ADetectorSystem(ADetectors[] detectors) {
        this.detectors = detectors;
    }

    public ADetectors[] getDetectors() {
        return this.detectors;
    }

    public void draw(AWindow window, AGraphics ag, AProjection2D projection) {
        if (!APar.get("Det", "Detectors").getStatus()) {
            return;
        }
        boolean drawFrames = APar.get("Det", "HideDetectors").getStatus();
        boolean colorBW = AColorMap.drawFrames();
        Color[] colorMap = AColorMap.getColors();
        ADetectors[] detectors = this.getDetectors();
        ACoord[] display = new ACoord[detectors.length];
        int[][] index = new int[detectors.length][];
        int[][] detColor = new int[detectors.length][];
        boolean[][] draw = new boolean[detectors.length][];
        int bkgColor = APar.get("Det", "BkgFill").getI();
        for (int det = 0; det < detectors.length; ++det) {
            display[det] = window.calculateDisplay(detectors[det].getUser(projection));
            index[det] = display[det].index;
            detColor[det] = detectors[det].getColor(index[det]);
            draw[det] = detectors[det].getDraw(index[det]);
        }
        boolean modeSelection = APar.get(projection.getName(), "Mode").getI() == 0 || APar.get(projection.getName(), "Mode").getI() > 8 && (projection instanceof AProjectionYX || projection instanceof AProjectionFR);
        for (int layer = 0; layer < 2; ++layer) {
            for (int det = 0; det < detectors.length; ++det) {
                ADrawParameters dp = detectors[det].getDrawParameters(layer, 0);
                ag.updateDrawParameters(dp);
                for (int i = 0; i < display[det].hv[0].length; ++i) {
                    int numPoints = display[det].hv[0][i].length;
                    ag.setColor(colorMap[detColor[det][i]]);
                    if (!draw[det][i] || numPoints <= 0) continue;
                    if (modeSelection) {
                        if (layer == 0 && (drawFrames || colorBW)) {
                            if (colorBW) {
                                ag.setColor(colorMap[26]);
                            }
                            ag.drawPolygon(display[det].hv[0][i], display[det].hv[1][i], numPoints);
                            continue;
                        }
                        if (layer != 1) continue;
                        if (drawFrames) {
                            ag.setColor(colorMap[bkgColor]);
                        }
                        ag.fillPolygon(detectors[det], index[det][i], display[det].hv[0][i], display[det].hv[1][i], numPoints);
                        continue;
                    }
                    if (layer == 0) {
                        if (drawFrames) {
                            ag.setColor(colorMap[bkgColor]);
                        }
                        ag.fillPolygon(detectors[det], index[det][i], display[det].hv[0][i], display[det].hv[1][i], numPoints);
                        continue;
                    }
                    if (layer != 1 || !drawFrames && !colorBW) continue;
                    if (colorBW) {
                        ag.setColor(colorMap[26]);
                    }
                    ag.drawPolygon(display[det].hv[0][i], display[det].hv[1][i], numPoints);
                }
            }
        }
        ABarrelSiliconDetector.drawAdditionalItems(window, ag, projection);
        AEndcapSiliconDetector.drawAdditionalItems(window, ag, projection);
        ABarrelTRTDetector.drawAdditionalItems(window, ag, projection);
        AEndcapTRTDetector.drawAdditionalItems(window, ag, projection);
        ACalorimeterDetector.drawAdditionalItems(window, ag, projection);
    }

    public static String getGeometryName() {
        return geometryName == null ? "n/a" : geometryName;
    }
}

