/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawParameters;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;

public abstract class ADetectors {
    protected ADetector[] det = null;
    protected int[] listdl;
    protected int numDraw;
    protected int numData;

    public ADetectors(ADetector[] det) {
        this.det = det;
        this.numData = det.length;
        this.numDraw = 0;
        this.listdl = new int[this.numData];
    }

    public ADetector[] getDetectors() {
        return this.det;
    }

    protected void constructDefaultDrawList() {
        this.numDraw = this.numData;
        for (int i = 0; i < this.numDraw; ++i) {
            this.listdl[i] = i;
        }
    }

    protected void makeDrawList(String projection) {
        this.constructDefaultDrawList();
    }

    protected ACoord getUser(String projection) {
        this.makeDrawList(projection);
        int[] numPoly = new int[this.numDraw];
        int numTotal = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            int len;
            numPoly[i] = len = this.det[this.listdl[i]].getUser((String)projection).hv[0].length;
            numTotal += len;
        }
        double[][][] hv = new double[2][numTotal][];
        int[] index = new int[numTotal];
        int k = 0;
        for (int i = 0; i < this.numDraw; ++i) {
            double[][][] temp = this.det[this.listdl[i]].getUser((String)projection).hv;
            int j = 0;
            while (j < numPoly[i]) {
                hv[0][k] = temp[0][j];
                hv[1][k] = temp[1][j];
                index[k] = this.listdl[i];
                ++j;
                ++k;
            }
        }
        return new ACoord(hv, index);
    }

    protected int[] getColor(int[] dl) {
        int[] col = new int[dl.length];
        for (int i = 0; i < dl.length; ++i) {
            col[i] = this.det[dl[i]].getFillColor();
        }
        return col;
    }

    protected boolean[] getDraw(int[] dl) {
        boolean[] draw = new boolean[dl.length];
        for (int i = 0; i < dl.length; ++i) {
            draw[i] = this.det[dl[i]].getDraw();
        }
        return draw;
    }

    public String getInfo(int index) {
        return this.det[index].getName();
    }

    protected ADrawParameters getDrawParameters(int layer, int type) {
        if (layer == 0) {
            return new ADrawParameters(true, 0, 0, 0, 1, 0);
        }
        return new ADrawParameters(true, 0, 0, 1, 0, 0);
    }

    protected ACoord getUserNoTransform(AProjection projection) {
        String name = projection.getName();
        ACoord data = this.getUser(name);
        if (name.charAt(0) == 'F') {
            data.includePhiWrapAround(name);
        }
        return data;
    }

    protected ACoord getUser(AProjection2D projection) {
        return projection.nonLinearTransform(this.getUserNoTransform(projection));
    }
}

