/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.utils.AMath;

public class ADiscDetector
extends ADetector {
    double rInner;
    double rOuter;
    int nInner;
    int nOuter;

    ADiscDetector(String name, String projection, String color, double rInner, double rOuter, int nInner, int nOuter) {
        super(name, projection, color);
        this.rInner = rInner;
        this.nInner = nInner;
        this.rOuter = rOuter;
        this.nOuter = nOuter;
    }

    protected ACoord getYXUser() {
        int j;
        if (!this.projection.equals("YX")) {
            return ACoord.NO_DATA;
        }
        int numPoints = this.nInner + this.nOuter + 2;
        double[][] hv = new double[2][numPoints];
        for (j = 0; j < this.nInner + 1; ++j) {
            hv[0][j] = this.rInner * Math.cos(Math.PI * 2 * (double)j / (double)this.nInner);
            hv[1][j] = this.rInner * Math.sin(Math.PI * 2 * (double)j / (double)this.nInner);
        }
        for (j = 0; j < this.nOuter + 1; ++j) {
            hv[0][j + this.nInner + 1] = this.rOuter * Math.cos(Math.PI * 2 * (double)(this.nOuter - j) / (double)this.nOuter);
            hv[1][j + this.nInner + 1] = this.rOuter * Math.sin(Math.PI * 2 * (double)(this.nOuter - j) / (double)this.nOuter);
        }
        return new ACoord(hv);
    }

    protected ACoord getFRUser() {
        if (!this.projection.equals("FR")) {
            return ACoord.NO_DATA;
        }
        return new ACoord(AMath.xBox((this.rInner + this.rOuter) / 2.0, (this.rOuter - this.rInner) / 2.0), AMath.yBox(180.0, 180.0));
    }
}

