/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.AClipper;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.utils.AMath;

public class AEndcapCalorimeterDetector
extends ACalorimeterDetector {
    public AEndcapCalorimeterDetector(String name, String color, int sampling, int region, double rMin, double rMax, double zMin, double zMax, double eta0, double deta, int neta, int meta, double phi0, int nphi) {
        super(name, color);
        this.sampling = sampling;
        this.region = region;
        this.rMin = rMin;
        this.rMax = rMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.eta0 = eta0;
        this.deltaEta = deta;
        this.numEta = neta;
        this.minEta = meta;
        this.phi0 = Math.toRadians(phi0);
        this.numPhi = nphi;
        this.deltaPhi = Math.PI * 2 / (double)this.numPhi;
        this.detEtaMin = AMath.etaAbs(this.zMin, this.rMax);
        this.detEtaMax = AMath.etaAbs(this.zMax, this.rMax);
        this.clipper = new AClipper(zMin, zMax, rMin, rMax);
        if (this.name.indexOf("LAr") >= 0 && this.name.indexOf("Inner") >= 0 && this.sampling < lar[3].length && this.region < lar[3][this.sampling].length) {
            AEndcapCalorimeterDetector.lar[3][this.sampling][this.region] = detectors.indexOf(this);
        } else if (this.name.indexOf("LAr") >= 0 && this.sampling < lar[2].length && this.region < lar[2][this.sampling].length) {
            AEndcapCalorimeterDetector.lar[2][this.sampling][this.region] = detectors.indexOf(this);
        } else if (this.name.equals("HEC") && this.sampling < hec.length && this.region < hec[this.sampling].length) {
            AEndcapCalorimeterDetector.hec[this.sampling][this.region] = detectors.indexOf(this);
        } else {
            System.out.println("Unknown calorimeter object: '" + this.name + "'" + " some hits might not be displayed correctly.");
        }
    }

    protected ACoord getYXUser() {
        int mode = APar.get("YX", "Mode").getI();
        if (mode < 12) {
            return ACoord.NO_DATA;
        }
        if (mode == 12 && (this.name.equals("LAr Endcap Presampler") || this.name.equals("LAr_EC_Presampler")) || this.name.equals("LAr Outer Endcap") && this.sampling == mode - 12 || this.name.equals("LAr Inner Endcap") && this.sampling == mode - 12 - 1 || this.name.equals("HEC") && this.sampling == mode - 16 || mode == 20 && this.name.indexOf("LAr") >= 0 || mode == 21 && this.name.equals("HEC")) {
            double r2;
            double r1;
            double etaMax = this.eta0 + (double)this.numEta * this.deltaEta;
            double etaMin = this.eta0;
            if (this.name.equals("HEC")) {
                r1 = this.rMax;
                r2 = this.rMin;
            } else {
                r1 = this.name.indexOf("Inner") >= 0 || this.name.indexOf("Presampler") >= 0 ? this.zMin / Math.sinh(etaMin) : this.rMax;
                r2 = this.zMin / Math.sinh(etaMax);
            }
            int numPoints = 2 * (this.numPhi + 1);
            double[][] hv = new double[2][numPoints];
            for (int i = 0; i < this.numPhi + 1; ++i) {
                hv[0][i] = r2 * Math.cos(this.phi0 + (double)i * this.deltaPhi);
                hv[1][i] = r2 * Math.sin(this.phi0 + (double)i * this.deltaPhi);
                hv[0][this.numPhi + 1 + i] = r1 * Math.cos(this.phi0 - (double)i * this.deltaPhi);
                hv[1][this.numPhi + 1 + i] = r1 * Math.sin(this.phi0 - (double)i * this.deltaPhi);
            }
            return new ACoord(hv);
        }
        return ACoord.NO_DATA;
    }

    protected ACoord getRZUser() {
        double[] v;
        double[] h;
        double etaMax = this.eta0 + (double)this.numEta * this.deltaEta;
        double etaMin = this.eta0;
        if (this.name.indexOf("HEC") >= 0) {
            h = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
            v = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        } else {
            double r0 = this.zMax / Math.sinh(etaMin);
            double r1 = this.zMin / Math.sinh(etaMin);
            double r2 = this.zMin / Math.sinh(etaMax);
            double r3 = this.zMax / Math.sinh(etaMax);
            h = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
            v = new double[]{r0, r1, r2, r3};
        }
        ACoord coord = this.clipper.clipPolygon(h, v, h.length);
        coord = new ACoord(coord, coord.mirrorV());
        coord = new ACoord(coord, coord.mirrorH());
        return coord;
    }

    protected ACoord getFRUser() {
        return this.getYXUser().convertYXToFR();
    }

    protected ACoord getFZUser() {
        double[][][] hv = new double[2][2][];
        double phiMin = 0.0;
        double phiMax = 360.0;
        hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][0] = new double[]{phiMax, phiMax, phiMin, phiMin};
        hv[0][1] = new double[]{-this.zMax, -this.zMin, -this.zMin, -this.zMax};
        hv[1][1] = new double[]{phiMax, phiMax, phiMin, phiMin};
        return new ACoord(hv);
    }

    public ACoord getYXCell(int eta, int phi) {
        int mode = APar.get("YX", "Mode").getI();
        if (mode < 12 || mode > 21) {
            return ACoord.NO_DATA;
        }
        if (mode == 20 && this.name.indexOf("LAr") >= 0 || mode == 21 && this.name.equals("HEC")) {
            double[][] hv = new double[][]{{0.0}, {0.0}};
            return new ACoord(hv);
        }
        if (mode == 12 && (this.name.equals("LAr Endcap Presampler") || this.name.equals("LAr_EC_Presampler")) || this.name.equals("LAr Outer Endcap") && this.sampling == mode - 12 || this.name.equals("LAr Inner Endcap") && this.sampling == mode - 12 - 1 || this.name.equals("HEC") && this.sampling == mode - 16) {
            double[][] hv = new double[2][];
            double phiMin = this.phi0 + (double)phi * this.deltaPhi;
            double phiMax = phiMin + this.deltaPhi;
            double newrMax = 0.0;
            double newrMin = 0.0;
            double etaMin = this.eta0 + (double)(eta - this.minEta) * this.deltaEta;
            double etaMax = etaMin + this.deltaEta;
            newrMax = this.zMin / Math.sinh(etaMin);
            newrMin = this.zMin / Math.sinh(etaMax);
            if (this.name.equals("HEC")) {
                if (newrMax > this.rMax) {
                    newrMax = this.rMax;
                }
                if (newrMin < this.rMin) {
                    newrMin = this.rMin;
                }
            }
            hv[0] = new double[]{newrMax * Math.cos(phiMin), newrMax * Math.cos(phiMax), newrMin * Math.cos(phiMax), newrMin * Math.cos(phiMin)};
            hv[1] = new double[]{newrMax * Math.sin(phiMin), newrMax * Math.sin(phiMax), newrMin * Math.sin(phiMax), newrMin * Math.sin(phiMin)};
            return new ACoord(hv);
        }
        return ACoord.NO_DATA;
    }

    public ACoord getRZCell(int eta, int phi, int side) {
        double[][] hv = new double[2][];
        int sign = this.getRSign(phi);
        if (side != 0) {
            side /= Math.abs(side);
        }
        double etaMin = this.eta0 + (double)(eta - this.minEta) * this.deltaEta;
        double etaMax = etaMin + this.deltaEta;
        if (this.name.indexOf("HEC") >= 0) {
            if (this.sampling == 0) {
                double rMin = (this.zMin + this.zMax) / 2.0 / Math.sinh(etaMax);
                double rMax = (this.zMin + this.zMax) / 2.0 / Math.sinh(etaMin);
                hv[0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
                hv[1] = new double[]{rMax, rMax, rMin, rMin};
            } else {
                double dz = this.zMax - this.zMin;
                double z0 = this.zMin;
                double z1 = this.zMin + dz / 2.0;
                double z2 = this.zMax;
                double r0 = (this.zMin + dz / 4.0) / Math.sinh(etaMax);
                double r1 = (this.zMax - dz / 4.0) / Math.sinh(etaMax);
                double r2 = (this.zMin + dz / 4.0) / Math.sinh(etaMin);
                double r3 = (this.zMax - dz / 4.0) / Math.sinh(etaMin);
                hv[0] = new double[]{z2, z1, z1, z0, z0, z1, z1, z2};
                hv[1] = new double[]{r3, r3, r2, r2, r0, r0, r1, r1};
            }
        } else {
            hv[0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
            hv[1] = new double[]{this.zMax / Math.sinh(etaMin), this.zMin / Math.sinh(etaMin), this.zMin / Math.sinh(etaMax), this.zMax / Math.sinh(etaMax)};
        }
        ACoord coord = this.clipper.clipPolygon(hv[0], hv[1], hv[0].length);
        int i = 0;
        while (i < coord.hv[0][0].length) {
            double[] dArray = coord.hv[0][0];
            int n = i;
            dArray[n] = dArray[n] * (double)side;
            double[] dArray2 = coord.hv[1][0];
            int n2 = i++;
            dArray2[n2] = dArray2[n2] * (double)sign;
        }
        return coord;
    }

    public ACoord getFZCell(int eta, int phi, int side) {
        double[][] hv = new double[2][];
        double phiMin = Math.toDegrees(this.phi0 + (double)phi * this.deltaPhi);
        double phiMax = phiMin + Math.toDegrees(this.deltaPhi);
        side /= Math.abs(side);
        hv[0] = new double[]{(double)side * this.zMax, (double)side * this.zMin, (double)side * this.zMin, (double)side * this.zMax};
        hv[1] = new double[]{phiMax, phiMax, phiMin, phiMin};
        return new ACoord(hv);
    }

    public ACoord getVPCell(int eta, int phi, int side) {
        double[][] hv = new double[2][];
        double etaMin = this.eta0 + (double)(eta - this.minEta) * this.deltaEta;
        double etaMax = etaMin + this.deltaEta;
        double phiMin = Math.toDegrees(this.phi0 + (double)phi * this.deltaPhi);
        double phiMax = phiMin + Math.toDegrees(this.deltaPhi);
        side /= Math.abs(side);
        hv[0] = new double[]{(double)side * etaMax, (double)side * etaMin, (double)side * etaMin, (double)side * etaMax};
        hv[1] = new double[]{phiMax, phiMax, phiMin, phiMin};
        return new ACoord(hv);
    }
}

