/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.AClipper;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.utils.AMath;

public class AEndcapCryostatDetector
extends ACalorimeterDetector {
    public AEndcapCryostatDetector(String name, String color, int sampling, int region, double rMin, double rMax, double zMin, double zMax, int neta, int nphi) {
        super(name, color);
        this.sampling = sampling;
        this.region = region;
        this.rMin = rMin;
        this.rMax = rMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.numEta = neta;
        this.numPhi = nphi;
        this.deltaPhi = Math.PI * 2 / (double)this.numPhi;
        this.phi0 = 0.0;
        this.eta0 = AMath.etaAbs(this.zMin, this.rMin);
        this.detEtaMin = AMath.etaAbs(this.zMin, this.rMax);
        this.detEtaMax = AMath.etaAbs(this.zMax, this.rMax);
        this.clipper = new AClipper(zMin, zMax, rMin, rMax);
        if (this.name.equals("Minimum Bias Trigger Scintillators")) {
            AEndcapCryostatDetector.mbts[this.sampling] = detectors.indexOf(this);
        } else {
            System.out.println("Unknown calorimeter object: '" + this.name + "'" + " some hits might not be displayed correctly.");
        }
    }

    protected ACoord getYXUser() {
        int j;
        int mode = APar.get("YX", "Mode").getI();
        if (mode != 22) {
            return ACoord.NO_DATA;
        }
        int numPoints = 2 * (this.numPhi + 1);
        double[][] hv = new double[2][numPoints];
        for (j = 0; j < this.numPhi + 1; ++j) {
            hv[0][j] = this.rMin * Math.cos(Math.PI * 2 * (double)j / (double)this.numPhi);
            hv[1][j] = this.rMin * Math.sin(Math.PI * 2 * (double)j / (double)this.numPhi);
        }
        for (j = 0; j < this.numPhi + 1; ++j) {
            hv[0][j + this.numPhi + 1] = this.rMax * Math.cos(Math.PI * 2 * (double)(this.numPhi - j) / (double)this.numPhi);
            hv[1][j + this.numPhi + 1] = this.rMax * Math.sin(Math.PI * 2 * (double)(this.numPhi - j) / (double)this.numPhi);
        }
        return new ACoord(hv);
    }

    protected ACoord getRZUser() {
        double[] h = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        double[] v = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        ACoord coord = this.clipper.clipPolygon(h, v, h.length);
        coord = new ACoord(coord, coord.mirrorV());
        coord = new ACoord(coord, coord.mirrorH());
        return coord;
    }

    protected ACoord getFRUser() {
        return this.getYXUser().convertYXToFR();
    }

    public ACoord getYXCell(int eta, int phi) {
        int mode = APar.get("YX", "Mode").getI();
        if (mode != 22) {
            return ACoord.NO_DATA;
        }
        double[][] hv = new double[2][];
        double phiMin = Math.PI * 2 * (double)phi / (double)this.numPhi;
        double phiMax = Math.PI * 2 * (double)(1 + phi) / (double)this.numPhi;
        hv[0] = new double[]{this.rMax * Math.cos(phiMin), this.rMax * Math.cos(phiMax), this.rMin * Math.cos(phiMax), this.rMin * Math.cos(phiMin)};
        hv[1] = new double[]{this.rMax * Math.sin(phiMin), this.rMax * Math.sin(phiMax), this.rMin * Math.sin(phiMax), this.rMin * Math.sin(phiMin)};
        return new ACoord(hv);
    }

    public ACoord getRZCell(int eta, int phi, int side) {
        double[][] hv = new double[2][];
        int sign = this.getRSign(phi);
        if (side != 0) {
            side /= Math.abs(side);
        }
        hv[0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        ACoord coord = this.clipper.clipPolygon(hv[0], hv[1], hv[0].length);
        int i = 0;
        while (i < coord.hv[0][0].length) {
            double[] dArray = coord.hv[0][0];
            int n = i;
            dArray[n] = dArray[n] * (double)side;
            double[] dArray2 = coord.hv[1][0];
            int n2 = i++;
            dArray2[n2] = dArray2[n2] * (double)sign;
        }
        return coord;
    }
}

