/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.canvas.AWindow;
import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionYX;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class AEndcapSiliconDetector
extends ADetector {
    private static List detectors = null;
    protected int layer;
    protected double length;
    protected double width;
    protected double thickness;
    protected int numZ;
    protected int numPhi;
    protected double phi0;
    protected double zMin;
    protected double zMax;
    protected double deltaPhi;
    protected double deltaZ;
    protected double rMin;
    protected double rMax;

    public AEndcapSiliconDetector(String name, String color, int layer, double length, double width, double thickness, int numZ, int numPhi, double rMin, double rMax, double phi0, double zMin, double zMax) {
        super(name, " ", color);
        if (detectors == null) {
            detectors = new ArrayList();
        }
        detectors.add(this);
        this.layer = layer;
        this.length = length;
        this.width = width;
        this.thickness = thickness;
        this.numZ = numZ;
        this.numPhi = numPhi;
        this.rMin = rMin;
        this.rMax = rMax;
        this.phi0 = Math.toRadians(phi0);
        this.zMin = zMin;
        this.zMax = zMax;
        this.deltaPhi = Math.PI * 2 / (double)this.numPhi;
        this.deltaZ = (this.zMax - this.zMin) / (double)this.numZ;
    }

    public static void clear() {
        if (detectors != null) {
            detectors.clear();
        }
    }

    public static void drawAdditionalItems(AWindow window, AGraphics ag, AProjection2D projection) {
        AParameter inDetDetail = APar.getUnknown("Det", "SiliconDetail");
        if (inDetDetail != null && detectors != null && inDetDetail.getStatus()) {
            for (int i = 0; i < detectors.size(); ++i) {
                ACoord coord = ACoord.NO_DATA;
                AEndcapSiliconDetector detector = (AEndcapSiliconDetector)detectors.get(i);
                if (projection instanceof AProjectionYX) {
                    coord = detector.getYXDetail();
                } else if (projection instanceof AProjectionFR) {
                    coord = detector.getYXDetail().convertYXToFR().includePhiWrapAround("FR");
                }
                if (coord == ACoord.NO_DATA) continue;
                Color[] colorMap = AColorMap.getColors();
                ag.setColor(colorMap[APar.get("Det", "SiliconDetail").getI()]);
                ACoord display = window.calculateDisplay(projection.nonLinearTransform(coord));
                for (int j = 0; j < display.hv[0].length; ++j) {
                    ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
                }
            }
        }
    }

    protected boolean isVisible() {
        int cut = APar.get("CutsInDet", "SCT").getI();
        return cut == -1 || cut == 0 || cut == 2;
    }

    protected ACoord getYXUser() {
        if (APar.get("YX", "Mode").getI() != 0) {
            return ACoord.NO_DATA;
        }
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        int numPoints = 2 * (this.numPhi + 1);
        double[][] hv = new double[2][numPoints];
        for (int i = 0; i < this.numPhi + 1; ++i) {
            hv[0][i] = this.rMin * Math.cos(this.phi0 + ((double)i + 0.5) * this.deltaPhi);
            hv[1][i] = this.rMin * Math.sin(this.phi0 + ((double)i + 0.5) * this.deltaPhi);
            hv[0][this.numPhi + 1 + i] = this.rMax * Math.cos(this.phi0 - ((double)i + 0.5) * this.deltaPhi);
            hv[1][this.numPhi + 1 + i] = this.rMax * Math.sin(this.phi0 - ((double)i + 0.5) * this.deltaPhi);
        }
        return new ACoord(hv);
    }

    protected ACoord getRZUser() {
        double[][][] hv = new double[2][4][];
        hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][0] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        hv[0][1] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][1] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        hv[0][2] = new double[]{-this.zMax, -this.zMin, -this.zMin, -this.zMax};
        hv[1][2] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        hv[0][3] = new double[]{-this.zMax, -this.zMin, -this.zMin, -this.zMax};
        hv[1][3] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        return new ACoord(hv);
    }

    protected ACoord getFZUser() {
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        double[][][] hv = new double[2][2][];
        hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][0] = new double[]{360.0, 360.0, 0.0, 0.0};
        hv[0][1] = new double[]{-this.zMax, -this.zMin, -this.zMin, -this.zMax};
        hv[1][1] = new double[]{360.0, 360.0, 0.0, 0.0};
        return new ACoord(hv);
    }

    protected ACoord getFRUser() {
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        return this.getYXUser().convertYXToFR();
    }

    protected ACoord getYXDetail() {
        if (APar.get("YX", "Mode").getI() != 0) {
            return ACoord.NO_DATA;
        }
        if (!this.isVisible()) {
            return ACoord.NO_DATA;
        }
        double[][][] hv = new double[2][this.numPhi][];
        for (int i = 0; i < this.numPhi; ++i) {
            hv[0][i] = new double[]{this.rMax * Math.sin(this.phi0 + ((double)i - 0.5) * this.deltaPhi), this.rMax * Math.sin(this.phi0 + ((double)i + 0.5) * this.deltaPhi), this.rMin * Math.sin(this.phi0 + ((double)i + 0.5) * this.deltaPhi), this.rMin * Math.sin(this.phi0 + ((double)i - 0.5) * this.deltaPhi)};
            hv[1][i] = new double[]{this.rMax * Math.cos(this.phi0 + ((double)i - 0.5) * this.deltaPhi), this.rMax * Math.cos(this.phi0 + ((double)i + 0.5) * this.deltaPhi), this.rMin * Math.cos(this.phi0 + ((double)i + 0.5) * this.deltaPhi), this.rMin * Math.cos(this.phi0 + ((double)i - 0.5) * this.deltaPhi)};
        }
        return new ACoord(hv);
    }
}

