/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.canvas.AWindow;
import atlantis.geometry.ADetector;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class AEndcapTRTDetector
extends ADetector {
    private static List detectors = null;
    protected int layer;
    protected int numPhi;
    protected double rMin;
    protected double rMax;
    protected double phi0;
    protected double zMin;
    protected double zMax;
    protected double deltaPhi;

    public AEndcapTRTDetector(String name, String color, int layer, int numPhi, double rMin, double rMax, double phi0, double zMin, double zMax) {
        super(name, " ", color);
        if (detectors == null) {
            detectors = new ArrayList();
        }
        detectors.add(this);
        this.layer = layer;
        this.numPhi = numPhi;
        this.rMin = rMin;
        this.rMax = rMax;
        this.phi0 = Math.toRadians(phi0);
        this.zMin = zMin;
        this.zMax = zMax;
        this.deltaPhi = Math.PI * 2 / (double)numPhi;
    }

    public static void clear() {
        if (detectors != null) {
            detectors.clear();
        }
    }

    public static void drawAdditionalItems(AWindow window, AGraphics ag, AProjection2D projection) {
        AParameter inDetDetail = APar.getUnknown("Det", "TRTDetail");
        if (inDetDetail != null && detectors != null && inDetDetail.getStatus()) {
            for (int i = 0; i < detectors.size(); ++i) {
                ACoord coord = ACoord.NO_DATA;
                AEndcapTRTDetector detector = (AEndcapTRTDetector)detectors.get(i);
                if (projection instanceof AProjectionRZ) {
                    coord = detector.getRZDetail();
                } else if (projection instanceof AProjectionFZ) {
                    coord = detector.getFZDetail();
                }
                if (coord == ACoord.NO_DATA) continue;
                Color[] colorMap = AColorMap.getColors();
                ag.setColor(colorMap[APar.get("Det", "TRTDetail").getI()]);
                ACoord display = window.calculateDisplay(projection.nonLinearTransform(coord));
                for (int j = 0; j < display.hv[0].length; ++j) {
                    ag.drawPolygon(display.hv[0][j], display.hv[1][j], display.hv[0][j].length);
                }
            }
        }
    }

    protected ACoord getYXUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getRZUser() {
        double[][][] hv = new double[2][4][];
        hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][0] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        hv[0][1] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][1] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        hv[0][2] = new double[]{-this.zMax, -this.zMin, -this.zMin, -this.zMax};
        hv[1][2] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        hv[0][3] = new double[]{-this.zMax, -this.zMin, -this.zMin, -this.zMax};
        hv[1][3] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        return new ACoord(hv);
    }

    protected ACoord getFZUser() {
        double[][][] hv = new double[2][2][];
        hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1][0] = new double[]{360.0, 360.0, 0.0, 0.0};
        hv[0][1] = new double[]{-this.zMax, -this.zMin, -this.zMin, -this.zMax};
        hv[1][1] = new double[]{360.0, 360.0, 0.0, 0.0};
        return new ACoord(hv);
    }

    protected ACoord getFRUser() {
        return ACoord.NO_DATA;
    }

    protected ACoord getRZDetail() {
        return ACoord.NO_DATA;
    }

    protected ACoord getFZDetail() {
        double[][][] hv = new double[2][2 * this.numPhi][2];
        for (int i = 0; i < this.numPhi; ++i) {
            hv[0][i][0] = this.zMin;
            hv[1][i][0] = Math.toDegrees(this.phi0 + (double)i * this.deltaPhi);
            hv[0][i][1] = this.zMax;
            hv[1][i][1] = Math.toDegrees(this.phi0 + (double)i * this.deltaPhi);
            hv[0][this.numPhi + i][0] = -this.zMax;
            hv[1][this.numPhi + i][0] = Math.toDegrees(this.phi0 + (double)i * this.deltaPhi);
            hv[0][this.numPhi + i][1] = -this.zMin;
            hv[1][this.numPhi + i][1] = Math.toDegrees(this.phi0 + (double)i * this.deltaPhi);
        }
        return new ACoord(hv).includePhiWrapAround("FZ");
    }
}

