/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ACalorimeterDetector;
import atlantis.graphics.ACoord;
import atlantis.utils.AMath;

public class AGapCalorimeterDetector
extends ACalorimeterDetector {
    protected int eta;

    public AGapCalorimeterDetector(String name, String color, int sampling, int region, double rMin, double rMax, double zMin, double zMax, int eta, double phi0, int nphi) {
        super(name, color);
        this.sampling = Math.abs(sampling);
        this.region = Math.abs(region);
        this.eta = Math.abs(eta);
        this.rMin = rMin;
        this.rMax = rMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.phi0 = Math.toRadians(phi0);
        this.numPhi = nphi;
        this.deltaPhi = Math.PI * 2 / (double)this.numPhi;
        if (this.name.indexOf("ITC") >= 0 && this.sampling < tile_gap.length && this.eta < tile_gap[this.sampling].length) {
            AGapCalorimeterDetector.tile_gap[this.sampling][this.eta] = detectors.indexOf(this);
        } else {
            System.out.println("Unknown calorimeter object: '" + this.name + "'" + " some hits might not be displayed correctly.");
        }
    }

    public double getEta(int eta, int side) {
        if (side < 0) {
            return -this.getEta(eta, -side);
        }
        return AMath.eta((this.zMin + this.zMax) / 2.0, (this.rMin + this.rMax) / 2.0);
    }

    public double getEtaMin(int eta, int side) {
        if (side < 0) {
            return -this.getEtaMax(eta, -side);
        }
        return AMath.eta((this.zMin + this.zMax) / 2.0, this.rMax);
    }

    public double getEtaMax(int eta, int side) {
        if (side < 0) {
            return -this.getEtaMin(eta, -side);
        }
        return AMath.eta((this.zMin + this.zMax) / 2.0, this.rMin);
    }

    protected ACoord getRZUser() {
        double[][][] hv;
        if (this.zMin < 0.0) {
            hv = new double[2][2][];
            hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
            hv[1][0] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
            hv[0][1] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
            hv[1][1] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        } else {
            hv = new double[2][4][];
            hv[0][0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
            hv[1][0] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
            hv[0][1] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
            hv[1][1] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
            hv[0][2] = new double[]{-this.zMin, -this.zMax, -this.zMax, -this.zMin};
            hv[1][2] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
            hv[0][3] = new double[]{-this.zMin, -this.zMax, -this.zMax, -this.zMin};
            hv[1][3] = new double[]{-this.rMin, -this.rMin, -this.rMax, -this.rMax};
        }
        return new ACoord(hv);
    }

    public ACoord getRZCell(int eta, int phi, int side) {
        double[][] hv = new double[2][];
        int sign = this.getRSign(phi);
        if (side != 0) {
            side /= Math.abs(side);
        }
        hv[0] = new double[]{this.zMax, this.zMin, this.zMin, this.zMax};
        hv[1] = new double[]{this.rMax, this.rMax, this.rMin, this.rMin};
        ACoord coord = new ACoord(hv);
        int i = 0;
        while (i < coord.hv[0][0].length) {
            double[] dArray = coord.hv[0][0];
            int n = i;
            dArray[n] = dArray[n] * (double)side;
            double[] dArray2 = coord.hv[1][0];
            int n2 = i++;
            dArray2[n2] = dArray2[n2] * (double)sign;
        }
        return coord;
    }

    public ACoord getVPCell(int eta, int phi, int side) {
        double[][] hv = new double[2][];
        double etaMin = AMath.eta((this.zMin + this.zMax) / 2.0, this.rMax);
        double etaMax = AMath.eta((this.zMin + this.zMax) / 2.0, this.rMin);
        double phiMin = Math.toDegrees(this.phi0 + (double)phi * this.deltaPhi);
        double phiMax = phiMin + Math.toDegrees(this.deltaPhi);
        side /= Math.abs(side);
        hv[0] = new double[]{(double)side * etaMax, (double)side * etaMin, (double)side * etaMin, (double)side * etaMax};
        hv[1] = new double[]{phiMax, phiMax, phiMin, phiMin};
        return new ACoord(hv);
    }
}

