/*
 * Decompiled with CFR 0.152.
 */
package atlantis.geometry;

import atlantis.geometry.ABoxDetector;
import atlantis.geometry.ADetector;
import atlantis.geometry.ADetectors;
import atlantis.geometry.ATrapezoidDetector;
import atlantis.parameters.APar;
import java.util.ArrayList;
import java.util.List;

public final class AGeneralDetectors
extends ADetectors {
    public AGeneralDetectors(List detectors) {
        super(AGeneralDetectors.filterGeneralDetectors(detectors));
    }

    private static ADetector[] filterGeneralDetectors(List detectors) {
        ArrayList tempDetectors = new ArrayList(detectors.size());
        for (Object o : detectors) {
            if (!(o instanceof ADetector) || o instanceof ABoxDetector || o instanceof ATrapezoidDetector) continue;
            tempDetectors.add(o);
        }
        return tempDetectors.toArray(new ADetector[tempDetectors.size()]);
    }

    private void makeDrawListYX() {
        int mode = APar.get("YX", "Mode").getI();
        if (mode == 0) {
            int num = 0;
            for (int i = 0; i < this.numData; ++i) {
                if (this.det[i].getName().indexOf("FCAL") >= 0) continue;
                this.listdl[num++] = i;
            }
            this.numDraw = num;
        } else if (mode > 8) {
            int num = 0;
            for (int i = 0; i < this.numData; ++i) {
                if (!(mode == 9 && this.det[i].getName().equals("FCAL EM") || mode == 10 && this.det[i].getName().equals("FCAL HAD 1") || mode == 11 && this.det[i].getName().equals("FCAL HAD 2") || mode == 12 && this.det[i].getName().equals("LAr Endcap Presampler") || this.det[i].getName().equals("LAr_EC_Presampler") || mode >= 13 && mode <= 15 && (this.det[i].getName().equals("LAr Outer Endcap") || this.det[i].getName().equals("LAr Inner Endcap")) || mode >= 16 && mode <= 19 && this.det[i].getName().equals("HEC") || APar.get("YX", "DrawFCAL").getStatus() && mode == 17 && this.det[i].getName().equals("FCAL EM") || APar.get("YX", "DrawFCAL").getStatus() && mode == 18 && this.det[i].getName().equals("FCAL HAD 1") || APar.get("YX", "DrawFCAL").getStatus() && mode == 19 && this.det[i].getName().equals("FCAL HAD 2") || mode == 20 && (this.det[i].getName().indexOf("LAr") >= 0 || this.det[i].getName().indexOf("Endcap") >= 0 || this.det[i].getName().indexOf("EC") >= 0) || mode == 21 && this.det[i].getName().equals("HEC")) && (mode != 22 || !this.det[i].getName().equals("Minimum Bias Trigger Scintillators"))) continue;
                this.listdl[num++] = i;
            }
            this.numDraw = num;
        } else {
            this.numDraw = 0;
        }
    }

    protected void makeDrawList(String projection) {
        if (projection.equals("YX") || projection.equals("FR")) {
            this.makeDrawListYX();
        } else if (APar.get(projection, "Mode").getI() == 0) {
            this.constructDefaultDrawList();
        } else {
            this.numDraw = 0;
        }
    }
}

